/*
 * Copyright (C) 2012 Pascal Noisette
 *
 * This file is part of Me TV Http Module
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

me_tv = (function () {

    /* http outgoing */
    connection = {
        send : function(callback, content){

            url = "/foo";

            jQuery.ajax({
                type     : "GET",
                url      : url,
                data     : {content: '\<\?xml version="1.0" \?>' + content},
                success  : callback,
                dataType : "text",
                error    : function(e){ui.log("ERROR", "Error while sending data to me-tv-server");}
            });
        }
    }

    /* encode data for outgooing */
    request = {
        _prepareXml : function (client) {
            var options = {
                formatOutput: true,
                rootTagName : "request"
            };
            var xml = $.json2xml(client, options);
            return xml;
        },
        send : function (client) {
            connection.send(
                function(doc){response.receive(doc, client);},
                this._prepareXml(client)
            );
        }
    };

    /* decode data for controler level abstraction usage */
    response = {
        receive : function(doc, client) {
            json = $.xml2json(doc);
            
            if(json && typeof(json.error) != "undefined") {
                ui.log("ERROR", json.error);
                return;
            }
            dispatcher.dispatch("server", client.command, json);
        }
    }

    /* model of data to send request */
    model = {
        client : {
            /* handle an object is use friendly compare to xml */
            client_id : 0,
            command : null
        }
    };

    /* handle user actions and server responses */
    controllers = {
        serverController : {},
        clientController : {}
    };

    /* launch the appropriate method of controller */
    dispatcher = {
        dispatch : function(controllerName, action, params) {
            jQuery(me_tv).trigger("me_tv_" + controllerName + "_action" + "_" + action + "_before", {params:params});

            if (controllerName == "client") {
                controller = controllers.clientController;
            } else {
                controller = controllers.serverController;
            }

            controller[action](params);
            //clean up extra params after request
            for(prop in model.client) {
                if (   model.client.hasOwnProperty(prop)
                    && prop != "client_id"
                    && prop != "command"){
                    delete model.client[prop];
                }
            }
            
            jQuery(me_tv).trigger("me_tv_" + controllerName + "_action" + "_" + action + "_after", {params:params});
        }
    };

    /* display informations */
    ui = {
        log : function(level, message) {
            jQuery(me_tv).trigger("me_tv_log" + "_" + level, {message:message});
        }
    };


    return {
         /* allow js plugin to defined there own action to handle */
        addAction : function(name, callbackClient, callbackServer) {
            
            controllers.serverController[name] = callbackServer;
            controllers.clientController[name] = callbackClient;
            
            me_tv[name] = function(params) {
                dispatcher.dispatch("client", name, params);
            }
        }
    };

})();
