/*
 * Copyright (C) 2012 Pascal Noisette
 *
 * This file is part of Me TV Http Module
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

me_tv.addAction(
    "register",
    function (param) {
        if (model.client.client_id != 0) {
            ui.log("WARNING", "Already connected with id " + model.client.client_id);
            return;
        }
        model.client.command = "register";
        request.send(model.client);
    },
    function (param) {
        if(typeof(param.client) == "undefined") {
            ui.log("ERROR", "Cannot connect, no client id found in response for register " + param.error);
            return;
        }
        model.client.client_id = param.client.id;
        ui.log("INFO", "connected with id " + model.client.client_id);
    }
);

me_tv.addAction(
    "unregister",
    function (param) {
        model.client.command = "unregister";
        request.send(model.client);
        model.client.client_id = 0;
    },
    function (param) {
        ui.log("INFO", "disconnected");
    }
);

me_tv.addAction(
    "get_channels",
    function (param) {
        model.client.command = "get_channels";
        request.send(model.client);
    },
    function (param) {
        /* make sure param.channel is an array */
        if (typeof(param.channel) == "undefined") {
            param.channel = [];
        } else if (!jQuery.isArray(param.channel)) {
            param.channel = [param.channel];
        }
    }
);

me_tv.addAction(
    "start_broadcasting",
    function (param) {
        model.client.command = "start_broadcasting";
        model.client.parameter = {
            name : "channel",
            value : param
        };
        request.send(model.client);
    },
    function (param) {
        ui.log("INFO", "Broadcast started");
    }
);

me_tv.addAction(
    "get_scheduled_recordings",
    function (param) {
       model.client.command = "get_scheduled_recordings";
       request.send(model.client);
    },
    function (param) {
        if (param == "" || typeof(param.scheduled_recording) == "undefined") {
            ui.log("INFO", "No schedule available");
			param = {};
            param.scheduled_recording = [];
            return;
        } else if (!jQuery.isArray(param.scheduled_recording)) {
            /* make sure param.scheduled_recording is an array */
            param.scheduled_recording = [param.scheduled_recording];
        }
    }
);

me_tv.addAction(
    "remove_scheduled_recording",
    function (param) {
       model.client.command = "remove_scheduled_recording";
       model.client.parameter = {
           name : "scheduled_recording_id",
           value : param
       };
       request.send(model.client);
    },
    function (param) {
        ui.log("INFO", "Schedule removed");
    }
);

me_tv.addAction(
    "add_scheduled_recording_from_schedule_recording",
    function (params) {
       if (params.channel_id == "") {
           ui.log ("WARNING", "Channel is missing.");
           return;
       }
       if (params.start_time == "") {
           ui.log ("WARNING", "Start time is missing.");
           return;
       }
       if (params.duration == "") {
           ui.log ("WARNING", "Duration is missing.");
           return;
       }
       if (params.description == "") {
           ui.log ("WARNING", "Description is missing.");
           return;
       }
       if (params.recurring_type == "") {
           params.recurring_type = 0;
       }


       model.client.command = "add_scheduled_recording_from_schedule_recording";
       model.client.parameter = [
            {name:"channel_id",     value:params.channel_id},
            {name:"description",    value:params.description},
            {name:"recurring_type", value:params.recurring_type},
            {name:"action_after",   value:0},
            {name:"start_time",     value:params.start_time},
            {name:"duration",       value:params.duration}
        ];
       request.send(model.client);
    },
    function (param) {
        ui.log("INFO", "Scheduled");
    }
);

me_tv.addAction(
    "get_configuration",
    function (param) {
       model.client.command = "get_configuration";
       request.send(model.client);
    },
    function (param) {
       console.log(param);
    }
);

me_tv.addAction(
    "get_status",
    function (param) {
       model.client.command = "get_status";
       request.send(model.client);
    },
    function (param) {
    }
);

/*
me_tv.addAction(
    "set_configuration",
    function (param) {
       return;
       model.client.command = "set_configuration";
       model.client.configuration = [
            {name:"",     value:""}
       ];
       request.send(model.client);
    },
    function (param) {
        console.log(param);
    }
);
*/
