if (typeof(Date.parseTime) == "undefined") {
    Date.parseTime = function (text) {
        var time = text.match(/(\d?\d):?(\d?\d?)/);
        var h = parseInt(time[1]);
        var m = parseInt(time[2]) || 0;

        if (h > 24) {
            // try a different format
            time = text.match(/(\d)(\d?\d?)/);
            h = parseInt(time[1]);
            m = parseInt(time[2]) || 0;
        }

        var d = new Date('1/1/1970');
        d.setHours(h);
        d.setMinutes(m);
        return +d;
    }
}

if ( typeof(Array.prototype.forEach) == "undefined") {
    Array.prototype.forEach = function (callback) {
        for(var i=0; i<this.length; i++){
            callback(this[i]);
        }
    }
}

if ( typeof(Array.prototype.indexOf) == "undefined") {
    Array.prototype.indexOf = function (needle) {
        for(var i=0; i<this.length; i++){
            if (needle == this[i]) {
                return i;
            }
        }
        return -1;
    }
}

if ( typeof(String.prototype.leftPad) == "undefined") {
    String.prototype.leftPad = function (paddingChar, maxLength) {
        var res = this;
        paddingChar = paddingChar.substr(0, 1);
        while (res.length < maxLength) {
            res = paddingChar + res;
        }
        return res;
    }
}
