# *
# * Copyright (C) 2012 Pascal Noisette
# *
# * This file is part of Me TV Http Module
# *
# * This program is free software; you can redistribute it and/or modify
# * it under the terms of the GNU General Public License as published by
# * the Free Software Foundation; either version 2 of the License, or
# * (at your option) any later version.
# * 
# * This program is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# * GNU Library General Public License for more details.
# * 
# * You should have received a copy of the GNU General Public License
# * along with this program; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
# *

import SimpleHTTPServer
from urlparse import urlparse
import cgi
import socket

HOST = '127.0.0.1'
PORT = 1999

class CombineHandler(SimpleHTTPServer.SimpleHTTPRequestHandler):

    def do_GET(self):

        url = urlparse(self.path)
        if url.path == "/foo" :
            query = cgi.parse_qs(url.query)["content"][0]

            s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            try:
                s.connect((HOST, PORT))
            except Exception, e:
                self.send_error(500, "Cannot connect to Me-tv Server")
                return None

            s.sendall(query)
            s.shutdown(1);
            
            total_data=[]
            while True:
                data = s.recv(1024)
                if not data: break
                total_data.append(data)
            result = ''.join(total_data)
            s.close()

            self.log_request("PASS")
            self.send_response(200)
            self.send_header("Content-Type", "text/html")
            self.end_headers()
            self.wfile.write(result)

        else :
             SimpleHTTPServer.SimpleHTTPRequestHandler.do_GET(self)
