/*
 * Copyright (C) 2011 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#ifndef __COMMON_H__
#define __COMMON_H__

#include <glibmm.h>
#include <unistd.h>

void replace_text(Glib::ustring& text, const Glib::ustring& from, const Glib::ustring& to);
Glib::ustring get_local_time_text(const gchar* format);
Glib::ustring get_local_time_text(time_t t, const gchar* format);
Glib::ustring encode_xml(const Glib::ustring& s);
Glib::ustring trim_string(const Glib::ustring& s);

void write_string(int fd, const Glib::ustring& data);
Glib::ustring read_string(int fd);

#endif
