/*
 * Copyright (C) 2011 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#include "me-tv.h"
#include "../common/i18n.h"
#include "../common/exception.h"
#include <glib/gprintf.h>

bool			verbose_logging			= false;
bool			safe_mode				= false;
bool			minimised_mode			= false;
bool			disable_epg_thread		= false;
bool			disable_epg				= false;
bool			no_screensaver_inhibit	= false;
Glib::ustring	devices;
gint			read_timeout			= 5;
Glib::ustring	server_host				= "localhost";
gint			server_port				= 1999;
Glib::ustring	engine_type				= "vlc";
Client			client;
Glib::ustring preferred_language;
guint		record_extra_before = 5;
guint		record_extra_after = 5;

Glib::RefPtr<Gtk::ToggleAction> toggle_action_fullscreen;
Glib::RefPtr<Gtk::ToggleAction> toggle_action_mute;
Glib::RefPtr<Gtk::ToggleAction> toggle_action_record_current;
Glib::RefPtr<Gtk::ToggleAction> toggle_action_visibility;

Glib::RefPtr<Gtk::Action> action_about;
Glib::RefPtr<Gtk::Action> action_auto_record;
Glib::RefPtr<Gtk::Action> action_channels;
Glib::RefPtr<Gtk::Action> action_change_view_mode;
Glib::RefPtr<Gtk::Action> action_decrease_volume;
Glib::RefPtr<Gtk::Action> action_epg_event_search;
Glib::RefPtr<Gtk::Action> action_increase_volume;
Glib::RefPtr<Gtk::Action> action_preferences;
Glib::RefPtr<Gtk::Action> action_present;
Glib::RefPtr<Gtk::Action> action_quit;
Glib::RefPtr<Gtk::Action> action_restart_server;
Glib::RefPtr<Gtk::Action> action_scheduled_recordings;

sigc::signal<void, int> signal_start_broadcasting;
sigc::signal<void> signal_stop_broadcasting;
sigc::signal<void, int> signal_add_scheduled_recording;
sigc::signal<void, int> signal_remove_scheduled_recording;
sigc::signal<void> signal_update;
sigc::signal<void, Glib::ustring> signal_error;

void log_handler(const gchar *log_domain, GLogLevelFlags log_level, const gchar *message, gpointer user_data)
{
	if (log_level != G_LOG_LEVEL_DEBUG || verbose_logging)
	{
		Glib::ustring time_text = get_local_time_text("%x %T");
		g_printf("%s: %s\n", time_text.c_str(), message);
	}
}

void on_error()
{
	try
	{
		throw;
	}
	catch (const Exception& exception)
	{
		signal_error(exception.what());
	}
	catch (const Glib::Error& exception)
	{
		signal_error(exception.what());
	}
	catch (...)
	{
		g_message("Unhandled exception");
		signal_error("Unhandled exception");
	}
}

void start_server()
{
	if (server_host != "localhost" && server_host != "127.0.0.1")
	{
		throw Exception("Can only start a local server");
	}

	Glib::spawn_command_line_async("me-tv-server");

	int wait_time = 0;
	while (wait_time++ < 5 && !client.is_registered())
	{
		sleep(1);
		
		g_debug("Attempting to register");
		try
		{
			client.register_client(server_host, server_port);
			g_debug("Registered with client ID %d", client.get_client_id());
		}
		catch (...)
		{
			on_error();
		}
	}

	if (!client.is_registered())
	{
		signal_error("Failed to register with Me TV Server");
	}
}

