--- a/cmsimple/cms.php
+++ b/cmsimple/cms.php
@@ -7,8 +7,8 @@
 /* utf8-marker = äöü */
 /*
   ======================================
-  $CMSIMPLE_XH_VERSION$
-  $CMSIMPLE_XH_DATE$
+  CMSimple_XH 1.5.6~agaida.4
+  2013-05-25
   based on CMSimple version 3.3 - December 31. 2009
   For changelog, downloads and information please see http://www.cmsimple-xh.org
   ======================================
@@ -61,9 +61,9 @@
 //);
 
 //HI 2009-10-30 (CMSimple_XH 1.0rc3) added version-informations
-define('CMSIMPLE_XH_VERSION', '$CMSIMPLE_XH_VERSION$');
-define('CMSIMPLE_XH_BUILD', '$CMSIMPLE_XH_BUILD$');
-define('CMSIMPLE_XH_DATE', '$CMSIMPLE_XH_DATE$');
+define('CMSIMPLE_XH_VERSION', 'CMSimple_XH 1.5.6~agaida.4');
+define('CMSIMPLE_XH_BUILD', '20130525');
+define('CMSIMPLE_XH_DATE', '2013-05-25');
 //version-informations
 
 if (preg_match('/cms.php/i', sv('PHP_SELF')))
@@ -81,19 +81,23 @@
 $pth['file']['content'] = $pth['folder']['content'] . 'content.htm';
 $pth['file']['pagedata'] = $pth['folder']['content'] . 'pagedata.php';
 
-$pth['folder']['base'] = is_dir('./cmsimple') ? './' : '../';
+//if (@is_dir('./cmsimple/'))
+//    $pth['folder']['base'] = './';
+//else
+//    $pth['folder']['base'] = './../';
 
 $pth['folder']['cmsimple'] = $pth['folder']['base'] . 'cmsimple/';
-
-$pth['file']['log'] = $pth['folder']['cmsimple'] . 'log.txt';
+$pth['file']['log'] = $pth['folder']['base'] . 'logs/log.txt';
 $pth['file']['cms'] = $pth['folder']['cmsimple'] . 'cms.php';
-$pth['file']['config'] = $pth['folder']['cmsimple'] . 'config.php';
+$pth['folder']['config'] = $pth['folder']['base'] . 'config/';
+$pth['file']['config'] = $pth['folder']['config'] . 'config.php';
 
-if (file_exists($pth['folder']['cmsimple'].'defaultconfig.php')) {
-    include($pth['folder']['cmsimple'].'defaultconfig.php');
+if (file_exists($pth['folder']['config'].'defaultconfig.php')) {
+	include($pth['folder']['config'].'defaultconfig.php');
 }
+
 if (!include($pth['file']['config']))
-    die('Config file missing');
+	die('Config file missing  #cms #die002');
 
 //for compatibility XH with older versions
 if (!isset($cf['folders']['userfiles']))
@@ -117,7 +121,7 @@
 $errors = array();
 
 $pth['folder']['language'] = $pth['folder']['cmsimple'] . 'languages/';
-$pth['folder']['langconfig'] = $pth['folder']['cmsimple'] . 'languages/';
+$pth['folder']['langconfig'] = $pth['folder']['config'];
 if (preg_match('/\/[A-z]{2}\/[^\/]*/', sv('PHP_SELF')))
     $sl = strtolower(preg_replace('/.*\/([A-z]{2})\/[^\/]*/', '\1', sv('PHP_SELF')));
 
@@ -133,25 +137,29 @@
 if (!isset($sl))
     $sl = $cf['language']['default'];
 $pth['file']['language'] = $pth['folder']['language'] . basename($sl) . '.php';
-$pth['file']['langconfig'] = $pth['folder']['language'] . basename($sl) . 'config.php';
+$pth['file']['langconfig'] = $pth['folder']['config'] . basename($sl) . 'config.php';
 $pth['file']['corestyle'] = $pth['folder']['base'] . 'css/core.css';
 
+
 if (!file_exists($pth['file']['language'])) {
     copy($pth['folder']['language'].'default.php', $pth['file']['language']);
 }
+
 if (!file_exists($pth['file']['langconfig'])) {
-    copy($pth['folder']['language'].'defaultconfig.php', $pth['file']['langconfig']);
+    copy($pth['folder']['config'].'defaultlangconfig.php', $pth['file']['langconfig']);
 }
 
 if (!file_exists($pth['file']['language']) && !file_exists($pth['folder']['language'].'default.php')) {
     die('Language file ' . $pth['file']['language'] . ' missing');
 }
-if (!file_exists($pth['file']['langconfig']) && !file_exists($pth['folder']['language'].'defaultconfig.php')) {
+if (!file_exists($pth['file']['langconfig']) && !file_exists($pth['folder']['config'].basename($sl) . 'config.php')) {
     die('Language config file ' . $pth['file']['langconfig'] . ' missing');
 }
 
+//  loading the defaults is absolutely nonsense - if the langfiles not exists, they will be created in the lines above
+//  if this goes wrong - poss. because rights - one have a much bigger problem with his installation
 include $pth['folder']['language'] . 'default.php';
-include $pth['folder']['language'] . 'defaultconfig.php';
+include $pth['folder']['config'] . 'defaultlangconfig.php';
 include $pth['file']['language'];
 include $pth['file']['langconfig'];
 
@@ -159,7 +167,6 @@
 $pth['folder']['template'] = $pth['folder']['templates'] . $cf['site']['template'] . '/';
 
 // for subsite solution - GE 20011-02
-
 if($txc['subsite']['template']=="")
 {
 	$pth['folder']['template'] = $pth['folder']['templates'].$cf['site']['template'].'/';
