<?php
 /**
  * RichPage - main index.php
  *
  * Stores rich page informations (subtitle, use_sub_in_title, slogan,
  * logo_pri and logo_sec) per page.
  * index.php is called by pluginloader and
  * returns (x)html-rich-page to template.
  *
  * @author Alf Gaida
  * @link http://www.g-com.eu
  * @version v0.1.01
  * @package richpage
  */

/**
 * Check if PLUGINLOADER is calling and die if not
 */
if (!defined('PLUGINLOADER')) {
    die('Plugin ' . basename(dirname(__FILE__)) . ' requires a newer version of the Pluginloader. No direct access.');
}

global $sl, $plugin_tx;

/**
 * Include language package
 */

include_once "languages/$sl.php";

/**
 * If not existent, create it
 */
if (! isset ($txc['site']['subtitle'])) {
    $txc['site']['subtitle'] = "Enter your subtitle here";
}
if (! isset ($txc['site']['use_sub_in_title'])) {
    $txc['site']['use_sub_in_title'] = "true";
}
if (! isset ($txc['site']['slogan'])) {
    $txc['site']['slogan'] = "";
}
if (! isset ($txc['site']['logo_pri'])) {
    $txc['site']['logo_pri'] = "";
}
if (! isset ($txc['site']['logo_pri_link'])) {
    $txc['site']['logo_pri_link'] = "";
}
if (! isset ($txc['site']['logo_sec'])) {
    $txc['site']['logo_sec'] = "";
}
if (! isset ($txc['site']['logo_sec_link'])) {
    $txc['site']['logo_sec_link'] = "";
}
if (! isset ($txc['site']['logo_pri_alttext'])) {
    $txc['site']['logo_pri_alttext'] = "";
}
if (! isset ($txc['site']['logo_sec_alttext'])) {
    $txc['site']['logo_sec_alttext'] = "";
}
if (! isset ($txc['site']['favicon'])) {
    $txc['site']['favicon'] = "favicon.ico";
}
if (! isset ($txc['site']['separator'])) {
    $txc['site']['separator'] = "•";
}
if (! isset ($txc['piwik']['enabled'])) {
    $txc['piwik']['enabled'] = "";
}
if (! isset ($txc['piwik']['base_url'])) {
    $txc['piwik']['base_url'] = "";
}
if (! isset ($txc['piwik']['site_id'])) {
    $txc['piwik']['site_id'] = "";
}
if (! isset ($txc['piwik']['disclaimer'])) {
    $txc['piwik']['disclaimer'] = "";
}
if (! isset ($txc['topmenu']['menu'])) {
    $txc['topmenu']['menu'] = "";
}
if (! isset ($txc['legals']['imprint_label'])) {
    $txc['legals']['imprint_label'] = "Add your Imprint_label here!";
}
if (! isset ($txc['legals']['imprint'])) {
    $txc['legals']['imprint'] = "Add your Imprint here!";
}
if (! isset ($txc['legals']['privacy_label'])) {
    $txc['legals']['privacy_label'] = "Add your privacy_label here!";
}
if (! isset ($txc['legals']['privacy'])) {
    $txc['legals']['privacy'] = "Add your privacy declaration here!";
}
if (! isset ($txc['legals']['terms_of_service_label'])) {
    $txc['legals']['terms_of_service_label'] = "Add your terms_of_service label here!";
}
if (! isset ($txc['legals']['terms_of_service'])) {
    $txc['legals']['terms_of_service'] = "Add your terms declaration here!";
}



/**
 * Add used interests to router
 */
$pd_router -> add_interest('subtitle');
$pd_router -> add_interest('use_sub_in_title');
$pd_router -> add_interest('slogan');
$pd_router -> add_interest('logo_pri');
$pd_router -> add_interest('logo_pri_link');
$pd_router -> add_interest('logo_pri_alttext');
$pd_router -> add_interest('logo_sec');
$pd_router -> add_interest('logo_sec_link');
$pd_router -> add_interest('logo_sec_alttext');
$pd_router -> add_interest('favicon');
$pd_router -> add_interest('separator');
$pd_router -> add_interest('enabled');
$pd_router -> add_interest('base_url');
$pd_router -> add_interest('site_id');
$pd_router -> add_interest('disclaimer');
$pd_router -> add_interest('topmenu');
$pd_router -> add_interest('imprint_label');
$pd_router -> add_interest('imprint');
$pd_router -> add_interest('privacy_label');
$pd_router -> add_interest('privacy');
$pd_router -> add_interest('terms_of_service_label');
$pd_router -> add_interest('terms_of_service');

/**
 * Add a tab for admin-menu
 */
$pd_router -> add_tab($plugin_tx['richpage']['tab'], $pth['folder']['plugins'] ."richpage/richpage_view.php");

/**
 * Set the meta tags contents.
 */
if ($pd_current['subtitle']) {
    $txc['site']['subtitle'] = $pd_current['subtitle'];
}
if ($pd_current['use_sub_in_title']) {
    $txc['site']['use_sub_in_title'] = $pd_current['use_sub_in_title'];
}
if ($pd_current['slogan']) {
    $txc['site']['slogan'] = $pd_current['slogan'];
}
if ($pd_current['logo_pri']) {
    $txc['site']['logo_pri'] = $pd_current['logo_pri'];
}
if ($pd_current['logo_pri_link']) {
   $txc['site']['logo_pri_link'] = $pd_current['logo_pri_link'];
}
if ($pd_current['logo_pri_alttext']) {
    $txc['site']['logo_pri_alttext'] = $pd_current['logo_pri_alttext'];
}
if ($pd_current['logo_sec']) {
    $txc['site']['logo_sec'] = $pd_current['logo_sec'];
}
if ($pd_current['logo_sec_link']) {
    $txc['site']['logo_sec_link'] = $pd_current['logo_sec_link'];
}
if ($pd_current['logo_sec_alttext']) {
    $txc['site']['logo_sec_alttext'] = $pd_current['logo_sec_alttext'];
}
if ($pd_current['favicon']) {
    $txc['site']['favicon'] = $pd_current['favicon'];
}
if ($pd_current['separator']) {
    $txc['site']['separator'] = $pd_current['separator'];
}
if ($pd_current['enabled']) {
   $txc['piwik']['enabled'] = $pd_current['enabled'];
}
if ($pd_current['base_url']) {
    $txc['piwik']['base_url'] = $pd_current['base_url'];
}
if ($pd_current['site_id']) {
    $txc['piwik']['site_id'] = $pd_current['site_id'];
}
if ($pd_current['disclaimer']) {
    $txc['piwik']['disclaimer'] = $pd_current['disclaimer'];
}
if ($pd_current['topmenu']) {
    $txc['topmenu']['menu'] = $pd_current['topmenu'];
}
if ($pd_current['imprint_label']) {
    $txc['legals']['imprint_label'] = $pd_current['imprint_label'];
}
if ($pd_current['imprint']) {
    $txc['legals']['imprint'] = $pd_current['imprint'];
}
if ($pd_current['privacy_label']) {
    $txc['legals']['privacy_label'] = $pd_current['privacy_label'];
}
if ($pd_current['privacy']) {
    $txc['legals']['privacy'] = $pd_current['privacy'];
}
if ($pd_current['terms_of_service_label']) {
    $txc['legals']['terms_of_service_label'] = $pd_current['terms_of_service_label'];
}
if ($pd_current['terms_of_service']) {
    $txc['legals']['terms_of_service'] = $pd_current['terms_of_service'];
}


/**
 * Basic Functions
 */
function separator($show = true ) {
    global $cf;
    if ($show) {
        $t = " ".$cf['site']['separator']." ";
        echo $t;
    }
}

function make_link($title,$ref,$text,$class,$rel) {
    $ref= "href=\"$ref\" ";
    if ($title != '') {
        $title= "title = \"$title\" ";
    }
    if ($class != '') {
        $class= "class = \"$class\" ";
    }
    if ($rel != '') {
       $rel= "rel = \"$rel\" ";
    }
    $t = "<a $ref $title $class $rel > $text </a>";
    return $t;
}

/**
 * Advanced Functions
 */

/*
 * function gc_doctype 2012-08-28
 */
function gc_doctype() {
    global $cf;
    $t = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">'."\n";
    if ($cf['xhtml']['endtags'] == 'true') {
        $t = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">'."\n";
    }
    echo $t;
}

/*
 * function gc_html 2012-08-28
 */
function gc_html() {
    global $cf;
    $t="<html>\n";
    if ($cf['xhtml']['endtags'] == 'true') {
        $t = "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n";
    }
    echo $t;
}

/*
 * function gc_body() 2012-08-29
 */
function gc_body() {
    $t = "<body " . onload() . ">";
    echo $t;
}


/*
 * function gc_locator() 2012-08-29
 */
function gc_locator() {
    $t = locator();
    echo $t;
}

/*
 * function gc_languagemenu() 2012-08-29
 */
function gc_languagemenu() {
    $t = languagemenu();
    echo $t;
}

/*
 * function gc_editmenu() 2012-08-29
 */
function gc_editmenu() {
    $t = editmenu();
    echo $t;
}

/*
 * function gc_content() 2012-08-29
 */
function gc_content() {
    $t = content();
    echo $t;
}

/*
 * function gc_sitemaplink() 2012-08-29
 */
function gc_sitemaplink() {
    $t = sitemaplink();
    echo $t;
}

/*
 * function gc_loginlink() 2012-08-29
 */
function gc_loginlink() {
    $t = loginlink();
    echo $t;
}

/*
 * function gc_mailformlink() 2012-08-29
 */
function gc_mailformlink() {
    $t = mailformlink();
    echo $t;
}

/*
 * function gc_lastupdate() 2012-08-29
 */
function gc_lastupdate() {
    $t = lastupdate();
    echo $t;
}

/*
 * function piwik() 2012-08-28
 *
 */
function piwik() {
    global $cf,$txc;
    if (! isset($txc['piwik']['enabled'])) {
        $txc['piwik']['enabled']="false";
        $txc['piwik']['base_url']="without http:// or https:// but trailing /";
        $txc['piwik']['site_id']="your id";
        $txc['piwik']['disclaimer']="false";
    }

    $t  = '<!-- Piwik -->'."\n";
    $t .= '<script type="text/javascript">'."\n";
    $t .= '   var _paq = _paq || [];'."\n";
    $t .= '    /* tracker methods like "setCustomDimension" should be called before "trackPageView" */'."\n";
    $t .= '    _paq.push(['trackPageView']);'."\n";
    $t .= '    _paq.push(['enableLinkTracking']);'."\n";
    $t .= '    (function() {'."\n";
    $t .= '        var u="//piwik.siduction.org/";'."\n";
    $t .= '       _paq.push(['setTrackerUrl', u+'piwik.php']);'."\n";
    $t .= '       _paq.push(['setSiteId', '3']);'."\n";
    $t .= '        var d=document, g=d.createElement('script'), s=d.getElementsByTagName('script')[0];'."\n";
    $t .= '        g.type='text/javascript'; g.async=true; g.defer=true; g.src=u+'piwik.js'; s.parentNode.insertBefore(g,s);'."\n";
    $t .= '   })();'."\n";
    $t .= '</script>'."\n";
    $t .= '<noscript><p><img src="//piwik.siduction.org/piwik.php?idsite=3&rec=1" style="border:0;" alt="" /></p></noscript>'."\n";
    $t .= '<!-- End Piwik Code -->."\n";


    if ($txc['piwik']['enabled'] == 'true') {
        echo $t;
    }
}

/*
 * function top_menu 2013-02-02
 *
 */
function top_menu() {
    global $txc;
    if ($txc['topmenu']['menu'] != '' ) {
        $t  = "<div id=\"top_navigation\">\n";
        $t .= "<ul>\n";
        $t .= $txc['topmenu']['menu'];
        $t .= "</ul>\n";
        $t .= "</div>\n";
        echo $t;
    }
}

function cms_link($show = true, $separator_before = false, $separator_after = true) {
    // ToDo: rethink constansts - make it a variable
    $cms_title = "cms";
    $cms_text = "cms";
    $cms_class = "";
    $cms_ref = "http://www.cmsimple-xh.org/";
    $cms_rel = "nofollow";
    // implementation
    $t = make_link($cms_title, $cms_ref, $cms_text, $cms_class, $cms_rel);
    if ($show) {
        if ($separator_before) {
            separator();
        }
        echo $t;
        if ($separator_after) {
            separator() . "\n";
        }
    }
}

function css_validate($show = true, $separator_before = false, $separator_after = true) {
    // ToDo: rethink constansts - make it a variable
    $css_title = "css";
    $css_text = "css";
    $css_class = "";
    $css_ref = "http://jigsaw.w3.org/css-validator/check/?uri=";
    $css_options = "&amp;profile=css3&amp;usermedium=all&amp;warning=0&amp;lang=de" ;
    $css_rel = "nofollow";
    // Implementation
    $url = cur_url();
    $css_url = $css_ref . $url . $css_options;
    $t = make_link($css_title, $css_url, $css_text, $css_class, $css_rel);
    if ($show) {
        if ($separator_before) {
            separator();
        }
        echo $t;
        if ($separator_after) {
            separator() . "\n";
        }
    }
}

function support_link($show = true, $separator_before = false, $separator_after = true) {
    // ToDo: rethink constansts - make it a variable
    $support_title = "g-com";
    $support_text = "g-com";
    $support_text = "g-com";
    $support_ref = "http://g-com.eu/";
    $support_rel = "nofollow";
    // Implementation
    $t = make_link($show = true, $support_title, $support_ref, $support_text, $support_class, $support_rel);
    if ($show) {
        if ($separator_before) {
            separator();
        }
        echo $t;
        if ($separator_after) {
            separator() . "\n";
        }
    }
}

function w3c_validate($show = true,  $separator_before = false, $separator_after = true) {
    // ToDo: rethink constansts - make it a variable
    $w3c_title = "w3c";
    $w3c_text = "w3c";
    $w3c_class = "";
    $w3c_ref = "http://validator.w3.org/check?uri=";
    $w3c_rel = "nofollow";

    // Implementation;
    $url = cur_url();
    $w3c_url = $w3c_ref . $url ;
    $t = make_link($w3c_title, $w3c_url, $w3c_text, $w3c_class, $w3c_rel);
    if ($show) {
        if ($separator_before) {
            separator();
        }
        echo $t;
        if ($separator_after) {
            separator() . "\n";
        }
    }
}


function header_logo() {
    global $txc;
    $t='';
    if (isset($txc['site']['logo_pri'])) {
        if ($txc['site']['logo_pri'] != 'none') {
            $logo = $txc['site']['logo_pri'];
            if (isset($txc['site']['logo_pri_link'])) {
                if ($txc['site']['logo_pri_link'] != 'none') {
                    $link = $txc['site']['logo_pri_link'];
                }
            }
            if (isset($txc['site']['logo_pri_alttext'])) {
                if ($txc['site']['logo_pri_alttext'] != 'none') {
                    $alttext = $txc['site']['logo_pri_alttext'];
                }
            }
            $t .= "<div id=\"header_logo\">\n";
            $t .= "<a class=\"pict_link\" href=\"$link\">\n";
            $t .= tag("img id=\"header_logo_img\" src=\"$logo\" alt=\"$alttext\" ") . "\n";
            $t .= "</a>\n";
            $t .= "</div>\n";
        }
    }
    echo $t;
}

function header_logo2() {
    global $txc;
    $t='';
    if (isset($txc['site']['logo_sec'])) {
        if ($txc['site']['logo_sec'] != 'none') {
            $logo = $txc['site']['logo_sec'];
            if (isset($txc['site']['logo_sec_link'])) {
                if ($txc['site']['logo_sec_link'] != 'none') {
                    $link = $txc['site']['logo_sec_link'];
                }
            }
            if (isset($txc['site']['logo_sec_alttext'])) {
                if ($txc['site']['logo_sec_alttext'] != 'none') {
                    $alttext = $txc['site']['logo_sec_alttext'];
                }
            }
            $t .= "<div id=\"header_logo2\">\n";
            $t .= "<a class=\"pict_link\" href=\"$link\">\n";
            $t .= tag("img id=\"header_logo_img2\" src=\"$logo\" alt= \"$alttext\" ") . "\n";
            $t .= "</a>\n";
            $t .= "</div>\n";
        }
    }
    echo $t;
}

/* Rework needed */
    // function gc_head()
    function gc_head() {
        global $title, $cf, $pth, $tx, $hjs;
        $t='';
        if (isset($cf['site']['title']) && $cf['site']['title'] != '') {
            $t .= $cf['site']['title'].' - ';
            }
        if (isset($cf['site']['subtitle']) && ($cf['site']['subtitle'] != '')
            && ($cf['site']['use_sub_in_title'] == 'true')) {
            $t .= $cf['site']['subtitle'].' - ';
        }

        if ($t != '') {
            $t .= $title;
        } else {
            $t = $title;
        }

        $t = "<title>" . strip_tags($t) . "</title>\n";

        foreach($cf['meta'] as $i => $k) {
            $t .= meta($i);
        }

        if ($tx['meta']['codepage'] != '') {
            $t = tag("meta http-equiv=\"content-type\" content=\"text/html;charset=" . $tx['meta']['codepage'] . '"') ."\n$t";
        }

        $t .= tag("meta name=\"generator\" content =\"" . CMSIMPLE_XH_VERSION  . CMSIMPLE_XH_BUILD . " - www.cmsimple-xh.org\" ") . "\n";
        // Pfad zu Font-Dateien und stylesheet.css
        // ist fest im Templateverzeichnis das Verzeichnis ./webfonts/stylesheet.css
        // Dokumentieren!!
        $t .= tag('link rel="stylesheet" href="' . $pth['file']['corestyle'] . '" type="text/css"') . "\n";
        $t .= tag('link rel="stylesheet" href= "'.$pth['folder']['template'].'webfonts/stylesheet.css" type="text/css"')."\n";
        $t .= tag('link rel="stylesheet" href="'.$pth['file']['stylesheet'].'" type="text/css"')."\n";
        $t .= gc_favicon();
        $t .= $hjs;
        echo $t;
    }

    // function gc_favicon() - by AG 2010-02-04
    function gc_favicon() {
        global $cf;
        $t = '';
        if (isset($cf['site']['favicon'])) {
            $f = ($cf['site']['favicon']);
            if ($f != '') {
                if ($f != 'none') {
                    $t = tag('link rel="shortcut icon" type="image/x-icon" href="./'.$f.'"');
                }
            }
        }
        return $t;
    }

    // function gc_toc() - AG 2012-08-29
    function gc_toc() {
        global $cl;
        $ta= array();
        for ($i= 0; $i < $cl; $i++) {
            if (!hide($i)) {
                $ta[] = $i;
            }
        }
        $t = li($ta, 'menulevel');
        echo $t;
    }



    // function gc_title() - by AG 2010-02-04
    function gc_title() {
        global $cf;
        $t = '';
        if (isset($cf['site']['title'])) {
            $f = $cf['site']['title'];
            if ($f !='') {
                if ($f != 'none') {
                    $t = '<h1>'.$f.'</h1>'."\n";
                }
            }
        }
        return $t;
    }

    // function subtitle() - by AG 2010-01-19
    function gc_subtitle() {
        global $cf;
        $t = '';
        if (isset($cf['site']['subtitle'])) {
            $f = $cf['site']['subtitle'];
            if ($f !='') {
                if ($f != 'none') {
                        $t = '<h2>'.$f.'</h2>'."\n" ;
                }
            }
        }
        return $t;
    }

    // function use_sub_in_title() - by AG 2010-01-19
    function gc_use_sub_in_title() {
        global $cf;
        $t = '';
        if (isset($cf['site']['use_sub_in_title'])) {
            $t .= $cf['site']['use_sub_in_title'];
        }
        return $t;
    }

    // function slogan()
    function gc_slogan() {
        global $cf;
        $t = '';
        if (isset($cf['site']['slogan'])) {
            $t .= $cf['site']['slogan'];
        }
        return $t;
    }


/**
 * Restructuration start
 * Get rid of userfuncs
 */

/**
 * Not reviewed yet
 */
    function page_navigation() {
        global $tx;
        // (FixMe) frei wählbarer Trenner
        $prev_page= previouspage();
        $page_top= top();
        $next_page= nextpage();
        if ($prev_page != '') {
            $t= $prev_page;
        } else {
            $t= $tx['navigator']['previous'];
        }
        // (FixMe) frei wählbarer Trenner
        $t .= ' • ' .$page_top .' • ';
        if ($next_page != '') {
            $t .= $next_page;
        } else {
            $t .= $tx['navigator']['next'];
        }
        return $t;
    }

    function cur_url() {
        $t = (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS']=='on'))?'https':'http';
        $t.= '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
        return $t;
    }

    function load_my_html($external_html_file) {
        //hier muss funktionaler code hin, der einfach
        //nur ein html-File lädt. Und das aus meinem Pool ;)
        // Thema durch
        $t = "";
        if (file_exists($external_html_file)) {
                $t = file_get_contents($external_html_file);
        }
        return $t;
    }

    function safe_include($u) {
        $ch = curl_init();
        curl_setopt ($ch, CURLOPT_URL,$u);
        curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
        $t = curl_exec($ch);
        curl_close($ch);
        return $t;
    }

/* new legals functions */


function imprintlink($show = true, $separator_before = true, $separator_after = true) {
    global $sn, $plugin_tx, $txc;
    if ($show) {
        $lang = $plugin_tx['richpage'];
        $title = "Imprint";
        $ref = $sn . "?" . uenc($lang['imprint']);
        $text = $txc['legals']['imprint_label'];
        $class = "";
        $rel = "nofollow";
        $t = make_link($title, $ref, $text, $class, $rel);
        if ($separator_before) {
            separator();
        }
        echo $t;
        if ($separator_after) {
            separator() . "\n";
        }
    }
}

function printpublisher($show = true, $islink = false, $separator_before = false, $separator_after = true) {
    global $sn, $plugin_tx, $cf;
    $lang = $cf['meta'];
    if ($show) {
        if ($islink) {
            $title = "Publisher";
            $ref = $sn . "?" . uenc($lang['publisher']);
            $text = $lang['publisher'];
            $class = "";
            $rel = "nofollow";
            $t = make_link($title, $ref, $text, $class, $rel);
        } else {
            $t = $lang['publisher'];
        }
        if ($separator_before) {
            separator();
        }
        echo $t;
        if ($separator_after) {
            separator() . "\n";
        }
    }
}

function privacylink($show = true, $separator_before = true, $separator_after = true) {
    global $sn, $plugin_tx, $txc;
    if ($show) {
        $lang = $plugin_tx['richpage'];
        $title = "Privacy";
        $ref = $sn . "?" . uenc($lang['privacy']);
        $text = $txc['legals']['privacy_label'];
        $class = "";
        $rel = "nofollow";
        $t = make_link($title, $ref, $text, $class, $rel);
        if ($separator_before) {
            separator();
        }
        echo $t;
        if ($separator_after) {
            separator() . "\n";
        }
    }
}

function termslink($show = true, $separator_before = true, $separator_after = false) {
    global  $sn, $plugin_tx, $txc;
    if ($show) {
        $lang = $plugin_tx['richpage'];
        $title = "Terms";
        $ref = $sn . "?" . uenc($lang['terms_of_service']);
        $text = $txc['legals']['terms_of_service_label'];
        $class = "";
        $rel = "nofollow";
        $t = make_link($title, $ref, $text, $class, $rel);
        if ($separator_before) {
            separator();
        }
        echo $t;
        if ($separator_after) {
            separator() . "\n";
        }
    }
}

$lang = $plugin_tx['richpage'];
//var_dump($plugin_tx);
$o .= legal_page($su, $sl, $lang, 'terms_of_service');
$o .= legal_page($su, $sl, $lang, 'privacy');
$o .= legal_page($su, $sl, $lang, 'imprint');

//var_dump($lang);
/**
 * Implementation legals with fallback
 *
 * ToDo: Hilfetexte Multilang
 *
 */
function legal_page($su, $sl, $lang, $pagename) {
    global $txc;
    $t = '';
    $label = $lang["$pagename"];
    if ($su == uenc($label)) {
        $t = "<h1>$label</h1>" . tag('br');
        $t .= $txc['legals']["$pagename"];
    }
    return $t;
}
?>
