#!/bin/bash
#
# Erik Troan <ewt@redhat.com> 
#
# Copyright 1998 Red Hat Software
#
# This software may be freely redistributed under the terms of the GNU
# public license.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

while [ $# -gt 0 ]; do
    case $1 in
	--arch)
	    shift
	    ARCH=$1
	    ;;

	--version)
	    shift
	    VERSION=$1
	    ;;

	--site)
	    shift
	    SITE=$1
	    ;;
	
	--dest)
	    shift
	    DEST=$1
	    ;;

	--subdir)
	    shift
	    SUBDIR=$1
	    ;;

	*)
	    break
	    ;;
    esac

    shift
done

. ../../locations.include
echo $SITE
echo $RELEASEDIR

TREE=$RELEASEDIR
if [ ! -d $TREE/$SUBDIR ]; then
    echo "$TREE/$SUBDIR directory does not exist."
    exit 1
fi

if [ -z "$DEST" ]; then
    echo "--dest needs to be defined."
    exit 1
fi

echo "Creating $DEST from $TREE/$SUBDIR"

cd $TREE/$SUBDIR

# Create the image (This is for disk 2)
mkisofs \
	-A "$SITE $DEFAULT DISC2" \
	-R -l -v -J \
	-x ./lost+found \
	-o $DEST \
	. 
