-- Copyright (c) 1991-2002, The Numerical ALgorithms Group Ltd.
-- All rights reserved.
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions are
-- met:
--
--     - Redistributions of source code must retain the above copyright
--       notice, this list of conditions and the following disclaimer.
--
--     - Redistributions in binary form must reproduce the above copyright
--       notice, this list of conditions and the following disclaimer in
--       the documentation and/or other materials provided with the
--       distribution.
--
--     - Neither the name of The Numerical ALgorithms Group Ltd. nor the
--       names of its contributors may be used to endorse or promote products
--       derived from this software without specific prior written permission.
--
-- THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
-- IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
-- TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
-- PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
-- OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
-- EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
-- PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
-- PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
-- LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
-- NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
-- SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

)package "BOOT"

bcFinish(name,arg,:args) == bcGen bcMkFunction(name,arg,args)

bcMkFunction(name,arg,args) ==
  args := [x for x in args | x]
  STRCONC(name,'"(",arg,"STRCONC"/[STRCONC('",", x) for x in args],'")")

bcString2HyString2 s ==
  (STRINGP s) and (s.0 = char '_")  =>
    len := #s
    STRCONC('"\_"", SUBSTRING(s, 1, len-2), '"\_"")
  s

bcString2HyString s == s

bcFindString(s,i,n,char) ==  or/[j for j in i..n | s.j = char]

bcGen command ==
  htInitPage('"Basic Command",nil)
  string :=
    #command < 50 => STRCONC('"{\centerline{\tt ",command,'" }}")
    STRCONC('"{\tt ",command,'" }")
  htMakePage [
     '(text
        "{Here is the FriCAS command you could have issued to compute this result:}"
            "\vspace{2}\newline "),
      ['text,:string]]
  htMakeDoitButton('"Do It", command)
  htShowPage()

bcOptional s ==
  s = '"" => '"2"
  s

bcvspace() == bcHt '"\vspace{1}\newline "

bcString2WordList s == fn(s,0,MAXINDEX s) where
  fn(s,i,n) ==
    i > n => nil
    k := or/[j for j in i..n | s.j ~= char '_  ]
    null INTEGERP k => nil
    l := bcFindString(s,k + 1,n,char '_  )
    null INTEGERP l => [SUBSTRING(s,k,nil)]
    [SUBSTRING(s,k,l-k),:fn(s,l + 1,n)]


bcwords2liststring u ==
  null u => nil
  STRCONC('"[",first u,fn rest u) where
    fn(u) ==
      null u => '"]"
      STRCONC('", ",first u,fn rest u)

bcVectorGen vec == bcwords2liststring vec

bcError string ==
  sayBrightlyNT '"NOTE: "
  sayBrightly string

bcDrawIt(ind,a,b) == STRCONC(ind,'"=",a,'"..",b)

bcNotReady htPage ==
  htInitPage('"Basic Command",nil)
  htMakePage '(
     (text .
        "{\centerline{\em This facility will soon be available}}"))
  htShowPage()

htStringPad(n,w) ==
  s := STRINGIMAGE n
  ws := #s
  STRCONC('"\space{",STRINGIMAGE (w - ws + 1),'"}",s)

stringList2String x ==
  null x => '"()"
  STRCONC('"(",first x,"STRCONC"/[STRCONC('",",y) for y in rest x],'")")

htMkName(s,n) == STRCONC(s,STRINGIMAGE n)
