\documentclass{article}
\usepackage{axiom}
\begin{document}
\title{\$SPAD/src/algebra invrender.as}
\author{The Axiom Team}
\maketitle
\begin{abstract}
\end{abstract}
\eject
\tableofcontents
\eject
\section{RenderTools}
<<RenderTools>>=
#include "axiom"

POINT ==> Point DoubleFloat;
NNI   ==> NonNegativeInteger;
SI    ==> SingleInteger;

RenderTools: with {
	renderToFile!:  (FileName, ThreeSpace DoubleFloat) -> ();
	makeSceneGraph: (ThreeSpace DoubleFloat) 	   -> IVNodeObject;
} == add {
	import from IVUtilities;

	renderToFile!(f: FileName, space: ThreeSpace DoubleFloat): () == {
		root := makeSceneGraph(space);
		write!(f, root);
	}

	local makePts: (lpts: List POINT,
			indicies: List List List NonNegativeInteger) ->
				(List POINT, List DoubleFloat);

	local makePts(lp: List POINT, indicies: List List List NonNegativeInteger):
				(List POINT, List DoubleFloat) == {
		local colorIdx: Integer;
		indexList := concat concat indicies;
		coordpts := lp;
		if (# first lp = 4) then colorIdx := 4 else colorIdx := 3;
		colors := [pt.colorIdx for pt in lp];
		(coordpts, colors)
	}

	local makeBaseColor(l: List DoubleFloat): IVBaseColor == {
		-- This works by interpolating between blue and green (via cyan).
		-- There may well be better ways...
		import from POINT;
		import from List POINT;
		import from DoubleFloat;
		import from List DoubleFloat;
		low  := 10000.0;
		high := -10000.0;
		for df in l repeat {
			if low  > df then low  := df;
			if high < df then high := df;
		}
		if (high = low) then high := high + 1.0;
		new [ point([0, (df - low)/(high - low), (high - df)/(high - low)])
			for df in l]
	}
	makeSceneGraph(space: ThreeSpace DoubleFloat): IVNodeObject == {
		import from List ThreeSpace DoubleFloat;
		import from List List List NNI;
		import from Integer;
		import from Symbol;
		import from IVValue;
		check(space);
		lpts := lp(space);
	      	indicies := lllip(space);
		root: IVSeparator  := new();
		(coordpts, colorvalues) := makePts(lpts, indicies);
		coords: IVCoordinate3 := new coordpts;
		colors: IVBaseColor   := makeBaseColor(colorvalues);
		addChild!(root, coerce coords);
		addChild!(root, coerce colors);
		binding: IVBasicNode := make "MaterialBinding";
		addField!(binding, "value", symbol "PER__VERTEX");
		addChild!(root, coerce binding);
		offset: NNI := 0;
	      	for ss in components space
	      	for index in indicies repeat {
			local coordIndex: List NNI;
			default i: Integer;
	        	closedCurve? ss => {
        			n: Integer := (#(index.1))::Integer;
          			coordIndex :=
					[offset+coerce(i) for i in 0..n::Integer];
				-- Close the curve
          			setlast!(coordIndex,offset);
          			curve :  IVIndexedLineSet := new coordIndex;
          			addChild!(root, coerce curve);
          			offset := offset+n::NNI;
			}
	        	curve? ss => {
	          		n := (#(index.1))::Integer;
	          		coordIndex :=
					[offset+coerce(i) for i in 0..(n-1)];
	          		curve :  IVIndexedLineSet := new coordIndex;
	          		addChild!(root, coerce curve);
	          		offset := offset+n::NNI;
			}
	        	polygon? ss => {
	          		vertices := #(index.1) + #(index.2);
	          		face : IVFaceSet := new(vertices::SI,offset::SI);
	          		addChild!(root, coerce face);
	          		offset := offset+vertices;
			}
	        	mesh? ss => {
	          		xStep: SingleInteger := (#index)::SingleInteger;
	          		yStep: SingleInteger := (#(first index))::SingleInteger;
	          		quadMesh : IVQuadMesh :=
						new(xStep,yStep,offset::SingleInteger);
	          		addChild!(root, coerce quadMesh);
	          		offset := offset+coerce(xStep*yStep);
			}
	        	point? ss => {
	          		pt : IVPointSet := new(offset::SingleInteger,
						       1$SingleInteger);
	          		addChild!(root, coerce pt);
	          		offset := offset+1;
			}
	        	error "Unrecognised SubSpace component";
		}
		coerce root;
	}
}

@
\section{License}
<<license>>=
--Copyright (c) 1991-2002, The Numerical ALgorithms Group Ltd.
--All rights reserved.
--
--Redistribution and use in source and binary forms, with or without
--modification, are permitted provided that the following conditions are
--met:
--
--    - Redistributions of source code must retain the above copyright
--      notice, this list of conditions and the following disclaimer.
--
--    - Redistributions in binary form must reproduce the above copyright
--      notice, this list of conditions and the following disclaimer in
--      the documentation and/or other materials provided with the
--      distribution.
--
--    - Neither the name of The Numerical ALgorithms Group Ltd. nor the
--      names of its contributors may be used to endorse or promote products
--      derived from this software without specific prior written permission.
--
--THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
--IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
--TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
--PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
--OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
--EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
--PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
--PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
--LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
--NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
--SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
@
<<*>>=
<<license>>

<<RenderTools>>
@
\eject
\begin{thebibliography}{99}
\bibitem{1} nothing
\end{thebibliography}
\end{document}
