\documentclass{article}
\usepackage{axiom}
\begin{document}
\title{\$SPAD/src/algebra iviews.as}
\author{The Axiom Team}
\maketitle
\begin{abstract}
\end{abstract}
\eject
\tableofcontents
\eject
\section{InventorDataSink}
<<InventorDataSink>>=
#include "axiom"
#assert Real

NNI 	==> NonNegativeInteger;
SI 	==> SingleInteger;
DF 	==> DoubleFloat;
POINT 	==> Point DF;
SPACE3  ==> ThreeSpace DoubleFloat;

DefaultSize ==> 65530;

Value ==> Symbol;

InventorDataSink: with {
	CoercibleTo OutputForm;
	new:      () -> %;
	dispose!: % -> ();

	put!:     (%, SI) -> ();
	put!:     (%, DF) -> ();
	put!: (%, String) -> ();

	vstart!: (%, 'int,float', SI) -> ();
	vput!:  (%, SI) -> ();
	vput!:  (%, DF) -> ();

	lstart!:   % -> ();
	lend!:     % -> ();
	export from 'int,float'
} == add {
#if Real
	-- No rep (we cheat!)
	import from SI;
	valOf(x) ==> x pretend Value;
	default sink: %;
	import {
		LISP_:_:GR_-GET_-MEM_-AREA: SI -> %;
		LISP_:_:GR_-KILL_-MEM_-AREA: % -> ();
		LISP_:_:GR_-PUT_-ITEM:	    (%, Value) -> ();
		LISP_:_:GR_-PUT_-LSTART:	     % -> ();
		LISP_:_:GR_-PUT_-LEND:	             % -> ();
		LISP_:_:GR_-INIT_-VECTOR: (%, Value, Value) -> %;
		LISP_:_:GR_-ADD_-TO_-VECTOR:     (%, Value) -> %;
	} from Foreign Lisp;

	new(): % == LISP_:_:GR_-GET_-MEM_-AREA(DefaultSize);
	dispose!(sink): () == LISP_:_:GR_-KILL_-MEM_-AREA(sink);

	put!(sink, si: SI): ()     == LISP_:_:GR_-PUT_-ITEM(sink, valOf(si));
	put!(sink, st: String): () == LISP_:_:GR_-PUT_-ITEM(sink, valOf(st));
	put!(sink, fl: DF): ()     == LISP_:_:GR_-PUT_-ITEM(sink, valOf(fl));

	vstart!(sink, type: 'int,float', sz: SI): () == {
		local sym: Symbol;
		if type = int then
			sym := coerce("integer");
		else
			sym := coerce("float");
		LISP_:_:GR_-INIT_-VECTOR(sink, valOf(sym), valOf(sz));
	}

	vput!(sink, si: SI): () ==
		LISP_:_:GR_-ADD_-TO_-VECTOR(sink, valOf(si));
	vput!(sink, df: DF): () ==
		LISP_:_:GR_-ADD_-TO_-VECTOR(sink, valOf(df));

	lstart!(sink): () == LISP_:_:GR_-PUT_-LSTART sink;
	lend!(sink): () == LISP_:_:GR_-PUT_-LEND sink;

	coerce(sink): OutputForm == {
		[outputForm "aSink"]
	}
#else
	Rep ==> Record(count: NonNegativeInteger);
	import from Rep, NNI;
	default sink: %;
	coerce(sink): OutputForm == {
		import from List OutputForm;
		bracket [outputForm "Sink: ",
			 outputForm coerce rep(sink).count];
	}

	local addn!(sink, n: NNI): () ==
		rep(sink).count := rep(sink).count + n;
	new(): % == per [0];
	dispose!(sink): () == dispose! rep sink;

	put!(sink, n: SI): () == addn!(sink, 1 + 4);
	put!(sink, f: DF): () == addn!(sink, 1 + 4);
	put!(sink, s: String): () == {
		addn!(sink, #s + 1 + 1);
	}

	vstart!(sink, type: 'int, float', n: SI): () == {
		addn!(sink, 1 + n::NNI*4);
	}

	vput!(sink, n: SI): () == {};
	vput!(sink, n: DF): () == {};

	lstart!(sink): () == addn!(sink, 1);
	lend!(sink): () == addn!(sink, 1);

#endif
}

@
\section{InventorViewPort}
<<InventorViewPort>>=
InventorViewPort: with {
	new:      () -> %;
	new: ThreeSpace DoubleFloat -> %;
	addData!: (%, InventorDataSink) -> %;
	addData!: (%, ThreeSpace DoubleFloat) -> %;
} == add {
#if Real
	import {
		LISP_:_:GR_-MAKE_-VIEW: (SI) -> %;
		LISP_:_:GR_-SET_-DATA:  (%, InventorDataSink) -> ();
	} from Foreign Lisp;
	import from SingleInteger;

	new(): % == LISP_:_:GR_-MAKE_-VIEW(0);

	new(space: ThreeSpace DoubleFloat): % == {
		import from InventorDataSink;
		import from InventorRenderPackage;
		view: % := new();
		addData!(view, space);
		view
	}

	addData!(view: %, data: InventorDataSink): % == {
		LISP_:_:GR_-SET_-DATA(view, data);
		view;
	}

	addData!(view: %, space: ThreeSpace DoubleFloat): % == {
		import from InventorRenderPackage;
		sink: InventorDataSink := new();
		render(sink, space, cartesian$CoordinateSystems(DoubleFloat));
		addData!(view, sink);
		view
	}

#else
	Rep ==> SingleInteger;
	import from Rep;
	new(): % == per 1;
	new(x: ThreeSpace DoubleFloat): % == per 2;
	addData!(view: %, data: InventorDataSink): % == view;
#endif

}

@
\section{InventorRenderPackage}
<<InventorRenderPackage>>=
InventorRenderPackage: with {
	render: (InventorDataSink, ThreeSpace DoubleFloat, POINT->POINT) -> ();
} == add {
	default sink: InventorDataSink;
	default space: ThreeSpace DoubleFloat;
	default transform: POINT->POINT;
	import from SI;

	local put!(sink, dims: UniversalSegment SI,
		   lp: List Point DoubleFloat,
		   f: Point DoubleFloat -> Point DoubleFloat): () == {
		import from NNI, Integer;
		i : SI := 0;
		for x in dims repeat i:= i+1;
		vstart!(sink, float, i*(coerce #lp));
		for p in lp repeat {
			p1 := f(p);
			for idx in dims repeat
				vput!(sink, p1.(idx::Integer));
		}
	}

	local put!(sink, lp: List SI): () == {
		import from NNI;
		vstart!(sink, int, coerce #lp);
		for p in lp repeat {
			vput!(sink, p);
		}
	}

	local putPoints!(sink, transform,
			 lpts: List POINT, indexList: List NNI): () == {
		import from Integer;
		if not sorted? indexList
		then {
			-- not nice!
			lst: List POINT := [];
			for idx in indexList repeat
				lst := cons(lpts.(coerce idx), lst);
			lpts := reverse! lst;
		}
		put!(sink, 1..3, lpts, transform);
      		if (# first lpts) = 4
		then {
			put!(sink, "Colours");
			put!(sink, 4..4, lpts, transform);
		}
	}
	render(sink, space, transform): () == {
	 	default ss: SPACE3;
	      	default i: NNI;
		import from List POINT;
		import from List List List NNI;
		import from List List NNI;
		import from List SPACE3;
		import from SingleInteger;
		put!(sink, "ThreeDScene");
      		-- Get the point data
	      	check(space);
      		indices := lllip(space);
      		lpts := lp(space);
      		indexList := concat concat indices;
		put!(sink, "Points");
		putPoints!(sink, transform, lpts, indexList);
      		offset : SI := 0;
		lstart!(sink);
		for ss in components(space) for index in indices repeat {
			closedCurve? ss => {
				put!(sink, "closedCurve");
				n: SI := coerce #(first index);
				put!(sink, offset);
				put!(sink, n);
				offset := offset + n;
			}
			curve? ss=> {
				put!(sink, "curve");
				n: SI := coerce #(first index);
				put!(sink, offset);
				put!(sink, n);
				offset := offset + n;
			}
			polygon? ss => {
				local vertices: SI;
				put!(sink, "polygon");
				vertices := coerce(#(first index)
						   + #(first rest index));
				put!(sink, offset);
				put!(sink, vertices);
				offset := offset+vertices;
			}
			mesh? ss=> {
				local xStep, yStep: SI;
				put!(sink, "mesh");
				xStep := coerce #index;
          			yStep := coerce #(first index);
				put!(sink, offset);
				put!(sink, xStep);
				put!(sink, yStep);
				offset := offset+xStep*yStep;
			}
			point? ss => {
				put!(sink, "points");
				put!(sink, offset);
				put!(sink, 1);
				offset := offset+1;
			}
			error "Unrecognised SubSpace component";
		}
		lend!(sink);
	}

}

@
\section{License}
<<license>>=
--Copyright (c) 1991-2002, The Numerical ALgorithms Group Ltd.
--All rights reserved.
--
--Redistribution and use in source and binary forms, with or without
--modification, are permitted provided that the following conditions are
--met:
--
--    - Redistributions of source code must retain the above copyright
--      notice, this list of conditions and the following disclaimer.
--
--    - Redistributions in binary form must reproduce the above copyright
--      notice, this list of conditions and the following disclaimer in
--      the documentation and/or other materials provided with the
--      distribution.
--
--    - Neither the name of The Numerical ALgorithms Group Ltd. nor the
--      names of its contributors may be used to endorse or promote products
--      derived from this software without specific prior written permission.
--
--THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
--IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
--TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
--PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
--OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
--EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
--PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
--PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
--LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
--NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
--SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
@
<<*>>=
<<license>>

<<InventorDataSink>>
<<InventorViewPort>>
<<InventorRenderPackage>>
@
\eject
\begin{thebibliography}{99}
\bibitem{1} nothing
\end{thebibliography}
\end{document}
