/***************************************************************************
 *
 * knetworkmanager.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *         Helmut Schaa    <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_TRAY_H
#define KNETWORKMANAGER_TRAY_H

#include <qmap.h>
#include <qtimer.h>

#include <qtooltip.h>
#include <ksystemtray.h>
#include <kuniqueapplication.h>
#include <kpopupmenu.h>
#include <kactionclasses.h>
#include <kstdaction.h>
#include <kstdguiitem.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qprogressbar.h>
#include <qguardedptr.h>

#include "knetworkmanager.h"

namespace ConnectionSettings
{
	class Connection;
	class ConnectionSetting;
}

class QMouseEvent;
class TrayComponent;
class TrayPrivate;

class Tray : public KSystemTray
{
	Q_OBJECT

	public:
	  Tray ();
	  ~Tray ();
		static Tray* getInstance();
		void contextMenuAboutToShow (KPopupMenu* menu);
	
	signals:

	public slots:
		void slotOfflineMode();
		void slotOnlineMode();
		void slotEnableWireless();
		void slotDisableWireless();
		void slotEditConnections();

		void slotStateChanged(Q_UINT32 state);
		void slotVPNSecretsNeeded(ConnectionSettings::Connection* connection, ConnectionSettings::ConnectionSetting* setting, const QStringList& hints, bool request_new);
		void slotSecretsNeeded(ConnectionSettings::Connection* connection, ConnectionSettings::ConnectionSetting* setting, const QStringList& hints, bool request_new);

		void slotDeviceAddedNotify(Device*);
		void slotDeviceRemovedNotify(Device*);
		void slotStateChangedNotify(Q_UINT32 state);

  protected slots:
		void updateDeviceTrays();
		void slotAddDeviceTrayComponent(Device*);
		void slotRemoveDeviceTrayComponent(Device*);
		void slotDeactivateConnection(int);
		void trayComponentNeedsCenterStage(TrayComponent*, bool);
		void slotUpdateDeviceState(NMDeviceState);
		void trayUiChanged();
		void slotEditNotifications();

	private:
		void updateTrayIcon(NMDeviceState);
		void updateActiveConnection(NMDeviceState);
		void mousePressEvent( QMouseEvent *e );
		void createVPNTrayComponent();
		void createDeviceTrayComponent(Device*);
		void enterEvent (QEvent*);

		TrayPrivate* d;
};

#endif /* KNETWORKMANAGER_TRAY_H */
