/***************************************************************************
 *
 * knetworkmanager-connection_setting_vpn.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_VPN_H
#define KNETWORKMANAGER_CONNECTION_SETTING_VPN_H

#include <stdint.h>
#include <qhostaddress.h>
#include <qmap.h>
#include <qvariant.h>
#include <qobject.h>
#include <qdatetime.h>

#include <dbus/qdbusdata.h>
#include "knetworkmanager-connection_setting.h"

/* NM headers */
#include <nm-setting-vpn.h>

namespace ConnectionSettings
{

// info setting
class VPN : public ConnectionSetting
{
	public:
		VPN(Connection* conn);

		SettingsMap toMap() const;
		void        fromMap(const SettingsMap&);

		SettingsMap toSecretsMap(bool with_settings = true) const;
		bool        fromSecretsMap(const SettingsMap&);

		QString     getUserName() const;
		void        setUserName(const QString&);

		QString     getServiceType() const;
		void        setServiceType(const QString&);

		QValueList<QString> getRoutes() const;
		void        setRoutes(const QValueList<QString>&);

		QMap<QString, QString>   getData() const;
		void                     setData(QMap<QString, QString> data);

		// Ugh, that is ugly
		QMap<QString, QString>   getSecrets() const;
		void                     setSecrets(const QMap<QString, QString>& secrets);

		bool        isValid() const;

	private:
		QString             _userName;
		QString             _serviceType;
		QValueList<QString> _routes;
		QMap<QString, QString> _data;
		QMap<QString, QString> _secrets;
};

}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_VPN_H */
