/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* qt headers */
#include <qhostaddress.h>
#include <qvariant.h>

/* kde headers */
#include <kdebug.h>
#include <klocale.h>

/* QDBus headers*/
#include <dbus/qdbusdata.h>
#include <dbus/qdbusdatamap.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-accesspoint.h"


using namespace ConnectionSettings;

/*
	class Info
*/
Info::Info(Connection* conn, QString devtype, const QString& name, bool autoconnect)
	: ConnectionSetting(conn, NM_SETTING_CONNECTION_SETTING_NAME)
{
	_name = name;
	_devtype = devtype;
	_autoconnect = autoconnect;
}

QString
Info::getDevType() const
{
	return _devtype;
}

void
Info::setDevType(const QString& devtype)
{
	_devtype = devtype;
	emitValidityChanged();
}

QString
Info::getName() const
{
	return _name;
}

void
Info::setName(const QString& name)
{
	_name = name;
	emitValidityChanged();
}

bool
Info::getAutoconnect() const
{
	return _autoconnect;
}

void
Info::setAutoconnect(bool autoconnect)
{
	_autoconnect = autoconnect;
	emitValidityChanged();
}

QDateTime
Info::getTimestamp() const
{
	return _timestamp;
}

void
Info::setTimestamp(const QDateTime& dt)
{
	_timestamp = dt;
}

QString
Info::getUUID() const
{
	return _uuid;
}

void
Info::setUUID(const QString& uuid)
{
	_uuid = uuid;
}

SettingsMap
Info::toMap() const
{
	SettingsMap map;
	map.insert(NM_SETTING_CONNECTION_ID, QDBusData::fromString(_name));
	map.insert(NM_SETTING_CONNECTION_TYPE, QDBusData::fromString(_devtype));
	map.insert(NM_SETTING_CONNECTION_AUTOCONNECT, QDBusData::fromBool(_autoconnect));
	map.insert(NM_SETTING_CONNECTION_UUID, QDBusData::fromString(_uuid));

	if (!_timestamp.isNull())
		map.insert(NM_SETTING_CONNECTION_TIMESTAMP, QDBusData::fromUInt32(_timestamp.toTime_t()));

	return map;
}

void
Info::fromMap(const SettingsMap& map)
{
	SettingsMap::ConstIterator it;

	if ((it = map.find(NM_SETTING_CONNECTION_ID)) != map.end())
		_name = it.data().toString();
	
	if ((it = map.find(NM_SETTING_CONNECTION_TYPE)) != map.end())
		_devtype = it.data().toString();

	if ((it = map.find(NM_SETTING_CONNECTION_AUTOCONNECT)) != map.end())
		_autoconnect = it.data().toBool();

	if ((it = map.find(NM_SETTING_CONNECTION_TIMESTAMP)) != map.end())
		_timestamp.setTime_t(it.data().toUInt32());

	if ((it = map.find(NM_SETTING_CONNECTION_UUID)) != map.end())
		_uuid = it.data().toString();
}

bool
Info::isValid() const
{
	// name is essential
	if (_name.isEmpty())
		return false;

	return true;
}
