/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* qt headers */
#include <qhostaddress.h>
#include <qvariant.h>

/* kde headers */
#include <kdebug.h>
#include <klocale.h>

/* QDBus headers*/
#include <dbus/qdbusdata.h>
#include <dbus/qdbusdatamap.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-connection_setting.h"
#include "knetworkmanager-connection.h"

using namespace ConnectionSettings;

/*
	class ConnectionSetting
*/
ConnectionSetting::ConnectionSetting(Connection* conn, QString type, const char* name, bool enabled)
	: QObject(conn, name)
{
	_type = type;
	_enabled = enabled;
	_conn = conn;
}

ConnectionSetting::ConnectionSetting(const ConnectionSetting& setting)
	: QObject()
{
	_type = setting.getType();
	_enabled = setting.getEnabled();
	_conn = setting.getConnection();
}

SettingsMap
ConnectionSetting::toSecretsMap(bool with_settings) const
{
	printf("ConnectionSetting::toSecretsMap\n");
	return SettingsMap();
}

bool
ConnectionSetting::fromSecretsMap(const SettingsMap& /*map*/)
{
	return true;
}

bool
ConnectionSetting::getEnabled(void) const
{
	return true;
}

QString
ConnectionSetting::getType(void) const
{
	return _type;
}

Connection*
ConnectionSetting::getConnection(void) const
{
	return _conn;
}

bool
ConnectionSetting::hasSecrets(void) const
{
	return !(toSecretsMap(false).isEmpty());
}

void
ConnectionSetting::emitValidityChanged()
{
	emit validityChanged();
}

#include "knetworkmanager-connection_setting.moc"
