/*********************************************************************
 * Name:      	main.h
 * Purpose:   	Declares simple wxWidgets application with GUI
 * 				created using wxFormBuilder.
 * Author:
 * Created:
 * Copyright:
 * License:   	wxWidgets license (www.wxwidgets.org)
 *
 * Notes:		Note that all GUI creation code is declared in
 * 				gui.h source file which is generated by wxFormBuilder.
 *********************************************************************/

#ifndef __main__
#define __main__

// main wxWidgets header file
#include <wx/wx.h>
#include <wx/filename.h>
#include <wx/popupwin.h>
#include <wx/arrstr.h>
#include <wx/gauge.h>
#include <wx/snglinst.h>
#include <wx/notifmsg.h>
#include "vlcplayer.h"
// gui classes generated by wxFormBuilder
#ifdef __WXMSW__
#include "gui-windows.h"
#else
#include "gui.h"
#endif
#include "baseprotocolhandler.h"
#include "acestreamenginehandler.h"
#include "sopprotocol.h"
#include "sopthread.h"
#include "channel.h"
#include "subscription.h"
#include "locallist.h"
#include "recordchoice.h"
#include "vlcplayer.h"
#include "busyobject.h"
#include "controlsframe.h"


#define SIZER_BORDER 5
#define TOGGLE_BUTTON_BORDER 1;

enum ESelList{
   E_SEL_LIST = 0,
   E_SEL_SUBSCRIPTION,
   E_SEL_FAVORITES

};

struct TRecordedPos
{
  TRecordedPos()
  {
     listIndex =  wxNOT_FOUND;
  };
  int listIndex;
  int groupIndex[2] = {wxNOT_FOUND,wxNOT_FOUND};
  int channelIndex[2] = {wxNOT_FOUND,wxNOT_FOUND};
};

WX_DECLARE_OBJARRAY(TRecordedPos, TRecordedPosList);


#ifdef __WXMSW__
    void HideCursor();
    void ShowCursor();
#endif

////////////////////////////////////////////////////////////////////////////////
// application class declaration
////////////////////////////////////////////////////////////////////////////////
using namespace tvlite;

class MainFrame;

class MainApp : public wxApp
{
public:
#ifdef __WXGTK__
      MainApp(){XInitThreads();}
#endif
      virtual bool OnInit();
      virtual int  OnExit();
      ControlsFrame *controlFrame;
      MainFrame* GetMainFrame();
      wxPanel* GetTVFrame();
private:
      MainFrame *mainframe;
      wxSingleInstanceChecker *m_checker;
};

struct refreshData
{
   long groupid;
   wxString chanid;
};

// declare global static function wxGetApp()
DECLARE_APP(MainApp)

////////////////////////////////////////////////////////////////////////////////
// main application frame declaration
////////////////////////////////////////////////////////////////////////////////

class MainFrame : public MainFrameBase, public CBusyObject
{
	public:
		MainFrame( wxWindow *parent );
		virtual ~MainFrame();
      void InitInterface();
      void RefreshInterface(int type, wxString pathsel = "");
      void LaunchProtocolHandler(wxString URL, wxString name, wxArrayString vlcoptions);
      void OnExitProtocolHandler(wxCommandEvent& event);
      void PlayVLC(wxCommandEvent& event);
      void ToggleFullScreen();
      void OnPopupClick(wxCommandEvent& event);
      void RaiseTransp();
      void UpdateAllSubscriptions();
      void SetVLCRecordState(int type);
      int GetVLCRecordState();
      bool isFullScreen();
      bool isMinSizeSet();
      wxTimer* GetMouseTimer();
      wxImage& GetLogo();
      tvlite::TSubscriptionList* GetSubscriptionList();
      tvlite::TLocalLists* GetLocalLists();
      void GetSelectedGroupFromLocalLists(wxArrayString& group) {group = m_dbGroupList;};
      void NullifyRecordChoice() {m_recordChoice = NULL;};
      tvlite::CSubscription* GetTempSubscription();
      void SetTempSubscription(tvlite::CSubscription* subscription);
      ESelList GetListType();
      void SetInitialSashPosition();
      CChannel GetLastPlayedChannel();
      void Play(CChannel ch);
      wxPanel* GetTVFrame();
      void ClearSubscriptionPosition();
      CVlcPlayer& GetVLCPlayer();
      wxToolBarToolBase* m_tvbutton;
		wxToolBarToolBase* m_radiobutton;
      eTableType m_crtTable;
#ifdef __WXMSW__   
       wxTaskBarIcon *m_tbicon ;
#endif   


	protected:
      // protected event handlers
		virtual void OnCloseFrame( wxCloseEvent& event );
		virtual void OnExitClick( wxCommandEvent& event );
      virtual void OnUpdateChannelList( wxCommandEvent& event );
      virtual void OnPlay( wxCommandEvent& event );
      virtual void OnStop( wxCommandEvent& event );
      virtual void OnFullScreen( wxCommandEvent& event );
      virtual void OnListPlay( wxListEvent& event );
      virtual void ToggleFullScreen( wxMouseEvent& event );
      virtual void ToggleFullScreen( wxKeyEvent& event );
      virtual void OnSubscriptionSelected( wxCommandEvent& event );
      virtual void OnListContextMenu( wxListEvent& event );
      virtual void OnListContextMenu( wxMouseEvent& event );
      virtual void OnSubscriptionClick( wxCommandEvent& event );
      virtual void OnLocalListClick(wxCommandEvent& event);
      virtual void OnLocalListAdd( wxCommandEvent& event );
      virtual void OnListTypeClick();
      virtual void OnSaveSubscriptionAsLocalList( wxCommandEvent& event );
      //virtual void OnSaveLocalList( wxCommandEvent& event );
      virtual void OnSaveList( wxCommandEvent& event );
		virtual void OnSaveView( wxCommandEvent& event );
      virtual void ToggleChannelList( wxCommandEvent& event );
      virtual void OnAbout( wxCommandEvent& event );
      virtual void OnVoumeChanged( wxMouseEvent& event ) ;
		virtual void OnVolumeChanged( wxCommandEvent& event );
      virtual void OnARDefault( wxCommandEvent& event );
		virtual void OnAR169( wxCommandEvent& event );
		virtual void OnAR43( wxCommandEvent& event );
      virtual void OnShowFrame( wxShowEvent& event );
      virtual void OnSize( wxSizeEvent& event );
      virtual void OnMove( wxMoveEvent& event );
      virtual void OnMaximizeFrame( wxMaximizeEvent& event );
      virtual void OnPaintEvent( wxPaintEvent& event );
      virtual void OnSeekUsrChanged( wxCommandEvent& event );
      virtual void OnPause( wxCommandEvent& event );
      virtual void OnPause(wxMouseEvent& event);
      virtual void HideBar( wxTimerEvent& event );
      virtual void OnRecord( wxCommandEvent& event );
      virtual void OnToggleListAZ( wxCommandEvent& event );
		virtual void OnToggleListZA( wxCommandEvent& event );
      virtual void OnToggleGroupAZ( wxCommandEvent& event );
		virtual void OnToggleGroupZA( wxCommandEvent& event );
      void OnMoveOverImage(wxMouseEvent& event);
      void OnMoveOverControls( wxMouseEvent& event );
      void LogoPaint( wxPaintEvent& event );
		void LogoSize( wxSizeEvent& event );
      virtual void OnSeekMouseChanged( wxMouseEvent& event );
      void RedrawPopup();
      void RedrawListPane();
      void OnTrackItemClick( wxCommandEvent& event );
      virtual void OnPopulateChannel( wxCommandEvent& event );
      virtual void OnShowPref( wxCommandEvent& event );
      virtual void OnGroupListPaint( wxSizeEvent& event );
      virtual void OnChannelListPaint( wxSizeEvent& event );
      virtual void OnGroupSelect( wxListEvent& event );
      virtual void OnStatusBarPaint( wxPaintEvent& event );
		virtual void OnStatusBarSize( wxSizeEvent& event );
        void OnListRepopulate();
        void PopulateFromQuery();
        void QueryDisplay();
        virtual void OnQueryTimer( wxTimerEvent& event );
      virtual void OnEraseBackground( wxEraseEvent& event );
        virtual void OnMuteClick( wxMouseEvent& event );
        void AfterFullScreen();
#ifdef __WXMSW__
        virtual void OnListRightClick( wxMouseEvent& event );
        virtual void OnSplitterMove( wxSplitterEvent& event );
#endif
        virtual void OnMiniWindow( wxCommandEvent& event );
        virtual void OnToggleMini( wxCommandEvent& event );
        virtual void OnMoveTimer( wxTimerEvent& event );
        virtual void OnMetaTimer( wxTimerEvent& event );

        virtual void OnToggleLocalLists( wxCommandEvent& event );
        virtual void OnToggleSubscriptions( wxCommandEvent& event );
		  virtual void OnToggleFavorites( wxCommandEvent& event );
        virtual void OnUpdateAllSubscriptions( wxCommandEvent& event );
        virtual void StartAcePlaying( wxTimerEvent& event );
        virtual void OnMouseLeaveMiniFrame( wxMouseEvent& event );
        virtual void OnTVButtonClick(wxCommandEvent& event);
        virtual void OnRadioButtonClick(wxCommandEvent& event);
#if (wxMAJOR_VERSION >= 3 && wxMINOR_VERSION >= 2)
        virtual void OnSysColourChanged(wxSysColourChangedEvent& event);
        virtual void CheckSystemColors();
#endif
private:
      wxString m_metaTitle;
      wxString m_metaArtist;
      tvlite::CVlcPlayer m_vlcPlayer;
      tvlite::TPChannelList m_currentChannelList;
      wxArrayString m_currentGroupList;
      tvlite::TChannelList *m_tvdbChannelList;
      tvlite::TChannelList *m_radiodbChannelList;
      tvlite::TChannelList *m_dbChannelList;
      tvlite::TChannelList *m_lastPlayedChannelList;
      wxArrayString m_dbGroupList;
      bool m_isFullScreen;
      bool m_isMute;
      bool m_delayedStart;
      bool m_destroy;
      wxImage m_logo;
      bool m_logoPresent;
      bool m_logoRefresh;
      wxFrame*  m_transp;
      tvlite::TSubscriptionList m_subscriptionList;
      tvlite::TLocalLists m_localLists;
      tvlite::CLocalList *m_favoritesdb;
      tvlite::CLocalList *m_lastplayeddb;
      tvlite::CBaseProtocolHandler *m_protocolhandler;
      tvlite::CRecordChoice *m_recordChoice;
      bool m_mev_treated;
      bool m_controlsShown;
      tvlite::TTrackInfoList videotracklist;
      tvlite::TTrackInfoList audiotracklist;
      tvlite::TTrackInfoList subtitletracklist;
      void PopulateChannelList(tvlite::TChannelList &list);
      void PopulateGroupList(wxString queryString = "", int sortType = 2);
      void RefreshCount(tvlite::TPChannelList &list);
      void PopulateChannelList(int groupIndex = 0, wxString queryString = "", int sortType = 2);
      void PopulateDBSubscription(int typeSel, int listIndex);
      void PopulateChoice(unsigned int typeSel, wxString pathSel ="");
      int  GetSelectedGroupIndex();
      int  GetHighlightedGroupIndex();
      int  GetHighlightedChannelIndex();
      void OnStop();
      void OnVlcEvent(wxCommandEvent& event);
      void OnVlcSeekEvent(wxCommandEvent& event);
      void OnRefreshEvent(wxCommandEvent& event);
      void SetVolume(int value);
      void ShowMovieSlider(bool show, unsigned int value);
      tvlite::CAcestreamEngineHandler *m_acestreamenginehandler;
      void ShowControls(bool state);
      void ShowControls();
      void HideControls();
      void MoveControls(wxWindow* newParent, wxSizer* fromSizer, wxSizer* toSizer);
      void ResizeControls();
      void ResizeMiniWindow();
      void ResizeControlsMini(bool show = false);
      void ShowControlsMini(bool state);
      void AddTrackItems(tvlite::TTrackInfoList &trackInfoList, wxMenu *menu, int baseid);
      void DeleteTrackItems(wxMenu *menu);
      void PreparePlayItems(wxString trackName);
      void SaveList(bool isView);
      void HighlightChan(wxString chanId);
      void HighlightGroup(wxString group);
      void SetChannelListVisibility(bool visible);
      void GetGroups(TChannelList *chanlist, wxArrayString& grouparray);
      int GetGroupSearchOrder();
      void SetGroupSearchOrder(int orderType);
      int GetListSearchOrder();
      void SetListSearchOrder(int orderType);
      tvlite::CSubscription *m_tempsubscription;
      void MoveMiniFrameControls(wxWindow* newParent, wxSizer* fromSizer, wxSizer* toSizer);
      void MoveMiniFrameVideo(wxWindow* newParent, wxSizer* fromSizer, wxSizer* toSizer);
      void ShowMiniWindow();
      void ShowNormalWindow();
      void PopulateMenuTrackItems();
      wxString SetStreamCaption();
      wxSize m_savedSize;
      wxPoint m_savedPosition;
      bool m_minSizeSet;
      void PrintMeta();
      int GetSashPos();
      bool m_titleRefresh;
      ESelList m_listType;
      wxScopedPtr<wxNotificationMessage> m_notif;
      int m_noexit;
      bool m_playlocked;
      TRecordedPosList m_recordedPos;
      void StorePosition(int type);
      void InitPositions();
      bool CheckYTDlpUsage(wxURI &uri);
};


#endif //__main__
