#ifndef CCIRCULARBUFFER_H
#define CCIRCULARBUFFER_H
#include <stdlib.h>
#include <wx/stream.h>

namespace tvlite
{

class CCircularBuffer final
{
private:
    CCircularBuffer(const CCircularBuffer&) = delete;
    CCircularBuffer& operator=(const CCircularBuffer&) = delete;

private:
    char *m_buffer;
    size_t m_size;
    char *m_readPointer;
    char *m_writePointer;
    bool m_empty;
    bool m_full;
    
public:
    CCircularBuffer(size_t size);
    virtual ~CCircularBuffer();
    size_t Read (char* dest, size_t length);
    size_t Write(char* source, size_t length);
    bool ReadStream(wxInputStream *stream, size_t &read);
    size_t GetAvailableWriteDataSize();
    size_t GetAvailableReadDataSize();

};

}

#endif // CCIRCULARBUFFER_H
