/*********************************************************************
 * Name:      	main.cpp
 * Purpose:   	Implements simple wxWidgets application with GUI
 * 				created using wxFormBuilder.
 * Author:     Cristian Burneci
 * Created:
 * Copyright:
 * License:   	GPLv2
 *
 * Notes:		Note that all GUI creation code is implemented in
 * 				gui.cpp source file which is generated by wxFormBuilder.
 *********************************************************************/



#include "main.h"
#include <wx/stdpaths.h>
#include <wx/utils.h>
#include <wx/filename.h>
#include <wx/aboutdlg.h>
#include <wx/icon.h>
#include <wx/persist/toplevel.h>
#ifdef __WXMSW__
 #include <wx/taskbar.h>
#endif
#include <wx/display.h>
#include "subscriptionlistdialog.h"
#include "debug.h"
#include "configuration.h"
#include "channel.h"
#include "database.h"
#include "downloadclient.h"
#include "subscription.h"
#include "locallist.h"
#include "acestreamprotocolhandler.h"
#include "sopprotocolhandler.h"
#include "streamprotocolhandler.h"
#include "sopthread.h"
#include "locallistdialog.h"
#include "localdialog.h"
#include "channeledit.h"
#include "channelinfo.h"
#include "userdataobject.h"
#include "prefdialog.h"
#include "statusgauge.h"
#include "version.h"
#include "dlprogress.h"
#include "textwrapper.h"

#ifdef __WXMSW__
#include <commctrl.h>
#endif
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wwrite-strings"
#include "icon-tv.xpm"
//#include "volume.xpm"
#include "volume1.xpm"
#include "volume2.xpm"
#include "volume3.xpm"
#include "volume4.xpm"
#include "volume5.xpm"

#pragma GCC diagnostic push


// initialize the application



#if defined(__WXGTK__)

IMPLEMENT_APP_NO_MAIN(MainApp);

int main(int argc, char** argv )
{
   gdk_set_allowed_backends ("x11,*");
   wxDISABLE_ASSERTS_IN_RELEASE_BUILD();
   wxEntry(argc, argv);
}
#else
IMPLEMENT_APP(MainApp);
#endif

wxDEFINE_EVENT(protEVT_EXIT, wxCommandEvent);
wxDEFINE_EVENT(playerEVT, wxCommandEvent);
wxDEFINE_EVENT(seekEVT, wxCommandEvent);
wxDEFINE_EVENT(chanlistEVT,wxCommandEvent);


#include <wx/arrimpl.cpp>
WX_DEFINE_OBJARRAY(TRecordedPosList);

static const int baseUrlId = wxID_HIGHEST + 1100;
static const int basePopId = wxID_HIGHEST + 1000;
static const int baseVideoId = wxID_HIGHEST + 1010;
static const int baseAudioId = wxID_HIGHEST + 1020;
static const int baseSubtitleId = wxID_HIGHEST + 1030;

wxLocale *locale;

#if defined(__WXGTK__)
	#define HIDE_CURSOR wxSetCursor(wxCURSOR_BLANK)
	#define SHOW_CURSOR wxSetCursor(*wxSTANDARD_CURSOR)
#elif defined(__WXMSW__)
	#define HIDE_CURSOR ::HideCursor()
	#define SHOW_CURSOR ::ShowCursor()
#endif

#ifdef __WXMSW__
void HideCursor()
{
      while (ShowCursor(0) >= 0);
}
void ShowCursor()
{
      while (ShowCursor(1) <= 0);
}
#endif

#ifdef __WXMSW__
   #define SET_SCREEN_FOCUS m_transp->SetFocus()
#else
   #define SET_SCREEN_FOCUS m_tvView->SetFocus()
#endif

#define MINIWIDTH 300

using namespace tvlite;

////////////////////////////////////////////////////////////////////////////////
// application class implementation
////////////////////////////////////////////////////////////////////////////////

bool MainApp::OnInit()
{
   m_checker = new wxSingleInstanceChecker;
   if ( m_checker->IsAnotherRunning() )
   {
       wxMessageBox(_("Another instance of TV-Lite is running. Aborting."), "Error", wxOK | wxICON_STOP, NULL);
       delete m_checker;
       return false;
   }
   long language =  wxLANGUAGE_DEFAULT;
   locale = new wxLocale(language);
#ifdef __WXMSW__
   locale->AddCatalog(wxT("tv-lite-windows"));
#else
   locale->AddCatalog(wxT("TVLite"));
#endif
   wxInitAllImageHandlers();
#ifdef __WXMSW__
   InitCommonControls();
#endif
   CConfiguration *conf = CConfiguration::Instance();
   if (!conf->Init())
   {
      wxMessageBox(_("Could not initialize program configuration"), "Error", wxOK | wxICON_STOP, NULL);
      return false;
   }
   conf->Load();
   mainframe = new MainFrame( NULL );
   
   if (mainframe)
   {

      SetTopWindow(mainframe);
      controlFrame = new ControlsFrame (mainframe);
      controlFrame->Hide();
      mainframe->Show();
      bool  __attribute__((unused)) rc = wxPersistentRegisterAndRestore(mainframe);
      DBG_INFO("wxPersistentRegisterAndRestore returned %d" , rc);
      if (conf->GetGeneralConfiguration().GetUpdateAllEnabled())
      {
         mainframe->UpdateAllSubscriptions();
      }

   }

	return true;
}

int MainApp::OnExit()
{
    delete m_checker;
    return wxApp::OnExit();
}

MainFrame* MainApp::GetMainFrame()
{
   return mainframe;
}

wxPanel* MainApp::GetTVFrame()
{
   return mainframe->GetTVFrame();
}
////////////////////////////////////////////////////////////////////////////////
// main application frame implementation
////////////////////////////////////////////////////////////////////////////////

MainFrame::MainFrame(wxWindow *parent) : MainFrameBase(parent),
   m_vlcPlayer(this),
   m_dbChannelList(nullptr),
   m_lastPlayedChannelList(nullptr),
   m_isFullScreen(false),
   m_isMute(false),
   m_delayedStart(false),
   m_destroy(false),
   m_logoPresent(false),
   m_logoRefresh(true),
   m_protocolhandler(NULL),
   m_recordChoice(NULL),
   m_mev_treated(false),
   m_controlsShown(true),
   m_minSizeSet(false),
   m_titleRefresh(false),
   m_listType(E_SEL_SUBSCRIPTION),
   m_notif(NULL),
   m_noexit(0),
   m_playlocked(false)
{

   wxIcon *icon = new wxIcon(icon_tv_xpm);
   m_dbChannelList = new TChannelList();
   m_lastPlayedChannelList = new TChannelList();
   m_tempsubscription = nullptr;
   Connect(wxID_ANY, protEVT_EXIT, wxCommandEventHandler(MainFrame::OnExitProtocolHandler));
   Connect(wxID_ANY, playerEVT,    wxCommandEventHandler(MainFrame::OnVlcEvent));
   Connect(wxID_ANY, seekEVT,      wxCommandEventHandler(MainFrame::OnVlcSeekEvent));
   Connect(wxID_ANY, chanlistEVT,    wxCommandEventHandler(MainFrame::OnRefreshEvent));
   Connect(wxEVT_KEY_DOWN,         wxKeyEventHandler(MainFrame::ToggleFullScreen));
   m_menuChannelList->Check();
   m_ChannelList->InsertColumn(0, _("Channel Name"));
   m_GroupList->InsertColumn(0, _("Groups"));
   m_tvView->SetOwnBackgroundColour(wxColour(*wxBLACK));

   wxStandardPaths &pathObj = wxStandardPaths::Get();

#ifdef __WXMSW__
   wxString sLogoPath = pathObj.GetDataDir() + "\\logo.png";
#else
   wxString sLogoPath = pathObj.GetDataDir() + "/logo.png";
#endif
    DBG_INFO("LOGO is %s", (const char*)sLogoPath.utf8_str());
    m_tvView->Connect( wxEVT_PAINT, wxPaintEventHandler( MainFrame::LogoPaint ), NULL, this );
    m_tvView->Connect( wxEVT_SIZE, wxSizeEventHandler( MainFrame::LogoSize ), NULL, this );
    if (wxFileExists(sLogoPath))
    {
       m_logo.LoadFile(sLogoPath);
       m_logoPresent=true;

    }

#ifdef __WXMSW__
   m_transp = new wxFrame();
   m_transp->SetBackgroundStyle(wxBG_STYLE_TRANSPARENT);
   m_transp->Create(this, wxID_ANY,"", m_tvView->GetScreenPosition() , m_tvView->GetSize(), wxBORDER_NONE|wxFRAME_FLOAT_ON_PARENT|wxFRAME_NO_TASKBAR);
   m_transp->Connect( wxEVT_LEFT_DCLICK, wxMouseEventHandler( MainFrame::ToggleFullScreen ), NULL, this );
   m_transp->Connect( wxEVT_KEY_DOWN, wxKeyEventHandler(MainFrame::ToggleFullScreen), NULL, this );
   //m_transp->Connect( wxEVT_LEFT_UP  , wxMouseEventHandler( MainFrame::OnPause          ), NULL, this );
#else
   m_tvView->Connect( wxEVT_LEFT_DCLICK, wxMouseEventHandler( MainFrame::ToggleFullScreen ), NULL, this );
   m_tvView->Connect( wxEVT_KEY_DOWN, wxKeyEventHandler(MainFrame::ToggleFullScreen), NULL, this );
   //m_tvView->Connect( wxEVT_LEFT_UP  , wxMouseEventHandler( MainFrame::OnPause          ), NULL, this );
#endif
   m_vlcPlayer.Init(m_tvView);

   int statusWidths[] = {300, 300};
   m_statusBar->SetStatusWidths(2,statusWidths);
#ifdef __WXMSW__
   m_statusBar->SetMinHeight(20);
#else
   m_statusBar->SetMinHeight(30);
#endif
   CStatusGauge::CreateStatusGauge(m_statusBar, E_SB_LISTBUFFER,   0);
   CStatusGauge::CreateStatusGauge(m_statusBar, E_SB_LISTPROGRESS, 1);
   CStatusGauge::HideStatusGauge(E_SB_LISTBUFFER);
   CStatusGauge::HideStatusGauge(E_SB_LISTPROGRESS);
   CStatusGauge::ShowStatusGauge(E_SB_LISTBUFFER, _("Ready"), false);
   SetVolume(m_slider1->GetValue());
   m_movieslider->SetPageSize(1);
   m_movieslider->SetLineSize(100);
   ShowMovieSlider(false,0);
#ifdef __WXMSW__   
   m_tbicon = NULL;
#endif
   if (icon != NULL) 
   {
      SetIcon(*icon);
   }

   SetBusy();
   InitInterface();
   ClearBusy();
   m_acestreamenginehandler = new CAcestreamEngineHandler(this);
   if (m_acestreamenginehandler)
   {
      m_acestreamenginehandler->Start();
   }
   m_ChannelList->SetFocus();

#ifdef __WXMSW__
   m_splitter1->Disconnect( wxEVT_IDLE, wxIdleEventHandler( MainFrameBase::m_splitter1OnIdle ), NULL, this );
#endif
}

MainFrame::~MainFrame()
{
   TVLITECONFIG->Write("LastRun/AspectRatio", m_vlcPlayer.GetAspectRatio());
   //TVLITECONFIG->Write("LastRun/ShowChannelList", m_menuChannelList->IsChecked());
   if (m_logoPresent)
   {
      m_tvView->Disconnect( wxEVT_PAINT, wxPaintEventHandler( MainFrame::LogoPaint ), NULL, this );
      m_tvView->Disconnect( wxEVT_SIZE, wxSizeEventHandler( MainFrame::LogoSize ), NULL, this );
   }
   CConfiguration *conf = CConfiguration::Instance();
   conf->Save();
   if (m_tempsubscription)
   {
      delete m_tempsubscription;
   }
   if (m_favoritesdb)
   {
      delete m_favoritesdb;
   }
   if (m_lastplayeddb)
   {
      delete m_lastplayeddb;
   }
    if (m_notif)
    {
       m_notif->Close();
       delete m_notif.release();
      
    }
    
#ifdef __WXMSW__
    if (m_transp)
    {
       m_transp->Destroy();
    }
    m_tbicon->RemoveIcon();
    delete m_tbicon;
#endif
}

void MainFrame::OnShowFrame( wxShowEvent& event )
{

#ifdef __WXMSW__

    m_transp->SetTransparent(1);
    m_transp->SetBackgroundColour(*wxBLACK);
    m_transp->Show(true);

#endif
    int size_x, size_y;
    m_ChannelList->GetSize(&size_x, &size_y);
    m_ChannelList->SetColumnWidth(0,size_x);
    m_GroupList->SetColumnWidth(0,size_x);
    CallAfter(&MainFrame::SetInitialSashPosition);
    if (CConfiguration::Instance()->GetGeneralConfiguration().GetPlayLastStreamEnabled())
    {
       CChannel ch = GetLastPlayedChannel();
       if (ch.GetStreamURLs().Count() != 0)
       {
          wxURI uri(ch.GetStreamURLs().Item(0));
          if (uri.HasScheme() && uri.GetScheme() == "acestream")
          {
             //wait five seconds for acestream to settle
             CStatusGauge::ShowStatusGauge(E_SB_LISTBUFFER, _("Wait for Acestream..."), false);
             m_playlocked = true;
             m_aceStartTimer.StartOnce(5000);

          }
          else
          {
             Play(ch);
          }
       }

    }
    event.Skip();

}

void MainFrame::StartAcePlaying( wxTimerEvent& event )
{
   m_playlocked = false;
   Play(GetLastPlayedChannel());
   CStatusGauge::ShowStatusGauge(E_SB_LISTBUFFER, _("Ready"), false);

}


void MainFrame::SetInitialSashPosition()
{
   int sashPos = GetSashPos();
   m_splitter1->SetSashPosition(sashPos);
   m_splitter1->Update();
}

void MainFrame::OnCloseFrame(wxCloseEvent& event)
{
	if (m_minSizeSet)
   {
      SHOW_CURSOR;
      SetSize(m_savedSize);
      SetPosition(m_savedPosition);
      CallAfter(&MainFrame::ShowNormalWindow);
   }
   else if (event.CanVeto())
   {
      m_destroy = true;

      event.Veto();
      if (m_protocolhandler && m_protocolhandler != m_acestreamenginehandler)
      {
         DBG_INFO("Stopping currently played video");
         m_protocolhandler->Stop();
         m_noexit++;
      }
      else if (m_acestreamenginehandler->IsEngineInstalled())
      {
         DBG_INFO("Stopping acestream engine");
         m_acestreamenginehandler->Stop();
         m_noexit++;
      }

      if (m_noexit == 0)
      {
         Destroy();
      }
   }
   else
   {
      Destroy();
   }
}

void MainFrame::OnExitClick(wxCommandEvent& event)
{

   m_destroy = true;
   if (m_protocolhandler)
   {
      DBG_INFO("Stopping currently played video");
      m_protocolhandler->Stop();
      m_noexit++;
   }
   else if (m_acestreamenginehandler->IsEngineInstalled())
   {
      DBG_INFO("Stopping acestream engine");
      m_acestreamenginehandler->Stop();
      m_noexit++;
   }
   if ( m_noexit == 0)
   {
      Destroy();
   }
}

void MainFrame::Play(CChannel ch)
{
    if (ch.GetStreamURLs().Count() == 0)
    {
       DBG_INFO ("Empty channel URL list. Exiting")
       return;
    }
    wxString url = ch.GetStreamURLs()[0];
    wxArrayString vlcoptions = ch.GetVLCOptions(url);
    PreparePlayItems(ch.GetName());
    DBG_INFO("Channel name is %s", (const char*)ch.GetName().utf8_str());
    LaunchProtocolHandler(url, ch.GetName(), vlcoptions);
}

CChannel MainFrame::GetLastPlayedChannel()
{
      CChannel ch;
      if (m_lastPlayedChannelList->Count() != 0)
      {
         //Play the last played channel here...
         //Playing can't be done from the frame constructor (doh!) so, we have to delay it

         ch = m_lastPlayedChannelList->Item(0);
      }
      return ch;
}


void MainFrame::OnUpdateChannelList( wxCommandEvent& event )
{
//   wxString filename = CConfiguration::GetConfigFileName();
//   CSubscription sub("https://github.com/kneekoo/tvmaxe-db/blob/master/Romania.db?raw=true");
//   sub.ReadData();
//   sub.SaveDataToCache();
//   m_currentChannelList = sub.GetChannelList();
//   for (size_t i = 0; i <  m_currentChannelList.GetCount(); i++)
//   {
//      wxListItem item;
//      item.SetId((long)i);
//      item.SetText(m_currentChannelList[i].GetName());
//      m_ChannelList->InsertItem(item);
//   }
//   m_ChannelList->SetColumnWidth(0,wxLIST_AUTOSIZE);
}

void MainFrame::OnPlay( wxCommandEvent& event )
{
   long itemIndex = -1;
   itemIndex = m_ChannelList->GetNextItem(itemIndex,
          wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
    // Got the selected item index
    if (itemIndex == wxNOT_FOUND)
    {
       wxMessageBox(_("No Item selected"), _("Error"), wxOK|wxICON_EXCLAMATION, this);
       return;
    }
    CChannel *pch = m_currentChannelList[itemIndex];
    CChannel ch = *pch;
    if (ch.GetStreamURLs().Count() == 0)
    {
      wxMessageBox(_("This item has no media sources"), _("Error"), wxOK|wxICON_STOP, this);
      return;
    }
    wxString url = ch.GetStreamURLs()[0];
    wxArrayString vlcoptions = ch.GetVLCOptions(url);
    PreparePlayItems(ch.GetName());
    LaunchProtocolHandler(url, ch.GetName(), vlcoptions);
}

void MainFrame::OnListPlay( wxListEvent& event )
{
   unsigned long index = event.GetIndex();
   DBG_INFO("Clicked on item %lu ", index);
   CChannel ch = *m_currentChannelList[index];
   if (ch.GetStreamURLs().Count() == 0)
   {
      wxMessageBox(_("This item has no media sources"), _("Error"), wxOK|wxICON_STOP, this);
      return;
   }
   wxString url = ch.GetStreamURLs()[0];
   wxArrayString vlcoptions = ch.GetVLCOptions(url);
   PreparePlayItems(ch.GetName());
   LaunchProtocolHandler(url, ch.GetName(), vlcoptions);
}

void MainFrame::OnStop( wxCommandEvent& event )
{
   if (!m_delayedStart)
   {
      OnStop();
   }
}

void MainFrame::OnStop()
{
   DBG_INFO("OnStop()");
   if (m_protocolhandler)
   {
      m_protocolhandler->Stop();

   }
}

void MainFrame::LaunchProtocolHandler(wxString URL, wxString name, wxArrayString vlcoptions)
{
   static wxString currentURL;
   static wxString currentName;
   static wxArrayString currentVLCOptions;

   if (URL == "")
   {
      if (currentURL == "")
      {
         DBG_ERROR ("No URL defined when launching protocol!");
         return;
      }
   }
   else if (m_playlocked)
   {
      DBG_ERROR ("Can't play now. Play is locked. ");
      return;
   }
   else
   {
      currentURL = URL;
      currentVLCOptions = vlcoptions;
      currentName = name;
   }


   SET_SCREEN_FOCUS;
   if (m_protocolhandler != NULL)
   {
      if (currentURL != m_protocolhandler->GetURL())
      {
         m_protocolhandler->Stop();
         m_delayedStart = true;
      }
      else
      {
         DBG_INFO("Same channel chosen. Doing nothing");
      }
   }
   else
   {
      //factory of handlers
      wxURI uri(currentURL);
      if (uri.HasScheme())
      {
         wxString scheme = uri.GetScheme();
         if (scheme == "sop")
         {
            m_protocolhandler = new CSopProtocolHandler(this,currentURL, currentName, currentVLCOptions);
            m_protocolhandler->SetVLCPlayer(&m_vlcPlayer);
            m_bpButtonPlay->Disable();
            m_bpButtonRecord->Disable();
            m_protocolhandler->Start();
         }
         else if (scheme == "http"||
                  scheme == "https"||
                  scheme == "rtmp" ||
                  scheme == "rtsp" ||
                  scheme == "mms"  ||
                  scheme == "file")
         {
            m_protocolhandler = new CStreamProtocolHandler(this, currentURL, currentName, currentVLCOptions);
            m_protocolhandler->SetVLCPlayer(&m_vlcPlayer);
            m_bpButtonPlay->Disable();
            m_bpButtonRecord->Disable();
            m_protocolhandler->Start();
         }
         else if (scheme == "acestream")
         {
            if (m_acestreamenginehandler->IsEngineInstalled() == false )
            {
               wxMessageBox(_("Acestream engine not found"), _("Error"), wxOK|wxICON_HAND, this);
            }
            else
            {

               m_protocolhandler = new CAcestreamProtocolHandler(this,currentURL, currentName, currentVLCOptions);
               m_protocolhandler->SetVLCPlayer(&m_vlcPlayer);
               m_bpButtonPlay->Disable();
               m_bpButtonRecord->Disable();
               m_protocolhandler->Start();
            }

         }
         else
         {
            DBG_ERROR("Protocol not implemented yet.");
            return;
         }

      }
   }
}

void MainFrame::OnExitProtocolHandler(wxCommandEvent& event)
{

   UserDataObject *pUserData = reinterpret_cast<UserDataObject *>(event.GetClientObject());
   if (pUserData == nullptr)
   {
      DBG_ERROR("NULL user data in exit protocol event");
      return;
   }
   int *p_event = (int *)pUserData->GetData();
   if (p_event == nullptr)
   {
      DBG_ERROR("NULL exit protocol data");
      return;
   }

   DBG_INFO("OnExitProtocolHandler event type = %d", *p_event);
   m_bpButtonPlay->Enable();
   m_bpButtonRecord->Enable();
   ShowMovieSlider(false, 0);

   if (m_protocolhandler && *p_event == 0)
   {
      if (m_destroy)
      {
         DBG_INFO("Saving currently played item")
         CChannel ch;
         wxString url;
         wxString name;
         wxArrayString urls;
         wxStringToStringHashMap names;
         wxArrayString vlcoptions;

         url = m_protocolhandler->GetURL();
         name = m_protocolhandler->GetName();
         urls.Add(url);
         names[url] = name;
         vlcoptions = m_protocolhandler->GetVLCOptions();

         ch.SetName(name);
         ch.SetStreamURLs(urls);
         ch.SetStreamNames(names);
         ch.SetVLCOptions(url, vlcoptions);
         ch.SetId("0000");

         if (m_lastPlayedChannelList->Count() == 0)
         {
            m_lastplayeddb->AddChannel(ch);
            DBG_INFO("Saved currently played channel (added)");
         }
         else
         {
            m_lastplayeddb->UpdateChannel(ch);
             DBG_INFO("Saved currently played channel (updated)");
         }
         //NOW destroy the acestream handler
         if (m_acestreamenginehandler->IsEngineInstalled())
         {
            DBG_INFO("Stopping acestream engine");
            m_acestreamenginehandler->Stop();
            m_noexit++;
         }
      }
      else
      {
         if ((m_lastPlayedChannelList->Count() != 0))
         {
            DBG_INFO("Emptied the playing channel (nothing to save) ");
            m_lastplayeddb->DeleteChannel(m_lastPlayedChannelList->Item(0));
            m_lastPlayedChannelList->RemoveAt(0);

         }
      }
      DBG_INFO("Deleting protocol handler...");
      delete (m_protocolhandler);
      m_protocolhandler = NULL;
   }
   else if (*p_event == 1)
   {
      if (m_destroy)
      {
         DBG_INFO("Delete ACE engine handler...");
         delete m_acestreamenginehandler;
         m_acestreamenginehandler = NULL;
      }
      else
      {
         DBG_INFO("Keep ACE engine handler...");
      }

   }

   if (m_destroy)
   {
      if (*p_event == 0)
      {
         m_delayedStart = false;
      }
      if (--m_noexit <= 0)
      {
         DBG_INFO("Can exit now!");
         delete p_event;
         delete pUserData;
         Destroy();
      }
      return;
   }
   if (*p_event == 0)
   {
      if (m_delayedStart)
      {
         LaunchProtocolHandler("", "", wxArrayString());
         m_delayedStart = false;
      }
      else
      {

         SetTitle("TV-Lite");
         CStatusGauge::ShowStatusGauge(E_SB_LISTBUFFER, _("Ready"), false);
      }
   }
   delete p_event;
   delete pUserData;
}

void MainFrame::OnFullScreen( wxCommandEvent& event )
{
   ToggleFullScreen();
}

void MainFrame::ToggleFullScreen(wxMouseEvent& event)
{
   ToggleFullScreen();
}
void MainFrame::ToggleFullScreen(wxKeyEvent& event)
{

   if (event.GetKeyCode() == WXK_ESCAPE && m_isFullScreen)
   {
      ToggleFullScreen();
   }
   if ( event.GetKeyCode() == WXK_F11 ||
        event.GetUnicodeKey() =='f'   ||
        event.GetUnicodeKey() =='F')
   {
      ToggleFullScreen();
   }
   if (event.GetKeyCode() == WXK_SPACE)
   {
       m_vlcPlayer.Pause();
   }
}

void MainFrame::ToggleFullScreen()
{

   if (m_minSizeSet)
   {
      return;
   }
   ControlsFrame* controlFrame = wxGetApp().controlFrame;
   DBG_INFO("Toggle full screen")
   m_isFullScreen = !m_isFullScreen;
   if (m_isFullScreen)
   {
      DBG_INFO("SET");
     ;
      m_splitter1->Unsplit(m_panel3);
      m_bmToggleMini->Hide();
      MoveControls(controlFrame, bSizer41, controlFrame->bSizerControls);
      bSizer3->Detach(bSizer41);
      controlFrame->bSizerControls->Layout();
      bSizer41->Layout();
      bSizer3->Layout();
      HideControls();
      //long winflags = GetWindowStyleFlag();  
      ShowFullScreen(true);
      //winflags |= wxSTAY_ON_TOP;
      //SetWindowStyleFlag(winflags);
     
      HIDE_CURSOR;
      m_vlcPlayer.SetFull();
#ifdef __WXMSW__
      //m_transp->Connect( wxEVT_KEY_DOWN, wxKeyEventHandler(MainFrame::ToggleFullScreen), NULL, this );
      m_transp->Connect( wxEVT_MOTION,   wxMouseEventHandler(MainFrame::OnMoveOverImage ), NULL, this );
      m_transp->Connect( wxEVT_LEAVE_WINDOW,   wxMouseEventHandler(MainFrame::OnMoveOverControls ), NULL, this );
      m_transp->SetFocus();
#else
      //m_tvView->Connect( wxEVT_KEY_DOWN, wxKeyEventHandler(MainFrame::ToggleFullScreen), NULL, this );
      m_tvView->Connect( wxEVT_MOTION,   wxMouseEventHandler(MainFrame::OnMoveOverImage ), NULL, this );
      m_tvView->Connect( wxEVT_LEAVE_WINDOW,   wxMouseEventHandler(MainFrame::OnMoveOverControls ), NULL, this );
      m_tvView->SetFocus();
#endif


   }
   else
   {
      DBG_INFO("RESET");

#ifdef __WXMSW__
      RedrawPopup();
      //m_transp->Disconnect( wxEVT_KEY_DOWN, wxKeyEventHandler(MainFrame::ToggleFullScreen), NULL, this );
      m_transp->Disconnect( wxEVT_MOTION,   wxMouseEventHandler(MainFrame::OnMoveOverImage ), NULL, this );
      m_transp->Disconnect( wxEVT_LEAVE_WINDOW,   wxMouseEventHandler(MainFrame::OnMoveOverControls ), NULL, this );
      SetFocus();
#else
      m_tvView->Disconnect( wxEVT_MOTION,   wxMouseEventHandler(MainFrame::OnMoveOverImage ), NULL, this );
      m_tvView->Disconnect( wxEVT_LEAVE_WINDOW,   wxMouseEventHandler(MainFrame::OnMoveOverControls ), NULL, this );
#endif
	  //long winflags = GetWindowStyleFlag();
      //winflags &= ~wxSTAY_ON_TOP;
	  //SetWindowStyleFlag(winflags);
      ShowFullScreen(false);
      if (m_menuChannelList->IsChecked())
      {
         m_splitter1->SplitVertically(m_panel3, m_panel4, GetSashPos());
      }
      bSizer3->Insert(1, bSizer41, 0, wxEXPAND | wxALL, 5 );

      MoveControls(this->m_panel4 , controlFrame->bSizerControls, bSizer41);
      m_bmToggleMini->Show();
      bSizer41->Layout();
      bSizer3->Layout();

      SHOW_CURSOR;
      m_vlcPlayer.SetEmbedded();
      controlFrame->Show(false);
   }
}


void MainFrame::ResizeControls()
{
    ControlsFrame *controlFrame = wxGetApp().controlFrame;
    int parentPosX, parentPosY;
    int parentSizeX, parentSizeY;
    int childSizeY;
    int newx, newy;
    GetPosition(&parentPosX, &parentPosY);
    GetClientSize(&parentSizeX, &parentSizeY);
    childSizeY = 48;
    DBG_INFO("Parent position %d, %d, parent size %d, %d", parentPosX, parentPosY, parentSizeX, parentSizeY);
    
    if (controlFrame != NULL)
    {
        newx = parentPosX + parentSizeX / 8;
#if defined(__WXGTK__)
        if (m_isFullScreen)
        {
            newy = parentSizeY - childSizeY;
        }
        else
        {
            newy = parentPosY + parentSizeY - childSizeY;
        }
#else
     newy = parentSizeY - childSizeY;
#endif

#if defined(__WXGTK__)
        ScreenToClient(&newx, &newy);
#endif
        controlFrame->SetSize(newx, newy,
                parentSizeX * 6 / 8,
                childSizeY);
        controlFrame->bSizerControls->Layout();
        controlFrame->Refresh();

    }

}


void MainFrame::ResizeMiniWindow()
{
    ControlsFrame *controlFrame = wxGetApp().controlFrame;
    wxSize controlSize = controlFrame->bSizerControls->GetMinSize();

    int width  = controlSize.GetWidth();

    m_tvView->SetMinSize(wxSize(width, width * 9 / 16));
    bSizer3->Layout();
    bSizer3->Fit(m_tvView);
    m_panel4->SetMinSize(bSizer3->GetMinSize());
    mainSizer->Layout();
    mainSizer->Fit(m_panel4);
    #ifdef __WXMSW__
		SetMenuBar(NULL);
      m_statusBar->Hide();
#else
      m_menuBar->Hide();
      m_statusBar->Hide();
#endif
      SendSizeEvent();
      //This is the minimum size
      Fit();

}


void MainFrame::ResizeControlsMini(bool show)
{
    bool allowShowing = true;
    ControlsFrame *controlFrame = wxGetApp().controlFrame;
    int parentPosX, parentPosY;
    int parentSizeX, parentSizeY;
    int childSizeY, childSizeX;
    
    m_tvView->GetScreenPosition(&parentPosX, &parentPosY);
    m_tvView->GetClientSize(&parentSizeX, &parentSizeY);
    
    controlFrame->GetSize(&childSizeX, &childSizeY);


    DBG_INFO("Parent position %d, %d, parent size %d, %d", parentPosX, parentPosY, parentSizeX, parentSizeY);

    if (controlFrame != NULL)
    {
        wxDisplay display(wxDisplay::GetFromWindow(this));
        wxPoint boundary = display.GetGeometry().GetBottomLeft();
        if (parentPosY + parentSizeY <= boundary.y + 1)
        {
           
           int newx = parentPosX;
           int newy = parentPosY + parentSizeY - childSizeY;
#if defined(__WXGTK__)
           ScreenToClient(&newx, &newy);
#endif
           DBG_INFO("My position %d, %d, My size %d, %d", newx, newy, parentSizeX, childSizeY);

           controlFrame->SetSize(newx, newy, parentSizeX, childSizeY);
           m_movieslider->Show(parentSizeX > 500);
           controlFrame->bSizerControls->Layout();
           controlFrame->SendSizeEvent();
           
        }
        else
        {
           allowShowing = false;
        }
        if (show && allowShowing)
        {
           controlFrame->Show();
           controlFrame->Update();
        }
    }
}

void MainFrame::ShowControls(bool state)
{
   wxGetApp().controlFrame->Show(state);
   if (state == true)
   {
      ResizeControls();
      wxGetApp().controlFrame->SetFocus();
   }
   else
   {
       SetFocus();
   }
}


void MainFrame::ShowControlsMini(bool state)
{
   if (state == true)
   {
      ResizeControlsMini();
   }
    wxGetApp().controlFrame->Show(state);
    wxGetApp().controlFrame->SetFocus();
}


void MainFrame::MoveControls(wxWindow* newParent, wxSizer* fromSizer, wxSizer* toSizer)
{
   fromSizer->Detach(m_bpButtonPlay);
   m_bpButtonPlay->Reparent(newParent);
   toSizer->Add( m_bpButtonPlay, 0, wxALIGN_CENTER|wxALL, 5 );

   fromSizer->Detach(m_bpButtonPause);
   m_bpButtonPause->Reparent(newParent);
   toSizer->Add( m_bpButtonPause, 0, wxALIGN_CENTER|wxALL, 5 );

   fromSizer->Detach(m_bpButtonStop);
   m_bpButtonStop->Reparent(newParent);
   toSizer->Add( m_bpButtonStop, 0, wxALIGN_CENTER|wxALL, 5 );

   fromSizer->Detach(m_bpButtonRecord);
   m_bpButtonRecord->Reparent(newParent);
   toSizer->Add( m_bpButtonRecord, 0, wxALIGN_CENTER|wxALL, 5 );

   fromSizer->Detach(m_currenttime);
   m_currenttime->Reparent(newParent);
   toSizer->Add( m_currenttime, 0,wxALIGN_CENTER_VERTICAL|wxALL|wxRIGHT, 5 );

   fromSizer->Detach(m_movieslider);
   m_movieslider->Reparent(newParent);
   toSizer->Add( m_movieslider, 1, wxALIGN_CENTER|wxALL, 5 );

   fromSizer->Detach(m_totaltime);
   m_totaltime->Reparent(newParent);
   toSizer->Add( m_totaltime, 0,wxALIGN_CENTER_VERTICAL|wxALL|wxRIGHT, 5 );

   fromSizer->Detach(m_bitmap1);
   m_bitmap1->Reparent(newParent);
   toSizer->Add( m_bitmap1, 0, wxALIGN_CENTER|wxALL, 5 );

   fromSizer->Detach(m_slider1);
   m_slider1->Reparent(newParent);
   toSizer->Add( m_slider1, 0, wxALIGN_CENTER|wxALL, 5 );

   fromSizer->Detach(m_bpButtonFullScreen);
   m_bpButtonFullScreen->Reparent(newParent);
   toSizer->Add( m_bpButtonFullScreen, 0, wxALIGN_CENTER|wxALL, 5 );

   fromSizer->Detach(m_bmToggleMini);
   m_bmToggleMini->Reparent(newParent);
   toSizer->Add( m_bmToggleMini, 0, wxALIGN_CENTER|wxALL, 5 );
}


void MainFrame::OnMiniWindow( wxCommandEvent& event )
{
   m_bmToggleMini->SetValue(true);
   Hide();
   if (IsMaximized())
   {
            Maximize(false);
   }
   m_savedSize = GetSize();
   m_savedPosition = GetPosition();
   CallAfter(&MainFrame::ShowMiniWindow);

}

void MainFrame::OnToggleMini( wxCommandEvent& event )
{
   if (!m_minSizeSet)
   {
      Hide();
      if (IsMaximized())
      {
            Maximize(false);
      }
      m_savedSize = GetSize();
      m_savedPosition = GetPosition();
      CallAfter(&MainFrame::ShowMiniWindow);

   }
   else
   {
      SetSize(m_savedSize);
      SetPosition(m_savedPosition);
      CallAfter(&MainFrame::ShowNormalWindow);
   }
}

void MainFrame::ShowMiniWindow()

{
   ControlsFrame *controlFrame = wxGetApp().controlFrame;


   m_minSizeSet = true;

   SetChannelListVisibility(false);
   MoveControls(controlFrame, bSizer41, controlFrame->bSizerControls);
   m_movieslider->Hide();
   m_bpButtonFullScreen->Hide();

   ResizeMiniWindow();
   controlFrame->bSizerControls->Fit(controlFrame);
   controlFrame->bSizerControls->Layout();
   #ifdef __WXMSW__
      //m_transp->Connect( wxEVT_KEY_DOWN, wxKeyEventHandler(MainFrame::ToggleFullScreen), NULL, this );
      m_transp->Connect( wxEVT_MOTION,   wxMouseEventHandler(MainFrame::OnMoveOverImage ), NULL, this );
      m_transp->Connect( wxEVT_LEAVE_WINDOW,   wxMouseEventHandler(MainFrame::OnMoveOverControls ), NULL, this );
      m_transp->SetFocus();
   #else
      //m_tvView->Connect( wxEVT_KEY_DOWN, wxKeyEventHandler(MainFrame::ToggleFullScreen), NULL, this );
      m_tvView->Connect( wxEVT_MOTION,   wxMouseEventHandler(MainFrame::OnMoveOverImage ), NULL, this );
      m_tvView->Connect( wxEVT_LEAVE_WINDOW,   wxMouseEventHandler(MainFrame::OnMoveOverControls ), NULL, this );
      m_tvView->SetFocus();
  #endif

   if (!m_moveTimer.IsRunning())
   {
        m_moveTimer.StartOnce(200);
   }

   m_bmToggleMini->SetBitmap( wxArtProvider::GetBitmap( wxART_GO_UP, wxART_BUTTON ) );
   m_bmToggleMini->SetBitmapFocus( wxArtProvider::GetBitmap( wxART_GO_UP, wxART_BUTTON ) );
   m_bmToggleMini->SetBitmapCurrent( wxArtProvider::GetBitmap( wxART_GO_UP, wxART_BUTTON ) );
   long winflags = GetWindowStyleFlag();

   Show();
   winflags |= wxSTAY_ON_TOP;
   SetWindowStyleFlag(winflags);
   

}

void MainFrame::OnMoveTimer(wxTimerEvent &event)
{

   //The actual positioning takes place here
   wxSize newsize = GetSize();
   wxDisplay display(wxDisplay::GetFromWindow(this));
   wxPoint boundary = display.GetGeometry().GetBottomRight();
   DBG_INFO("Display size =  %d, %d", boundary.x, boundary.y);

   wxPoint newpos(boundary.x - newsize.GetWidth() - 10, boundary.y - newsize.GetHeight() - 10);
   DBG_INFO("New position =  %d, %d", newpos.x, newpos.y);
   CallAfter([this,newpos, newsize]{SetSize(newpos.x, newpos.y, newsize.GetWidth(), newsize.GetHeight());SetMinSize(GetSize());ResizeControlsMini();});

}

void MainFrame::OnMetaTimer(wxTimerEvent &event)
{
   if (m_vlcPlayer.WasStopped())
   {
      m_metaTimer.Stop();
   }
   m_vlcPlayer.GetMeta(m_metaTitle, m_metaArtist);
   PopulateMenuTrackItems();
   PrintMeta();
   event.Skip();
}

 void MainFrame::ShowNormalWindow()
 {
    ControlsFrame *controlFrame = wxGetApp().controlFrame;
    DBG_INFO("ShowNormalWindow")

    controlFrame->Hide();
    ResizeControlsMini(); //to show the movieslider

#ifdef __WXMSW__
		SetMenuBar(m_menuBar);
#else
    m_menuBar->Show();
#endif
    m_statusBar->Show();
    //To show the statusbar
    SendSizeEvent();
    MoveControls(this->m_panel4 , controlFrame->bSizerControls, bSizer41);
    bSizer41->Layout();
    bSizer3->Layout();
    m_bpButtonFullScreen->Show();
    m_movieslider->Show();
    SetChannelListVisibility(m_menuChannelList->IsChecked());
    m_tvView->SetMinSize(wxSize(-1, -1));
    m_panel4->SetMinSize(wxSize(-1, -1));
    m_minSizeSet=false;

   long winflags = GetWindowStyleFlag();
   //winflags |= wxMINIMIZE_BOX | wxMAXIMIZE_BOX;
   winflags &= ~wxSTAY_ON_TOP;
    SetWindowStyleFlag(winflags);
    m_bmToggleMini->SetValue(false);
    m_bmToggleMini->SetBitmap( wxArtProvider::GetBitmap( wxART_GO_DOWN, wxART_BUTTON ) );
    m_bmToggleMini->SetBitmapFocus( wxArtProvider::GetBitmap( wxART_GO_DOWN, wxART_BUTTON ) );
    m_bmToggleMini->SetBitmapCurrent( wxArtProvider::GetBitmap( wxART_GO_DOWN, wxART_BUTTON ) );
 }



void MainFrame::ShowControls()
{
    ShowControls(true);
    m_controlsShown = true;
}

void MainFrame::HideControls()
{
    ShowControls(false);
    m_controlsShown = false;
}

void MainFrame::ToggleChannelList( wxCommandEvent& event )
{
    SetChannelListVisibility(m_menuChannelList->IsChecked());
}

int MainFrame::GetSashPos()
{
   return m_toggleSubscriptions->GetSize().GetWidth() +
             m_toggleLocalLists->GetSize().GetWidth() +
             m_toggleFavorites->GetSize().GetWidth() +
#ifdef __WXMSW__
             m_splitter1->GetSashSize() + 2 * TOGGLE_BUTTON_BORDER;
#else
             m_splitter1->GetSashSize() + 2 * SIZER_BORDER + 2 * TOGGLE_BUTTON_BORDER;
#endif
}

void MainFrame::SetChannelListVisibility(bool visible)
{
   if (!visible)
   {
      m_splitter1->Unsplit(m_panel3);
   }
   else
   {

      m_splitter1->SplitVertically(m_panel3, m_panel4, GetSashPos());
   }
}

void MainFrame::PopulateChoice(unsigned int typeSel, wxString pathSel)
{
   unsigned int index = 0;
   m_choice1->Clear();
   switch (typeSel)
   {
      case 0:
         if (!m_choice1-IsShown())
         {
            m_choice1->Show();
            bSizer4->Layout();
         }
         for (unsigned int i = 0; i < m_localLists.GetCount(); i++)
         {
            m_choice1->Append(m_localLists[i]->GetSubscriptionInfo()->name);
            if (m_localLists[i]->GetSubscriptionInfo()->url == pathSel)
            {
               index = i;
               DBG_INFO("list index is %d", i);
            }

         }
         break;

      case 1:
         if (!m_choice1-IsShown())
         {
            m_choice1->Show();
            bSizer4->Layout();

         }
         for (unsigned int i = 0; i < m_subscriptionList.GetCount(); i++)
         {
            m_choice1->Append(m_subscriptionList[i]->GetSubscriptionInfo()->name);
            if (m_subscriptionList[i]->GetSubscriptionInfo()->url == pathSel)
            {
               index = i;
               DBG_INFO("subscription index is %d", i);
            }
         }
         break;

      case 2:
      {
         m_choice1->Hide();
         bSizer4->Layout();
      }
      default:
         break;
   }
   m_choice1->SetSelection(index);

}


int MainFrame::GetHighlightedGroupIndex()
{
    int itemIndex = wxNOT_FOUND;
    if (m_GroupList->GetItemCount() != 0)
    {
       itemIndex = m_GroupList->GetNextItem(itemIndex,
             wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
    }
    return itemIndex;
}

int MainFrame::GetSelectedGroupIndex()
{
    int itemIndex = GetHighlightedGroupIndex();
    if (itemIndex == wxNOT_FOUND) itemIndex = 0;
    return itemIndex;
}

int MainFrame::GetHighlightedChannelIndex()
{
    int itemIndex = wxNOT_FOUND;
    if (m_ChannelList->GetItemCount() != 0)
    {
       itemIndex = m_ChannelList->GetNextItem(itemIndex,
             wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
    }
    if (itemIndex == wxNOT_FOUND) itemIndex = 0;
    return itemIndex;
}

void MainFrame::RefreshCount(TPChannelList &list)
{
   wxString statlabel;
   unsigned int sources = 0;
   for (size_t i = 0; i <  list.GetCount(); i++)
   {
      wxArrayString s = list[i]->GetStreamURLs();
      sources += s.GetCount();
      s.Clear();
   }
   statlabel << _("Total: ") << list.GetCount() << _(" channels and ") << sources << _(" sources.");
   m_statistics->SetLabel(statlabel);
}

void MainFrame::PopulateDBSubscription(int typeSel, int listIndex)
{

   m_ChannelList->SetItemCount(0);
   //m_ChannelList->Update();
   m_GroupList->DeleteAllItems();
   //m_GroupList->Update();
   m_currentChannelList.Clear();
   m_dbChannelList->Clear();
   delete m_dbChannelList;
   m_dbChannelList = new TChannelList();

   if (typeSel == 0)
   {
      if (m_localLists.GetCount() > (size_t)listIndex)
      {
         m_localLists[listIndex]->ReadData(m_dbChannelList);
      }
   }

   else if (typeSel == 1)
   {
      if (m_subscriptionList.GetCount() > (size_t)listIndex)
      {
         m_subscriptionList[listIndex]->ReadDataFromCache(m_dbChannelList);
      }
   }
   else if (typeSel == 2)
   {
      m_favoritesdb->ReadData(m_dbChannelList);
   }
}

void MainFrame::GetGroups(TChannelList *chanlist, wxArrayString& grouparray)
{

   CStatusGauge::ShowStatusGauge(E_SB_LISTPROGRESS, _("Finding groups..."), false);
   grouparray.Clear();
   grouparray.Add("");
   for (size_t i = 0; i < chanlist->Count(); i++)
   {
      bool found = false;
      for (size_t j = 0; j < grouparray.GetCount(); j++)
      {
         if (chanlist->Item(i).GetGroup() == grouparray[j])
         {
            found = true;
            break;
         }
      }
      if (!found)
      {
         grouparray.Add(chanlist->Item(i).GetGroup());
      }
   }
   CStatusGauge::HideStatusGauge(E_SB_LISTPROGRESS);
}

void MainFrame::HighlightChan(wxString chanId)
{
   int itemIndex = wxNOT_FOUND;
   if (m_currentChannelList.GetCount() == 0)
   {
      return;
   }
   if (chanId != "")
   {
      for (unsigned int i = 0; i < m_currentChannelList.Count(); i++ )
      {
         if (m_currentChannelList[i]->GetId() == chanId)
         {
            itemIndex = i;
            break;
         }
      }
      if (itemIndex != wxNOT_FOUND)
      {

         m_ChannelList->EnsureVisible(itemIndex);
         m_ChannelList->SetItemState(itemIndex,wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
      }
   }

}

void MainFrame::HighlightGroup(wxString group)
{
   int itemIndex = wxNOT_FOUND;
   if (m_dbGroupList.GetCount() == 0)
   {
      return;
   }
   if (group != "")
   {
      for (unsigned int i = 0; i < m_dbGroupList.Count(); i++ )
      {
         if (m_dbGroupList[i] == group)
         {
            itemIndex = i;
            break;
         }
      }
      if (itemIndex != wxNOT_FOUND)
      {

         m_GroupList->EnsureVisible(itemIndex);
         m_GroupList->SetItemState(itemIndex,wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
      }
   }

}


void MainFrame::PopulateGroupList(wxString queryString, int sortType)
{


   wxBeginBusyCursor();
   wxArrayString grouplist;
   wxArrayString searchlist;
   wxArrayString &list = grouplist;

   GetGroups(m_dbChannelList, grouplist);
   m_GroupList->DeleteAllItems();
   if (sortType != GetGroupSearchOrder())
   {
      SetGroupSearchOrder(sortType);
   }

   if (queryString != m_groupSearchCtrl->GetValue())
   {
      m_groupSearchCtrl->SetValue(queryString);
   }

   if (queryString != "")
   {
      for (size_t i = 0; i < grouplist.Count(); i++)
      {
         if (grouplist.Item(i).Lower().Find(queryString.Lower()) != wxNOT_FOUND)
         {
            searchlist.Add(grouplist.Item(i));
         }
      }
      list = searchlist;
      DBG_INFO("Using search");
   }

   if (sortType == 0)
   {
      DBG_INFO("Sorting ascending");
      list.Sort();
   }

   if (sortType == 1)
   {
       DBG_INFO("Sorting descending");
       list.Sort(true);
       for (size_t i = 0; i < list.GetCount(); i++)
       {
          if (list[i] == "")
          {
             list.RemoveAt(i);
             list.Insert("", 0);
             break;
          }
       }

   }

   for (size_t i = 0; i <  list.GetCount(); i++)
   {
      wxListItem item;
      item.SetId((long)i);
      if (list[i] == "")
      {
         item.SetText(_("<All Channels>"));
      }
      else
      {
         item.SetText(list[i]);
      }
      m_GroupList->InsertItem(item);
   }


   m_GroupList->EnsureVisible(0);
   //m_GroupList->SetItemState(0,wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
   m_dbGroupList.Clear();
   m_dbGroupList = list;
   grouplist.Clear();
   searchlist.Clear();
   list.Clear();
   wxEndBusyCursor();
}

void MainFrame::PopulateChannelList(int groupIndex, wxString queryString, int sortType)
{

   m_ChannelList->SetItemCount(0);
   m_currentChannelList.Clear();
   if (queryString != m_listSearchCtrl->GetValue())
   {
      m_listSearchCtrl->SetValue(queryString);
   }
   if (sortType != GetListSearchOrder())
   {
      SetListSearchOrder(sortType);
   }
   if (m_dbGroupList.GetCount() == 0)
   {
      //no groups selected - erase everything
      RefreshCount(m_currentChannelList);
      return;
   }
   if (groupIndex == wxNOT_FOUND)
   {
      groupIndex = 0;
   }
   if (groupIndex != GetSelectedGroupIndex())
   {
      m_GroupList->EnsureVisible(groupIndex);
      m_GroupList->SetItemState(groupIndex,wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
   }
   wxBeginBusyCursor();
   CStatusGauge::ShowStatusGauge(E_SB_LISTPROGRESS, _("Update channelList"));
   wxString group = m_dbGroupList[groupIndex];

   bool groupvalidate = (group != "");
   bool searchvalidate = (queryString != "");

   for (size_t i = 0; i < m_dbChannelList->Count(); i++)
   {
      bool valid = true;
      if (groupvalidate)
      {
         valid =  (m_dbChannelList->Item(i).GetGroup() == group);
      }
      if (valid && searchvalidate)
      {
         valid = (m_dbChannelList->Item(i).GetName().Lower().Find(queryString.Lower()) != wxNOT_FOUND);

      }
      if (valid)
      {
         m_currentChannelList.Add(&(*m_dbChannelList)[i]);
      }
   }
   if (sortType == 0)
   {
      DBG_INFO("Sorting ascending");
      m_currentChannelList.Sort(CChannel::CompareAsc);
   }

   if (sortType == 1)
   {
      DBG_INFO("Sorting descending");
      m_currentChannelList.Sort(CChannel::CompareDesc);
   }

   m_ChannelList->SetItemCount(m_currentChannelList.Count());
   RefreshCount(m_currentChannelList);
   CStatusGauge::HideStatusGauge(E_SB_LISTPROGRESS);
   wxEndBusyCursor();
}

void MainFrame::OnPopulateChannel( wxCommandEvent& event )
{
    CallAfter(&MainFrame::PopulateFromQuery);
}

void MainFrame::PopulateFromQuery()
{
    if (m_queryTimer.IsRunning())
    {
       m_queryTimer.Stop();
    }
    m_queryTimer.StartOnce(1000);
}

void MainFrame::OnQueryTimer(wxTimerEvent& event)
{
   CallAfter(&MainFrame::QueryDisplay);
   event.Skip();
}

void MainFrame::QueryDisplay()
{
   CBusyGuard guard(this);

   if (guard.Allows())
   {

      wxString groupId;
      int groupIndex = m_GroupList->GetNextItem(wxNOT_FOUND,wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
      if (groupIndex != wxNOT_FOUND)
      {
         groupId = m_dbGroupList[groupIndex];
      }
      wxString chanId;
      int itemIndex = m_ChannelList->GetNextItem(wxNOT_FOUND,wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
      if (itemIndex != wxNOT_FOUND)
      {
         chanId = m_currentChannelList[itemIndex]->GetId();
      }
      PopulateGroupList(m_groupSearchCtrl->GetValue(), GetGroupSearchOrder());
      HighlightGroup(groupId);
      PopulateChannelList(GetSelectedGroupIndex(), m_listSearchCtrl->GetValue(), GetListSearchOrder());
      HighlightChan(chanId);
   }

}

void MainFrame::InitInterface()
{
      wxString cfgItem = TVLITECONFIG->Read("LastRun/AspectRatio", "");
      m_vlcPlayer.SetAspectRatio(cfgItem);
      //bool boolItem = TVLITECONFIG->Read("LastRun/ShowChannelList", true);
      //m_menuChannelList->Check(boolItem);
      //SetChannelListVisibility(boolItem);
      SetChannelListVisibility(true);
      m_menuChannelList->Check(true);
      CLocalList::GetStoredData(m_localLists);
      CSubscription::GetCachedData(m_subscriptionList);
      wxFileName favoritesfile(CConfiguration::GetFavoritesDir(), CConfiguration::GetFavoritesFileName());
      wxFileName lastplayedfile(CConfiguration::GetLastPlayedDir(), CConfiguration::GetLastPlayedFileName());
      m_favoritesdb = new CLocalList(favoritesfile.GetFullPath());
      m_lastplayeddb = new CLocalList(lastplayedfile.GetFullPath());
      m_ChannelList->SetChannelList(&m_currentChannelList);
      PopulateChoice(m_listType);
      m_choice1->SetSelection(0);
      InitPositions();
      PopulateDBSubscription(m_listType,m_choice1->GetSelection());
      PopulateGroupList();
      PopulateChannelList();
      //Prepare the last played channel list
      m_lastplayeddb->ReadData(m_lastPlayedChannelList);

}

void MainFrame::RefreshInterface(int type, wxString pathsel)
{
      if (type == 0)
      {
         CLocalList::GetStoredData(m_localLists);
      }
      else if (type ==1)
      {
         CSubscription::GetCachedData(m_subscriptionList);
      }

      if (type == m_listType )
      {

         PopulateChoice(m_listType, pathsel);
         PopulateDBSubscription(m_listType,m_choice1->GetSelection());
         PopulateGroupList("", GetGroupSearchOrder());
         PopulateChannelList(GetSelectedGroupIndex(), "",  GetListSearchOrder());

      }

}

void MainFrame::UpdateAllSubscriptions()

{
   CBusyGuard guard(this);
   if (guard.Allows())
   {

      if (m_subscriptionList.Count() == 0)
      {
         //Add George's subscription
         CSubscription *subscription = new CSubscription("http://www.radiocondor.ro/uploads/liste-tvlite/Canale-Romania.db");
         subscription->GetSubscriptionInfo()->url = "http://www.radiocondor.ro/uploads/liste-tvlite/Canale-Romania.db";
         m_subscriptionList.Add(subscription);
         subscription = new CSubscription("https://iptv-org.github.io/iptv/index.country.m3u");
         subscription->GetSubscriptionInfo()->url = "https://iptv-org.github.io/iptv/index.country.m3u";
         subscription->GetSubscriptionInfo()->name = "IPTV org";
         m_subscriptionList.Add(subscription);
      }
      CDLProgress *progressDialog = new CDLProgress(this, &m_subscriptionList);
      int rc = progressDialog->ShowModal();
      if (rc == E_DLP_OK)
      {
         ClearSubscriptionPosition();
         RefreshInterface(1);
      }
      progressDialog->Destroy();
      delete progressDialog;
   }
}


void MainFrame::OnSubscriptionSelected( wxCommandEvent& event )
{

   CallAfter(&MainFrame::OnListRepopulate);

}

void MainFrame::OnListRepopulate()
{
   CBusyGuard guard(this);
   if (guard.Allows())
   {
       PopulateDBSubscription(m_listType, m_choice1->GetSelection());
       PopulateGroupList("", GetGroupSearchOrder());
       PopulateChannelList(GetSelectedGroupIndex(),"", GetListSearchOrder());
   }
}

void MainFrame::OnListContextMenu( wxMouseEvent& event )
{
   wxMenu contextMenu;
   int popId = basePopId;
   if (m_currentChannelList.GetCount() == 0  )
   {
      contextMenu.Append(popId++, _("New Item"  ));
      contextMenu.Connect(wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(MainFrame::OnPopupClick),
                    NULL,
                    this);
   PopupMenu(&contextMenu);
   }
   else
   {
       event.Skip();
   }

}

void MainFrame::OnGroupSelect( wxListEvent& event )
{

  CBusyGuard guard(this);
  if (guard.Allows())
  {
      wxString chanId;
      int itemIndex = wxNOT_FOUND;
      if (m_ChannelList->GetItemCount() != 0)
      {
         itemIndex = m_ChannelList->GetNextItem(itemIndex,
             wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
      }
       // Got the selected item index
       if (itemIndex != wxNOT_FOUND)
       {
          chanId = m_currentChannelList[itemIndex]->GetId();
       }
      PopulateChannelList(GetSelectedGroupIndex(), m_listSearchCtrl->GetValue(), GetListSearchOrder());
      if (chanId != "")
      {
         HighlightChan(chanId);
      }
   }
}

#ifdef __WXMSW__
void MainFrame::OnListRightClick( wxMouseEvent& event )
{
    if (m_currentChannelList.GetCount() == 0)
    {
        if (m_listType == (ESelList)E_SEL_LIST)
        {
           wxMenu contextMenu;
           contextMenu.Append(basePopId, _("New Item"  ));
           contextMenu.Connect(wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(MainFrame::OnPopupClick),
                    NULL,
                    this);
            PopupMenu(&contextMenu);
        }

    }
    else
    {
        event.Skip();
    }
}
#endif

void MainFrame::OnListContextMenu( wxListEvent& event )
{
   wxMenu contextMenu;
   int urlId = baseUrlId;
   int popId = basePopId;
   int index = (int)event.GetIndex();
   if (m_currentChannelList.GetCount() == 0 || index == wxNOT_FOUND )
   {
      if (GetListType() == (ESelList)E_SEL_LIST || GetListType() == (ESelList)E_SEL_FAVORITES)
      {
         contextMenu.Append(popId++, _("New Item"  ));
         contextMenu.Connect(wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(MainFrame::OnPopupClick),
                    NULL,
                    this);
      }
   }
   else
   {
      CChannel ch = *m_currentChannelList[index];
      wxString url;
      int urlCount = ch.GetStreamURLs().Count();
      if (urlCount != 0)
      {
         url =ch.GetStreamURLs()[0];
      }
      for (int i = 0; i < urlCount; i++)
      {
         url = ch.GetStreamURLs()[i];
         contextMenu.Append(urlId++,ch.GetStreamNames()[url]);
      }


      if (GetListType() == (ESelList)E_SEL_LIST ||
          GetListType() == (ESelList)E_SEL_FAVORITES)
      {
         contextMenu.AppendSeparator();
         contextMenu.Append(popId++, _("New Item"  ));
         contextMenu.Append(popId++, _("Edit Item"  ));
         contextMenu.Append(popId++, _("Delete Item"));
      }
      else
      {
         contextMenu.AppendSeparator();
         contextMenu.Append(basePopId + 3, _("Information"  ));

      }
      if (GetListType() != (ESelList)E_SEL_FAVORITES)
      {
         contextMenu.AppendSeparator();
         contextMenu.Append(basePopId + 4, _("Add to favorites"));
      }

   contextMenu.Connect(wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(MainFrame::OnPopupClick),
                    new UserDataObject(m_currentChannelList[index]),
                    this);
   }

   PopupMenu(&contextMenu);
}

void MainFrame::OnRefreshEvent(wxCommandEvent& event)
{
   UserDataObject *pUserData = reinterpret_cast<UserDataObject *>(event.GetClientObject());
   if (pUserData == nullptr)
   {
      DBG_ERROR("NULL user data in refresh event");
      return;
   }
   refreshData *p_event = (refreshData *)pUserData->GetData();
   if (p_event == nullptr)
   {
      DBG_ERROR("NULL refresh event");
      return;
   }
   CBusyGuard guard(this);
   if (guard.Allows())
   {
   PopulateChannelList(p_event->groupid, "", GetListSearchOrder());
   HighlightChan(p_event->chanid);
   RefreshCount(m_currentChannelList);
   delete p_event;
   delete pUserData;
   }

}

void MainFrame::OnPopupClick(wxCommandEvent& event)
{
   //Canalul în lista curenta
   CChannel *ch = NULL;
   //Canalul în lista bazei de date
   int dbListIndex = wxNOT_FOUND;
   UserDataObject *eventData = static_cast<UserDataObject*>(event.GetEventUserData());
   if (eventData != nullptr)
   {
      ch = (CChannel*)eventData->GetData();
   }
   if (ch == NULL)
   {
       DBG_ERROR("Channel NULL");
       //return;
   }

   int ident = event.GetId();

   if (ch != NULL)
   {
      for (size_t i = 0; i < m_dbChannelList->Count(); i++)
      {
         if (ch->GetId() == m_dbChannelList->Item(i).GetId())
         {
            dbListIndex = i;
            break;
         }
      }
      if (dbListIndex == wxNOT_FOUND)
      {
         DBG_ERROR("Channel Not found in db list");
         return;
      }
   }

   CChannelEdit *chEdit;
   CLocalList *list = nullptr;

   int itemIndex = wxNOT_FOUND;
   int rc;

   int listindex = m_choice1->GetSelection();
   if (GetListType() != (ESelList)E_SEL_FAVORITES && listindex == wxNOT_FOUND)
   {
         return;
   }
   if (GetListType() == (ESelList)E_SEL_LIST)
   {
      list = m_localLists[listindex];
   }
   if (GetListType() == (ESelList)E_SEL_FAVORITES)
   {
      list = m_favoritesdb;
   }

      if (ident < baseUrlId)
      {
         CBusyGuard guard(this);
         switch(ident - basePopId)
         {
            case 0:
                if (guard.Allows())
                {
                   CChannel *newch = new CChannel();
                   wxString chanid;
                   chEdit = new CChannelEdit(this);
                   chEdit->FillGroups();
                   rc =chEdit->ShowModal();
                   if (rc == wxID_OK)
                   {
                       chEdit->GetData(newch);
                       //set id here to scroll the list to the new channel
                       wxString id = newch->GetName().BeforeFirst(' ');
                       wxString randVal;
                       randVal.Printf("%03d", rand() % 1000);
                       chanid = id + randVal;
                       newch->SetId(chanid);

                       if (list)
                       {
                           newch->PopulateDefaultValues();
                           rc = list->AddChannel(*newch);
                           if (rc != E_DB_OK)
                           {
                               DBG_ERROR("Could not add channel");
                           }
                           else
                           {
                              m_dbChannelList->Add(*newch);
                           }

                       }
                        PopulateGroupList("", GetGroupSearchOrder());
                        PopulateChannelList(GetSelectedGroupIndex(),"", GetListSearchOrder());
                        HighlightChan(chanid);
                   }

                }

            break;
            case 1:
               if (guard.Allows() && ch != NULL)
               {
                  chEdit = new CChannelEdit(this);
                  chEdit->SetData(ch);
                  wxString oldname = ch->GetName();
                  wxString oldgroup = ch->GetGroup();
                  rc = chEdit->ShowModal();
                  if (rc == wxID_OK)
                  {
                     chEdit->GetData(ch);
                     if (list)
                     {
                        ch->PopulateDefaultValues();
                        rc = list->UpdateChannel(*ch);
                        if (rc != E_DB_OK)
                        {
                           DBG_ERROR("Could not update channel");
                        }
                     }
                  }
                  chEdit->Destroy();
                  delete chEdit;
                  {
                     wxString newgroup = ch->GetGroup();
                     wxString newname  = ch->GetName();
                     if (oldgroup != newgroup || oldname != newname)
                     {
                        wxCommandEvent refreshevent(chanlistEVT);
                        refreshData *evdata = new refreshData;
                        bool triggerGroup = false;
                        bool triggerName = (oldname != newname);
                        if (oldgroup != newgroup)
                        {
                           long currentSelectedIndex = GetSelectedGroupIndex();
                           PopulateGroupList();
                           long groupindex = m_GroupList->FindItem(-1, newgroup );
                           if (currentSelectedIndex == 0)
                           {
                              evdata->groupid = 0;
                           }
                           else
                           {
                              evdata->groupid = groupindex;
                              triggerGroup = true;
                           }
                        }
                        else
                        {
                           evdata->groupid = GetSelectedGroupIndex();
                        }
                        if (triggerGroup || triggerName)
                        {
                           evdata->chanid = ch->GetId();
                           refreshevent.SetClientObject((wxClientData*) new UserDataObject((void *)evdata));
                           wxQueueEvent(this, refreshevent.Clone());

                        }
                     }
                  }
               }
            break;
            case 2:
                   if (list != nullptr && guard.Allows() && ch != NULL)
                   {
                       if (wxMessageBox(_("Do you really wish to delete the selected channel?"),
                                      _("Question"),
                                        wxYES_NO|wxICON_QUESTION, NULL) == wxYES)
                       {
                            rc = list->DeleteChannel(*ch);
                            if (rc != E_DB_OK)
                            {
                                DBG_ERROR("Could not delete channel");
                            }
                           itemIndex = m_ChannelList->GetNextItem(wxNOT_FOUND,wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
                           m_dbChannelList->RemoveAt(dbListIndex);
                           PopulateGroupList(m_groupSearchCtrl->GetValue(), GetGroupSearchOrder());
                           PopulateChannelList(GetSelectedGroupIndex(),m_listSearchCtrl->GetValue(), GetListSearchOrder());
                           //The same list, minus the deleted one
                           if (itemIndex != wxNOT_FOUND && m_ChannelList->GetItemCount() != 0)
                           {
                             if (itemIndex > 0)
                             {
                                itemIndex--;
                             }
                              m_ChannelList->EnsureVisible(itemIndex);
                              m_ChannelList->SetItemState(itemIndex,wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);

                           }
                        }
                   }
               break;
            case 3:
               {
                  if (ch != NULL)
                  {
                     CChannelInfo* chInfo = new CChannelInfo(this);
                     chInfo->SetData(ch);
                     chInfo->ShowModal();
                     chInfo->Destroy();
                     delete chInfo;
                  }
               }
               break;
            case 4:
            {
               m_favoritesdb->AddChannel(*ch);
            }
            break;
            default:
               break;
         }
      }
      else
      {
         if (ch != NULL)
         {
            int index = ident - baseUrlId;
            DBG_INFO("index is %d" ,index);
            DBG_INFO("URL is %s", (const char*)ch->GetStreamURLs()[index].utf8_str());
            PreparePlayItems(ch->GetName());
            LaunchProtocolHandler(ch->GetStreamURLs()[index], ch->GetName(), ch->GetVLCOptions(ch->GetStreamURLs()[index]));
         }
      }
}

void MainFrame::OnSubscriptionClick( wxCommandEvent& event )
{
   CSubscriptionListDialog *subscriptionList = new CSubscriptionListDialog(this);
   subscriptionList->ShowModal();
   subscriptionList->Destroy();
   delete subscriptionList;
   DBG_INFO("Exiting OnSubscriptionClick")
}


void MainFrame::OnUpdateAllSubscriptions( wxCommandEvent& event )
{
   UpdateAllSubscriptions();
}

TSubscriptionList* MainFrame::GetSubscriptionList()
{
   return &m_subscriptionList;
}

TLocalLists* MainFrame::GetLocalLists()
{
   return &m_localLists;
}

void MainFrame::OnLocalListClick(wxCommandEvent& event)
{
   CLocalListDialog *localLists = new CLocalListDialog(this);
   localLists->SetLists(&m_localLists);
   localLists->Repopulate();
   localLists->ShowModal();

   localLists->Destroy();
   delete localLists;
}

void MainFrame::OnLocalListAdd(wxCommandEvent& event)
{
   CLocalDialog *dialog = new CLocalDialog(this);
   int rc = dialog->ShowModal();
   if (rc == wxID_OK)
   {
      CLocalList newList;
      CSubscriptionInfo info;
      dialog->GetData(&info);
      newList.SetSubscriptionInfo(info);
      newList.SaveDataToListDir(); //TODO check result
   }
   dialog->Destroy();
   delete dialog;
   RefreshInterface(0);
}

void MainFrame::OnListTypeClick()
{
    CBusyGuard guard(this);
    if (guard.Allows())
    {
       SetBusy();
       PopulateChoice(GetListType());
       
       if (m_choice1->GetCount() > 0 && m_recordedPos[m_listType].listIndex == wxNOT_FOUND)
       {
            m_choice1->SetSelection(0);
       }
       else
       {
           m_choice1->SetSelection( m_recordedPos[m_listType].listIndex);
       }
       PopulateDBSubscription(m_listType, m_choice1->GetSelection());
       PopulateGroupList("",GetGroupSearchOrder());
       if (m_recordedPos[m_listType].groupIndex != wxNOT_FOUND)
       {
            m_GroupList->EnsureVisible(m_recordedPos[m_listType].groupIndex);
            m_GroupList->SetItemState(m_recordedPos[m_listType].groupIndex, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
       }
       PopulateChannelList(GetSelectedGroupIndex(),"", GetListSearchOrder());
       if (m_recordedPos[m_listType].channelIndex != wxNOT_FOUND)
       {
           m_ChannelList->EnsureVisible(m_recordedPos[m_listType].channelIndex);
           m_ChannelList->SetItemState(m_recordedPos[m_listType].channelIndex, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
       }
    }
}

void MainFrame::OnSaveSubscriptionAsLocalList( wxCommandEvent& event )
{
   TChannelList chanlist;
   if (GetListType() == (ESelList)E_SEL_SUBSCRIPTION)
   {
      int listindex = m_choice1->GetSelection();
      if (listindex == wxNOT_FOUND)
      {
         return;
      }
      m_subscriptionList[listindex]->ReadDataFromCache(&chanlist);
      m_subscriptionList[listindex]->SetChannelList(&chanlist);
      m_subscriptionList[listindex]->SaveDataToListDir();
      RefreshInterface(0);
      wxMessageBox(_("The list was saved."), "Save", wxOK|wxICON_INFORMATION, this);
   }
}

void MainFrame::OnSaveList( wxCommandEvent& event )
{
  SaveList(false);
}

void MainFrame::OnSaveView( wxCommandEvent& event )
{
  SaveList(true);
}

void MainFrame::SaveList(bool isView)
{
      CSubscription *crtlist = nullptr;
      CSubscriptionInfo* crtInfo = nullptr;
      TChannelList tempList;

      int listindex = m_choice1->GetSelection();
      if (listindex == wxNOT_FOUND)
      {
         return;
      }

      if (GetListType() == (ESelList)E_SEL_SUBSCRIPTION)
      {
         crtInfo = m_subscriptionList[listindex]->GetSubscriptionInfo();
      }
      else
      {
         crtInfo = m_localLists[listindex]->GetSubscriptionInfo();
      }

      if (crtInfo != nullptr)
      {
         crtlist = new CSubscription(crtInfo->url);
         crtlist->SetSubscriptionInfo(*crtInfo);

         if (isView)
         {

            for (size_t i = 0 ; i < m_currentChannelList.Count(); i++)
            {
              tempList.Add(*m_currentChannelList[i]);
            }
            crtlist->SetChannelList(&tempList);
         }
         else
         {
            crtlist->SetChannelList(m_dbChannelList);
         }
      }
      else
      {
         return;
      }


   wxFileDialog *SaveDialog = new wxFileDialog(
		this, _("Save File As _?"), wxEmptyString, wxEmptyString,
		_("TV-Maxe lists (*.db)|*.db|All files (*)|*"),
		wxFD_SAVE | wxFD_OVERWRITE_PROMPT, wxDefaultPosition);

	if (SaveDialog->ShowModal() == wxID_OK) // If the user clicked "OK"
	{
      wxString savePath = SaveDialog->GetPath();
      if (wxFileExists(savePath))
      {
         if (!wxRemoveFile(savePath))
         {
            wxMessageBox(_("Error while trying to write file: ") + savePath, _("Error"), wxOK|wxICON_EXCLAMATION, this);
            return;
         }
      }
      crtlist->SaveData(savePath);
      wxMessageBox(_("The list has been saved."), _("Save list"), wxOK|wxICON_INFORMATION, this);
	}

	SaveDialog->Destroy();
   delete crtlist;
}

void MainFrame::OnAbout( wxCommandEvent& event )
{
    wxAboutDialogInfo aboutInfo;
    aboutInfo.SetName("TV-Lite");
    //aboutInfo.SetVersion(TV_LITE_VERSION_STRING);
    aboutInfo.SetDescription(_("Player for online TV Channels - TV-maxe like\nVersion ") + wxString(TV_LITE_VERSION_STRING) );
    aboutInfo.SetCopyright("(C) 2020 - 2025");
    aboutInfo.SetWebSite("https://tv-lite.com");
    aboutInfo.AddDeveloper("Cristian Burneci");
    wxAboutBox(aboutInfo);
}

void MainFrame::OnVlcEvent(wxCommandEvent& event)
{
   static bool timecodeShown = false;
   static bool vol_unwanted = true;
   UserDataObject *pUserData = reinterpret_cast<UserDataObject *>(event.GetClientObject());
   if (pUserData == nullptr)
   {
      DBG_ERROR("NULL user data in player event");
      return;
   }
   libvlc_event_t *p_event = (libvlc_event_t *)pUserData->GetData();
   if (p_event == nullptr)
   {
      DBG_ERROR("NULL player event");
      return;
   }
   //DBG_INFO("VLC event id = %X", p_event->type);
  /* if (p_event->type != libvlc_MediaPlayerBuffering)
   {
      if (CStatusGauge::IsVisible(E_SB_LISTBUFFER))
      {
         CStatusGauge::HideStatusGauge(E_SB_LISTBUFFER);
      }
   }*/
   switch(p_event->type)
   {
       case libvlc_MediaParsedChanged:
         DBG_INFO("Parse ended");
       break;
       case libvlc_MediaMetaChanged:
       {
         DBG_INFO("Meta found");
         PrintMeta();
       }
      break;
      case libvlc_MediaPlayerBuffering:
         CStatusGauge::ShowStatusGauge(E_SB_LISTBUFFER, _("Buffering"));
         CStatusGauge::UpdateGauge(E_SB_LISTBUFFER, (int)p_event->u.media_player_buffering.new_cache);
         break;
      case libvlc_MediaPlayerPlaying:
      case libvlc_MediaPlayerVout:
         m_vlcPlayer.GetMeta(m_metaTitle, m_metaArtist);
         PrintMeta();
         if (!m_metaTimer.IsRunning())
         {
            m_metaTimer.Start(1000);
         }
         //libvlc_video_set_spu(m_vlcPlayer.GetMediaPlayer(), m_vlcPlayer.GetTrackMap()[etSubtitle]);
         if (m_vlcPlayer.GetLength() != "" && m_vlcPlayer.IsValidTime())
         {
            if (m_controlsShown)
            {
               m_currenttime->SetLabel(m_vlcPlayer.GetTime());
               m_totaltime->SetLabel(m_vlcPlayer.GetLength());
               bSizer41->Layout();
            }
            timecodeShown = true;
         }
         else
         {
            timecodeShown = false;
         }
         vol_unwanted = true;
         if (p_event->type == libvlc_MediaPlayerVout)
         {
            m_logoRefresh = false;
            m_titleRefresh = false;
         }
         else
         {
            m_titleRefresh = true;
         }
         break;
      case libvlc_MediaPlayerPositionChanged:
         CStatusGauge::ShowStatusGauge(E_SB_LISTBUFFER, _("Playing"), false);
         m_movieslider->SetValue(m_vlcPlayer.GetPosition() * m_movieslider->GetMax());
         if (timecodeShown &&  m_vlcPlayer.IsValidTime())
         {
            //DBG_INFO("current time = %s", (const char*)(m_vlcPlayer.GetLength().utf8_str()));

            if (m_controlsShown)
            {
               m_currenttime->SetLabel(m_vlcPlayer.GetTime());
               m_totaltime->SetLabel(m_vlcPlayer.GetLength());
               bSizer41->Layout();
            }

         }
         else
         {
            m_totaltime->SetLabel(wxEmptyString);
            m_currenttime->SetLabel(wxEmptyString);
            bSizer41->Layout();
         }
         break;
      case libvlc_MediaPlayerPaused:
         CStatusGauge::ShowStatusGauge(E_SB_LISTBUFFER, _("Paused"), false);
         break;
      case libvlc_MediaPlayerStopped:
         CStatusGauge::ShowStatusGauge(E_SB_LISTBUFFER, _("Stopped"), false);
         m_bpButtonPlay->Enable();
         m_bpButtonRecord->Enable();
         m_logoRefresh = true;
         m_titleRefresh = false;
         if (m_metaTimer.IsRunning())
         {
            m_metaTimer.Stop();
         }
         m_tvView->Refresh();

         DeleteTrackItems(m_videoTracks);
         DeleteTrackItems(m_audioTracks);
         DeleteTrackItems(m_subtitleTracks);
         if (m_vlcPlayer.WasStopped() == false)
         {
            m_protocolhandler->Stop();
         }
         m_totaltime->SetLabel(wxEmptyString);
         m_currenttime->SetLabel(wxEmptyString);
         bSizer41->Layout();
         vol_unwanted = true;
         break;
      case libvlc_MediaPlayerEncounteredError:
         wxMessageBox(_("The player encountered an error while trying to play URL"), _("Error"), wxOK|wxICON_EXCLAMATION, this);
         break;
         m_tvView->Refresh();
         if (m_vlcPlayer.WasStopped() == false)
         {
            m_protocolhandler->Stop();
         }
      case libvlc_MediaPlayerEndReached:
        //experimental
         m_vlcPlayer.Play();
         break;
      case libvlc_MediaPlayerSeekableChanged:
         ShowMovieSlider(p_event->u.media_player_seekable_changed.new_seekable, 0);
         break;
      case libvlc_MediaPlayerAudioVolume:
         DBG_INFO("Volume value is %f", p_event->u.media_player_audio_volume.volume);
         if (vol_unwanted)
         {
            int desiredvolume = m_vlcPlayer.GetVolume();
            SetVolume(desiredvolume);
            m_slider1->SetValue(desiredvolume);
            vol_unwanted = false;
         }
         else
         {
            m_slider1->SetValue((int)(p_event->u.media_player_audio_volume.volume * 100.0));
         }
         break;


       default:

          break;
   }
   delete p_event;
   delete pUserData;
}

void MainFrame::OnVoumeChanged( wxMouseEvent& event )
{
   SetVolume(m_slider1->GetValue());
}
void MainFrame::OnVolumeChanged( wxCommandEvent& event )
{
   SetVolume(m_slider1->GetValue());
}


 void MainFrame::SetVolume(int value)
 {
    if (value < 0 || value > 100)
    {
       return;
    }
     m_vlcPlayer.SetVolume(value);
     if (value < 20)
     {
         m_bitmap1->SetBitmap(volume1_xpm);
     }
     else if (value < 40)
     {
         m_bitmap1->SetBitmap(volume2_xpm);
     }
     else if (value < 60)
     {
         m_bitmap1->SetBitmap(volume3_xpm);
     }
     else if (value < 80)
     {
         m_bitmap1->SetBitmap(volume4_xpm);
     }
     else
     {
         m_bitmap1->SetBitmap(volume5_xpm);
     }
 }


void MainFrame::OnARDefault( wxCommandEvent& event )
{
    m_vlcPlayer.SetAspectRatio("");
}

void MainFrame::OnAR169( wxCommandEvent& event )
{
    m_vlcPlayer.SetAspectRatio("16:9");
}

void MainFrame::OnAR43( wxCommandEvent& event )
{
   m_vlcPlayer.SetAspectRatio("4:3");
}

void MainFrame::RedrawPopup()
{
    wxPoint pos = m_tvView->GetScreenPosition();
    pos.x += 5;
    wxSize size = m_tvView->GetSize();
    int width = size.GetWidth();
    size.SetWidth(width);

    m_transp->SetPosition(pos);
    m_transp->SetSize(size);
    m_transp->Refresh();

}


void MainFrame::RedrawListPane()
{
    //just a placeholder for extra work, if needed
    //wxSize size = m_grouptbAZ->GetSize();
    //DBG_INFO("size is - %d, %d", size.GetWidth(), size.GetHeight());
}


void MainFrame::OnSize( wxSizeEvent& event )
{


#ifdef __WXMSW__
   RedrawPopup();

#endif
    //RedrawListPane();

    if (m_minSizeSet)
    {
       HideControls();
       CallAfter(&MainFrame::ResizeControlsMini , false);
    }
    
    if (m_isFullScreen)
    {
       ResizeControls();
    }
    event.Skip();
}

void MainFrame::OnMove( wxMoveEvent& event )
{

#ifdef __WXMSW__
    RedrawPopup();
#endif
    //RedrawListPane();
    if (m_minSizeSet)
    {
       HideControls();
       CallAfter(&MainFrame::ResizeControlsMini , false);
    }
    DBG_INFO("Moved to %d, %d", GetPosition().x, GetPosition().y);
    event.Skip();
}

void MainFrame::OnMaximizeFrame( wxMaximizeEvent& event )
{

   DBG_INFO("Window gets maximized");
   if (m_minSizeSet)
   {
      if (IsMaximized())
      {
         HideControls();
#if 0
         Maximize(false);
         if (!m_moveTimer.IsRunning())
          {
             m_moveTimer.StartOnce(200);
          }
#endif
      }

   }

#ifdef __WXMSW__
      RedrawPopup();
#endif
      RedrawListPane();
      event.Skip();

}

void MainFrame::RaiseTransp()
{
   m_transp->Raise();
}

void MainFrame::OnPaintEvent( wxPaintEvent& event )
{
#ifdef __WXMSW__
   RedrawPopup();
#endif
   //RedrawListPane();
   event.Skip();
}

wxImage& MainFrame::GetLogo()
{
   return m_logo;
}

void MainFrame::LogoPaint( wxPaintEvent& event )
{
    int neww, newh;
    wxPaintDC dc(m_tvView);
    dc.GetSize(&neww, &newh);
    if (m_logoRefresh && m_logoPresent && !m_minSizeSet)
    {
       wxBitmap bmp(m_logo);
       if (neww > 0 && newh > 0)
       {
            dc.DrawBitmap(bmp, neww/2 - (bmp.GetWidth()/2) , newh/2 - (bmp.GetHeight()/2) );
       }
    }
    if (m_titleRefresh)
    {
       wxFont font(neww < 500 ? 11 : 16, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL );
       dc.SetTextForeground(*wxYELLOW);
       dc.SetTextBackground(*wxBLUE);
       dc.SetFont(font);
       wxRect metaRect(10, newh - newh/4, neww - 20 , newh/4);
       wxString label;
       m_tvView->SetFont(font);
       CTextWrapper wrapper(m_tvView, neww * 70 /100 );
       wxString caption = SetStreamCaption();
       dc.DrawLabel(wrapper.Wrap(caption),  metaRect, wxALIGN_CENTER | wxALIGN_CENTER_VERTICAL);
    }
    //event.Skip();
}

void MainFrame::LogoSize ( wxSizeEvent& event )
{
   Refresh();
}

void MainFrame::OnSeekUsrChanged( wxCommandEvent& event )
{
   if (m_mev_treated)
   {
      m_mev_treated = false;
      event.Skip();
      return;
   }
   float slval = (float)m_movieslider->GetValue() / (float)m_movieslider->GetMax();
   m_vlcPlayer.Seek(slval);
   event.Skip();
}

void MainFrame::OnSeekMouseChanged( wxMouseEvent& event )
{
   wxPoint coord = event.GetPosition();
   int x, y;
   m_movieslider->GetClientSize(&x, &y);
   m_movieslider->SetMax(x - 20);

   int oldpos = m_movieslider->GetValue();

   int newpos = coord.x -10;
   DBG_INFO ("max = %d",m_movieslider->GetMax());
   DBG_INFO("old= %d, new = %d", oldpos, newpos);
   if (abs(oldpos - newpos) <= 10) //we are on the thumb
   {
       event.Skip();
       return;
   }
   m_movieslider->SetValue(newpos);
   float slval = (float)m_movieslider->GetValue() / (float)m_movieslider->GetMax();
   m_vlcPlayer.Seek(slval);
   m_mev_treated = true;
}

void MainFrame::OnPause( wxCommandEvent& event )
{
   m_vlcPlayer.Pause();
}

void MainFrame::OnPause( wxMouseEvent& event )
{
   m_vlcPlayer.Pause();
}

void MainFrame::OnVlcSeekEvent( wxCommandEvent& event )
{
   ShowMovieSlider(true, 0);
}


void MainFrame::ShowMovieSlider(bool show, unsigned int value)
{
   if (value <= 1)
   {
      m_movieslider->SetValue(value * m_movieslider->GetMax());
   }
   m_movieslider->Enable(show);
}

void MainFrame::OnMoveOverImage( wxMouseEvent& event )
{

    if (!m_isFullScreen && !m_minSizeSet) return;
    if (!m_trtimer.IsRunning())
    {
        m_trtimer.StartOnce(2000);
        SHOW_CURSOR;
        if (m_isFullScreen)
        {
           CallAfter(&MainFrame::ShowControls);
        }
        if (m_minSizeSet)
        {
           ResizeControlsMini(true);
           //ShowControlsMini(true);
        }
    }
    else
    {
        event.Skip();
    }


}


void MainFrame::OnMoveOverControls( wxMouseEvent& event )
{
   if (!m_isFullScreen && !m_minSizeSet) return;
   if (m_trtimer.IsRunning())
   {
       m_trtimer.Stop();
   }
  wxRect rect = m_tvView->GetClientRect();
  wxPoint pnt = event.GetPosition();
;
  if (!rect.Contains(pnt))
   {
      HideControls();
   }
   event.Skip();
}

void MainFrame::OnMouseLeaveMiniFrame( wxMouseEvent& event )
{
   if (m_minSizeSet)
   {
      HideControls();
   }
   event.Skip();
}

void MainFrame::HideBar( wxTimerEvent& event )
{
    if (!m_isFullScreen && !m_minSizeSet) return;
    if (m_isFullScreen)
    {
       HideControls();
       HIDE_CURSOR;
    }
    if (m_minSizeSet)
    {
       ShowControlsMini(false);
    }

    event.Skip();
}
void  MainFrame::OnRecord( wxCommandEvent& event )
{
   int /*buttonHeight, buttonWidth,*/ ownHeight, ownWidth;

   int xcoord, ycoord;
   if (m_recordChoice == NULL)
   {
      m_recordChoice = new CRecordChoice(this);
   }
   m_recordChoice->GetSize(&ownWidth, &ownHeight);
   wxPoint buttonPos = m_bpButtonRecord->GetScreenPosition();
   xcoord = buttonPos.x - (ownWidth/2);
   if (xcoord < 0)
   {
      xcoord = 0;
   }
   ycoord = buttonPos.y - ownHeight;
   if (ycoord < 0)
   {
      ycoord = 0;
   }
   m_recordChoice->Move(xcoord, ycoord);
   m_recordChoice->Show();
}

void MainFrame::SetVLCRecordState(int type)
{
   m_vlcPlayer.SetRecordState((EVLCRecordState)type);
}

int MainFrame::GetVLCRecordState()
{
   return (int)m_vlcPlayer.GetRecordState();
}

void MainFrame::AddTrackItems(TTrackInfoList &trackInfoList, wxMenu *menu, int baseid)
{
   for (size_t i = 0; i < trackInfoList.Count(); i++)
   {
      wxString label = trackInfoList[i].GetInfo();
      wxMenuItem *item = new wxMenuItem( menu, baseid + i, label, wxEmptyString, wxITEM_NORMAL );
	   menu->Append(item);
      menu->Bind(wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MainFrame::OnTrackItemClick), this, item->GetId());

   }

}

void MainFrame::DeleteTrackItems(wxMenu *menu)
{
   wxMenuItemList::compatibility_iterator node = menu->GetMenuItems().GetFirst();
   while (node)
	{
		wxMenuItem *item = node->GetData();
      DBG_INFO("Found item %s",(const char*)item->GetItemLabelText().utf8_str());
		menu->Unbind(wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(MainFrame::OnTrackItemClick), this, item->GetId());
      node = node->GetNext();
      menu->Destroy(item);

	}
}

void MainFrame::OnTrackItemClick( wxCommandEvent& event )
{
   int id = event.GetId();
   int index;
   ETrackType trackType;
   if (id >= baseSubtitleId)
   {
      trackType = etSubtitle;
      index = subtitletracklist[id - baseSubtitleId].GetIndex();
   }
   else if (id >= baseAudioId)
   {
      index = audiotracklist[id - baseAudioId].GetIndex();
      trackType = etAudio;
   }
   else if (id >= baseVideoId)
   {
      index = videotracklist[id - baseVideoId].GetIndex();
      trackType = etVideo;
   }
   else
   {
      DBG_ERROR("Wrong selection");
      return;
   }

   DBG_INFO("index is %d " ,index);
   m_vlcPlayer.SetTrack(index, trackType );
}

void MainFrame::PreparePlayItems(wxString trackName)
{
   SetTitle("TV-Lite - " + trackName);
   wxString saveFileName = trackName << "_" << wxNow() <<".mpg";
   #if defined __WXMSW__
   saveFileName.Replace(":","_",true);
   #endif
   wxFileName fullFileName(CConfiguration::Instance()->GetGeneralConfiguration().GetRecordDir(), saveFileName);
   m_vlcPlayer.SetRecordFileName(fullFileName.GetFullPath());
   m_vlcPlayer.SetStreamPort(CConfiguration::Instance()->GetGeneralConfiguration().GetStreamPort());
}

void MainFrame::OnShowPref(wxCommandEvent& event)
{
   CPrefDialog *dialog = new CPrefDialog(this);
   dialog->SetData();
   int rc = dialog->ShowModal();
   if (rc == wxID_OK)
   {
      dialog->GetData();
   }
   dialog->Destroy();
   delete dialog;
}

void MainFrame::OnGroupListPaint( wxSizeEvent& event )
{
    //event.Skip();
    DBG_INFO("Paint group");
    int size_x, size_y;
    m_GroupList->GetSize(&size_x, &size_y);
    m_GroupList->SetColumnWidth(0,size_x);
    event.Skip();
}


void MainFrame::OnChannelListPaint( wxSizeEvent& event )
{
   int size_x, size_y;
   m_ChannelList->GetSize(&size_x, &size_y);
   m_ChannelList->SetColumnWidth(0,size_x);
   event.Skip();
}

void MainFrame::OnStatusBarPaint( wxPaintEvent& event )
{
   event.Skip();
   CStatusGauge::RedrawStatusGauges(m_statusBar);
}

void MainFrame::OnStatusBarSize( wxSizeEvent& event )
{
   event.Skip();
   CStatusGauge::RedrawStatusGauges(m_statusBar);
}

void MainFrame::OnEraseBackground( wxEraseEvent& event )
{
   if (m_logoRefresh)
   {
      event.Skip();
   }
}

bool MainFrame::isFullScreen()
{
   return m_isFullScreen;
}

bool MainFrame::isMinSizeSet()
{
   return m_minSizeSet;
}

wxTimer* MainFrame::GetMouseTimer()
{
   return &m_trtimer;
}

void MainFrame::OnMuteClick( wxMouseEvent& event )
{
    static int sliderpos = 100;
    if (!m_isMute)
    {
        m_isMute = true;
        sliderpos = m_slider1->GetValue();
        SetVolume(0);
        m_slider1->SetValue(0);

    }
    else
    {
        m_isMute = false;
        SetVolume(sliderpos);
        m_slider1->SetValue(sliderpos);
    }
}

CSubscription* MainFrame::GetTempSubscription()
{
   return m_tempsubscription;
}

void MainFrame::SetTempSubscription(CSubscription* subscription)
{
   m_tempsubscription = subscription;
}

void MainFrame::OnToggleListAZ( wxCommandEvent& event )
{
   if (m_listtbAZ->GetValue() && m_listtbZA->GetValue())
   {
      m_listtbZA->SetValue(false);
   }
   CallAfter(&MainFrame::QueryDisplay);
}

void MainFrame::OnToggleListZA( wxCommandEvent& event )
{
   if (m_listtbAZ->GetValue() && m_listtbZA->GetValue())
   {
      m_listtbAZ->SetValue(false);
   }
   CallAfter(&MainFrame::QueryDisplay);

}

void MainFrame::OnToggleGroupAZ( wxCommandEvent& event )
{
   if (m_grouptbAZ->GetValue() && m_grouptbZA->GetValue())
   {
      m_grouptbZA->SetValue(false);
   }
   CallAfter(&MainFrame::QueryDisplay);
}

void MainFrame::OnToggleGroupZA( wxCommandEvent& event )
{
   if (m_grouptbAZ->GetValue() && m_grouptbZA->GetValue())
   {
      m_grouptbAZ->SetValue(false);
   }
   CallAfter(&MainFrame::QueryDisplay);
}

int MainFrame::GetGroupSearchOrder()
{
 //0 - ascending, 1 - Descending, 2 - None
   if (m_grouptbAZ->GetValue() == true)
   {
      return 0;
   }
   else if (m_grouptbZA->GetValue() == true)
   {
      return 1;
   }
   else
   {
      return 2;
   }

}

void MainFrame::SetGroupSearchOrder(int sortType)
{
   if (sortType == 0)
   {
      m_grouptbAZ->SetValue(true);
      m_grouptbZA->SetValue(false);
   }
   else if (sortType == 1)
   {
      m_grouptbAZ->SetValue(false);
      m_grouptbZA->SetValue(true);
   }
   else
   {
      m_grouptbAZ->SetValue(false);
      m_grouptbZA->SetValue(false);
   }
}


int MainFrame::GetListSearchOrder()
{
//0 - ascending, 1 - Descending, 2 - None
   if (m_listtbAZ->GetValue() == true)
   {
      return 0;
   }
   else if (m_listtbZA->GetValue() == true)
   {
      return 1;
   }
   else
   {
      return 2;
   }
}

void MainFrame::SetListSearchOrder(int sortType)
{
   if (sortType == 0)
   {
      m_listtbAZ->SetValue(true);
      m_listtbZA->SetValue(false);
   }
   else if (sortType == 1)
   {
      m_listtbAZ->SetValue(false);
      m_listtbZA->SetValue(true);
   }
   else
   {
      m_listtbAZ->SetValue(false);
      m_listtbZA->SetValue(false);
   }
}
#ifdef __WXMSW__
void MainFrame::OnSplitterMove(wxSplitterEvent& event)
{
   Refresh();
   RedrawPopup();
   RedrawListPane();
   event.Skip();
}
#endif

wxString MainFrame::SetStreamCaption()
{

   wxString newcaption;
   if (m_titleRefresh)
   {
      if (m_metaTitle == "")
      {
         newcaption = m_metaArtist;
      }
      else
      {
         newcaption = m_metaTitle + " (" + m_metaArtist + ")";
      }
   }
   return newcaption;
}

void  MainFrame::PrintMeta()
{
   static wxString oldcaption;
   wxString newcaption = SetStreamCaption();
   DBG_INFO("Print Meta");
   if (oldcaption != newcaption)
   {
      DBG_INFO("Changed Meta");
      oldcaption = newcaption;
      if (!IsIconized())
      {
         m_tvView->Refresh();
      }

      if (CConfiguration::Instance()->GetGeneralConfiguration().GetNotifEnabled() &&
      #ifdef __WXMSW__
           !m_transp->HasFocus()
      #else
           !m_tvView->HasFocus()
      #endif
     )
     {

         DBG_INFO("Notifying; ");
#ifdef __WXMSW__   
         if (!m_tbicon)
         {
            m_tbicon = new wxTaskBarIcon();
            m_tbicon->SetIcon(icon_tv_xpm);
         }
         wxNotificationMessage::UseTaskBarIcon(m_tbicon);
         wxNotificationMessage::MSWUseToasts("TV-Lite.lnk");		
#endif  
         if (m_notif.get()) m_notif->Close();
         m_notif.reset(new wxNotificationMessage("TV-Lite", newcaption, this));
         m_notif->Show();

      }


   }

}

void MainFrame::PopulateMenuTrackItems()
{
   int nt;
   videotracklist.Clear();
   nt = m_vlcPlayer.GetTracks(videotracklist,etVideo);
   if (nt == 0)
   {
      DeleteTrackItems(m_videoTracks);
      AddTrackItems(videotracklist, m_videoTracks, baseVideoId);
   }
   DBG_INFO("Got video tracks result = %d", nt);
   audiotracklist.Clear();
   nt = m_vlcPlayer.GetTracks(audiotracklist,etAudio);
   if (nt == 0)
   {
      DeleteTrackItems(m_audioTracks);
      AddTrackItems(audiotracklist, m_audioTracks, baseAudioId);
   }
   DBG_INFO("Got audio tracks result = %d", nt);
   subtitletracklist.Clear();
   nt = m_vlcPlayer.GetTracks(subtitletracklist,etSubtitle);
   if (nt == 0)
   {
      DeleteTrackItems(m_subtitleTracks);
      AddTrackItems(subtitletracklist, m_subtitleTracks, baseSubtitleId);
   }
   DBG_INFO("Got subtitles result = %d", nt);
}

ESelList MainFrame::GetListType()
{
   return m_listType;
}

void MainFrame::OnToggleLocalLists(wxCommandEvent& event)
{
   if (m_toggleLocalLists->GetValue())
   {
      if (m_toggleSubscriptions->GetValue() == true)
      {
         m_toggleSubscriptions->SetValue(false);
      }
      if (m_toggleFavorites->GetValue() == true)
      {
         m_toggleFavorites->SetValue(false);
      }
   }
   else
   {
      m_toggleLocalLists->SetValue(true);
   }
   StorePosition((int)m_listType);
   m_listType = E_SEL_LIST;
   CallAfter(&MainFrame::OnListTypeClick);
}

void MainFrame::OnToggleSubscriptions(wxCommandEvent& event)
{
   if (m_toggleSubscriptions->GetValue())
   {
      if (m_toggleLocalLists->GetValue() == true)
      {
         m_toggleLocalLists->SetValue(false);
      }
      if (m_toggleFavorites->GetValue() == true)
      {
         m_toggleFavorites->SetValue(false);
      }
   }
   else
   {
      m_toggleSubscriptions->SetValue(true);
   }
   StorePosition((int)m_listType);
   m_listType = E_SEL_SUBSCRIPTION;
   CallAfter(&MainFrame::OnListTypeClick);
}

void MainFrame::OnToggleFavorites(wxCommandEvent& event)
{
   if (m_toggleFavorites->GetValue())
   {
      if (m_toggleLocalLists->GetValue() == true)
      {
         m_toggleLocalLists->SetValue(false);
      }
      if (m_toggleSubscriptions->GetValue() == true)
      {
         m_toggleSubscriptions->SetValue(false);
      }
   }
   else
   {
      m_toggleFavorites->SetValue(true);
   }
   StorePosition((int)m_listType);
   m_listType = E_SEL_FAVORITES;
   CallAfter(&MainFrame::OnListTypeClick);
}

wxPanel* MainFrame::GetTVFrame()
{
   return m_tvView;
}


void MainFrame::StorePosition(int type)
{
    m_recordedPos[type].listIndex = m_choice1->GetSelection();
    m_recordedPos[type].groupIndex = GetHighlightedGroupIndex();
    m_recordedPos[type].channelIndex = GetHighlightedChannelIndex();
}

void MainFrame::InitPositions()
{
    TRecordedPos position;
    for (int type = (int)E_SEL_LIST; type <= (int)E_SEL_FAVORITES; type++)
    {
        m_recordedPos.Add(position);
    }
}

void MainFrame::ClearSubscriptionPosition()
{
    TRecordedPos position;
    m_recordedPos[E_SEL_SUBSCRIPTION] = position;
}