import requests.exceptions
from _typeshed import Incomplete

class AuthError(RuntimeError): ...
class LoginFailed(AuthError): ...
class LoginRequired(AuthError): ...
class UnboundEntity(RuntimeError): ...
class Fault(requests.exceptions.HTTPError): ...
class ObjectNotFound(Fault): ...
class AccessUnauthorized(Fault): ...

class RateLimitExceeded(RuntimeError):
    limit: Incomplete
    timeout: Incomplete
    def __init__(
        self, msg, timeout: Incomplete | None = ..., limit: Incomplete | None = ...
    ) -> None: ...

class RateLimitTimeout(RateLimitExceeded): ...
class ActivityUploadFailed(RuntimeError): ...
class ErrorProcessingActivity(ActivityUploadFailed): ...
class CreatedActivityDeleted(ActivityUploadFailed): ...
class TimeoutExceeded(RuntimeError): ...
class NotAuthenticatedAthlete(AuthError): ...

def warn_param_deprecation(param_name: str): ...
def warn_param_unofficial(param_name: str): ...
def warn_units_deprecated() -> None: ...
