/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.superscript.internal;

import com.vladsch.flexmark.ext.superscript.Superscript;
import com.vladsch.flexmark.ext.superscript.SuperscriptExtension;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SuperscriptNodeRenderer
implements NodeRenderer {
    private final String superscriptStyleHtmlOpen;
    private final String superscriptStyleHtmlClose;

    public SuperscriptNodeRenderer(DataHolder options) {
        this.superscriptStyleHtmlOpen = SuperscriptExtension.SUPERSCRIPT_STYLE_HTML_OPEN.get(options);
        this.superscriptStyleHtmlClose = SuperscriptExtension.SUPERSCRIPT_STYLE_HTML_CLOSE.get(options);
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<Superscript>(Superscript.class, this::render));
        return set;
    }

    private void render(Superscript node, NodeRendererContext context, HtmlWriter html) {
        if (this.superscriptStyleHtmlOpen == null || this.superscriptStyleHtmlClose == null) {
            if (context.getHtmlOptions().sourcePositionParagraphLines) {
                html.withAttr().tag("sup");
            } else {
                html.srcPos(node.getText()).withAttr().tag("sup");
            }
            context.renderChildren(node);
            html.tag("/sup");
        } else {
            html.raw(this.superscriptStyleHtmlOpen);
            context.renderChildren(node);
            html.raw(this.superscriptStyleHtmlClose);
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new SuperscriptNodeRenderer(options);
        }
    }
}

