//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/cksharerequestaccessoperation?language=objc)
    #[unsafe(super(CKOperation, NSOperation, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "CKOperation")]
    pub struct CKShareRequestAccessOperation;
);

#[cfg(feature = "CKOperation")]
extern_conformance!(
    unsafe impl NSObjectProtocol for CKShareRequestAccessOperation {}
);

#[cfg(feature = "CKOperation")]
impl CKShareRequestAccessOperation {
    extern_methods!(
        /// Creates a new, empty share request access operation.
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// Creates a share request access operation configured with specified share URLs.
        ///
        /// - Parameter shareURLs: An array of `NSURL` objects representing the shares to request access to.
        /// - Returns: A configured ``CKShareRequestAccessOperation`` instance.
        #[unsafe(method(initWithShareURLs:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithShareURLs(
            this: Allocated<Self>,
            share_ur_ls: &NSArray<NSURL>,
        ) -> Retained<Self>;

        /// The URLs of the shares to request access to.
        ///
        /// Include multiple URLs to request access to multiple shares simultaneously. The server processes each URL independently.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(shareURLs))]
        #[unsafe(method_family = none)]
        pub unsafe fn shareURLs(&self) -> Option<Retained<NSArray<NSURL>>>;

        /// Setter for [`shareURLs`][Self::shareURLs].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setShareURLs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShareURLs(&self, share_ur_ls: Option<&NSArray<NSURL>>);

        #[cfg(feature = "block2")]
        /// A completion block called once for each processed share URL.
        ///
        /// The server does not disclose share existence to protect user privacy.
        ///
        /// - Parameters:
        /// - shareURL: The URL of the share that was processed.
        /// - shareRequestAccessError: An error describing why the access request failed, or `nil` if successful.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument 1 must be a valid pointer.
        /// - The returned block's argument 2 must be a valid pointer or null.
        /// - This might not be thread-safe.
        #[unsafe(method(perShareAccessRequestCompletionBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn perShareAccessRequestCompletionBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<NSURL>, *mut NSError)>;

        #[cfg(feature = "block2")]
        /// Setter for [`perShareAccessRequestCompletionBlock`][Self::perShareAccessRequestCompletionBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setPerShareAccessRequestCompletionBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPerShareAccessRequestCompletionBlock(
            &self,
            per_share_access_request_completion_block: Option<
                &block2::DynBlock<dyn Fn(NonNull<NSURL>, *mut NSError)>,
            >,
        );

        #[cfg(feature = "block2")]
        /// A completion block called when the entire operation finishes.
        ///
        /// - Parameter operationError: An error describing the overall operation failure, or `nil` if successful.
        ///
        /// If `operationError` is `CKErrorPartialFailure`, the `userInfo` dictionary contains detailed errors for each share under ``CKPartialErrorsByItemIDKey``.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument must be a valid pointer or null.
        /// - This might not be thread-safe.
        #[unsafe(method(shareRequestAccessCompletionBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn shareRequestAccessCompletionBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(*mut NSError)>;

        #[cfg(feature = "block2")]
        /// Setter for [`shareRequestAccessCompletionBlock`][Self::shareRequestAccessCompletionBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setShareRequestAccessCompletionBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShareRequestAccessCompletionBlock(
            &self,
            share_request_access_completion_block: Option<&block2::DynBlock<dyn Fn(*mut NSError)>>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "CKOperation")]
impl CKShareRequestAccessOperation {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
