//MIT License
//
//Copyright (c) 2016 Drake Levy
//Copyright (c) 2023 szlldm
//
//Permission is hereby granted, free of charge, to any person obtaining a copy
//of this software and associated documentation files (the "Software"), to deal
//in the Software without restriction, including without limitation the rights
//to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//copies of the Software, and to permit persons to whom the Software is
//furnished to do so, subject to the following conditions:
//
//The above copyright notice and this permission notice shall be included in all
//copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//SOFTWARE.


static const int16_t pl3x2_paramFeatureBias[12] = {
    -10957, -14208, -9753, -14329, -298, -23751, -1218, -107, -13079, -5388, -14247, 554, 
};

static const int16_t pl3x2_paramFeatureWeights[300] = {
    63, -113, -598, -1165, 1647, -4722, -1415, -1341, -1209, -396, -2975, -1519, -1323, -1123, 5004, 620, 
    -548, 145, -143, 2030, 91, -436, 3243, -2588, -2947, -247, -1979, 749, 1867, 2504, 1556, -969, 
    3413, 568, 6853, -3440, 89, 4403, 6345, -1118, 611, -2510, -1711, 933, 3027, -1002, -911, -448, 
    1740, 44, 531, -3059, 1499, -2936, 188, -393, -1852, 12, -4197, -234, 1903, -3564, -2507, 4474, 
    1888, -248, -5630, 1257, -168, 160, 1449, 2411, 1094, 5051, -6237, -1409, -7190, 3540, -2474, -385, 
    3931, 2074, -5402, -2121, -4505, -2351, -20646, -6221, 1981, 6790, -343, -3072, 10551, -1015, -3112, -2314, 
    2673, -9722, -1573, -1752, 12, 3595, 840, -142, 792, 634, 2940, 2140, 62, -539, -1105, 3681, 
    1410, -1142, 19, 1260, -2654, 1855, 1393, 662, -1910, 2419, 4034, -467, -958, 1485, -4491, 211, 
    -1339, -1115, 2588, 501, -9, 9786, 5324, -7952, -3703, 610, 602, -3457, -469, 2168, -2654, 7927, 
    -1595, 9523, 2277, -4572, 11014, 6239, 4775, 6537, -4580, -3518, -8425, 2475, 5702, -10365, 2425, 610, 
    -107, 4707, 563, -1510, -6466, 1547, 8234, -8437, 815, 1350, -1842, 512, -1915, -271, 2913, -371, 
    -2028, -1508, 5222, -463, -1429, -661, 149, -800, 3134, -1084, -725, 1286, 1896, -354, 302, 166, 
    -3495, 1907, 4891, 3128, -5584, 792, -2265, -1926, -1736, 1714, 953, 2534, 1866, -2893, 7849, 9567, 
    428, 5788, 3961, -796, -1786, -322, -3933, 2062, 2978, -5580, 7884, 4522, -7549, 1600, 413, -1803, 
    1464, 163, -2731, -470, -1806, 1327, -907, -1662, -2476, -3066, 808, 66, 1799, -1604, 916, -2726, 
    651, -846, -1632, -2422, 149, -3689, 1178, -225, -600, -53, -2831, 668, -2212, -2288, -2049, 1979, 
    1198, -1149, -2134, 1410, -3314, 888, 3716, -552, 492, 1308, -4208, 3299, 2910, 1047, -367, -165, 
    -1310, -357, 2370, 3107, 834, 2308, -2843, 431, -925, -3130, 3452, 1030, 2548, -1287, -1828, 961, 
    -1314, -69, -93, -2097, 174, -1190, 135, -24, -2246, 1131, -1899, -782, 
};

static const int16_t pl3x2_paramPassThroughFeatureBias[4] = {
    1, 1, 0, 0, 
};

static const int16_t pl3x2_paramPassThroughFeatureWeights[100] = {
    32, -4, -23, 43, -92, 4, 164, -92, -305, -261, 429, 478, 46, -126, -46, 126, 
    -32, 42, 15, -10, -114, 123, 23, -94, 348, -528, -561, -68, 2052, 2016, -922, -971, 
    -580, 359, -127, -537, 163, -109, -63, 17, -281, 474, -289, 478, 2062, -956, 2059, -982, 
    6474, 6541, 6489, 6569, -876, 2022, -911, 1998, 426, -269, 444, -267, 37, -90, -97, 123, 
    -600, -80, 341, -506, -881, -975, 2044, 1987, -169, -523, -551, 393, -41, 2, 143, -123, 
    -21, 32, 41, -15, 163, -75, -124, 13, 428, 460, -271, -280, -39, 143, 10, -110, 
    15, -13, -9, 33, 
};

static const int16_t pl3x2_paramModel1Bias[12] = {
    -16775, -138, -1982, -1963, -2529, 429, -4906, -98, -1306, 3293, -5933, 2119, 
};

static const int16_t pl3x2_paramModel1Weights[1296] = {
    -1756, -1562, -2877, 844, 280, -466, 2643, -4220, -1062, -1591, 5484, 2874, 1211, 1953, 1337, 1232, 
    3612, 1645, 305, -958, -574, -2114, 2800, -1195, -654, 992, 4636, -1138, 3002, -3461, -799, -949, 
    3448, 693, -2120, -7270, 2916, -6253, 860, 7393, -1276, 7202, -3409, -3295, 2405, -264, -2745, -3348, 
    -778, -13085, -6507, -3651, 4178, -349, -1710, 2263, -1143, 7288, -1484, -6213, -375, -4494, -8947, 4726, 
    -892, -1175, -5788, 9914, -194, -766, -604, -5791, -9791, -4587, -10219, 8018, -4372, 8276, -5659, -1102, 
    -126, -12260, 3869, 8726, -2233, 4435, 1899, 3919, 342, -2287, 89, 9457, 7314, -12505, -9787, 9945, 
    -2796, 1649, -1404, -714, -5379, 1017, -5932, 244, -680, -2299, 502, -2602, -1760, 1285, 4358, -9225, 
    403, 1656, 4428, 6948, -5675, 2220, -2466, 6259, 300, 3112, -3165, 4255, -12286, -7655, -1615, 5789, 
    -909, 2002, 3418, 167, 2609, -3405, -891, 1326, -4021, -1688, -1109, -1267, -741, -4976, -706, -4673, 
    1936, 3678, 4262, -269, -1352, -944, 2473, -1427, -5876, 525, 867, 9043, 3625, -2637, 5085, -378, 
    -1644, 7951, 5238, 318, 644, -3404, 1764, 896, 7282, 1348, 7095, -9701, 1169, -2885, -3751, -2703, 
    -1203, -2346, -3090, -6286, -4122, -2501, -2408, 3146, -1105, 11457, -2191, 4875, 7102, -1005, 2090, -4700, 
    -343, 1332, -5049, 8830, -1002, 2269, -2298, 6957, -1367, -543, 4728, 622, 1133, -13807, 3301, -1883, 
    -9578, 1539, -1551, -4560, -1645, -124, -2081, -8808, 3556, 8951, 6970, -4255, 890, -2608, -12023, -6661, 
    -1686, -5038, 11121, -17599, -1767, 589, -472, -3502, -2640, 9729, 60, -15577, -7086, 12844, 12908, 2205, 
    3697, 2204, -3579, -5433, -7319, -3530, -14542, 2241, -1956, 985, 1491, -1864, -9732, -1663, -3110, 2202, 
    -5838, 149, -1210, 2620, -2000, -5488, -9825, 8083, -2892, -1950, -6115, 6530, 8030, -12888, -8026, -6439, 
    -5315, 459, -302, 8903, -1680, -4734, 1210, 18082, 4576, -4134, 1776, -360, 4829, -6027, 8576, 19892, 
    -2630, 2233, 5371, -1734, 2322, -4761, 209, -2807, 580, -1653, -1695, -170, -5399, -354, 3005, -1759, 
    4036, 3113, 5336, 5929, -3393, -61, -6704, 4594, 3060, -1245, 6196, -2306, 680, -478, -3810, 3678, 
    -3035, -400, 3564, -381, 5458, -4547, 2203, 364, -78, 7351, 3315, 1389, 3580, -3083, -33, -546, 
    -4557, -6221, -1530, -10586, 1859, 684, -9821, 3661, 1522, -1189, -3566, 4901, -6583, 604, -1478, -4093, 
    13570, 3242, 5186, 21654, -966, 2041, -2113, -2127, -129, 7728, -3663, -1968, -8320, -4735, -11830, 5678, 
    324, -14771, -256, 13700, -324, -1604, -1592, -1082, 426, -8502, 564, -2000, 340, -7009, -3979, -1694, 
    1772, 489, 7068, -962, 1279, 202, -6855, -2140, 2125, 1486, 4837, 2896, 4869, 4470, 1477, 4134, 
    873, -3185, 5594, 2641, -9152, -1046, -7382, 3096, 2907, -219, 4933, -4322, 2101, 12090, 10017, -4782, 
    -2109, -10, -528, 780, 688, 1554, 1398, -3960, -1585, 1346, -2542, -2341, -8192, 9221, -907, -2513, 
    -2472, -2021, -1746, 1461, 4678, -1199, -110, -6519, 1824, 2667, 1743, -3961, 4855, -960, -1872, -661, 
    -1802, 7326, 4910, 2238, -2550, -7529, -1705, 4330, 2476, -2990, -451, 812, 5048, 3648, 2719, 2385, 
    857, 1573, -3752, -8398, 2740, -4390, 220, 14067, 7597, -1636, 638, -6641, 7937, -9176, 3101, -5738, 
    1627, 5973, 3803, 3289, -3413, 1225, 3921, 9778, 460, -9122, -4714, -7479, 5314, -2299, -6663, -1550, 
    1947, -23703, -520, -13654, 3582, -1947, -1942, -11262, 7935, -780, -10058, 9985, -1988, 290, 1945, 7495, 
    -7408, 13959, 6329, 9060, -849, 2785, 2419, 3470, -520, -8156, -1835, 4533, 421, -9593, -11976, -1685, 
    3519, -399, 1009, -4448, -3042, -2773, 4385, -3088, -4543, -56, -2746, 7335, 8362, -7583, 7778, -13434, 
    -1434, -2411, -173, 3833, -14761, 887, -2631, 9977, -2541, 6284, 2369, -5565, 4087, -1096, -125, 18427, 
    -8704, -1535, 1122, 5213, 3487, 8144, -4692, 4098, -1966, 8614, -1794, -10215, -5353, -12417, 1960, 32145, 
    11170, -3520, 862, -2649, -12157, 361, -13594, 4558, 7762, -4503, -7505, -262, 8150, -12052, 8923, -6968, 
    -2556, 15612, 1845, 4979, -3060, -17110, -5327, -7775, -6464, 1697, -12786, -2329, 698, 3608, -4617, 6666, 
    1833, -4039, -9982, -3141, 368, 9576, 6602, 614, 18148, -3078, 2257, -2578, 9276, -13562, 3424, -1419, 
    -12531, 2774, 4146, 15510, -18673, 4848, 7878, 15677, -4020, -7419, 268, 7993, 15631, -8682, -8652, 4592, 
    -26487, -7487, 10220, -27262, 9073, -910, -2468, -11221, 824, 12535, -2736, -7595, -17427, -11899, -12854, 1664, 
    -6817, 13965, -9812, -30887, -2471, 2802, 1159, -2928, 10896, -1150, -10732, -31368, 5345, 20890, -3522, 1228, 
    10218, 6304, 10021, -6008, -9158, 697, -23774, -1498, -817, 1208, -3020, -3992, -10521, -12542, -20119, -2428, 
    -339, -7134, 7803, 2574, 9069, -9937, -3057, 3598, 3063, 9997, 6144, 15991, 9545, -32767, -5084, -17331, 
    -10559, 4819, -977, 5669, -6580, 5878, 2398, 15341, -6789, 336, -7698, 5431, 24590, -7868, 17095, -4753, 
    4005, 2352, -4087, -3129, 1462, 2656, -1614, 5643, -817, 1108, -4826, -2314, 4698, -7549, 7041, -4067, 
    593, 3943, 3985, -1097, 1340, -2125, 1862, 2088, -7402, -4709, -8209, -839, 5985, -1306, -397, 3449, 
    -957, 488, -1880, -1569, -459, 5053, 555, -1782, 1759, -5094, -2716, 3378, -259, -8714, -240, 6958, 
    12538, -1443, 2383, -5368, -7795, 344, -7354, 6596, 622, 2813, -1791, 540, -12246, 702, -3051, -10034, 
    3573, 19238, 1622, 5483, 262, 3150, -2184, -5271, -127, 27263, 14522, 4174, -957, 4315, -11860, 13742, 
    54, 3084, -9137, 5011, -2026, 116, -1202, -3930, 4301, 6138, -15042, -9164, -8556, -8775, 5483, 12393, 
    3456, 3242, 8560, -1334, -9310, -371, 490, 1338, -523, 1288, -485, -2974, -4805, 456, -6853, 7191, 
    2645, -4092, 1444, 954, -13731, -2274, -4443, -6040, -1373, -2083, 1716, 2318, -6261, -7664, -16190, -21489, 
    -5529, 3892, 1902, -770, -693, 12204, 170, -8164, 2650, 3977, -214, 3467, 18178, 368, -4724, -23338, 
    -2992, 427, -4905, -645, 2240, 1979, 6274, -564, -6685, 2568, -5579, 2871, -1254, 192, -2683, 1861, 
    1813, 308, -1372, 1592, 1305, -479, -3220, 4298, 2249, 901, -378, 5627, -1874, 1396, 386, 1068, 
    -1767, 3829, -142, -4161, -3118, 584, 2539, 4559, -4326, -1407, -268, -4605, 1740, -4297, 2444, -593, 
    247, 11005, -8313, -5691, 2424, -1358, 4337, 3025, -4065, -299, -1889, 2537, -9761, -1047, -4420, -4753, 
    3641, -671, 2125, 674, -4859, 568, 5647, -6733, -5085, -8771, 3496, -2690, -10692, 5078, -10453, 747, 
    5105, 8351, 2251, 695, -95, -2360, -3367, 2778, -2635, -2846, -2130, 6183, 3377, -1613, -115, -3993, 
    425, 1812, -943, 1687, -7967, -1193, -6316, -5526, 3609, 266, 686, 330, -5210, 702, -10588, 15865, 
    -614, -2116, -2287, -1198, -2224, 2215, -8886, 9884, 4260, -1309, -1213, 3485, 1770, -1160, 5711, -7320, 
    -1473, 4324, -635, -1224, -2227, 4428, -1196, 2168, 768, -2557, -231, 937, 5118, 13739, 2272, -4301, 
    -923, -1036, 3059, -2939, 5692, -199, -6438, -3129, 8411, -7978, 394, -8268, -7744, -4990, -6097, -3190, 
    -1074, 1147, -4878, 6121, 2683, -5076, 4934, 478, 1738, 5844, 360, 13788, -5504, -409, -229, -1266, 
    -1404, 1975, 1321, 609, 6690, -2168, -1415, 834, -2821, -9577, 1508, 6050, 2546, -2422, 3668, 5438, 
    10244, -4750, 844, -6242, -2348, -3872, 7022, 6831, 5013, -6254, 5213, -4180, -16764, 7206, -15561, -113, 
    11130, 7015, -1493, 7456, 1002, -1057, 4790, -8292, 1403, 3849, 5535, -1380, -3194, 1481, -4929, 13214, 
    1560, -11464, -11194, 4284, 1222, -2807, -1470, -1566, 3895, -13929, -4937, -11333, 6561, -8575, -10787, 8791, 
    -4128, 8301, -3079, 5655, -6528, 4531, -2864, 3018, 6472, 5053, 1615, -1720, 12657, -3090, 8373, -11077, 
    -6473, -1361, 3041, -2704, -4908, -1550, -2135, 3879, 2621, 3661, -2550, 1113, -9286, 13767, 19063, 14260, 
    -2439, 9360, -1120, -3303, 987, 5568, -3979, -284, -3489, 7040, 2526, -2565, 3294, -25212, -5206, -14614, 
    1585, 1914, 331, 3153, 3189, -820, 6806, -1009, -5006, -185, 5154, -2469, -210, -1479, -3227, 3342, 
    180, -2319, -3387, -2038, 4654, -2011, 3066, 554, 1211, -5990, -3682, 7026, 622, -1064, 243, -5044, 
    1196, -2664, -1702, -1055, -3029, 1913, 1460, -743, -7445, -3973, -6717, 3635, 2125, 805, 1009, -972, 
    -7722, 11244, -1979, 1445, 3277, -1888, 823, 2241, -4645, -518, 131, -4139, -2491, -2312, -1103, -127, 
    4854, -594, -2612, 8269, -5882, 2035, 4620, -3331, 1051, 7891, -7779, 11518, 1401, -1680, 540, -161, 
    -2010, 15034, 3374, 7795, 1250, -1537, 1835, -1956, 2241, -2937, 975, 9892, -6006, 11962, -4931, -13862, 
    -667, 2579, -2896, 174, -2871, 812, -5091, -3220, -2822, -860, -1562, 1483, 871, -5627, -1501, -6014, 
    1820, 3318, -654, 1435, 64, -32, -6289, 2882, 1183, 3557, -128, -1525, -247, -588, -1005, 4448, 
    2719, 3438, 3565, -2954, 7212, 2861, -670, -3390, 1670, -1736, -267, 2999, -2607, -19065, 4424, 6916, 
};

static const int16_t pl3x2_paramModel1Alpha[12] = {
    7673, 1158, 7017, 62, 5671, -3463, 6622, -22, -1509, -618, 4425, -551, 
};

static const int16_t pl3x2_paramModel2Bias[12] = {
    8642, 5366, -4461, 9422, -5690, -795, 6954, -875, -1183, 1713, -4960, -7084, 
};

static const int16_t pl3x2_paramModel2Weights[1296] = {
    202, -2805, -1245, -1606, 4115, -1559, 1689, 1765, -286, -3713, 3056, 871, 1471, 1341, -1086, 898, 
    -5354, -6761, -333, -4920, 1810, 1661, 148, 1601, -9657, -1522, -1615, 786, -2177, 2242, 617, -5209, 
    -420, 1781, 2348, -1382, 285, -11282, -484, 1596, -2195, 7225, -140, -1830, -808, 2538, -1178, -747, 
    -163, 1065, 5192, 314, -453, -619, 1986, -562, -1831, 967, -1708, -841, -468, -817, 4065, 576, 
    3637, 305, 4986, 1778, 437, 1869, -1611, -4398, 2416, -2518, -1464, -988, 589, 2052, -102, 512, 
    -3320, -6996, 3727, -1138, 159, 280, 120, -1237, 1387, -1689, -13, 2385, 1002, 2185, 896, -169, 
    1085, -982, 1757, 403, -2327, -339, -1425, 1732, 3898, -1039, -1689, 1509, -2155, -1784, 3011, 576, 
    4080, -3925, -3376, -804, -2185, -3163, -4682, 4736, 4662, 5264, 2497, -5340, -4599, 2068, -7846, -3520, 
    -134, 829, -559, 1807, -232, 3595, 1206, -565, -1562, -1444, 2274, -1822, -746, -1582, 441, 1096, 
    6593, 3622, -885, -641, -6138, 2372, -2601, -2145, -1358, 1838, -1, -1891, 340, 1502, -4513, 2938, 
    2498, -8453, 655, -1613, -346, 3969, -14188, -922, 4789, -1175, -2700, -5857, -6978, -789, -2511, 3165, 
    -2941, 20478, 5789, 2128, 2320, -19221, 3682, -2314, 5902, 7731, 2086, 971, -2964, 769, 88, 3706, 
    1921, -3584, 937, -3761, 336, 708, 2191, -653, -3894, -527, -2033, -2191, -1380, 610, -2274, 225, 
    -7004, 850, 834, -5007, -947, 4695, -1803, -4682, 2441, 1919, -7257, 4459, 1128, -2935, 1067, 4923, 
    5414, -5221, 1883, -1988, 1448, 6988, -370, -1039, -10086, -2311, 2185, 2452, 693, -10171, -288, -206, 
    -605, -2700, 1932, -1169, 7231, -307, -2885, -4063, 863, -1552, -1494, -6299, -741, -717, -26, 1530, 
    337, 3819, 328, -1315, -9192, 432, 10726, -6817, 2407, 4763, 3760, 4712, -4497, 729, -10120, -881, 
    -854, 1531, 1305, -1360, -890, 3194, -2301, 127, 1689, 205, -2251, 297, -399, 5399, -345, 511, 
    -4160, 1690, 8356, -1380, -157, -3500, 2092, -327, 1514, 4680, -3203, 725, -1688, 2390, -5909, 987, 
    -24, 825, -479, -658, 568, -3361, 5704, -5703, 2046, -2495, 5752, -1598, -609, 4885, 1276, -5055, 
    789, 3398, -4000, -3495, -5267, -3038, -1807, 86, -730, -3920, -234, -1898, 7463, -990, -801, -2799, 
    -3590, -1913, 1452, 633, -1202, -1654, -785, -834, 2030, -3607, -269, 817, 257, -459, 596, -1934, 
    -3219, -2028, -4890, 4420, -365, 4963, 2433, -5760, 3048, -266, -2126, 2242, -3213, 2763, -2799, 1387, 
    -267, 1707, -1536, 2531, -1283, -705, 188, -943, -3947, 3422, -2473, -1137, -2325, 521, 685, 505, 
    -199, 2772, -610, -1427, -1870, 1883, 129, -1808, 1407, 1072, 1048, 2544, -52, 277, 1768, 1730, 
    -975, 410, -2913, -3381, 3242, -1750, -28, 4194, -7288, 4282, 357, -2223, 1216, 1797, -3007, -3228, 
    -1291, -1063, -1867, -701, 229, 2454, -872, -766, 17538, 863, 1279, -5771, -3104, -477, 792, -332, 
    -3307, 202, -2780, 7958, 8577, -7731, -5430, -2193, -2500, 10415, 855, -6177, -3581, -2524, 3458, 1519, 
    13229, 1415, -271, 6254, 7772, -946, -1034, 2446, -2510, 5473, 1868, 10046, -6501, 1328, -494, -424, 
    6448, 1627, 252, 445, 1748, -6968, -905, 3215, -4682, -12782, -842, 1433, -448, -6561, 1994, -6362, 
    3326, -636, -2133, 4645, -904, 1191, -4122, 351, -208, -4158, 901, 722, 3347, -3964, 1396, -957, 
    1352, 4784, -2037, -6526, 2525, -2986, -8622, -431, 887, 3204, 5294, 1437, 2594, 1217, -291, -4179, 
    -3104, 3432, 1150, -2886, 349, 537, 1485, -3848, 1124, 3322, -4498, 789, 134, -2360, -1396, -2359, 
    1031, -1634, -475, -1106, -2114, 1408, -536, -843, 2750, 10223, 2166, -3076, -385, -1306, -4089, -770, 
    2888, -506, -2359, 103, 417, -347, -213, -1236, 35, 1919, 1016, -3464, 3066, -5524, -3372, 4109, 
    -1571, -6694, -540, -1249, -2420, -2513, 793, 1159, -3185, -2113, -2778, 3058, 906, 4836, -1743, 846, 
    -723, 8534, -7406, -9793, -3243, 573, -6763, 2799, -28, -4504, 3241, 12220, 2395, -3169, 22750, -6643, 
    380, 7650, 11705, -5838, -7815, 5304, -756, 394, 14576, 5552, -3140, -2657, 6423, -8624, -4241, 10197, 
    -1614, -7326, -17906, 4208, 5570, 3146, 3804, 1156, 5212, -14404, -9213, -2432, -7400, -10932, -2206, -15975, 
    -2498, 2050, -442, 3457, -3448, 568, -3393, -1935, -311, 157, 4661, 9346, -3359, -8395, -8288, -327, 
    -7119, 2880, 1672, -2043, 2612, -3605, -5866, 5160, -2789, 4808, -734, -8595, -7986, 1025, -169, -486, 
    2497, 408, -4706, 4292, -1967, -8161, -601, 46, 11120, -2107, 4274, 1275, -795, 8654, 1557, 5940, 
    -2936, -1257, -6565, -2567, -330, -2094, -1843, -653, -4790, 6207, 2742, -1425, -2966, -131, -6427, -1416, 
    1420, 4551, -6108, 7189, -6215, -1045, -3218, -3576, -7643, -13399, -5652, 6289, 917, -298, -1551, 484, 
    1214, 1882, 1358, -1909, -3512, 12369, 1936, -4074, -19007, -1599, 4424, 4413, 2095, -3386, -2140, 2943, 
    7689, -378, -1709, -1343, -2632, 9869, 4542, 2316, 4006, -6752, -2198, -1064, 2794, -3903, -7139, -1064, 
    1662, -6763, -3937, 8237, -13, 1523, 6003, 3104, -3219, 5295, -7482, -1126, 2835, -6216, -1361, 366, 
    -13656, -1718, 9732, 2674, -262, 3161, 1441, -2472, 1771, -5564, 5560, 6130, -1387, -1885, 64, 9066, 
    3290, -1541, 129, -850, -514, 1407, 340, -538, -868, 2757, -2799, -4001, -421, -2032, -1706, 28, 
    14438, -2049, 1145, 4838, 1681, -5915, 1880, -894, -6885, -410, 4252, -971, -4746, 589, 3357, 1646, 
    4059, 3843, -158, 41, -23, 972, -1212, -519, 4436, -3923, 1029, -1564, 3506, 1655, -2730, 3308, 
    -225, -1013, 2888, -116, 149, -6985, -1121, -3548, 2302, -4210, 4689, 4388, -4009, -990, -2881, -832, 
    -11295, -407, -3270, 1055, -6260, 1547, -2137, 6361, -641, -2315, 1476, 620, 5373, -1211, 1218, -4392, 
    1624, -994, -174, -3246, 1734, -4545, -5122, 259, 1574, -1142, -3729, 998, 5706, -469, -334, -178, 
    -2444, -2571, -3222, -3222, -281, 188, 5908, 700, 1592, -1630, -3163, 1181, 3041, -3275, 1556, -658, 
    5931, 5585, 2208, 7921, 3913, -4876, -704, 3592, -3903, -2578, -3561, -4393, 9360, 4289, 165, -1645, 
    -3207, -1980, -932, -259, -5859, 5197, 1524, -213, -806, 4041, 1718, 700, -811, 3837, 2159, 1605, 
    156, 4719, -3869, -67, 1034, -732, 135, -461, 2613, 4016, 815, 646, 431, 3531, 2012, -59, 
    -2613, 405, -5048, 7380, -1535, -4124, -450, 1655, -4211, -1212, -1725, 1370, -1305, -1641, 382, -5635, 
    3251, -546, 272, 1861, 936, -1046, 690, 308, -706, 1388, 1118, -849, 1242, 311, -198, -1012, 
    -987, -77, 206, 1188, 332, -78, 106, 776, 6344, -3457, -7059, -902, -3272, -467, 1896, -941, 
    1085, -1332, 724, 559, -2061, 942, 382, -1476, -2456, -5671, -5064, 52, -2092, 2191, -2396, 757, 
    -2096, 2743, 1981, -1095, 3109, -5554, 92, -564, 7113, 3654, 4274, -3347, -2163, -2196, 1191, 856, 
    -3193, -10281, -5490, 8173, 1802, -3181, 1571, -3116, 1231, -3566, -588, -4616, -452, -8926, 3806, 2200, 
    -12443, -155, 639, -16036, -14940, -799, 4366, -10092, 2025, -5009, 5474, 4549, 6240, 3946, 2063, -3822, 
    11917, -13451, 2531, 1237, 3804, 10425, 159, 438, -1468, 11186, -882, -2972, 623, -199, 3030, 11162, 
    -3761, -2338, 3149, -6958, -2058, -2222, -1743, -1376, -103, -3865, 2187, -3037, -285, 3451, 4739, -1682, 
    2076, -7818, -1457, -3396, -116, -3471, 2377, 1770, 8714, -5016, 107, 839, 3249, 777, 811, 1683, 
    -7704, 6476, 4274, -3048, -852, 367, 417, 493, -4960, 2886, 1734, -3121, -2647, 1490, -1136, 2843, 
    3954, -3828, -6188, -2077, -850, 1537, -2872, 282, -3573, -3841, -3755, -999, -3194, -5072, -3271, -1404, 
    -4998, 1, 8491, -4094, 185, 1014, 1561, 3877, -1747, -3044, -1054, -836, 827, 1426, -2153, 515, 
    2320, 1645, -1802, -351, -1437, -1946, 376, 1694, 742, 283, -427, 1086, -798, -1321, -1059, 450, 
    -598, 2037, 4884, 577, -40, 1193, 1855, 1628, -4619, 3435, 2520, -1423, -3449, 8138, -4237, 2960, 
    -6901, 6560, -9992, 7480, 2998, -1673, -889, -495, -5008, -2721, 4415, -2869, -556, -735, 4574, 4748, 
    2854, -3078, 2436, 116, -439, 8318, 1213, -858, -3342, 7555, 1558, 88, 3570, 8683, 591, -562, 
    2307, 1675, -863, 2041, -1128, -1934, -130, -918, 2675, 3526, -876, -834, -2260, 2891, 2752, -538, 
    -2463, 5080, 4021, -740, -4656, -1966, 1838, -392, -4184, -117, 2366, -821, -700, -197, 3213, 3452, 
    157, -2579, -6715, -148, 1232, -195, -220, -943, 1234, -1392, -2650, 1387, -1594, 202, -801, 4069, 
    -2178, 4090, -1304, 924, -859, -1306, 2599, -1742, -10319, -2256, 5698, 1437, 2204, 684, -2285, -537, 
    -896, -2135, 1983, -2221, -2135, -418, -727, -284, 7408, 1708, 1192, 3685, 4606, -5581, 1215, -393, 
    -594, 232, 1457, -1655, -704, -10739, -949, -3349, -6944, 369, -718, 2433, -1039, 1084, -1460, -1356, 
};

static const int16_t pl3x2_paramModel2Alpha[12] = {
    2150, 2467, -166, 3915, 372, 557, 868, 1383, -2938, -2870, 5860, 868, 
};

static const int16_t pl3x2_paramModel3Bias[12] = {
    -421, 5441, -24620, -9248, 12030, 2813, -3243, 3852, -1012, -7421, 2007, 7140, 
};

static const int16_t pl3x2_paramModel3Weights[1296] = {
    -716, -1289, 4331, 623, -3604, 2162, 4437, -2827, -2025, 50, -1467, 966, -218, 1009, 2625, 2173, 
    4457, -4023, -1235, 5249, -6137, -1326, 3848, -2618, 739, 59, 3894, -688, 4121, 2820, -3161, -930, 
    -4647, 4094, 2529, -1256, 7, -1627, 1600, -9114, -617, -31, 3684, -1321, 987, -2760, 3442, 726, 
    -620, -847, -556, -1464, -2172, 338, 2290, -1193, 962, 124, -2143, 1015, 44, -293, 313, 525, 
    -4494, -882, 2974, 1371, 695, -496, 1524, -1018, -6253, 141, 1066, -860, 1651, 181, -565, 1889, 
    -518, 878, 1907, -227, 1214, 657, -4125, -1578, -4174, 1050, -1800, -5062, 1204, 587, -827, 547, 
    1262, -661, -222, -622, -939, -433, -739, -284, -1149, -1204, -571, -2257, -2163, 1410, 5470, -234, 
    -2421, -822, 2868, -4684, -564, -220, -1972, 358, 1529, -12, 4815, 1914, 1668, -1371, 3245, -63, 
    -1077, -1561, -6266, -3580, 372, 90, -1358, 357, 920, 4409, 9127, -398, -1778, 3012, 606, -3156, 
    -319, -1049, -6603, -2506, 1565, -2031, -8205, 1945, -3208, 248, -142, -248, 3447, -280, -1732, -237, 
    720, -6507, -12384, 4764, 112, 2534, 1997, 3358, -902, -507, 240, 1566, -5596, 856, -5619, -2184, 
    338, 6763, 2222, 275, -3138, -945, 7081, 969, -1911, -2494, -1044, -425, 1079, 458, 5387, 1302, 
    -1250, -746, -2998, -234, -2464, -1083, -1610, -1841, -1679, 71, 3293, -2967, -3811, 827, -3322, 1110, 
    307, 1642, 4311, -2314, 480, -2646, 3428, 908, -3309, 1431, -4255, 456, -1853, 148, -2233, 1476, 
    -426, 463, 592, 1465, -163, -843, 1338, 1934, -1630, -594, 4014, -6345, 149, -3136, -2518, -634, 
    460, 1185, -444, 519, -109, 24, 1699, 205, -1236, 1763, 7220, 563, 2220, -497, -1371, -724, 
    1281, -390, 3730, -2975, 764, -42, -1716, -392, 341, -511, 342, -6703, 907, -4602, 16136, 240, 
    -695, 240, -4370, -1187, 706, -352, -2627, -836, 2343, -789, -5150, -1246, -889, -2085, 3279, 2682, 
    162, 2263, -648, -526, 211, 1944, -1200, 2015, 479, 186, -1128, -1169, -1210, -2414, 2028, 1110, 
    -1978, 2569, -1377, 47, 3506, 804, 4993, 1347, -306, -930, -436, -548, 190, 2229, -1487, 304, 
    -4781, -4338, 8010, -5585, 2080, 481, -5014, 1513, -1708, -1117, 1148, 2549, 419, 2580, -355, -1744, 
    239, -369, 264, -2270, 272, 807, -659, -79, -68, -547, 3837, -2474, 1772, -675, -503, -27, 
    498, 442, 2019, 471, 712, 1582, 4652, -2008, -553, -621, 2289, 64, -1143, 711, 4248, -3160, 
    433, -386, 422, -1267, 1206, 1132, 5806, 2143, -3657, -2373, -476, 2042, -1771, 2938, 2027, 2086, 
    -299, 743, 790, 434, -1701, -85, -20, 649, 2439, 314, 1184, 156, -2051, -936, 353, 1914, 
    -28, -2120, 3855, -2748, -666, 555, 1381, -1512, -266, -4616, -492, 1870, 435, -981, -7340, 170, 
    -1146, 175, -6092, -613, 1443, 703, -3891, -886, 2164, -2514, 1828, -4732, 1271, -958, 1077, 216, 
    4741, -700, -4602, -4251, 1786, 126, -4258, -1982, -1395, -343, -2698, 1335, -6680, -203, 4750, 4364, 
    1429, 2592, -1780, 961, 787, -3429, -2933, -3994, -3394, 24, -266, -1626, -1482, -2270, -120, -1185, 
    1920, 4820, 2156, 995, -2107, 220, -5896, 161, 1555, -1550, -1355, -2311, 199, -3947, -5676, 1687, 
    -2124, -1095, 254, -2051, -1287, -1114, 3255, 636, -1595, -207, 2064, 231, 627, -1263, -153, 514, 
    -899, 284, -410, -187, 678, -4667, -647, 958, 1116, -1313, -10, 1802, -300, -340, 7954, -109, 
    3212, 2349, 2240, 1199, 551, -1612, -6579, -5873, 1629, 4239, -8307, -889, 2562, -1279, -3774, -1081, 
    2077, -1569, -1320, 1063, -1184, -909, 440, 484, 2605, 2842, 1374, -2434, 3472, 53, -1600, 19, 
    -3746, -3040, 1114, -4417, -1382, -1893, -2680, 187, 568, -278, -2068, -8797, -2012, 1832, 491, 280, 
    1176, 459, 6774, -2421, 1278, 356, -773, 188, 515, 4423, 228, -1985, 4008, -1437, 2308, 829, 
    -3954, -1441, -854, 1096, 1694, -4255, 2437, -47, -3605, -951, -5136, -1303, 4149, 7860, 2035, 4603, 
    129, -4152, 4155, -2102, -859, 2061, -3341, -2952, -718, 823, -2750, 1078, -219, -5663, 6917, 558, 
    -1985, -5391, -5177, -2228, 3211, 1970, 3326, 1687, 457, -2846, -3457, 925, 1842, -4456, 9533, 2885, 
    833, -1580, -3274, 366, 1809, -921, 747, -2186, 780, -256, -2668, -1728, -1476, -1871, 132, -517, 
    1662, -533, 6165, 38, -436, -3132, -5358, 674, -681, -1489, 5706, -795, -2549, 571, 405, -1746, 
    -3284, -1196, -698, -2482, 1256, -593, -6509, -585, 1372, -2407, -1570, 4206, 356, -1452, 762, -1711, 
    -445, -942, 622, 283, -553, -483, 1407, 16, -4372, -2207, -13037, 8875, -1249, 2271, -8113, 563, 
    -1462, -457, 807, -2373, 159, -49, -5254, -471, -1985, 744, -3778, 2853, -975, -1863, 11029, 1076, 
    -2143, -723, -2974, -4010, 687, -347, 631, -1671, 3598, -13185, -7112, -2709, 2307, -977, -2789, 1676, 
    -217, 158, 5646, 1543, 305, -798, 2737, 5418, -999, -390, -3885, -1627, -69, -1927, 699, -9400, 
    1683, 3428, -159, -5327, 195, -264, 4569, -850, -515, -2065, 7473, 1930, -1850, 2992, -3898, 2853, 
    7778, -7555, 6336, 2471, 918, -644, -1035, 4104, 743, -706, 2785, 1194, 1016, 11804, 5797, -1902, 
    -193, 58, 959, 2943, -928, 1465, 395, -1032, -1065, 673, -122, -1103, -1437, -757, 1241, -473, 
    160, -505, -2560, -217, -2200, -1970, 5224, -426, 661, 1621, 5827, 1871, 412, -2559, 901, 3331, 
    1610, 289, -5659, 775, -2714, -1500, 1945, 79, 74, 463, -851, -597, -2756, 2098, 52, -260, 
    545, -472, -1458, 263, -482, -726, 872, -989, -1352, -1663, -6526, -3262, 693, 114, 4656, 1729, 
    -1032, -1383, 2756, -3395, 202, -200, -3106, 2142, 2553, -254, -1117, 3999, -1627, 1955, -4363, -1742, 
    -396, -374, -5190, -930, -142, 502, -2601, -299, -5616, 1698, 841, -2253, 2043, -1477, -1052, 2099, 
    824, 616, -3877, -252, 2485, 357, -1956, -478, 2384, -26, 1830, 744, 7480, 1787, -3861, 28, 
    -1108, 3474, 4016, -5904, 2399, 816, 3089, 1682, 1864, 535, 1050, -488, 2400, 1925, 1303, 4335, 
    3477, 2859, 360, -5451, 932, 2233, -367, 1039, -721, -323, -284, -642, -177, 400, -11692, 7418, 
    1471, -1032, 1144, -756, -2177, -1856, 163, 901, 108, -538, -1839, -79, 222, -849, -205, -1064, 
    -3219, 192, -113, -1255, -845, -1068, 415, -2658, -577, -1080, -5771, 167, -843, -614, -3780, -2414, 
    -64, 377, 1202, -93, 1131, -1795, -6043, -3800, -1040, 544, 4633, 2402, -961, -570, 4384, -2573, 
    2047, -420, 505, -887, 503, -937, -164, -196, 2180, 262, -1161, 536, -2884, 1083, 930, -1659, 
    -1473, -115, -2762, -3655, -2012, -1786, 474, 714, -578, 581, -348, 422, -643, -2823, -2178, -1843, 
    -1005, 794, 5886, -2173, 1264, 286, -313, -534, -112, 124, 5486, 3533, -1995, 1976, 334, -1126, 
    -4368, 978, 8093, -517, -1170, 642, 3520, -515, -1524, -755, -1722, 478, -7802, -1172, 2419, 175, 
    -33, -94, 3074, -1212, 294, 994, -1983, 997, -74, -3394, -2081, 1747, 2022, 2933, 2648, 2045, 
    -2477, -1753, -1316, -2845, -2191, -282, 2578, 3830, -911, -2225, 529, 2381, -2970, -2124, -4204, 7486, 
    -1258, 247, 2946, 1503, 987, 415, 2771, -515, -407, -330, -2031, -118, 2398, -1162, 2979, -1051, 
    -308, -1433, -429, 1419, -375, 475, -6897, -879, -182, -797, 2408, -2275, 508, -148, -1657, -3332, 
    -3146, 2302, -1128, -825, 933, 2120, 8959, 3621, 1042, 291, 7706, 1912, -355, -2219, 5262, -988, 
    1410, -581, 572, 624, -324, -209, 2650, -404, 4442, 576, 5238, -609, 1797, -388, 1762, -568, 
    -4531, 156, 558, -685, -1262, -950, -3416, -95, 42, 1867, 363, 4109, -1054, 1049, -4835, 450, 
    -2876, 603, -521, -1504, -717, -205, 1548, -3028, -2887, 629, 1943, 2299, 648, -904, 20, -2822, 
    3132, -1738, -1647, 1211, -788, -1598, -2021, 1292, 63, -614, -701, -987, 2612, 226, -4629, -5025, 
    -1856, -1119, -3006, -678, -562, -1989, 2149, 2111, -288, -51, -443, -239, -283, -1082, -985, -3117, 
    1528, -2335, -5043, 3196, -1461, 1691, -2998, -4040, -1002, 375, -405, 1050, 587, -1189, -5439, -9979, 
    -328, 835, 1053, 1448, -1087, -364, -2054, 2434, -2424, 201, 1862, -1434, 937, -448, 2068, 931, 
    -2861, -1340, 318, -836, 11, 150, 4459, -1968, 1544, 323, -3156, 41, 982, -4450, -4936, -506, 
    -29, 475, 2677, 1943, 1805, 3827, 1377, 1203, -2804, 851, 3216, 1251, -1865, -2969, 317, 1433, 
    -40, 264, -271, -151, -1396, -368, 801, -42, -2174, -285, 3276, -420, -1816, 98, -2074, 1291, 
    -2210, -892, 1033, -2987, -1066, 161, -6699, 1506, -888, -1066, -1973, -775, 1836, -1820, -2795, 84, 
    -2542, 485, -3867, -1220, -1347, -1470, -164, -45, -1503, 2361, -1485, 7407, -616, -3093, -1897, -2051, 
};

static const int16_t pl3x2_paramModel3Alpha[12] = {
    2289, 3265, 236, -377, 508, 1613, 1313, 204, 2464, -94, 942, 1189, 
};

static const int16_t pl3x2_paramModel4Bias[12] = {
    1130, -7491, -5225, -5157, 1129, -5071, -804, -1101, 8989, -8320, 3365, -22582, 
};

static const int16_t pl3x2_paramModel4Weights[1296] = {
    1572, 319, -1269, 274, 1456, 663, -502, 547, 217, -1168, -502, -701, 1439, -1874, 890, -381, 
    40, -1120, -616, -968, -504, -2911, 1100, 277, -2775, 180, 1220, -979, -3250, 405, 1677, -3285, 
    -945, 1695, 462, -1173, -77, -643, -1752, 169, 44, -1819, -1157, -25, -2685, -2105, -582, -293, 
    -1503, 1500, -1650, -3490, -577, 198, 4061, -1840, 525, -171, -232, 130, 227, -1926, 825, -771, 
    710, -4241, -202, 2250, 4116, -3018, 1875, 747, 804, -213, 374, 429, 2226, -1697, -1076, 2102, 
    985, 3248, 1189, 3085, 695, 400, 5870, 655, -22, 335, -374, 639, -24, 1876, 2333, -1039, 
    -466, -238, 854, 1395, 362, -2011, -197, 1998, 330, 962, -853, -364, -2316, -521, 1102, -2919, 
    535, 1183, 631, 445, -60, 335, 694, -548, 1276, -703, 249, 1461, 915, 577, 1488, -657, 
    536, 1279, 544, -112, 401, 798, -980, 24, -66, 1166, -410, 115, -1842, 2344, -148, 1435, 
    1565, 1447, -1359, -1637, 3063, -1463, -2534, -165, 292, -749, 1249, -672, -2769, -2307, -633, -119, 
    -560, -1660, -1825, 368, 1227, 1040, -4517, -440, -127, -826, 473, 666, -2069, 975, -1087, -407, 
    -3241, 2659, 209, -2037, -1664, -2050, -28, -1089, 357, -4185, -1119, 1348, -3724, -903, -387, 1351, 
    1905, -305, -2351, 1717, 603, 80, 2543, 3909, -10, -237, -959, -167, -1782, -4471, 771, 110, 
    2057, 1457, 1118, 2817, -4694, -2356, -2144, -2204, 157, -356, -387, 602, -1256, -1150, 2440, -1956, 
    -302, -2702, -3367, 88, -660, 2191, -5847, 2277, -140, 216, 183, 279, -1363, 2599, -4618, 759, 
    534, 1491, -1789, -3974, 2260, -3818, 1394, -181, 551, -412, 217, 542, -2882, -189, -1402, -814, 
    -1334, -4, 1505, 3771, -1269, 683, -2265, 18, 463, -2359, -631, -421, 1767, -2651, 157, -1344, 
    975, 1030, -72, 2529, -2376, -1198, -2478, -72, 551, 640, -164, -177, -1169, 978, -1113, 874, 
    307, 508, 526, 724, 3219, -358, 648, 461, -1655, 1591, 170, -261, -915, -24, 715, 1, 
    1558, -140, 287, -3592, -2051, -718, 2526, -1165, -1331, 17, -846, -783, 788, -187, -2362, 1054, 
    2689, -2047, 747, -111, 605, 3273, 4521, 3206, 919, -4993, -1610, 2085, -615, 1105, 715, 1173, 
    1540, 650, 760, 151, -1971, -1434, -2773, -35, 504, 1026, -627, -164, -1581, -255, 2245, -858, 
    -5410, 2727, 2787, -1583, -4390, -1207, 2978, -8541, 210, 316, 196, 602, -338, -1849, -1872, 651, 
    2989, -5480, 2353, -913, 3639, -191, 841, 2573, -279, 207, 95, 364, -879, -1512, 565, 642, 
    -1066, -2259, -120, -763, -372, -1254, -761, 628, 347, -1000, -780, 175, -2409, 556, -121, 45, 
    1468, 334, -187, 1299, 506, -728, -3615, 1352, 558, 137, 594, 6, 728, 52, -937, -379, 
    -1405, -1818, -2131, -1428, -3196, -823, 185, -734, -163, 2146, 563, -183, 137, 1335, 760, -761, 
    175, 794, -954, -128, -340, -2880, -2922, 846, -1611, 343, -1452, 1257, -1311, 524, -2132, -603, 
    -828, -17, -85, -1234, -3722, 916, -6698, -357, 989, -4139, -155, 158, -1719, -2715, 3254, -744, 
    1362, 2801, 1795, 17, -1466, -5168, 486, 1313, 684, 3211, -6422, 47, 422, 2200, -1704, 1353, 
    -868, 1478, 50, -429, -2453, 3273, -228, 966, -190, -884, -302, -1125, -797, -2562, 672, -2681, 
    2449, -3251, 2161, 2414, 879, 1695, 72, 600, 973, 24, 924, 357, -11, -16, 130, 1358, 
    1728, 5822, 1788, -585, -1218, -15, -6610, -1412, 862, -264, 107, 865, 735, 1071, -3510, 19, 
    1614, -793, -332, 957, 1136, -2264, 1161, 228, -252, -669, -507, -1062, 46, 1055, -839, 214, 
    898, 56, -1193, 3803, -1699, -208, 734, -3051, 121, -990, -725, 279, -1259, 19, 1346, 404, 
    1259, 590, -1754, -293, 89, -1594, -1440, 810, -50, 852, -877, -249, -710, -708, 1415, 1249, 
    -3930, -703, -576, 1888, -3708, -2015, 873, 4602, -1627, 329, -2122, 1133, 6852, -535, 1107, 1266, 
    1, -8192, -347, -391, -4300, -7681, 4423, 3124, 3956, -6428, 2052, -172, -2607, 3630, -3544, -3897, 
    -10, 5714, -697, 2033, 1529, -456, 499, -4872, 778, -1503, -1099, 2540, -4273, 1622, 514, -3030, 
    1578, -329, -1263, -1196, 2888, -3236, -1717, -3927, -1130, -89, -1399, -1405, -1561, -1352, 572, -46, 
    -3713, 1879, -3039, -217, -2337, 6352, 611, -4957, -971, 312, -58, 1837, 1535, 819, -73, 591, 
    -772, -8095, -1320, -53, -2040, 3164, 4140, 888, 135, 1325, -1112, -328, -557, 2333, -1470, 1116, 
    -1505, -2869, -411, -1684, -6147, -1242, -2296, 242, -2015, -433, -870, -1317, -537, -1250, -480, -1432, 
    -2390, -3589, 4041, 3899, 1310, -578, -9067, -510, -416, -2736, -212, 384, 1464, -595, 956, -139, 
    -506, -1391, -1527, -2219, -8671, 781, 585, 4184, -119, -412, -462, -737, 686, 1929, 395, 1576, 
    -210, -2557, -1515, -1532, -7616, -3182, 3442, 1301, -385, -1123, 94, -171, -650, -1001, 726, 184, 
    -701, -191, -2530, 2903, 1823, 1912, 1442, 5607, -185, -2318, 1070, 494, -2082, 1425, -3894, -472, 
    -5584, 943, -3886, -1845, -1880, 3736, 1151, -1158, -635, -168, -215, 580, -4068, -1965, -848, 757, 
    -2069, 697, -2769, -1580, 957, -6949, -2261, -2187, -314, -27, -408, -400, -2992, -1265, 80, -872, 
    -739, -1595, 2070, -2999, 4422, -321, 4389, -2194, -162, -763, -223, 359, -1092, -3524, -1367, 2616, 
    -4307, -827, -1714, 419, -1896, 5292, 2863, -5404, 493, 1108, -539, 208, -481, -1341, -295, -507, 
    -701, -3140, 852, 148, 1369, -2765, -634, 542, -374, 982, 867, 21, -250, -1912, -1321, -364, 
    -273, 87, 178, -1635, -461, 317, -2550, 731, -1972, -3750, 123, 186, 1097, 177, -541, -972, 
    157, 1494, 2418, -1061, 2159, 1902, 330, 118, -808, 1159, -209, 1221, 270, 2498, -1360, -1234, 
    -536, -518, -1720, 35, -4007, -1351, 340, -722, -32, -1778, -339, 405, -121, 794, -64, -478, 
    -473, -673, 385, -828, 1180, 3688, 574, 1082, 686, -3052, 928, 290, -1709, 46, -2811, -2067, 
    -2126, 2677, -2035, -376, -1032, 5847, 2461, 495, -832, -668, -1296, -43, -8055, -858, -1538, 1232, 
    2835, -2009, 1387, -3620, 2914, 827, -700, 1264, 628, 587, -402, 391, -416, -736, 1459, -1849, 
    199, 4218, -98, 5390, 1164, 1995, -1962, 3041, 471, 1284, 1045, 375, -3997, -1082, -874, -5682, 
    -2220, -4690, -1039, -2519, -1535, -1762, -538, 196, -879, -61, -310, -22, -5176, -3708, -468, 2020, 
    -1222, -670, 703, 366, -797, 909, 161, -942, 793, 1045, 65, -816, 446, 93, -328, 747, 
    -1420, -1311, 1039, -397, -447, -2647, -879, -3892, 672, -181, 962, 762, -660, 437, -1956, 89, 
    1961, -503, -793, 157, 676, 370, 870, 191, -101, 1062, 578, -180, -586, -550, -1221, 229, 
    2348, 1987, 301, 2626, -808, 5, 1157, 3638, -260, 120, 1005, -675, -62, -1493, -140, -507, 
    995, -3319, 1300, -640, 2034, 303, 1082, -8957, -1191, -3677, 1398, 1024, 97, -1326, -3500, -2151, 
    396, 1161, 574, 796, 1590, -2055, 698, 7035, 1207, -2120, -934, 1980, -5483, 607, -933, 270, 
    -1810, -4497, 382, -443, 1704, 466, -355, -659, -1759, -924, -537, -929, -603, 412, 1388, -1705, 
    -626, 2981, -264, 661, 202, 2036, -3546, 1746, -696, 249, -2056, 2324, 965, -2227, 1443, -609, 
    -1947, 3423, 3372, 2360, 2139, 1422, 2211, 264, -1542, 1321, -320, -702, -19, 3275, 1824, -659, 
    1494, -1174, 1949, 84, -1078, -73, 675, -344, 330, 435, 297, 142, 358, -141, -513, -506, 
    -362, -1400, 2467, -1340, -1385, -176, -3583, -1797, 1071, -575, 142, 2633, 1344, 1333, -148, 1086, 
    -850, -2029, 778, 2306, -1259, 87, 284, 609, 390, 1167, -354, 1294, -775, 470, 1144, -1185, 
    1886, 412, -1654, 1010, -2888, 2956, -150, -1928, -362, -107, -357, 238, -68, 572, -1196, -120, 
    -566, -665, -1410, 1059, 1862, 1775, -9062, 8234, 755, -1408, -1758, 910, 1228, -331, -2245, 2445, 
    749, 2073, 2898, -507, 2093, -7741, -5078, -3370, 713, 537, -973, -60, -1244, 1851, -761, -1063, 
    -899, -10572, -2021, -2075, 2430, -2391, 244, -1052, -675, -790, -289, -390, 61, -1440, 735, -552, 
    -157, -2829, 1527, 5053, 760, 3686, 1435, 4832, 760, 82, -728, 1522, 177, 517, 1304, 2549, 
    -1011, 3521, -2213, 5156, 4536, 3533, -748, -1053, -1182, 690, -110, -132, -233, 1582, -24, -987, 
    -972, 982, 621, -162, -1231, -2143, 1665, -761, -855, 27, -397, -986, -1252, -1470, 130, -828, 
    -2192, -72, 2100, -2395, -27, -786, -662, -916, -193, -770, 1275, 1030, 26, 665, -610, -1102, 
    2590, -851, -1951, -34, -919, -439, -81, 485, 304, 342, -1391, 163, 1280, 584, 1415, 1388, 
};

static const int16_t pl3x2_paramModel4Alpha[12] = {
    2866, -25, 901, 862, 3607, 544, 666, 1066, 787, 871, 726, 75, 
};

static const int16_t pl3x2_paramModel5Bias[12] = {
    -8990, 16605, -32767, 13589, 3445, 1278, 10335, 1996, -8876, -7727, 1909, 10041, 
};

static const int16_t pl3x2_paramModel5Weights[1296] = {
    163, 561, 241, -1496, 1324, -2915, 1782, 2220, 923, -784, 771, 1704, -654, -859, 1102, 289, 
    -967, 456, 1617, 875, 2269, -2017, 7, 3278, 755, 2741, 666, -7028, 2359, -353, 215, 1704, 
    1729, -545, -568, -506, 236, -47, -357, -1243, 1157, -489, -567, -2249, 1546, -1437, -473, -221, 
    -164, 1041, -302, -2710, 64, -110, -513, -830, -2906, 29, 1636, -187, 603, 154, 101, -241, 
    371, -670, 283, -1717, 943, -558, 26, 394, 1693, -774, -241, -107, -1866, 616, -163, -1425, 
    -1316, 1125, 1095, 1941, -1907, -923, -126, -13, -1450, 302, -301, 1155, 1625, -800, -560, -36, 
    -448, -717, -611, 533, -1625, -376, 95, 111, 99, -2186, 1109, 5150, 712, -3608, -278, -2072, 
    924, 1670, 855, 2241, -2804, 81, -88, 65, -2520, -2349, -3305, 371, 1838, 525, -88, -2199, 
    139, -1727, -996, -362, -102, -1099, -525, -404, 695, 582, -1727, 5657, 2577, -893, -510, 848, 
    858, 506, -1654, 844, -466, -151, 298, -2080, -3068, -1409, -519, -841, -1230, -491, -1224, 1608, 
    3170, 192, 210, 141, 824, 393, -263, -2287, 2821, -468, 2677, -2949, 3187, 1333, 476, 92, 
    -2018, 243, 616, 1081, -757, -770, 484, -234, -2322, 759, 582, -1568, 797, -1705, -1165, -1573, 
    4017, 70, -257, 2141, 146, 424, -908, 404, 1237, -2860, -1393, -1726, -1362, -527, -1610, -523, 
    -1218, -421, -345, -433, -902, 1358, -448, 91, -963, -2947, 53, 32, -718, -242, 347, 240, 
    842, 1467, 1193, 1016, -867, 1520, 742, 1860, -86, 2008, -1487, -561, -189, 1410, 138, 204, 
    1693, 5672, 1243, -1707, -1115, 791, -2523, -1346, 6678, -8796, -2023, -11628, -835, 323, -170, -675, 
    -1120, 374, 600, -1719, -3711, -688, 653, -589, -1453, -929, 240, 3077, 2197, -107, 328, 1215, 
    284, 3035, 475, 2506, 820, -154, -1576, 5, -483, 6333, -5829, -2901, -1504, -1883, -812, -3320, 
    -655, 54, -300, -699, -220, 472, 384, 1547, -411, 2364, -381, 665, 2434, -1249, -1405, -2441, 
    -1025, -930, 2347, 589, 2364, 350, -488, 1123, 769, 932, 268, -3900, -1906, -825, 364, 2017, 
    34, -73, -933, 43, 1459, -1591, 692, 1, -863, 986, -33, 178, 875, -571, -83, -1420, 
    815, 322, -923, 104, 493, -2783, -657, 230, 2339, 1800, -2117, -15, 595, 362, 357, -760, 
    -585, -365, 173, 1528, 1042, 94, -832, 1241, -1502, -1713, -161, -621, -1031, -1132, -642, 1096, 
    2281, -570, -1392, -372, -270, -4, -38, -934, -1497, -686, -1210, -3231, 317, -469, -1005, -1857, 
    -1701, -6122, -953, 1609, 2281, -575, -212, -1157, -1101, 1580, 1701, 3027, 1150, -1009, -1071, -3552, 
    718, 2618, -1439, -965, -1466, 473, 666, -370, 1032, -6795, -1888, -602, -763, 156, 1628, -779, 
    1017, 760, -1199, -3103, -86, 859, 456, -305, -2906, -3228, -2134, -5324, 586, 2439, 6, 2106, 
    -1470, -436, 2030, -395, -1565, -1665, 284, -404, -6941, -102, -3170, -2979, 1743, -1851, -3374, -2133, 
    3640, -394, 137, 580, -2117, -729, 1250, -709, -3371, -2852, -1310, -4147, -209, -1365, -1088, -5440, 
    -1707, -1770, -473, -2048, 3347, -1429, -2608, 1805, -4504, 672, 87, -174, -123, -2175, 101, 382, 
    1221, 1547, 939, 1211, 956, -549, -163, -442, 1677, -474, -709, -287, -54, -1650, -1297, -478, 
    -318, -670, 735, -877, 379, -470, -455, -1388, -232, -669, 737, -2012, -480, 210, -1457, 1058, 
    1498, 903, -614, -937, 256, -474, 634, 809, -1526, 525, 1017, -1071, 1816, 532, -774, -642, 
    -3084, 461, 2013, 658, 2179, -1936, -1848, -1256, 1610, -6103, 2111, 2503, 3086, -2962, -1119, -2056, 
    1597, -1245, -193, -2540, 957, -502, -1097, 588, -1373, 1180, -1507, 2332, -3076, 584, 1374, -744, 
    1284, 1703, 110, 1334, 777, 691, 1066, 930, 1214, 1210, 1284, -1424, 633, 387, 1445, 328, 
    3601, 1558, -393, -175, 4408, 231, -1353, 648, 8592, -888, 3637, 1229, -2605, 3690, -2021, 565, 
    -4380, 857, 4887, 595, -1687, 639, 254, -1370, -1029, -61, -2191, -901, 1362, 2006, -1709, 1976, 
    -768, 2372, 2959, 2827, 4731, -263, -2461, -2922, 1572, 4274, 699, 1693, -1842, -3379, 807, -3797, 
    -9235, 97, -5048, -2327, 792, 318, 1091, -116, -2219, -667, -1676, -814, 8044, -184, -37, 1120, 
    1561, 1299, 2505, -770, 712, 168, -2986, 435, -627, -7309, 836, -2445, 245, -1147, -1476, -1235, 
    1250, 2370, -1871, 255, 2220, 1849, 314, 1612, -1661, 108, 195, -835, 1406, -1255, -2027, 2660, 
    -301, 1859, 5271, -1376, 4027, -703, -770, 250, 987, 5244, -1235, -1884, -3752, -2129, -1235, -4169, 
    800, 474, -479, 3775, -1356, 806, -2535, 669, 3635, -1614, -3323, 276, -541, 1541, 1636, -3159, 
    5064, -1471, 534, 142, 455, 153, -1050, -1701, -1569, -2811, -943, 1598, -2239, -3760, -281, -1292, 
    2481, -132, 1853, 609, -2432, 1208, -199, -562, 3096, 1017, 572, -1372, -7828, -2163, -5047, 582, 
    610, 108, 875, 1409, 1101, -712, -976, -2310, -1398, -1338, -1363, -213, 212, -2984, -1874, -2463, 
    1486, -995, -2090, 683, -947, -3707, 44, -1667, 3795, -1489, -511, -5456, -758, -811, 1267, 800, 
    1760, -571, 1853, 1003, -609, 59, -676, -1032, -821, 688, -3348, 40, 581, -122, -2561, -1156, 
    151, -292, -1514, -708, -1083, -456, -2130, -1708, -929, -576, -2086, 91, -881, -1288, -556, -632, 
    -281, 1300, 30, -850, 1647, 1004, 75, -2351, 1662, 2069, 2337, 823, -879, 1061, -438, 453, 
    7167, -2556, -552, -353, -2463, -993, -2359, -598, 3544, 787, -6161, -2774, -875, -1782, 28, -2847, 
    -1449, 923, 915, -303, -739, -889, -335, 431, -2788, 1417, 3, -4380, -822, -385, 426, -446, 
    6370, -1018, -3799, -1300, 111, -1729, -394, -2377, 842, 7890, 1500, 9919, -719, 1403, 135, 711, 
    3540, -18, -873, -1436, -464, -689, -537, 259, 1186, -489, -1401, -560, -3818, 85, -512, 1317, 
    595, 423, -1181, -265, -835, -493, -1084, -314, -1020, -265, -1278, -1272, 1778, -15, 822, 2306, 
    1795, -4054, -402, -2953, -100, 1657, -304, -1157, -680, 2330, 2043, 675, -196, -1043, 211, 1003, 
    1831, -2253, -2751, -371, -2290, -447, 895, 1428, 132, -776, -2380, 514, -733, -880, -875, 564, 
    -890, 259, -881, 1722, 1158, -43, -193, -421, -37, 1013, 657, -7011, 127, 319, -826, -280, 
    25, 3004, 37, 210, -799, -454, -252, 208, -1203, 170, 390, -776, 876, 479, -324, -1575, 
    2597, 1637, 1320, -524, 528, -701, 797, -424, -4335, 1235, 4468, -2218, 1508, -3539, -1504, -2218, 
    -1221, -1190, 1433, -5615, -138, -479, -278, 134, 1317, -884, 1957, -4203, 1345, -434, -1020, -4040, 
    3599, 544, 385, 2132, 117, -839, 252, 67, 706, 4316, 1494, -2534, 553, -455, -331, -965, 
    -92, -164, 1031, -53, 2900, 2276, -763, 566, 5409, -2708, -2994, 1625, 14111, -1997, -5062, -626, 
    1744, -829, -2153, 1240, 74, -1641, -1855, 868, 39, 1226, 1258, -3534, -850, 1922, 3189, 423, 
    -3389, -2020, 827, -2054, 2348, 2729, -940, -2728, 3757, 2420, -2669, 338, 3697, 348, -527, 3832, 
    -500, 968, 1792, 62, 4223, -2174, -2732, -1503, -1379, 1028, -1302, 496, 209, 439, 640, -1605, 
    909, -476, 770, 918, -321, 568, 357, -29, -422, -1367, 126, 1554, 648, -2215, -357, -1117, 
    1741, 1237, -1212, -1933, 301, -1355, -572, 2131, 757, -606, -364, -1519, -799, 24, -870, -1332, 
    -1708, -1978, -3070, 1983, 182, 292, -3117, 48, 1821, 2777, 3299, 2014, -790, -2602, -3155, -3481, 
    624, -1478, -1151, 2129, -137, 95, -2750, -2484, -2493, 606, 1446, -5955, 543, -1638, -1400, -1744, 
    153, 464, -435, 753, -77, -937, 122, 572, 4636, 4086, -1859, -3676, -2358, 359, 321, -1609, 
    733, -115, 3231, -543, -714, -1939, 824, -1108, -1562, 435, -43, -1143, -4101, -2036, -2759, 2473, 
    597, 408, -167, 558, 656, -1351, 2429, 783, -237, 37, 1891, -2068, -1801, -566, 967, -336, 
    1263, -358, -937, -41, -1594, 262, -36, -63, -7106, 1299, 598, -1219, -1879, -2520, 219, 101, 
    2550, -340, 2194, 133, 3130, 1278, 548, 441, 1340, 948, 51, -162, 1546, -747, -1400, 500, 
    -667, 1277, 1402, 778, 437, 187, 434, 1287, -2110, -244, -346, -1410, 479, -840, -652, 113, 
    3153, 2533, 464, 1147, 528, 1123, -1617, 16, 1663, -1075, 379, 1134, 1058, 28, -337, -695, 
    -168, 2770, 942, -758, -354, -634, 1112, 43, -918, -4718, 2220, -841, 2598, -1123, 427, -802, 
    408, 1095, -954, 687, -368, 55, -562, 423, -817, -1920, -4032, 3324, -601, -347, -2039, -1210, 
    -167, -123, -1447, -2298, 443, -29, -146, -221, 654, -5662, -2436, -1974, 2667, 2059, -197, 1282, 
};

static const int16_t pl3x2_paramModel5Alpha[12] = {
    4186, 19, 1070, -557, -364, 215, 449, 29, -1058, -1222, 1314, -1237, 
};

static const int16_t pl3x2_paramModel6Bias[12] = {
    21979, 4024, 13869, 12793, 12205, 9867, -1155, -7466, -14726, 8117, 8854, 16582, 
};

static const int16_t pl3x2_paramModel6Weights[1296] = {
    -49, -669, -97, 310, 485, -1970, 2165, -524, -2377, -5487, 1564, 964, -2709, -13410, 361, 2974, 
    -254, -57, 130, -48, -671, -1074, 4429, -6550, 4161, 5239, -2959, 138, -1816, 1765, 2251, -3505, 
    -69, -134, 447, -654, -12948, 824, 2223, 555, -10307, -1614, 7215, -2420, -2850, 2045, -2780, 998, 
    -151, 1134, -2937, -117, -1543, 557, -45, -4902, -988, 1950, -4613, -990, -1652, -1868, -1041, -2214, 
    -109, 180, -157, -260, 1844, -151, -1853, 506, -2615, -624, 201, -998, -369, -755, -1321, 963, 
    3043, 822, -2198, -625, 765, 1415, -3932, -887, 403, -113, 788, -211, 5670, -1816, 2711, -750, 
    498, -1237, 222, -385, 338, -4755, 472, -1410, 1952, -1915, 154, -82, -271, -2874, -2058, 584, 
    -420, -366, -7, 59, -14, -1010, -374, 316, -207, 1307, -1528, -271, 172, -9, 1191, -494, 
    -4096, -991, -2786, 638, -9014, -1220, -517, -1219, -416, -941, -916, 2429, -5172, 1012, -1110, -927, 
    -79, -1413, -228, 668, -2891, -3339, -490, 2113, 1773, 5039, 1720, 130, 2213, 2684, -1723, -2423, 
    418, -911, -919, -455, 860, -3775, 1870, -4397, -1430, 5917, -231, -903, 3639, -1595, -1285, 886, 
    -2281, -456, -449, -298, -11975, 3854, 777, -3076, 18980, 4114, 5393, 565, -92, -558, -1461, 81, 
    851, 1278, -1218, -1448, -1603, -43, -1084, 3654, -1330, -1131, -4016, 578, -3663, -6661, -9415, 52, 
    -60, -3366, 621, -718, 107, 2149, -3108, 3653, 53, -636, -23, -679, -661, -479, 583, -994, 
    -193, -275, -857, 364, -4373, -246, -1534, -24, 5857, -720, -619, 1065, 9925, 434, -341, -1691, 
    -844, -568, 257, -593, -1530, -3139, -370, 493, -1048, -5722, 1924, -2096, -713, -439, -1366, -504, 
    -82, -2226, -440, -939, -165, -1374, 417, -990, 681, -3682, 1223, -2256, -206, -1839, -2658, 1287, 
    -1732, -295, -277, 387, -5030, 1098, 939, -870, -1323, 1256, -1648, -1774, -11069, -416, -34, -1044, 
    -35, -201, 284, -803, -296, 2462, -1075, -538, 7280, -6894, 3585, -3661, -2106, 922, 177, 56, 
    -8, -44, -504, -186, -693, -3934, -14303, 6276, 881, -1085, 1195, 1334, 966, -3073, -1485, 1942, 
    -2777, -383, -334, -822, 8888, -4596, -151, -425, 15135, 3071, -2502, -306, -809, -862, -935, 1717, 
    260, 57, -825, -2008, -1450, -566, 3997, -2329, -1666, 880, 736, -1817, -416, -12477, -1069, -1030, 
    714, -2419, 676, -764, 262, -601, -2041, -3068, -180, 504, 1379, -2175, -552, 1776, -124, -2033, 
    3007, 407, -489, 558, 1903, -649, -730, 879, 446, 966, 382, 153, -26, -2483, 352, 1832, 
    379, 681, -757, -535, -629, -2946, -1389, 789, 2078, -2918, -672, -1077, -1817, 1242, -1173, -709, 
    -14, -106, -431, -40, -876, -1143, -2, -1287, 184, -396, -2121, 211, -1596, -192, 365, 2993, 
    1798, 749, 697, 5, -1248, -180, 414, 661, 2323, -178, -638, -497, -1363, -957, -61, -1001, 
    -164, 406, -357, -70, -2398, -1676, 173, -144, 8477, 12459, -4462, 3102, -2722, 1407, 3326, -689, 
    -420, -37, -390, -372, -467, -1069, 993, 1677, 2279, -4749, -497, -1435, -1414, -3883, -2320, 6796, 
    -1734, -707, -547, 571, -1928, -1525, -444, -194, -590, -5099, 5760, -74, -3695, -5369, -3917, 4174, 
    384, 230, -2460, 857, -3221, 8823, 2135, -2138, 544, -8857, -1422, 102, -1370, 670, -1707, -504, 
    2111, -194, 1334, -738, -248, 1039, -118, 266, 1196, -38, 1448, -901, 2008, 546, 633, -1351, 
    2313, 260, -1235, 634, 3745, -1737, -178, 100, 2583, 726, -2325, -1389, -4448, 772, 88, 1143, 
    -225, -7926, -1593, 804, -752, 2065, 339, 505, 2054, -8003, 478, 3367, -1646, 5112, 582, -1611, 
    -113, -756, 1349, 904, 443, 201, 637, -548, 1283, -922, -2433, 4148, -913, -795, -1721, 1071, 
    -8358, 424, -1565, -1541, -420, -576, -106, 737, 1266, 2065, 2361, -3941, -415, 120, 221, -2617, 
    48, -3509, -328, -851, 1561, -1621, 716, -1341, -10111, 11999, 6287, 1200, 2034, 601, -861, 1456, 
    529, 538, -23, -254, -772, 170, -6256, 5975, -4696, -2012, 2599, 1967, 829, -1703, -1007, -301, 
    -21926, -447, -1143, 2288, 5340, -2549, -1069, -902, 22334, -3741, -1028, 6639, -2527, 627, -1382, -5678, 
    -664, -5816, -336, -411, -1315, -21691, 869, 678, -1647, -1852, -872, -489, 620, -4553, -1436, -209, 
    -2363, 1267, 43, -2498, 4336, -1365, -502, -2488, 1088, 2042, 2669, -3945, 1035, -209, -692, -1506, 
    -1278, 1484, 3808, -4642, -6253, 4663, 1932, 4623, 1155, 4624, 2096, 3955, 1407, -1122, -310, -637, 
    1020, 2247, 1620, -1765, -683, -7425, -559, -650, 653, 3513, 1508, -2405, -668, -11403, -177, -1156, 
    1168, -410, -1215, 1, -2101, -1465, 11, 1185, -709, 2937, -3296, 1596, -1358, 772, 77, 1033, 
    -3794, -1387, 258, -2652, -7617, -1302, -751, -2449, 1723, -10845, 2833, 3864, -20514, -63, -1372, 134, 
    -56, -3391, -706, -902, 1027, -6085, -1854, -267, 109, 3530, 9726, 4343, 1299, -3023, 1543, -828, 
    -50, -29, 152, 115, 36, -779, 5977, -3924, 5451, -396, 2761, -4509, -1702, 545, 2682, -4944, 
    548, -297, -210, -9, -32767, 3570, 2571, 2104, 17515, 664, -945, 7351, -6043, -621, 390, -1906, 
    24, -1381, -1507, -916, -754, 2452, -320, -2454, -581, -1869, -846, -1912, 2534, -13205, -3848, -293, 
    2337, 173, 380, -486, -1259, 605, -3653, -729, 817, -1101, 1237, 464, -298, 1212, -1140, 1315, 
    -3741, 258, 529, 570, 1959, -3701, 1039, -2872, -8907, 126, -342, 225, -2118, -1211, -230, 694, 
    -63, -5308, 523, -155, -597, -2444, 990, -489, 1989, -4239, 2418, 2573, -831, -94, -715, 560, 
    -1302, -918, 1452, 1066, -241, -704, -874, 164, -945, -774, 2634, 1008, -688, 544, 17, -2503, 
    -1783, -642, 247, 373, -3241, -651, -236, 76, -294, 1181, 895, 1847, -7911, 753, 631, 730, 
    147, -1720, 97, 358, 106, 2650, -376, 1373, 6698, -9533, -4300, 1297, -601, -1647, 535, -337, 
    -475, -359, 337, 69, 1654, -992, -3426, 1333, 308, 4114, 6802, 3275, -1328, -499, -685, -2667, 
    -592, -286, 490, -180, -6283, -412, -1706, -774, -7090, -158, -365, -2498, 4128, -1796, -1913, 97, 
    512, 1060, -725, 179, 81, -4635, -1684, -18, -967, 1363, -517, 35, -1691, -6302, -1215, 400, 
    -1727, -550, 168, 402, 2803, 361, -879, 480, -1186, -308, 1525, -494, -2001, -210, 455, -441, 
    -7544, -40, 1591, 1388, -3524, 439, -125, 430, 3504, 113, -1258, 613, 974, 449, 1537, -1337, 
    -2255, 479, 266, 577, 777, -2511, -218, 470, -1353, -5131, -343, 1853, -271, -1076, -2463, -1266, 
    -1018, -667, 143, 241, -326, 879, 299, -291, 28, 594, 776, 796, -493, 186, -1982, 1182, 
    -1699, -479, 563, -1107, -1434, -104, -352, 273, 3973, 1431, 1108, 716, -910, -974, 417, -2660, 
    -119, -908, -87, -330, -1115, 683, 1602, 605, -1436, -5034, 980, -683, -1130, -7698, -735, 2416, 
    -338, -195, 585, 1033, -3104, 1631, 435, -3882, 1696, -1305, 3816, 4561, 623, 1155, -402, -588, 
    338, -862, -745, -232, -4234, -1246, 911, 706, 4541, 549, -1730, -843, -19229, 352, 451, -1548, 
    515, 2893, 293, 1526, 1989, -5500, 2683, 1529, -2195, 3752, 1088, -1800, 232, 2199, 1059, 348, 
    -1997, -330, 233, -743, 400, -343, -4275, 1484, -2618, 103, -1624, -1857, 777, 1426, -2611, 239, 
    1533, -2643, 329, 1897, -7019, -525, 47, -1277, 4014, -2326, 869, -1507, -3285, 506, -222, 253, 
    -660, -881, 117, -1218, 608, -4527, -956, 424, 3288, -2008, 44, -1197, -650, -3138, -195, -1342, 
    208, 138, -701, -274, 180, -875, 962, -330, 396, -615, -529, -737, -1759, -1386, -1168, -2069, 
    -1310, 330, -361, 432, -3670, 306, -1010, -232, -4392, 1248, -1076, 1625, -3803, 730, 747, -1148, 
    37, -1099, -56, -147, -1130, -2911, -310, 1752, 6674, 4072, -1133, 2669, 218, -9091, 74, -5241, 
    -403, -378, -46, 284, 941, -584, 2375, -1806, -1466, 528, -550, 891, 1574, 1413, 2124, 405, 
    -2017, -422, -297, -652, -168, 529, 1568, 593, -9552, -2669, -1240, -2358, 1746, -9, -2340, -1600, 
    -123, 1661, 1240, -1014, 49, -364, -335, 1272, 599, 445, -1226, -3007, -1035, 1084, -83, 518, 
    687, -1696, 500, -892, 213, 559, -1728, -1081, 615, 304, -374, 727, 1826, -574, 1456, 216, 
    219, -1588, 9, -437, -5211, -187, 914, -911, 1391, 458, -1714, 771, -8825, 1220, 641, 3022, 
    465, 152, -841, -221, -1040, -521, 105, -596, -688, 5087, -209, 899, 602, 638, -775, -1296, 
    -670, 141, 117, 277, 325, 503, -839, 151, -1833, -560, -2985, -300, 16, -243, 364, -792, 
    829, 444, 300, 518, -596, -476, 120, 111, 2549, -1417, -42, -120, -1002, 1208, -872, -376, 
};

static const int16_t pl3x2_paramModel6Alpha[12] = {
    95, 424, 5, -75, -1044, -86, -914, -449, 489, 2869, -122, 2704, 
};

static const int16_t pl3x2_paramResidualBias[12] = {
    10492, 14791, 9792, 14848, 789, 11803, -948, 664, 13027, 5956, 14962, -2291, 
};

static const int16_t pl3x2_paramResidualWeights[144] = {
    554, -305, -101, -97, 170, 688, 554, 26, 177, 128, -174, -125, -3, -314, -230, 83, 
    -534, -117, -52, -191, -218, 1252, 1182, -156, -139, 209, -417, 85, -385, 68, -227, -63, 
    -168, -123, 51, 127, 731, 655, -344, 826, 34, -175, -163, -99, 635, 248, -326, 52, 
    -514, 42, -201, -564, 568, 212, -364, -398, -293, -494, -374, -457, -133, -83, -234, -254, 
    48, -292, -380, -153, -665, -2038, 238, -139, -292, -39, -348, -24, -230, 260, -45, -77, 
    -201, 124, -65, -175, 170, 206, -499, 623, -42, 83, -311, 16, -287, -156, -76, -119, 
    238, 349, 371, 332, -28, 90, 67, -134, 99, -17, -338, -267, -209, -0, -6, -27, 
    647, -124, -412, 281, -15, 739, 143, -62, -365, -1164, -669, 210, 89, 278, 187, -473, 
    310, -95, 626, -103, -101, -422, -70, 73, -16, -68, -114, 47, -62, 1, 73, 38, 
};

static const int16_t pl3x2_paramResidualAlpha[12] = {
    95, 105, 9, 113, 2, 6, 63, 4244, 9, 4440, 198, 21, 
};

static const int16_t pl3x2_paramSubConvolutionBias[4] = {
    -63, 59, 81, -70, 
};

static const int16_t pl3x2_paramSubConvolutionWeights[432] = {
    -136, 141, 285, -112, -379, 164, 272, 10, 202, 285, 217, -88, 284, -154, -178, 35, 
    -700, 185, 33, -79, 41, -37, 25, 31, 20, 156, 29, -78, -144, -63, -2, 54, 
    -176, 128, -68, -124, -438, -317, -92, 81, 621, -248, -220, 255, -121, 109, -154, -94, 
    -460, 442, 23, -179, -540, 454, 167, -291, 411, -165, -193, 304, -83, 13, 443, 311, 
    -235, 46, 8, -332, 243, -160, 59, 125, 291, -28, 237, 58, -124, -293, 14, 67, 
    -206, 220, -33, -168, 121, -378, 270, 228, 123, -798, -163, 189, 276, 320, -3, 142, 
    -117, 13, -14, 33, 53, 596, 129, -165, -82, 111, 194, 52, -292, 280, 161, -104, 
    -62, 67, 92, 28, -95, 61, -19, 100, -54, 91, 143, -41, 99, 47, -67, 61, 
    252, -429, -184, -63, -83, 27, 31, 49, -109, 20, -62, 2, 155, -147, 57, 78, 
    356, 159, -251, 213, -342, 56, 461, -352, -269, 505, 140, -375, 350, -116, -444, 205, 
    178, -229, 213, -71, 118, 86, -275, 147, -21, 259, -60, -7, 72, 169, -393, 172, 
    -344, -26, 72, -142, 68, 270, -678, 167, -340, 571, -342, 251, -58, 96, -249, 86, 
    185, -530, -492, 448, -165, -272, 383, -938, 462, -1024, -471, 823, -441, -143, -94, -19, 
    175, 424, 49, -393, 356, -200, -57, -211, 464, -17, 200, 108, -619, -889, -669, -886, 
    -236, -69, -260, -434, 1134, 118, 91, -542, -560, 412, -238, 163, 140, -475, 546, 205, 
    -311, 61, -204, 263, 33, 709, 466, -161, -303, 455, 437, -336, -63, 503, 254, -770, 
    -146, -666, 26, 106, 25, 83, -28, 140, -160, 201, -307, 350, 181, -52, 98, 223, 
    152, -147, -242, 123, -118, 276, -30, 37, -162, 204, 83, -180, 461, 183, -293, 402, 
    256, -5, 198, 109, 406, -280, -501, 23, -290, 181, 246, -122, -39, -89, -209, 54, 
    -218, -6, -142, 115, 71, 44, 57, 74, 78, 70, 19, 40, 100, -53, 121, 219, 
    44, 77, 63, -146, -49, 196, 15, 194, -312, 110, 974, -344, -134, -296, 176, -133, 
    88, -306, 77, -409, 357, -528, -474, 475, -20, -192, -202, 314, -203, -56, 271, 168, 
    141, 166, -177, 113, 53, -53, 35, -31, 99, 176, 199, 52, 326, 207, -41, 185, 
    134, 200, 468, 151, -59, -213, 399, 165, -394, 477, 598, -1021, -293, 396, -466, -384, 
    -8, -57, -357, 173, 122, -339, -289, 550, 23, 131, 169, -280, -39, -36, 29, -296, 
    -64, -167, -173, 105, 38, -11, -77, 107, 81, -187, -123, 176, -133, 95, 88, 159, 
    130, -6, -23, 387, -42, -163, -131, 149, -135, 304, 114, -655, -28, -5, 158, 172, 
};

