#include <wx/msgdlg.h>
#include <wx/wfstream.h>
#include <wx/string.h>
#ifdef __WXMSW__
#include <wx/stdpaths.h>
#include <wx/filename.h>
#endif
#include "main.h"
#include "debug.h"
#include "ytprotocol.h"
#include "ytprotocolhandler.h"
#include "configuration.h"



using namespace tvlite;

CYTProtocol::CYTProtocol(wxEvtHandler *parent, wxString url, wxString cmd):CBaseProtocol(parent,url, cmd),
 m_inputStream(nullptr), 
 m_fileDescriptor(-1),
 m_ytthread(nullptr)
{
   Redirect();
}

tvlite::CYTProtocol::~CYTProtocol()
{
   DBG_INFO ("Youtube protocol -> delete"); 
}

int CYTProtocol::LoadConfig()
{
   //TODO stub
   return 0;   
}

int CYTProtocol::SaveConfig()
{
   //TODO stub
   return 0;
}

int CYTProtocol::GetFileDescriptor()
{
   return m_fileDescriptor;
}

int CYTProtocol::StartProtocol (long &pid)
{ 
   CConfiguration *conf = CConfiguration::Instance();
   DBG_INFO("Starting a new yt-dlp process");
   MainFrame *mainWindow = (MainFrame*)wxGetApp().GetTopWindow();
   pid = 0;
   int result = E_OK;
   m_cmd = conf->GetYTDlpConfiguration().GetFullPath();
   if (m_cmd == "")
   {
      if (SearchYT(m_cmd) != 0)
      {
         wxMessageBox(_("Could not search for yt-dlp.\n Please specify the yt-dlp path in the \"Preferences\" window"), _("Error"), wxOK|wxICON_EXCLAMATION, mainWindow);
      }
      else
      {
         if (m_cmd == "")
         {
            wxMessageBox(_("Could not find yt-dlp in the path."), _("Error"), wxOK|wxICON_EXCLAMATION, mainWindow);
            result = E_ERROR;
         }   
      }
         
   }
   
   if (result == E_OK)
   {
      wxString cmd = m_cmd << " -o - " << conf->GetYTDlpConfiguration().GetParams();
      //wxString cmd = m_cmd << " " << conf->GetYTDlpConfiguration().GetParams();
      if (conf->GetYTDlpConfiguration().GetUseFFMpeg())
      {
         cmd << " --downloader ffmpeg ";
      }
      cmd << " "<< m_url; 
      DBG_INFO("yt-dlp command is '%s'.", (const char*)cmd.utf8_str());
      long rc = wxExecute(cmd, wxEXEC_ASYNC|wxEXEC_MAKE_GROUP_LEADER, this);
      pid = rc;
      if (rc == 0L)
      {
         DBG_ERROR("Execution of '%s' failed.", (const char*)cmd.utf8_str());
         wxMessageBox(_("Could not execute yt-dlp!"), _("Error"), wxOK|wxICON_EXCLAMATION, mainWindow);
         result = E_ERROR;
      }
   }
   if (result == E_OK)
   {  
      
#ifdef __APPL_USE_FILESTREAM__       
      wxFileInputStream * pfis = (wxFileInputStream*)(GetInputStream());
      if (pfis != nullptr)
      {
        m_fileDescriptor =  pfis->GetFile()->fd();
      }
      else
      {
          result = E_ERROR;
      }
#else
      m_inputStream = GetInputStream();
     
      if (m_inputStream == nullptr)
      {
          result = E_ERROR;
      }
#endif
   }
   if (result == E_OK)
   {
      m_ytthread = new CYTThread(m_pparent, this);
      if (m_ytthread == NULL)
      {
          DBG_ERROR("YT: Could not allocate thread");
          result = E_ERROR;
      }
   }
   if (result == E_OK)
   {
      if ( m_ytthread->Create() != wxTHREAD_NO_ERROR )
      {
          DBG_ERROR("Could not create thread");
          delete m_ytthread;
          m_ytthread = NULL;
          result = E_ERROR;
      }

   }
   if (result == E_OK)
   {
      if (m_ytthread->Run() != wxTHREAD_NO_ERROR)
      {
         DBG_ERROR("Could not run thread");
         result = E_ERROR;
      }

   }
   return result;
}

int CYTProtocol::SearchYT(wxString &cmd)
{
   wxArrayString res, err;
   long rc;
#ifdef __WXMSW__
    wxStandardPaths stdPath = wxStandardPaths::Get();
    wxString YTDir = stdPath.GetDataDir(); 
    wxFileName cmdFileName(YTDir, "yt-dlp.exe");
    DBG_INFO("Engine supposed name %s", (const char*)YTDir.utf8_str());
     if (cmdFileName.IsOk()  && cmdFileName.FileExists())
     {
         rc = 0;
         cmd = cmdFileName.GetFullPath();
     }   
     else
     {
         rc = -1;
     }
#else
   rc = wxExecute("which yt-dlp" , res, err);
   if (!rc)
   {
      if (!res.IsEmpty())
      {
         cmd = res[0];
      }   
   }
#endif
   return rc;
}

void CYTProtocol::StopProtocol()
{
   CBaseProtocol::StopProtocol();
   WaitThread();
}

void CYTProtocol::OnTerminate(int pid, int status)
{
   WaitThread();
}


void CYTProtocol::WaitThread()
{
   if (m_ytthread != nullptr)
   {
      DBG_INFO("Waiting for thread");
      m_ytthread->SetRunning(false);
      m_ytthread->Wait();
      delete m_ytthread;
      m_ytthread = NULL;
      DBG_INFO("Finished wait");
   }
   else
   {
      DBG_INFO("Thread has been already destroyed");
   }
}

void CYTProtocol::LockAccessMutex()
{
   DBG_INFO("Lock access mutex");
    m_accessMutex.Lock(); 
}

void CYTProtocol::UnlockAccessMutex()
{
    DBG_INFO("UNLock access mutex");
    m_accessMutex.Unlock(); 
    
}
