from typing import NamedTuple

from _typeshed import Incomplete
from stravalib.unithelper import is_quantity_type as is_quantity_type

META: int
SUMMARY: int
DETAILED: int

class Attribute:
    log: Incomplete
    resource_states: Incomplete
    data: Incomplete
    units: Incomplete
    def __init__(
        self, type_, resource_states: Incomplete | None = ..., units: Incomplete | None = ...
    ) -> None: ...
    def __get__(self, obj, clazz): ...
    def __set__(self, obj, val) -> None: ...
    @property
    def type(self): ...
    @type.setter
    def type(self, v) -> None: ...
    def marshal(self, v): ...
    def unmarshal(self, v): ...

class DateAttribute(Attribute):
    def __init__(self, resource_states: Incomplete | None = ...) -> None: ...
    def marshal(self, v): ...
    def unmarshal(self, v): ...

class TimestampAttribute(Attribute):
    tzinfo: Incomplete
    def __init__(self, resource_states: Incomplete | None = ..., tzinfo=...) -> None: ...
    def marshal(self, v): ...
    def unmarshal(self, v): ...

class LatLon(NamedTuple):
    lat: Incomplete
    lon: Incomplete

class LocationAttribute(Attribute):
    def __init__(self, resource_states: Incomplete | None = ...) -> None: ...
    def marshal(self, v): ...
    def unmarshal(self, v): ...

class TimezoneAttribute(Attribute):
    def __init__(self, resource_states: Incomplete | None = ...) -> None: ...
    def unmarshal(self, v): ...
    def marshal(self, v): ...

class TimeIntervalAttribute(Attribute):
    def __init__(self, resource_states: Incomplete | None = ...) -> None: ...
    def unmarshal(self, v): ...
    def marshal(self, v): ...

class ChoicesAttribute(Attribute):
    choices: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    def marshal(self, v): ...
    def unmarshal(self, v): ...

class EntityAttribute(Attribute):
    bind_clients: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def type(self): ...
    @type.setter
    def type(self, v) -> None: ...
    def __set__(self, obj, val) -> None: ...
    def marshal(self, v): ...
    def unmarshal(self, value, bind_client: Incomplete | None = ...): ...

class EntityCollection(EntityAttribute):
    def marshal(self, values): ...
    def unmarshal(self, values, bind_client: Incomplete | None = ...): ...
