/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutionInterceptor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class ExecutorsQuery<Result, Parameter>
extends AbstractQuery<Result> {
    private static final Logger LOG = Logger.getInstance(ExecutorsQuery.class);
    private final List<? extends QueryExecutor<Result, Parameter>> myExecutors;
    private final Parameter myParameters;

    public ExecutorsQuery(@NotNull Parameter params, @NotNull List<? extends QueryExecutor<Result, Parameter>> executors) {
        if (params == null) {
            ExecutorsQuery.$$$reportNull$$$0(0);
        }
        if (executors == null) {
            ExecutorsQuery.$$$reportNull$$$0(1);
        }
        this.myParameters = params;
        this.myExecutors = executors;
    }

    @Override
    protected boolean processResults(@NotNull Processor<? super Result> consumer) {
        if (consumer == null) {
            ExecutorsQuery.$$$reportNull$$$0(2);
        }
        for (QueryExecutor<? super Result, Parameter> queryExecutor : this.myExecutors) {
            try {
                ProgressManager.checkCanceled();
                if (queryExecutor.execute(this.myParameters, consumer)) continue;
                return false;
            }
            catch (IndexNotReadyException indexNotReadyException) {
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        return true;
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @ApiStatus.Experimental
    @NotNull
    public Query<Result> wrap(@NotNull QueryWrapper<Result> wrapper) {
        if (wrapper == null) {
            ExecutorsQuery.$$$reportNull$$$0(3);
        }
        return new ExecutorsQuery<Result, Parameter>(this.myParameters, ContainerUtil.map(this.myExecutors, e -> e.wrap(wrapper)));
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public Query<Result> interceptWith(@NotNull QueryExecutionInterceptor interceptor) {
        if (interceptor == null) {
            ExecutorsQuery.$$$reportNull$$$0(4);
        }
        return new ExecutorsQuery<Result, Parameter>(this.myParameters, ContainerUtil.map(this.myExecutors, e -> ExecutorsQuery.interceptWith(e, interceptor)));
    }

    private static <R, P> QueryExecutor<R, P> interceptWith(QueryExecutor<R, P> executor, QueryExecutionInterceptor interceptor) {
        return (parameters, consumer) -> interceptor.intercept(() -> executor.execute(parameters, consumer));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interceptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ExecutorsQuery";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processResults";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "wrap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "interceptWith";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

