/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyPackagesNotificationPanel;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
@ApiStatus.Internal
public final class DeprecatedUtils {
    private DeprecatedUtils() {
    }

    private static void reportPackageInstallationFailure(@NotNull String frameworkName, @Nullable Pair<Sdk, ExecutionException> sdkAndException) {
        if (frameworkName == null) {
            DeprecatedUtils.$$$reportNull$$$0(0);
        }
        PyPackageManagementService.PyPackageInstallationErrorDescription errorDescription = DeprecatedUtils.getErrorDescription(sdkAndException, frameworkName);
        Application app = ApplicationManager.getApplication();
        app.invokeLater(() -> PyPackagesNotificationPanel.showPackageInstallationError(PyBundle.message("python.new.project.install.failed.title", frameworkName), errorDescription));
    }

    @NotNull
    private static PyPackageManagementService.PyPackageInstallationErrorDescription getErrorDescription(@Nullable Pair<Sdk, ExecutionException> sdkAndException, @NotNull String packageName) {
        ExecutionException exception;
        if (packageName == null) {
            DeprecatedUtils.$$$reportNull$$$0(1);
        }
        PyPackageManagementService.PyPackageInstallationErrorDescription errorDescription = null;
        if (sdkAndException != null && (errorDescription = PyPackageManagementService.toErrorDescription(Collections.singletonList(exception = (ExecutionException)((Object)sdkAndException.second)), (Sdk)sdkAndException.first, packageName)) == null) {
            errorDescription = PyPackageManagementService.PyPackageInstallationErrorDescription.createFromMessage(exception.getMessage());
        }
        if (errorDescription == null) {
            errorDescription = PyPackageManagementService.PyPackageInstallationErrorDescription.createFromMessage(PyBundle.message("python.new.project.error.solution.another.sdk", new Object[0]));
        }
        PyPackageManagementService.PyPackageInstallationErrorDescription pyPackageInstallationErrorDescription = errorDescription;
        if (pyPackageInstallationErrorDescription == null) {
            DeprecatedUtils.$$$reportNull$$$0(2);
        }
        return pyPackageInstallationErrorDescription;
    }

    @NotNull
    public static Future<Void> installFrameworkIfNeeded(@NotNull Project project, final @NotNull String frameworkName, final @NotNull String requirement, final @NotNull Sdk sdk2, final boolean forceInstallFramework, final @Nullable Runnable callback) {
        if (project == null) {
            DeprecatedUtils.$$$reportNull$$$0(3);
        }
        if (frameworkName == null) {
            DeprecatedUtils.$$$reportNull$$$0(4);
        }
        if (requirement == null) {
            DeprecatedUtils.$$$reportNull$$$0(5);
        }
        if (sdk2 == null) {
            DeprecatedUtils.$$$reportNull$$$0(6);
        }
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (forceInstallFramework || PythonSdkUtil.isRemote(sdk2)) {
            ProgressManager.getInstance().run((Task)new Task.Modal(project, PyBundle.message("python.install.framework.ensure.installed", frameworkName), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DeprecatedUtils.installPackages(frameworkName, forceInstallFramework, indicator, requirement, sdk2);
                }

                public void onThrowable(@NotNull Throwable error) {
                    if (error == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    future.completeExceptionally(error);
                }

                public void onSuccess() {
                    future.complete(null);
                    if (callback != null) {
                        callback.run();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "error";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/python/newProject/DeprecatedUtils$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        } else {
            future.complete(null);
            if (callback != null) {
                assert (SwingUtilities.isEventDispatchThread());
                callback.run();
            }
        }
        CompletableFuture<Void> completableFuture = future;
        if (completableFuture == null) {
            DeprecatedUtils.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    private static void installPackages(@NotNull String frameworkName, boolean forceInstallFramework, @NotNull ProgressIndicator indicator, @NotNull String requirement, @NotNull Sdk sdk2) {
        if (frameworkName == null) {
            DeprecatedUtils.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            DeprecatedUtils.$$$reportNull$$$0(9);
        }
        if (requirement == null) {
            DeprecatedUtils.$$$reportNull$$$0(10);
        }
        if (sdk2 == null) {
            DeprecatedUtils.$$$reportNull$$$0(11);
        }
        PyPackageManager packageManager = PyPackageManager.getInstance(sdk2);
        boolean installed = false;
        if (!forceInstallFramework) {
            indicator.setText(PyBundle.message("python.install.framework.checking.is.installed", frameworkName));
            List<PyPackage> packages2 = PyPackageUtil.refreshAndGetPackagesModally(sdk2);
            boolean bl = installed = PyPsiPackageUtil.findPackage(packages2, requirement) != null;
        }
        if (!installed) {
            indicator.setText(PyBundle.message("python.install.framework.installing", frameworkName));
            try {
                packageManager.install(requirement);
                packageManager.refresh();
            }
            catch (ExecutionException e) {
                DeprecatedUtils.reportPackageInstallationFailure(requirement, (Pair<Sdk, ExecutionException>)Pair.create((Object)sdk2, (Object)((Object)e)));
            }
        }
    }

    @NotNull
    public static List<Sdk> getValidPythonSdks(@NotNull List<Sdk> existingSdks) {
        if (existingSdks == null) {
            DeprecatedUtils.$$$reportNull$$$0(12);
        }
        List list = ((StreamEx)((StreamEx)StreamEx.of(existingSdks).filter(sdk2 -> sdk2 != null && sdk2.getSdkType() instanceof PythonSdkType && PySdkExtKt.getSdkSeemsValid(sdk2))).sorted((Comparator)new PreferredSdkComparator())).toList();
        if (list == null) {
            DeprecatedUtils.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/newProject/DeprecatedUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirement";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/newProject/DeprecatedUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "installFrameworkIfNeeded";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidPythonSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reportPackageInstallationFailure";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getErrorDescription";
                break;
            }
            case 2: 
            case 7: 
            case 13: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installFrameworkIfNeeded";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "installPackages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getValidPythonSdks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 13 -> new IllegalStateException(string);
        };
    }
}

