/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.screenForwarding;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import com.jetbrains.rd.platform.codeWithMe.screenForwarding.ScreenForwardingCommonSettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0006\u0010\u000b\u001a\u00020\n\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\"\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0004\"\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"hasXpra", "Ljava/util/function/Supplier;", "", "getHasXpra", "()Ljava/util/function/Supplier;", "hasXvfb", "getHasXvfb", "hasXorg", "getHasXorg", "defaultXpraLocationWindows", "", "getEffectiveXpraExecutablePath", "intellij.platform.split"})
public final class ScreenForwardingCommonUtilKt {
    @NotNull
    private static final Supplier<Boolean> hasXpra;
    @NotNull
    private static final Supplier<Boolean> hasXvfb;
    @NotNull
    private static final Supplier<Boolean> hasXorg;
    @NotNull
    public static final String defaultXpraLocationWindows = "C:/Program Files/Xpra/Xpra_cmd.exe";

    @NotNull
    public static final Supplier<Boolean> getHasXpra() {
        return hasXpra;
    }

    @NotNull
    public static final Supplier<Boolean> getHasXvfb() {
        return hasXvfb;
    }

    @NotNull
    public static final Supplier<Boolean> getHasXorg() {
        return hasXorg;
    }

    @NotNull
    public static final String getEffectiveXpraExecutablePath() {
        String xpraExecutablePathFromSettings = ScreenForwardingCommonSettings.Companion.getInstance().getXpraExecutablePath();
        if (!StringsKt.isBlank((CharSequence)xpraExecutablePathFromSettings)) {
            File file = new File(xpraExecutablePathFromSettings);
            if (!file.canExecute()) {
                Object[] objectArray = new Object[]{xpraExecutablePathFromSettings};
                throw new FileNotFoundException(PlatformSplitBundle.INSTANCE.message("screen.forwarding.xpra.not.found.path.from.settings", objectArray));
            }
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            return string;
        }
        if (hasXpra.get().booleanValue()) {
            return "xpra";
        }
        if (SystemInfoRt.isWindows) {
            if (!new File(defaultXpraLocationWindows).canExecute()) {
                Object[] objectArray = new Object[]{defaultXpraLocationWindows};
                throw new FileNotFoundException(PlatformSplitBundle.INSTANCE.message("screen.forwarding.xpra.not.found.env.path.and.default.location", objectArray));
            }
            return defaultXpraLocationWindows;
        }
        throw new FileNotFoundException(PlatformSplitBundle.INSTANCE.message("screen.forwarding.xpra.not.found.env.path", new Object[0]));
    }

    static {
        Supplier supplier = PathExecLazyValue.create((String)"xpra");
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"create(...)");
        hasXpra = supplier;
        Supplier supplier2 = PathExecLazyValue.create((String)"Xvfb");
        Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"create(...)");
        hasXvfb = supplier2;
        Supplier supplier3 = PathExecLazyValue.create((String)"Xorg");
        Intrinsics.checkNotNullExpressionValue((Object)supplier3, (String)"create(...)");
        hasXorg = supplier3;
    }
}

