/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.wiki;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;
import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.context.RenderContext;

public class TestCaseRenderEngine
implements RenderEngine {
    Pattern groovyCodePattern = Pattern.compile("\\{code:groovy\\}");
    Pattern groovyShellPattern = Pattern.compile("\\{code:groovysh\\}");
    Pattern codePattern = Pattern.compile("\\{code\\}");

    public String getName() {
        return "TestCase";
    }

    public String render(String content, RenderContext context) {
        int idx;
        String name = (String)context.get("name");
        if (name == null) {
            name = "UknownName.wiki";
        }
        if ((idx = name.lastIndexOf(46)) > 0) {
            name = name.substring(0, idx);
        }
        name = name + "Test";
        StringBuffer buf = new StringBuffer();
        String[] parts = this.groovyCodePattern.split(content);
        buf.append("package wiki\nclass " + name + " extends GroovyTestCase {\n\n");
        buf.append("/*\n");
        buf.append(this.processShellScripts(parts[0]));
        for (int count = 1; count < parts.length; ++count) {
            buf.append("*/ \n\n  void testCase" + count + "() {\n");
            buf.append(this.processShellScripts(this.removeCloseCode(parts[count])));
        }
        buf.append("\n*/\n\n");
        buf.append("void testDummy() {\n// this is a dummy test case\n}\n\n}\n");
        return buf.toString();
    }

    protected String processShellScripts(String text) {
        StringBuffer buf = new StringBuffer();
        String[] parts = this.groovyShellPattern.split(text);
        buf.append(parts[0]);
        for (int count = 1; count < parts.length; ++count) {
            buf.append("*/ \n\n  void testScript" + count + "() {\n");
            buf.append("    assertScript( <<<SCRIPT_EOF" + count + "\n");
            String code = parts[count].replaceFirst("\\{code\\}", "\nSCRIPT_EOF" + count + " )\n}    \n\n /*");
            StringBuffer temp = new StringBuffer(code);
            int idx = 0;
            while ((idx = temp.indexOf("$", idx)) >= 0) {
                String next;
                if ((next = temp.substring(++idx, idx + 1)).equals("{") && idx - 2 >= 0 && !temp.substring(idx - 2, idx - 1).equals("\\")) {
                    temp.insert(idx - 1, "\\");
                    ++idx;
                }
                ++idx;
            }
            buf.append(temp.toString());
        }
        return buf.toString();
    }

    protected String removeCloseCode(String text) {
        return text.replaceFirst("\\{code\\}", "\n}\n\n /*");
    }

    public void render(Writer out, String content, RenderContext context) throws IOException {
        out.write(this.render(content, context));
    }
}

