/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.ClassData;
import fpc.tools.javapp.PascalClassData;
import fpc.tools.javapp.PascalKeywords;
import fpc.tools.javapp.TypeSignature;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PascalTypeSignature
extends TypeSignature {
    private boolean useOpenArrays;
    private boolean useConstOpenArrays;
    private boolean useClassRefs;

    public PascalTypeSignature(String JVMSignature, ClassData cls, boolean useOpenArrays, boolean useConstOpenArrays, boolean useClassRef) {
        this.useOpenArrays = useOpenArrays;
        this.useConstOpenArrays = useConstOpenArrays;
        this.useClassRefs = this.useClassRefs;
        this.init(JVMSignature);
    }

    @Override
    public String getBaseType(String baseType) {
        if (baseType != null) {
            if (baseType.equals("B")) {
                return "jbyte";
            }
            if (baseType.equals("C")) {
                return "jchar";
            }
            if (baseType.equals("D")) {
                return "jdouble";
            }
            if (baseType.equals("F")) {
                return "jfloat";
            }
            if (baseType.equals("I")) {
                return "jint";
            }
            if (baseType.equals("J")) {
                return "jlong";
            }
            if (baseType.equals("S")) {
                return "jshort";
            }
            if (baseType.equals("Z")) {
                return "jboolean";
            }
            if (baseType.equals("V")) {
                return "";
            }
        }
        return null;
    }

    @Override
    public String getObjectType(String JVMobjectType) {
        String objectType = super.getObjectType(JVMobjectType).replace('.', '/');
        if (objectType != null) {
            objectType = !PascalClassData.currentUnit.isExternalInnerClass(objectType) ? PascalClassData.getFullPascalClassName(objectType) : PascalClassData.getShortPascalClassName(objectType);
        }
        if (PascalKeywords.isPascalKeyword(objectType)) {
            objectType = "&" + objectType;
        }
        if (this.useClassRefs && objectType.equals("JLClass")) {
            objectType = "JLObjectClassRef";
        }
        return objectType;
    }

    @Override
    public String getArrayType(String arrayType) {
        if (arrayType != null) {
            int dimCount = 0;
            int i = 0;
            while (i < arrayType.length()) {
                if (arrayType.charAt(i) != '[') {
                    arrayType = arrayType.substring(i);
                    break;
                }
                ++dimCount;
                ++i;
            }
            String componentType = "";
            String outerClass = "";
            if (arrayType.startsWith("L")) {
                String baseType = arrayType.substring(1, arrayType.length() - 1);
                if (PascalClassData.isInnerClass(baseType) && !PascalClassData.currentUnit.isExternalInnerClass(baseType)) {
                    int index = baseType.lastIndexOf(36);
                    outerClass = String.valueOf(PascalClassData.getShortPascalClassName(baseType.substring(0, index))) + ".";
                    componentType = "Inner" + baseType.substring(index + 1).replace('$', '.');
                } else {
                    outerClass = "";
                    componentType = PascalClassData.getShortPascalClassName(baseType);
                }
            } else {
                componentType = this.getBaseType(arrayType);
            }
            if (!this.useOpenArrays || dimCount > 1) {
                return String.valueOf(outerClass) + "Arr" + dimCount + componentType;
            }
            return "array of " + outerClass + componentType;
        }
        return null;
    }

    @Override
    protected String parameterSignatureFromParameters(Vector<String> parameters) {
        this.argumentlength = parameters.size();
        StringBuilder parametersignature = new StringBuilder("(");
        int i = 0;
        while (i < this.argumentlength) {
            String paraType = parameters.elementAt(i);
            if (paraType.contains("array of")) {
                if (!this.useConstOpenArrays) {
                    parametersignature.append("var ");
                } else {
                    parametersignature.append("const ");
                }
            }
            parametersignature.append("para");
            parametersignature.append(i + 1);
            parametersignature.append(": ");
            parametersignature.append(paraType);
            if (i != parameters.size() - 1) {
                parametersignature.append("; ");
            }
            ++i;
        }
        parametersignature.append(")");
        return parametersignature.toString();
    }
}

