/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.AttrData;
import fpc.tools.javapp.ClassData;
import fpc.tools.javapp.LineNumData;
import fpc.tools.javapp.LocVarData;
import fpc.tools.javapp.StackMapData;
import fpc.tools.javapp.StackMapTableData;
import fpc.tools.javapp.TrapData;
import fpc.tools.javapp.TypeSignature;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class MethodData {
    ClassData cls;
    int access;
    int name_index;
    int descriptor_index;
    int attributes_count;
    int[] exc_index_table = null;
    Vector attrs = new Vector(0);
    boolean isSynthetic = false;
    boolean isDeprecated = false;
    boolean isVarArgs = false;

    public MethodData(ClassData cls) {
        this.cls = cls;
    }

    /*
     * Unable to fully structure code
     */
    public void read(DataInputStream in) throws IOException {
        this.access = in.readUnsignedShort();
        this.name_index = in.readUnsignedShort();
        this.descriptor_index = in.readUnsignedShort();
        attributes_count = in.readUnsignedShort();
        i = 0;
        while (i < attributes_count) {
            attr_name_index = in.readUnsignedShort();
            if (this.cls.getTag(attr_name_index) != 1) ** GOTO lbl-1000
            attr_name = this.cls.getString(attr_name_index);
            if (attr_name.equals("Code")) {
                this.readCode(in);
                attr = new AttrData(this.cls);
                attr.read(attr_name_index);
                this.attrs.addElement(attr);
            } else if (attr_name.equals("Exceptions")) {
                this.readExceptions(in);
                attr = new AttrData(this.cls);
                attr.read(attr_name_index);
                this.attrs.addElement(attr);
            } else if (attr_name.equals("Synthetic")) {
                if (in.readInt() != 0) {
                    throw new ClassFormatError("invalid Synthetic attr length");
                }
                this.isSynthetic = true;
                attr = new AttrData(this.cls);
                attr.read(attr_name_index);
                this.attrs.addElement(attr);
            } else if (attr_name.equals("Deprecated")) {
                if (in.readInt() != 0) {
                    throw new ClassFormatError("invalid Synthetic attr length");
                }
                this.isDeprecated = true;
                attr = new AttrData(this.cls);
                attr.read(attr_name_index);
                this.attrs.addElement(attr);
            } else lbl-1000:
            // 2 sources

            {
                attr = new AttrData(this.cls);
                attr.read(attr_name_index, in);
                this.attrs.addElement(attr);
            }
            ++i;
        }
    }

    public void readCode(DataInputStream in) throws IOException {
        int attr_length = in.readInt();
        int max_stack = in.readUnsignedShort();
        int max_locals = in.readUnsignedShort();
        int codelen = in.readInt();
        int totalread = 0;
        while (totalread < codelen) {
            totalread += in.skipBytes(codelen - totalread);
        }
        boolean clen = false;
        this.readExceptionTable(in);
        int code_attributes_count = in.readUnsignedShort();
        AttrData attr = new AttrData(this.cls);
        int k = 0;
        while (k < code_attributes_count) {
            int table_name_index = in.readUnsignedShort();
            byte table_name_tag = this.cls.getTag(table_name_index);
            if (table_name_tag == 1) {
                String table_name_tstr = this.cls.getString(table_name_index);
                if (table_name_tstr.equals("LineNumberTable")) {
                    this.readLineNumTable(in);
                    attr.read(table_name_index);
                } else if (table_name_tstr.equals("LocalVariableTable")) {
                    this.readLocVarTable(in);
                    attr.read(table_name_index);
                } else if (table_name_tstr.equals("StackMapTable")) {
                    this.readStackMapTable(in);
                    attr.read(table_name_index);
                } else if (table_name_tstr.equals("StackMap")) {
                    this.readStackMap(in);
                    attr.read(table_name_index);
                } else {
                    attr.read(table_name_index, in);
                }
            } else {
                attr.read(table_name_index, in);
            }
            ++k;
        }
    }

    void readExceptionTable(DataInputStream in) throws IOException {
        int exception_table_len = in.readUnsignedShort();
        Vector<TrapData> exception_table = new Vector<TrapData>(exception_table_len);
        int l = 0;
        while (l < exception_table_len) {
            exception_table.addElement(new TrapData(in, l));
            ++l;
        }
    }

    void readLineNumTable(DataInputStream in) throws IOException {
        int attr_len = in.readInt();
        int lin_num_tb_len = in.readUnsignedShort();
        Vector<LineNumData> lin_num_tb = new Vector<LineNumData>(lin_num_tb_len);
        int l = 0;
        while (l < lin_num_tb_len) {
            lin_num_tb.addElement(new LineNumData(in));
            ++l;
        }
    }

    void readLocVarTable(DataInputStream in) throws IOException {
        int attr_len = in.readInt();
        int loc_var_tb_len = in.readUnsignedShort();
        Vector<LocVarData> loc_var_tb = new Vector<LocVarData>(loc_var_tb_len);
        int l = 0;
        while (l < loc_var_tb_len) {
            loc_var_tb.addElement(new LocVarData(in));
            ++l;
        }
    }

    public void readExceptions(DataInputStream in) throws IOException {
        int attr_len = in.readInt();
        int num_exceptions = in.readUnsignedShort();
        this.exc_index_table = new int[num_exceptions];
        int l = 0;
        while (l < num_exceptions) {
            short exc = in.readShort();
            this.exc_index_table[l] = exc;
            ++l;
        }
    }

    void readStackMapTable(DataInputStream in) throws IOException {
        int attr_len = in.readInt();
        int stack_map_tb_len = in.readUnsignedShort();
        StackMapTableData[] stackMapTable = new StackMapTableData[stack_map_tb_len];
        int i = 0;
        while (i < stack_map_tb_len) {
            stackMapTable[i] = StackMapTableData.getInstance(in, this);
            ++i;
        }
    }

    void readStackMap(DataInputStream in) throws IOException {
        int attr_len = in.readInt();
        int stack_map_len = in.readUnsignedShort();
        StackMapData[] stackMap = new StackMapData[stack_map_len];
        int i = 0;
        while (i < stack_map_len) {
            stackMap[i] = new StackMapData(in, this);
            ++i;
        }
    }

    public String[] getAccess() {
        Vector<String> v = new Vector<String>();
        if ((this.access & 1) != 0) {
            v.addElement("public");
        }
        if ((this.access & 2) != 0) {
            v.addElement("private");
        }
        if ((this.access & 4) != 0) {
            v.addElement("protected");
        }
        if ((this.access & 8) != 0) {
            v.addElement("static");
        }
        if ((this.access & 0x10) != 0) {
            v.addElement("final");
        }
        if ((this.access & 0x20) != 0) {
            v.addElement("synchronized");
        }
        if ((this.access & 0x100) != 0) {
            v.addElement("native");
        }
        if ((this.access & 0x400) != 0) {
            v.addElement("abstract");
        }
        if ((this.access & 0x800) != 0) {
            v.addElement("strictfp");
        }
        Object[] accflags = new String[v.size()];
        v.copyInto(accflags);
        return accflags;
    }

    public String getName() {
        return this.cls.getStringValue(this.name_index);
    }

    public String getInternalSig() {
        return this.cls.getStringValue(this.descriptor_index);
    }

    public String getReturnType() {
        String rttype = new TypeSignature(this.getInternalSig()).getReturnType();
        return rttype;
    }

    public String getParameters() {
        String ptype = new TypeSignature(this.getInternalSig()).getParameters();
        return ptype;
    }

    public int getArgumentlength() {
        return new TypeSignature(this.getInternalSig()).getArgumentlength();
    }

    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    public int[] get_exc_index_table() {
        return this.exc_index_table;
    }

    public Vector getAttributes() {
        return this.attrs;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }
}

