/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Arrays;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArraySorter;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArraySorterTest
extends AbstractLangTest {
    @Test
    public void testSortByteArray() {
        byte[] array1 = new byte[]{2, 1};
        byte[] array2 = (byte[])array1.clone();
        Arrays.sort(array1);
        Assertions.assertArrayEquals((byte[])array1, (byte[])ArraySorter.sort((byte[])array2));
        Assertions.assertNull((Object)ArraySorter.sort((byte[])null));
    }

    @Test
    public void testSortCharArray() {
        char[] array1 = new char[]{'\u0002', '\u0001'};
        char[] array2 = (char[])array1.clone();
        Arrays.sort(array1);
        Assertions.assertArrayEquals((char[])array1, (char[])ArraySorter.sort((char[])array2));
        Assertions.assertNull((Object)ArraySorter.sort((char[])null));
    }

    @Test
    public void testSortComparable() {
        Object[] array1 = (String[])ArrayUtils.toArray((Object[])new String[]{"foo", "bar"});
        Object[] array2 = (String[])array1.clone();
        Arrays.sort(array1);
        Assertions.assertArrayEquals((Object[])array1, (Object[])ArraySorter.sort((Object[])array2, String::compareTo));
        Assertions.assertNull((Object)ArraySorter.sort((Object[])null));
    }

    @Test
    public void testSortDoubleArray() {
        double[] array1 = new double[]{2.0, 1.0};
        double[] array2 = (double[])array1.clone();
        Arrays.sort(array1);
        Assertions.assertArrayEquals((double[])array1, (double[])ArraySorter.sort((double[])array2));
        Assertions.assertNull((Object)ArraySorter.sort((double[])null));
    }

    @Test
    public void testSortFloatArray() {
        float[] array1 = new float[]{2.0f, 1.0f};
        float[] array2 = (float[])array1.clone();
        Arrays.sort(array1);
        Assertions.assertArrayEquals((float[])array1, (float[])ArraySorter.sort((float[])array2));
        Assertions.assertNull((Object)ArraySorter.sort((float[])null));
    }

    @Test
    public void testSortIntArray() {
        int[] array1 = new int[]{2, 1};
        int[] array2 = (int[])array1.clone();
        Arrays.sort(array1);
        Assertions.assertArrayEquals((int[])array1, (int[])ArraySorter.sort((int[])array2));
        Assertions.assertNull((Object)ArraySorter.sort((int[])null));
    }

    @Test
    public void testSortLongArray() {
        long[] array1 = new long[]{2L, 1L};
        long[] array2 = (long[])array1.clone();
        Arrays.sort(array1);
        Assertions.assertArrayEquals((long[])array1, (long[])ArraySorter.sort((long[])array2));
        Assertions.assertNull((Object)ArraySorter.sort((long[])null));
    }

    @Test
    public void testSortObjects() {
        Object[] array1 = (String[])ArrayUtils.toArray((Object[])new String[]{"foo", "bar"});
        Object[] array2 = (String[])array1.clone();
        Arrays.sort(array1);
        Assertions.assertArrayEquals((Object[])array1, (Object[])ArraySorter.sort((Object[])array2));
        Assertions.assertNull((Object)ArraySorter.sort((Object[])null));
    }

    @Test
    public void testSortShortArray() {
        short[] array1 = new short[]{2, 1};
        short[] array2 = (short[])array1.clone();
        Arrays.sort(array1);
        Assertions.assertArrayEquals((short[])array1, (short[])ArraySorter.sort((short[])array2));
        Assertions.assertNull((Object)ArraySorter.sort((short[])null));
    }
}

