//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uikeymodifierflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIKeyModifierFlags(pub NSInteger);
bitflags::bitflags! {
    impl UIKeyModifierFlags: NSInteger {
        #[doc(alias = "UIKeyModifierAlphaShift")]
        const AlphaShift = 1<<16;
        #[doc(alias = "UIKeyModifierShift")]
        const Shift = 1<<17;
        #[doc(alias = "UIKeyModifierControl")]
        const Control = 1<<18;
        #[doc(alias = "UIKeyModifierAlternate")]
        const Alternate = 1<<19;
        #[doc(alias = "UIKeyModifierCommand")]
        const Command = 1<<20;
        #[doc(alias = "UIKeyModifierNumericPad")]
        const NumericPad = 1<<21;
    }
}

unsafe impl Encode for UIKeyModifierFlags {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIKeyModifierFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// Represents an alternate action to take for a command.
    ///
    /// Two alternates are equal iff their modifierFlags are equal.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicommandalternate?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICommandAlternate;
);

extern_conformance!(
    unsafe impl NSCoding for UICommandAlternate {}
);

extern_conformance!(
    unsafe impl NSCopying for UICommandAlternate {}
);

unsafe impl CopyingHelper for UICommandAlternate {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICommandAlternate {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UICommandAlternate {}
);

impl UICommandAlternate {
    extern_methods!(
        /// Short display title.
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub fn title(&self) -> Retained<NSString>;

        /// Action to take on choosing this command alternate.
        #[unsafe(method(action))]
        #[unsafe(method_family = none)]
        pub fn action(&self) -> Sel;

        /// Bitmask of modifier flags to choose this command alternate.
        #[unsafe(method(modifierFlags))]
        #[unsafe(method_family = none)]
        pub fn modifierFlags(&self) -> UIKeyModifierFlags;

        /// Initialize an alternate action to take for a command.
        ///
        ///
        /// Parameter `title`: Short display title. This should be localized.
        ///
        /// Parameter `action`: Action to take on choosing this command alternate.
        ///
        /// Parameter `modifierFlags`: Bitmask of modifier flags to choose this command alternate.
        ///
        /// Returns: A new command alternate.
        ///
        /// # Safety
        ///
        /// `action` must be a valid selector.
        #[unsafe(method(alternateWithTitle:action:modifierFlags:))]
        #[unsafe(method_family = none)]
        pub unsafe fn alternateWithTitle_action_modifierFlags(
            title: &NSString,
            action: Sel,
            modifier_flags: UIKeyModifierFlags,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

extern_class!(
    /// Represents an action to take.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicommand?language=objc)
    #[unsafe(super(UIMenuElement, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIMenuElement")]
    pub struct UICommand;
);

#[cfg(feature = "UIMenuElement")]
extern_conformance!(
    unsafe impl NSCoding for UICommand {}
);

#[cfg(feature = "UIMenuElement")]
extern_conformance!(
    unsafe impl NSCopying for UICommand {}
);

#[cfg(feature = "UIMenuElement")]
unsafe impl CopyingHelper for UICommand {
    type Result = Self;
}

#[cfg(feature = "UIMenuElement")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UICommand {}
);

#[cfg(feature = "UIMenuElement")]
extern_conformance!(
    unsafe impl NSSecureCoding for UICommand {}
);

#[cfg(all(feature = "UIMenuElement", feature = "UIMenuLeaf"))]
extern_conformance!(
    unsafe impl UIMenuLeaf for UICommand {}
);

#[cfg(feature = "UIMenuElement")]
impl UICommand {
    extern_methods!(
        /// Short display title.
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub fn title(&self) -> Retained<NSString>;

        /// Setter for [`title`][Self::title].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub fn setTitle(&self, title: &NSString);

        #[cfg(feature = "UIImage")]
        /// Image that can appear next to this command
        #[unsafe(method(image))]
        #[unsafe(method_family = none)]
        pub fn image(&self) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImage")]
        /// Setter for [`image`][Self::image].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setImage:))]
        #[unsafe(method_family = none)]
        pub fn setImage(&self, image: Option<&UIImage>);

        /// Elaborated title used in keyboard shortcut overlay.
        #[unsafe(method(discoverabilityTitle))]
        #[unsafe(method_family = none)]
        pub fn discoverabilityTitle(&self) -> Option<Retained<NSString>>;

        /// Setter for [`discoverabilityTitle`][Self::discoverabilityTitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setDiscoverabilityTitle:))]
        #[unsafe(method_family = none)]
        pub fn setDiscoverabilityTitle(&self, discoverability_title: Option<&NSString>);

        /// Action to take on choosing this command.
        #[unsafe(method(action))]
        #[unsafe(method_family = none)]
        pub unsafe fn action(&self) -> Sel;

        /// Property list object to distinguish commands, if needed.
        #[unsafe(method(propertyList))]
        #[unsafe(method_family = none)]
        pub fn propertyList(&self) -> Option<Retained<AnyObject>>;

        /// Command attributes.
        #[unsafe(method(attributes))]
        #[unsafe(method_family = none)]
        pub fn attributes(&self) -> UIMenuElementAttributes;

        /// Setter for [`attributes`][Self::attributes].
        #[unsafe(method(setAttributes:))]
        #[unsafe(method_family = none)]
        pub fn setAttributes(&self, attributes: UIMenuElementAttributes);

        /// State that can appear next to the command.
        #[unsafe(method(state))]
        #[unsafe(method_family = none)]
        pub fn state(&self) -> UIMenuElementState;

        /// Setter for [`state`][Self::state].
        #[unsafe(method(setState:))]
        #[unsafe(method_family = none)]
        pub fn setState(&self, state: UIMenuElementState);

        /// Alternates that differ in modifier flags, if any.
        #[unsafe(method(alternates))]
        #[unsafe(method_family = none)]
        pub fn alternates(&self) -> Retained<NSArray<UICommandAlternate>>;

        #[cfg(feature = "UIImage")]
        /// Initializes a keyless command.
        ///
        ///
        /// Parameter `title`: Short display title. This should be localized.
        ///
        /// Parameter `image`: Image that can appear next to this command, if needed.
        ///
        /// Parameter `action`: Action to take on choosing this command.
        ///
        /// Parameter `propertyList`: Property list object to distinguish commands, if needed.
        ///
        /// Returns: A new keyless command.
        ///
        /// # Safety
        ///
        /// - `action` must be a valid selector.
        /// - `property_list` should be of the correct type.
        #[unsafe(method(commandWithTitle:image:action:propertyList:))]
        #[unsafe(method_family = none)]
        pub unsafe fn commandWithTitle_image_action_propertyList(
            title: &NSString,
            image: Option<&UIImage>,
            action: Sel,
            property_list: Option<&AnyObject>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "UIImage")]
        /// Initializes a keyless command with alternates.
        ///
        ///
        /// Parameter `title`: Short display title. This should be localized.
        ///
        /// Parameter `image`: Image that can appear next to this command, if needed.
        ///
        /// Parameter `action`: Action to take on choosing this command.
        ///
        /// Parameter `propertyList`: Property list object to distinguish commands, if needed.
        ///
        /// Parameter `alternates`: Alternates that differ in modifier flags.
        ///
        /// Returns: A new keyless command with alternates.
        ///
        /// # Safety
        ///
        /// - `action` must be a valid selector.
        /// - `property_list` should be of the correct type.
        #[unsafe(method(commandWithTitle:image:action:propertyList:alternates:))]
        #[unsafe(method_family = none)]
        pub unsafe fn commandWithTitle_image_action_propertyList_alternates(
            title: &NSString,
            image: Option<&UIImage>,
            action: Sel,
            property_list: Option<&AnyObject>,
            alternates: &NSArray<UICommandAlternate>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicommandtagshare?language=objc)
    pub static UICommandTagShare: &'static NSString;
}
