/*   xfdiff_gui.c */

/*  xfdiff (a gtk frontend for diff)
 *  Copyright (C)  Edscott Wilson Garcia under GNU GPL
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* ***** Mikeb 4.5.1 Changes *****
 * Most changes have been made here otherwise its just the removal of connected functions.
 * Gui tidied up and enlarged.
 * Removed broken and redundant patch making code as it seems like it is eternally broken so its just a simple file difference viewer.
 * TODO fix population of combo boxes when a folder is selected...IF thats actually a useful function..otherwise lob that code too and just have 2 entry boxes instead.
 * */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gmodule.h>
#include <stdarg.h>

#include "xfdiff.h"
#include "xfdiff_dlg.h"
#include "xfdiff_misc.h"

#define COLOR_GDK	65535.0

/*extern GdkPixbuf *create_pixbuf(gchar *);*/

static GtkTargetEntry target_table[] = {
  {"text/uri-list", 0, TARGET_URI_LIST},
  {"STRING", 0, TARGET_STRING}
};
#define NUM_TARGETS (sizeof(target_table)/sizeof(GtkTargetEntry))

static GtkWidget *viewW;
	/*  */
static GtkTextBuffer *text;

/* static prototypes: */
/* GUI prototypes: */
static gint expose_event (GtkWidget * widget, GdkEventExpose * event);

/* CB prototypes: */
static void cb_do_patch (GtkWidget * widget, gpointer data);
static void cb_do_diff (GtkWidget * widget, gpointer data);

/******************** CB section ************************/

gchar *
get_rcfile(void){
  gchar *xdg_dir=g_build_filename(g_get_home_dir(),".config",NULL);
  gchar *xfdiff_dir=g_build_filename(xdg_dir,"xfdiff",NULL);
  gchar *rcfile=g_build_filename(xfdiff_dir,"xfdiffrc",NULL);

  if (!g_file_test(xdg_dir,G_FILE_TEST_IS_DIR)){
      if (mkdir(xdg_dir,0770)<0){
	  g_warning("%s: %s",xdg_dir, strerror(errno));
      }
  }
  if (!g_file_test(xfdiff_dir,G_FILE_TEST_IS_DIR)){
      if (mkdir(xfdiff_dir,0770)<0){
	  g_warning("%s: %s",xfdiff_dir, strerror(errno));
      }

  }  
  g_free(xdg_dir);
  g_free(xfdiff_dir);
  return rcfile; 
}

static
GdkPixbuf *xfdiff_icon(void)
{
    GdkPixbuf *pix;
    GError *error=NULL;
    gchar *filename=g_build_filename(PACKAGE_DATA_DIR,"pixmaps","xfdiff-icon.png",NULL);
    pix = gdk_pixbuf_new_from_file(filename, &error);
    if (error) {
        g_warning("filename: %s",error->message);
        g_error_free(error);
    }
    g_free(filename);
    return pix;
}

void
clear_text_buffer (GtkTextBuffer * buffer)
{
  if (!buffer)
    return;
  gtk_text_buffer_set_text (buffer, "", -1);

}


static void
cb_wheel (GtkWidget * widget, GdkEventButton * event, void *data)
{
  int new_adj;

  
  /*("cb_wheel");*/
  new_adj = (GTK_ADJUSTMENT (adj)->value);

  if (event->button == 4){
    new_adj -= (3 * lineH);	
  } 
  if (event->button == 5){
    new_adj += (3 * lineH);	
  }
  if (new_adj < 0)
    new_adj = 0;
  gtk_adjustment_set_value (GTK_ADJUSTMENT (adj), new_adj);
}

gboolean
on_drag_motion (GtkWidget * widget, GdkDragContext * dc, gint x, gint y, guint t, gpointer data)
{
  GdkDragAction action;
  
  action = GDK_ACTION_COPY;

  /* Respond with default drag action (status). First we check
   * the dc's list of actions. If the list only contains
   * move or copy then we select just that, otherwise we return
   * with our default suggested action.
   * If no valid actions are listed then we respond with 0.
   */

  if (dc->actions == GDK_ACTION_MOVE)			gdk_drag_status (dc, GDK_ACTION_MOVE, t);
  else if (dc->actions == GDK_ACTION_COPY)		gdk_drag_status (dc, GDK_ACTION_COPY, t);
  else if (dc->actions == GDK_ACTION_LINK)		gdk_drag_status (dc, GDK_ACTION_LINK, t);  
  else if (dc->actions & action)			gdk_drag_status (dc, action, t);
  else							gdk_drag_status (dc, 0, t);
  /*fprintf(stderr,"dbg: drag motion done...\n");*/
 
 return (TRUE);
}
	
static void
on_drag_data_received (GtkWidget * entry, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, void *client)
{
  char *text, *file;

  if ((data->length == 0) || (data->format != 8) || (info != TARGET_STRING))
  {
    gtk_drag_finish (context, FALSE, TRUE, time);
  }

  text = (char *) malloc (data->length + 1);
  strncpy (text, (char *) data->data, data->length);
  text[data->length] = '\0';

  if (strstr (text, "\n"))
    text = strtok (text, "\n");
  if (strncmp (text, "file:", strlen ("file:")) == 0)
  {
    file = text + strlen ("file:");
    {
      int i;
      for (i = 0; i < strlen (file); i++)
	if (file[i] == 13)
	  file[i] = 0;
    }

      if (entry == viewR)
      {
	filename[1] = assign (filename[1], file);
	fileRD = assign (fileRD, checkdir (file) ? file : NULL);
      }
      else
      {
	filename[0] = assign (filename[0], file);
	fileLD = assign (fileLD, checkdir (file) ? file : NULL);
      }

    update_titlesP ();
    cleanF ();
    cleanP ();
    cleanA ();
    cleanT ();
  }
  gtk_drag_finish (context, TRUE, TRUE, time);
  free (text);
}


#define DIFF_MENUS 4


static GtkWidget *diffM[DIFF_MENUS];


static void
hideshow_menus (void)
{
  gint i;

    for (i = 0; i < DIFF_MENUS; i++)
	gtk_widget_show (diffM[i]);

}


static void
cb_toggle_synchronize (GtkWidget * widget, gpointer data)
{
  synchronize = !synchronize;
  if (silent)
    show_diag (_("Line synchronization enabled.\n"));
  else
    show_diag (_("Line synchronization disabled.\n"));
#ifdef AUTOSAVE
  cb_save_defaults (NULL, NULL);
#endif
  {
    int old_adj = 0;
    polygon *thisP;
    if (current)
    {
      old_adj = current->topLR;
    }

      cb_do_diff (NULL, (gpointer) ((int) 0));
    thisP = head;
    while (thisP)
    {
      if (thisP->topLR == old_adj)
      {
	old_adj = thisP->topR;
	break;
      }
      thisP = thisP->next;
    }
    current = thisP;
    gtk_adjustment_set_value (GTK_ADJUSTMENT (adj), old_adj);
  }

}


static void
cb_toggle_show_lineN (GtkWidget * widget, gpointer data)
{
  show_lineN = !show_lineN;
  if (show_lineN)
    show_diag (_("Line numbers enabled.\n"));
  else
    show_diag (_("Line numbers disabled.\n"));
#ifdef AUTOSAVE
  cb_save_defaults (NULL, NULL);
#endif
  configure_event (drawA, NULL);
}

static void
cb_toggle_filledP (GtkWidget * widget, gpointer data)
{
  filledP = !filledP;
  if (filledP)
    show_diag (_("Polygons will now be filled.\n"));
  else
    show_diag (_("Polygons will now *not* be filled.\n"));
#ifdef AUTOSAVE
  cb_save_defaults (NULL, NULL);
#endif
  configure_event (drawA, NULL);
}


static void
cb_select_colors (GtkWidget * widget, gpointer data)
{
  char *newcolor;
  GtkStyle *style;
  int caso;
  
  caso = (long) data;

  style = gtk_widget_get_style (viewR);
  /* initial colors defined in getdefaults() */

  switch (caso)
  {
  case 1:
    newcolor = xf_colorselect (_("Select highlight background color"), &colorbg);
    break;
  default:
    newcolor = xf_colorselect (_("Select highlight text color"), &colorfg);
    break;
  }
  if (newcolor)
  {
    int old_silent, old_adj;

    set_highlight ();

    old_silent = silent;
    silent = 1;
    old_adj = (GTK_ADJUSTMENT (adj)->value);

    silent = old_silent;
    gtk_adjustment_set_value (GTK_ADJUSTMENT (adj), old_adj);
#ifdef AUTOSAVE
    cb_save_defaults (NULL, NULL);
#endif
  }
}


static void
cb_do_diff (GtkWidget * widget, gpointer data)
{
  cleanP ();
  cleanA ();
  cleanT ();
  do_diff ();
}


static void
cb_do_patch (GtkWidget * widget, gpointer data)
{
  gchar *s = NULL;
  patched_file *thisF;
  int from_menu;
  from_menu = (int) data;

  cleanP ();
  cleanA ();
  cleanT ();
  if (from_menu)
    cleanF ();			/* force a new patch run if selected from menu */

  if (!headF)
  {

      cb_do_diff (widget, data);

    return;
  }

  /* s must be g_freed now. */
  s = gtk_editable_get_chars (GTK_EDITABLE (GTK_COMBO (titleD)->entry), 0, -1);
  thisF = headF;
  while (thisF)
  {
    if (strcmp (s, thisF->file) == 0)
      break;
    thisF = thisF->next;
  }
  if (thisF)
    currentF = thisF;
  else
  {
    gchar *texto=NULL;

      texto = g_strdup_printf(_("Warning: cannot read from %s"),s);

    xf_dlg_info (diff,texto);
    g_free (texto);
    
    g_free (s);s=NULL;
    return;
  }

    filename[0] = assign (filename[0], currentF->file);
    filename[1] = assign (filename[1], currentF->newfile);
    do_diff ();
 
  first_diff ();
  update_titlesP ();

  g_free (s);s=NULL;
  return;
}


static void
cb_do_diff_new (GtkWidget * widget, gpointer data)
{
  char Pstrip[4];
  char *Pright, *Pleft;
  char *arguments[10];
  int argc = 0;


  arguments[argc++] = "xfdiff4";

  strcpy (Pstrip, "-P");
  Pstrip[2] = strip + '0';
  Pstrip[3] = 0;
  arguments[argc++] = Pstrip;

    arguments[argc++] = "-N";

    if (fileRD)
      Pright = fileRD;
    else
      Pright = filename[1];
    if (fileLD)
      Pleft = fileLD;
    else
      Pleft = filename[0];

  if (Pleft)
    arguments[argc++] = Pleft;
  if ((Pright) && (Pleft))
    arguments[argc++] = Pright;
  arguments[argc++] = (char *) 0;

  if (fork ())
  {				/*  parent will fork to new  */
    execvp ("xfdiff4", arguments);
    perror ("exec");
    _exit (127);		/* parent never gets here (hopefully) */
  }
  return;
}


void
cb_save_defaults (GtkWidget * widget, gpointer data)
{
  FILE *defaults;
  gchar *rcfile=get_rcfile();
  gchar *m=NULL;
    
  defaults = fopen (rcfile, "w");

  if (!defaults)
  {
    m=g_strdup_printf(_("%s cannot be created\n"),rcfile);
    xf_dlg_warning(diff,m);
    g_free(m);
    g_free(rcfile);
    return;
  }
  
  fprintf (defaults, "# file created by xfdiff, if removed xfdiff returns to Xfce defaults.\n");
  fprintf (defaults, "colorfg.red : %d\n", colorfg.red);
  fprintf (defaults, "colorfg.green : %d\n", colorfg.green);
  fprintf (defaults, "colorfg.blue : %d\n", colorfg.blue);
  fprintf (defaults, "colorbg.red : %d\n", colorbg.red);
  fprintf (defaults, "colorbg.green : %d\n", colorbg.green);
  fprintf (defaults, "colorbg.blue : %d\n", colorbg.blue);

  fprintf (defaults, "filledP : %d\n", filledP);
  fprintf (defaults, "show_lineN : %d\n", show_lineN);
  fprintf (defaults, "synchronize : %d\n", synchronize);
#ifdef GNU_PATCH
  fprintf (defaults, "verbose : %d\n", verbose);
#endif
  fclose (defaults);
#ifndef AUTOSAVE
  m=g_strdup_printf(_("Configuration saved in %s\n"),rcfile);
  xf_dlg_warning(diff,m);
#endif
  g_free(rcfile);
  g_free(m);
  
  return;
}

static void
cb_about (GtkWidget * widget, gpointer data)
{
    gchar *message=g_strdup_printf(_("%s: Graphical differences viewer\n%s\nhttp://xffm.sf.net/xfdiff.html\nTidied by mikeb\n"),PACKAGE_STRING,PACKAGE_COPYRIGHT);
    show_diag(message);
    g_free(message);
}

void
cb_next_diff (GtkWidget * widget, gpointer data)
{
  int value;
  gchar *g=NULL;
  long next;
  next = (long) data;
  
  if (!current) return;
  {
    if (next)
    {
      if (current->next){
	current = current->next;
	g=g_strdup_printf(_("Showing difference number %d"),current->id);
      }
      else {
	  if (diff_is_done) g=g_strdup_printf(_("There is no next difference"));
	  else g=g_strdup_printf(_("Diff run has not finished"));
      }
    }
    else
    {
      if (current->previous){
	current = current->previous;
	g=g_strdup_printf(_("Showing difference number %d"),current->id);
      }
      else {
	  if (diff_is_done) g=g_strdup_printf(_("There is no previous difference"));
	  else g=g_strdup_printf(_("Diff run has not finished"));
      }
    }
    if (g) {
	show_diag("xfdiff> ");show_diag(g);show_diag("\n");
	g_free(g);
    }

    value = (current->topR < current->topL) ?
	current->topR : current->topL;
    if (value >= lineH)
      value -= lineH;
    else
      value = 0;
  }
  gtk_adjustment_set_value (GTK_ADJUSTMENT (adj), value);
  configure_event (drawA, NULL);
  cb_adjust ((GtkAdjustment *) adj, NULL);
}

static void
cb_next_file (GtkWidget * widget, gpointer data)
{
  long next;
  next = (long) data;
  if (currentF == NULL)
  {
    xf_dlg_warning(diff,("There is no such file"));
    return;
  }

  if (next)
  {
    if (currentF->next)
      currentF = currentF->next;
    else
    {
      xf_dlg_warning(diff,("There is no next file"));
      return;
    }

  }
  else
  {
    if (currentF->previous)
      currentF = currentF->previous;
    else
    {
      xf_dlg_warning(diff,("There is no previous file"));
      return;
    }
  }

  cleanT ();
  cleanP ();

    filename[0] = assign (filename[0], currentF->file);
    filename[1] = assign (filename[1], currentF->newfile);
    do_diff ();

  update_titlesP ();
  first_diff ();
}

void
cb_adjust (GtkAdjustment * adj, GtkWidget * widget)
{
  GdkEventExpose event;

  /*("value=%lf",GTK_ADJUSTMENT (adj)->value);*/
  gtk_adjustment_set_value (GTK_ADJUSTMENT (adjR), GTK_ADJUSTMENT (adj)->value);

  event.area.x = 0;
  event.area.y = 0;
  event.area.width = drawA->allocation.width;
  event.area.height = drawA->allocation.height;
  configure_event (drawA, NULL);
}

/* spot 2/3 where filename[1] and filename[0] come in */
static void
cb_get_fileR (GtkWidget * widget, gpointer data)
{
  filename[1] = get_the_file (filename[1]);
  fileRD = assign (fileRD, checkdir (filename[1]) ? filename[1] : NULL);
  update_titlesP ();
  cleanP ();
  cleanA ();
}

static void
cb_get_fileL (GtkWidget * widget, gpointer data)
{
  filename[0] = get_the_file (filename[0]);
  fileLD = assign (fileLD, checkdir (filename[0]) ? filename[0] : NULL);
  update_titlesP ();
  cleanP ();
  cleanA ();
}


/********************  GUI section **********************/

gint
configure_event (GtkWidget * widget, GdkEventConfigure * event)
{
  int height;
  PangoLayout *layout = NULL;
  PangoRectangle logical_rect;

  if (widget->window == NULL)
    return FALSE;

  /* if height definition is changed, watchout at function cleanA() */
  height = 3 * widget->allocation.height;
  if (drawP)
    g_object_unref (G_OBJECT(drawP));
  drawP = gdk_pixmap_new (widget->window, widget->allocation.width, height, -1);
  gdk_draw_rectangle (drawP, widget->style->bg_gc[GTK_WIDGET_STATE (widget)], TRUE, 0, 0, widget->allocation.width, height);
  
#define Y1 (thisP->topL - GTK_ADJUSTMENT (adj)->value + widget->allocation.height)
#define Y2 (thisP->topR - GTK_ADJUSTMENT (adj)->value + widget->allocation.height)
#define Y3 (thisP->botR - GTK_ADJUSTMENT (adj)->value + widget->allocation.height)
#define Y4 (thisP->botL - GTK_ADJUSTMENT (adj)->value + widget->allocation.height)
#define H  (widget->allocation.height)
#define W  (widget->allocation.width)
  {
    polygon *thisP;
    GdkRectangle update_rect;
    GdkPoint pt[4];
    update_rect.x = 0;
    update_rect.y = 0;
    update_rect.width = W;
    update_rect.height = H;
    thisP = head;
    while (thisP)
    {
      /* is it in the update region? */
      if (((Y1 <= 3 * H) || (Y2 <= 3 * H)) && ((Y3 >= 0) || (Y4 >= 0)))
      {
	pt[0].x = 0;
	pt[0].y = (Y1 > 3 * H) ? 3 * H : (Y1 < 0) ? 0 : Y1;
	pt[1].x = W;
	pt[1].y = (Y2 > 3 * H) ? 3 * H : (Y2 < 0) ? 0 : Y2;
	pt[2].x = W;
	pt[2].y = (Y3 > 3 * H) ? 3 * H : (Y3 < 0) ? 0 : Y3;
	pt[3].x = 0;
	pt[3].y = (Y4 > 3 * H) ? 3 * H : (Y4 < 0) ? 0 : Y4;
	gdk_draw_polygon (drawP, drawGC, filledP, pt, 4);
	if (show_lineN)
	{
	  char number[32];
	  int x;
	  sprintf (number, "%d", thisP->topLL);
          layout = gtk_widget_create_pango_layout(widget, number);
          gdk_draw_layout(drawP, fileGC, 0, pt[0].y , layout);
          g_object_unref(G_OBJECT(layout));
	  if (pt[3].y >= pt[0].y + lineH * 2)
	  {
	    sprintf (number, "%d", thisP->botLL);
            layout = gtk_widget_create_pango_layout(widget, number);
            gdk_draw_layout(drawP, fileGC, 0, pt[3].y - lineH, layout);
            g_object_unref(G_OBJECT(layout));
	  }
	  sprintf (number, "%d", thisP->topLR);
          layout = gtk_widget_create_pango_layout(widget, number);
          pango_layout_get_pixel_extents(layout, NULL, &logical_rect);
	  x = W - logical_rect.width;
	  if (x < 0)
	    x = 0;
          gdk_draw_layout(drawP, fileGC, x, pt[1].y, layout);
          g_object_unref(G_OBJECT(layout));
	  if (pt[2].y >= pt[1].y + lineH * 2)
	  {
	    sprintf (number, "%d", thisP->botLR);
            layout = gtk_widget_create_pango_layout(widget, number);
            pango_layout_get_pixel_extents(layout, NULL, &logical_rect);
	    x = W - logical_rect.width;
	    if (x < 0)
	      x = 0;
            gdk_draw_layout(drawP, fileGC, x, pt[2].y - lineH, layout);
            g_object_unref(G_OBJECT(layout));
	  }
	}			/* end if in update region */
      }
      thisP = thisP->next;
    }
    gtk_widget_queue_draw_area (drawA, update_rect.x, update_rect.y, update_rect.width, update_rect.height);
  }
  return TRUE;
}



static gint
expose_event (GtkWidget * widget, GdkEventExpose * event)
{
  gdk_draw_drawable (widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)], drawP, event->area.x, event->area.y + H, event->area.x, event->area.y, event->area.width, event->area.height);

  return FALSE;
}



static void
delete_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  gtk_widget_hide(diff);
  while (gtk_events_pending()) gtk_main_iteration();
  xfdiff_abort (E_CLEANUP);
}


#define TOGGLENOT 4
#define TOGGLE 3
#define EMPTY_SUBMENU 2
#define SUBMENU 1
#define MENUBAR 0
#define RIGHT_MENU -1

static GtkWidget *
shortcut_menu (int submenu, GtkWidget * parent, char *txt, gpointer func, gpointer data)
{
  GtkWidget *menuitem;
  static GtkWidget *menu;
  int togglevalue;

  switch (submenu)
  {
  case TOGGLE:
  case TOGGLENOT:
    togglevalue = (int) data;
    menuitem = gtk_check_menu_item_new_with_label (txt);
    GTK_CHECK_MENU_ITEM (menuitem)->active = (submenu == TOGGLENOT) ? (!togglevalue) : togglevalue;
    /* gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (menuitem), 1); */
    break;
  case EMPTY_SUBMENU:
    menuitem = gtk_menu_item_new ();
    break;
  case RIGHT_MENU:
    menuitem = gtk_menu_item_new_with_label (txt);
    gtk_menu_item_set_right_justified  (GTK_MENU_ITEM (menuitem), TRUE);
    break;
  case SUBMENU:
  case MENUBAR:
  default:
    menuitem = gtk_menu_item_new_with_label (txt);
    break;
  }
  if (submenu > 0)
  {
    /*  */
    gtk_menu_shell_append (GTK_MENU_SHELL (parent), menuitem);
    if ((submenu) && (submenu != EMPTY_SUBMENU) && (func))
      g_signal_connect (G_OBJECT (menuitem), "activate", G_CALLBACK (func), (gpointer) data);
  }
  else
    gtk_menu_shell_append (GTK_MENU_SHELL (parent), menuitem);
  gtk_widget_show (menuitem);

  if (submenu <= 0)
  {
    menu = gtk_menu_new ();
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), menu);
    return menu;

  }
  return menuitem;
}

static GtkWidget *
create_menu (GtkWidget * top)
{
  GtkWidget *menu, *menubar;
  int i;

  menubar = gtk_menu_bar_new ();
  gtk_widget_show (menubar);

  for (i = 0; i < DIFF_MENUS; i++)
    diffM[i] = NULL;
  /* Create "File" menu */
  menu = shortcut_menu (MENUBAR, menubar, _("File"), NULL, NULL);
  diffM[0] = shortcut_menu (SUBMENU, menu, _("Select left file"), (gpointer) cb_get_fileL, NULL);
  diffM[1] = shortcut_menu (SUBMENU, menu, _("Select right file"), (gpointer) cb_get_fileR, NULL);

  shortcut_menu (EMPTY_SUBMENU, menu, NULL, NULL, NULL);
  shortcut_menu (SUBMENU, menu, _("Exit"), (gpointer) delete_event, NULL);

  /* Create "Settings" menu */
  menu = shortcut_menu (MENUBAR, menubar, _("Diff Settings"), NULL, NULL);

  shortcut_menu (SUBMENU, menu, _("Highlight text color"), (gpointer) cb_select_colors, (gpointer) ((long) 0));
  shortcut_menu (SUBMENU, menu, _("Highlight background color"), (gpointer) cb_select_colors, (gpointer) ((long) 1));
  shortcut_menu (TOGGLE, menu, _("Fill polygons"), (gpointer) cb_toggle_filledP, (gpointer) filledP);
  shortcut_menu (TOGGLE, menu, _("Show line numbers"), (gpointer) cb_toggle_show_lineN, (gpointer) show_lineN);

  shortcut_menu (TOGGLE, menu, _("Use line synchronization voids"),

		 (gpointer) cb_toggle_synchronize, (gpointer) synchronize);

#ifndef AUTOSAVE
  shortcut_menu (EMPTY_SUBMENU, menu, NULL, NULL, NULL);
  shortcut_menu (SUBMENU, menu, _("Save settings as default"), (gpointer) cb_save_defaults, NULL);
#endif


  /* Create "Actions" menu */
  menu = shortcut_menu (MENUBAR, menubar, _("Actions"), NULL, NULL);
  diffM[2] = shortcut_menu (SUBMENU, menu, _("View differences"), (gpointer) cb_do_diff, (gpointer) ((int) 1));
  diffM[3] = shortcut_menu (SUBMENU, menu, _("View differences in new"), (gpointer) cb_do_diff_new, (gpointer) ((int) 1));

  /* Create "Help" menu */
  menu = shortcut_menu (MENUBAR, menubar, _("Help"), NULL, NULL);
  shortcut_menu (SUBMENU, menu, _("About"), (gpointer) cb_about, NULL);

  /* hide and show whatever */
  hideshow_menus ();

  return menubar;
}

static void
on_clear_show_diag (GtkWidget * widget, gpointer data)
{
  void clear_text_buffer (GtkTextBuffer * buffer);
  clear_text_buffer ((GtkTextBuffer *) data);
}

void
show_diag (gchar * message)
{
    GtkTextIter start, end;
    GtkTextMark *mark;
    if ((!message) || (!strlen (message)))
    return;

  utf8_insert (text, message);
    gtk_text_buffer_get_bounds((GtkTextBuffer *)text, &start, &end);
    mark = gtk_text_buffer_create_mark(text, "scrollmark", &end, FALSE);
    gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(view_diag), mark, 0.2,	/*gdouble within_margin, */
				 FALSE, 0.0, 0.0);
    gtk_text_buffer_delete_mark((GtkTextBuffer *)text, mark);
  gdk_flush();
  return;
}


static GtkWidget *
shortcut_button (GtkWidget * box, char *txt, gpointer func, gpointer data,gboolean stock)
{
  static GtkWidget *button = NULL;
  if (stock) {
	  button = gtk_button_new_from_stock(txt);
	  /*gtk_button_set_label (button,"OK");*/
  }
  else button = gtk_button_new_with_mnemonic (txt);
  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (func), (gpointer) data);
  if (box != NULL)
  {
/*	  gtk_container_add (GTK_CONTAINER (box), button);*/
    gtk_box_pack_start (GTK_BOX (box), button, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
    gtk_widget_show (button);
  }
  return button;
}

GtkWidget *
create_diff_window (void)
{
  GtkWidget *vbox, *vbox1, *vbox1a, *vbox1b, *vbox2, *vbox3, *vbox4, *hbox3;
  GtkWidget *hbox, *menutop, *handlebox;
  GtkWidget *bbox, *vscrollbar, *button;
  GtkWidget *view, *viewL, *vpaned, *scrolled_window;
  GtkWidget *scrolled_windowR, *scrolled_windowL;
  PangoLayout *layout = NULL;
  PangoRectangle logical_rect;
  GdkPixbuf *icon_pixbuf;
  /*guint drawW;*/

  get_defaults ();
  diff = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  icon_pixbuf=xfdiff_icon();

  if (icon_pixbuf){
      gtk_window_set_icon (GTK_WINDOW (diff), icon_pixbuf);
      g_object_unref (G_OBJECT(icon_pixbuf));   
  }

  g_signal_connect (G_OBJECT (diff), "destroy", G_CALLBACK (delete_event), (gpointer) GTK_WIDGET (diff));
  g_signal_connect (G_OBJECT (diff), "destroy_event", G_CALLBACK (delete_event), (gpointer) GTK_WIDGET (diff));
  g_signal_connect (G_OBJECT (diff), "delete_event", G_CALLBACK (delete_event), (gpointer) GTK_WIDGET (diff));
/* menu */
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (diff), vbox);
  gtk_widget_show (vbox);

  handlebox = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX (vbox), handlebox, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (handlebox), 0);
  gtk_widget_show (handlebox);

  menutop = create_menu (diff);
  gtk_container_add (GTK_CONTAINER (handlebox), menutop);

  gtk_widget_show (menutop);

  gtk_window_set_position (GTK_WINDOW (diff), GTK_WIN_POS_MOUSE);
  gtk_window_set_title (GTK_WINDOW (diff), "Xfdiff");
  gtk_widget_realize (diff);

/* box arrangement */
  vpaned = gtk_vpaned_new ();
  gtk_widget_ref (vpaned);
  g_object_set_data (G_OBJECT (diff), "vpaned", vpaned);
  gtk_box_pack_start (GTK_BOX (vbox), vpaned, TRUE, TRUE, 0);
  gtk_widget_show (vpaned);

  bbox = gtk_hbox_new (FALSE, 0);
  gtk_paned_pack1 (GTK_PANED (vpaned), bbox, TRUE, TRUE);
  gtk_widget_show (bbox);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (bbox), vbox1, TRUE, TRUE, 0);
  gtk_widget_show (vbox1);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (bbox), vbox2, FALSE, TRUE, 0);
  gtk_widget_show (vbox2);

  vbox1a = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox1), vbox1a, FALSE, TRUE, 0);
  gtk_widget_show (vbox1a);

  vbox1b = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox1), vbox1b, TRUE, TRUE, 0);
  gtk_widget_show (vbox1b);

  adj = gtk_adjustment_new (0, 0, 0, 0, 0, 0);
  adjR = gtk_adjustment_new (0, 0, 0, 0, 0, 0);
  vscrollbar = gtk_vscrollbar_new (GTK_ADJUSTMENT (adj));

  gtk_box_pack_start (GTK_BOX (vbox2), vscrollbar, TRUE, TRUE, 0);
  gtk_widget_show (vscrollbar);

  /* invisible box : */
/*seems shared button for both modes...messy*/
  patchbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox1a), patchbox, TRUE, TRUE, 0);
  gtk_widget_show (patchbox);
/*beware goes  through patch call even in diff mode*/
  titleD = gtk_combo_new ();
  
  OKbutton = button = shortcut_button (NULL, GTK_STOCK_APPLY,  (gpointer) cb_do_patch, (gpointer) ((int) 0),TRUE);
  
  /* this is the good place for lineH */
  layout = gtk_widget_create_pango_layout(titleD,"W");
  pango_layout_get_pixel_extents(layout, NULL, &logical_rect);
  lineH= logical_rect.height;
  lineW = 3*logical_rect.width/4;
  g_object_unref(layout);
  
  titleP = gtk_combo_new ();
  
  gtk_widget_set_size_request (titleP, sizeL * lineW , 2*lineH);
  gtk_widget_set_size_request (titleD, sizeL * lineW , 2*lineH);
  
  button = shortcut_button (patchbox,  GTK_STOCK_OPEN, (gpointer) cb_get_fileL, NULL, TRUE);
  gtk_box_pack_start (GTK_BOX (patchbox), titleD, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (patchbox), OKbutton, FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (patchbox), titleP, TRUE, TRUE, 0);
  button = shortcut_button (patchbox,   GTK_STOCK_OPEN, (gpointer) cb_get_fileR, NULL,TRUE);

  gtk_widget_show (titleP);
  gtk_widget_show (titleD);
  gtk_widget_show (OKbutton);

  /* text boxes : */

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox1b), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  /* viewL should be using horiz-adjust adj!!!! */
  scrolled_windowL = gtk_scrolled_window_new (NULL, GTK_ADJUSTMENT (adj));
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_windowL), GTK_POLICY_AUTOMATIC, GTK_POLICY_NEVER);
  gtk_widget_show (scrolled_windowL);

  viewL = gtk_text_view_new ();
  text_buffer[0] = gtk_text_view_get_buffer (GTK_TEXT_VIEW (viewL));
  gtk_text_view_set_cursor_visible ((GtkTextView *) viewL, FALSE);
  gtk_text_view_set_editable ((GtkTextView *) viewL, FALSE);
  gtk_text_view_set_wrap_mode ((GtkTextView *) viewL, GTK_WRAP_NONE);
  /* boosted size a bit here and below by 1.5*/
  gtk_widget_set_size_request (viewL, sizeL * lineW *1.5, sizeH * lineH *1.6);
  gtk_container_add (GTK_CONTAINER (scrolled_windowL), viewL);

  scrolled_windowR = gtk_scrolled_window_new (NULL, GTK_ADJUSTMENT (adjR));
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_windowR), GTK_POLICY_AUTOMATIC, GTK_POLICY_NEVER);
  gtk_widget_show (scrolled_windowR);
  
  viewR = gtk_text_view_new ();
  text_buffer[1] = gtk_text_view_get_buffer (GTK_TEXT_VIEW (viewR));
  gtk_text_view_set_cursor_visible ((GtkTextView *) viewR, FALSE);
  gtk_text_view_set_editable ((GtkTextView *) viewR, FALSE);
  gtk_text_view_set_wrap_mode ((GtkTextView *) viewR, GTK_WRAP_NONE);
  gtk_widget_set_size_request (viewR, sizeL * lineW *1.5, sizeH * lineH *1.6);
  gtk_container_add (GTK_CONTAINER (scrolled_windowR), viewR);
  
  /*drawA shows the linked line numbers between panes..must be left as is to work properly*/
  drawA = gtk_drawing_area_new ();

  gtk_box_pack_start (GTK_BOX (hbox), scrolled_windowL, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), drawA, FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), scrolled_windowR, TRUE, TRUE, 0);

  gtk_widget_show (scrolled_windowL);
  gtk_widget_show (viewL);
  gtk_widget_show (drawA);
  gtk_widget_show (viewR);
  gtk_widget_show (scrolled_windowR);

/* log */
  bbox = gtk_hbox_new (FALSE, 0);
  gtk_paned_pack2 (GTK_PANED (vpaned), bbox, TRUE, FALSE);
  gtk_widget_show (bbox);

  scrolled_window = gtk_scrolled_window_new (NULL, NULL);

  gtk_box_pack_start (GTK_BOX (bbox), scrolled_window, TRUE, TRUE, 0);
  
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_ALWAYS);
  gtk_widget_show (scrolled_window);
  {
    view_diag = gtk_text_view_new ();
    text = gtk_text_view_get_buffer (GTK_TEXT_VIEW (view_diag));
    gtk_text_view_set_cursor_visible ((GtkTextView *) view_diag, FALSE);
    gtk_text_view_set_editable ((GtkTextView *) view_diag, FALSE);
    gtk_text_view_set_wrap_mode ((GtkTextView *) view_diag, GTK_WRAP_NONE);
    gtk_widget_show (view_diag);
    gtk_container_add (GTK_CONTAINER (scrolled_window), view_diag);
  }
  
  /*moved buttons up to here for neatness*/
  vbox3 = gtk_vbox_new (FALSE, 0);
  vbox4 = gtk_vbox_new (FALSE, 0);
  
  button = shortcut_button (vbox3, GTK_STOCK_GO_UP, (gpointer) cb_next_diff, (gpointer) ((long) 0),TRUE);
  button = shortcut_button (vbox3, GTK_STOCK_GO_DOWN, (gpointer) cb_next_diff, (gpointer) ((long) 1),TRUE);
  
  button = shortcut_button (vbox4, GTK_STOCK_CLEAR, (gpointer) on_clear_show_diag, (gpointer) text,TRUE);
  button = shortcut_button (vbox4, GTK_STOCK_QUIT, (gpointer) delete_event, NULL,TRUE);

  gtk_box_pack_start (GTK_BOX (bbox), vbox3, FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (bbox), vbox4, FALSE, TRUE, 0);

  gtk_widget_show (vbox3);
  gtk_widget_show (vbox4);

/* last box on bottom */
 /* 
  next_file = shortcut_button (bbox, _("Next file"), (gpointer) cb_next_file, (gpointer) ((long) 1),FALSE);
  prev_file = shortcut_button (bbox, _("Previous file"), (gpointer) cb_next_file, (gpointer) ((long) 0),FALSE);*/
  /*combo box - file list not growing...meant when directory selected*/
 /*gtk_widget_hide(next_file);
  gtk_widget_hide(prev_file);
*/

  /* gtk_widget_set_events (drawA,GDK_EXPOSURE_MASK); */

  gtk_drag_dest_set (viewL, GTK_DEST_DEFAULT_ALL, target_table, NUM_TARGETS, GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);
  gtk_drag_dest_set (viewR, GTK_DEST_DEFAULT_ALL, target_table, NUM_TARGETS, GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);

  g_signal_connect (G_OBJECT (viewR), "drag_motion", G_CALLBACK (on_drag_motion), NULL);
  g_signal_connect (G_OBJECT (viewL), "drag_motion", G_CALLBACK (on_drag_motion), NULL);
  g_signal_connect (G_OBJECT (viewL), "drag_data_received", G_CALLBACK (on_drag_data_received), (gpointer) NULL);
  g_signal_connect (G_OBJECT (viewR), "drag_data_received", G_CALLBACK (on_drag_data_received), (gpointer) NULL);

  g_signal_connect (G_OBJECT (scrolled_windowR), "button_press_event", G_CALLBACK (cb_wheel), (gpointer) NULL);


  g_signal_connect (G_OBJECT (diff), "delete_event", G_CALLBACK (delete_event), (gpointer) GTK_WIDGET (diff));
  g_signal_connect (G_OBJECT (drawA), "configure_event", G_CALLBACK (configure_event), (gpointer) NULL);
  g_signal_connect (G_OBJECT (drawA), "expose_event", G_CALLBACK (expose_event), (gpointer) NULL);
  g_signal_connect (G_OBJECT (adj), "value_changed", G_CALLBACK (cb_adjust), (gpointer) adj);
  gtk_widget_show (diff);
  set_highlight ();
  
  gtk_widget_set_size_request (drawA, OKbutton->allocation.width, sizeH * lineH);

  return diff;
}
