#!/bin/bash
# Pipe filename must be unique for your application
PIPE="/tmp/gtk.bash.\$$"

# Find GTK-server configfile first
if [[ -f gtk-server.cfg ]]; then
    CFG=gtk-server.cfg
elif [[ -f /etc/gtk-server.cfg ]]; then
    CFG=/etc/gtk-server.cfg
elif [[ -f /usr/local/etc/gtk-server.cfg ]]; then
    CFG=/usr/local/etc/gtk-server.cfg
else
    echo "No GTK-server configfile found! Please install GTK-server..."
    exit 1
fi
# Now create global functionnames from GTK API
if [[ ! -f $HOME/.gtk4bash || $CFG -nt $HOME/.gtk4bash ]]; then
    echo "#!/bin/bash" > $HOME/.gtk4bash
    echo "gtk-server -fifo=$PIPE &" >> $HOME/.gtk4bash
    echo "while [ ! -p $PIPE ]; do continue; done" >> $HOME/.gtk4bash
    while read LINE
    do
	if [[ $LINE = FUNCTION_NAME* ]]; then
	    LINE=${LINE#*= }
	    printf "\nfunction ${LINE%%,*}\n" >> $HOME/.gtk4bash
	    printf "{\n/bin/echo ${LINE%%,*} \$@ > $PIPE" >> $HOME/.gtk4bash
	    printf "\nread GTK < $PIPE\n}\n" >> $HOME/.gtk4bash
	fi
    done < $CFG
fi
# Declare global variables
declare GTK NULL="NULL"
unset CFG PIPE LINE

# Include the generated file to use embedded GTK functions
. ${HOME}/.gtk4bash

#---------------------------------------------------------- Global inits

# GTK-server must go after an error in the script
declare PIPE=/tmp/gtk.bash.$$
trap 'gtk_server_exit' ERR 

# Assignment function
function define() { $2 $3 $4 $5 $6 $7 $8 $9; eval $1="$GTK"; }

# Communicate with GTK-server
gtk()
{
/bin/echo $@ > $PIPE
read GTK < $PIPE
}

#---------------------------------------------------------- GUI realization

gtk_init
gtk_server_define gtk_builder_new NONE WIDGET 0
gtk_server_define gtk_builder_add_from_file NONE INT 3 WIDGET STRING NULL
gtk_server_define gtk_builder_get_object NONE WIDGET 2 WIDGET STRING

define BUILDER gtk gtk_builder_new
define RESULT gtk gtk_builder_add_from_file $BUILDER psip.glade
define MAIN_WINDOW gtk gtk_builder_get_object $BUILDER main_window
define QUIT_BUTTON gtk gtk_builder_get_object $BUILDER quit
define QUIT_BUTTON gtk gtk_builder_get_object $BUILDER quit
define OPEN_CALL_WINDOW_BUTTON gtk gtk_builder_get_object $BUILDER open_call_window
define SETUP_BUTTON gtk gtk_builder_get_object $BUILDER preferences
define ABOUT_BUTTON gtk gtk_builder_get_object $BUILDER about

define CALL_WINDOW gtk gtk_builder_get_object $BUILDER call_window
define SETUP_DIALOG gtk gtk_builder_get_object $BUILDER preferences_dialog
define ABOUT_DIALOG gtk gtk_builder_get_object $BUILDER aboutdialog

g_object_unref $BUILDER

gtk_server_connect $MAIN_WINDOW delete-event finish
gtk_server_connect $QUIT_BUTTON clicked finish
gtk_server_connect $OPEN_CALL_WINDOW_BUTTON clicked open-call-window
gtk_server_connect $SETUP_BUTTON clicked setup-button-clicked
gtk_server_connect $ABOUT_BUTTON clicked about-button-clicked

gtk_server_connect $CALL_WINDOW delete-event call-window-delete
gtk_server_connect $SETUP_DIALOG response setup-window-response
gtk_server_connect $ABOUT_DIALOG response about-dialog-response
gtk_server_connect $ABOUT_DIALOG delete-event about-dialog-delete

gtk_widget_show $MAIN_WINDOW

#----- main loop
until [[ $EVENT = "finish" ]]
do
	define EVENT gtk_server_callback wait
	case $EVENT in
		open-call-window) 
			gtk_widget_show $CALL_WINDOW
			;;
		call-window-delete)
			gtk_widget_hide $CALL_WINDOW
			;;
		setup-button-clicked)
			gtk_dialog_run $SETUP_DIALOG
			;;		
		setup-window-response)
			gtk_widget_hide $SETUP_DIALOG
			;;
		about-button-clicked)
			gtk_dialog_run $ABOUT_DIALOG
			;;
		about-dialog-response|about-dialog-delete)
			gtk_widget_hide $ABOUT_DIALOG
			;;
	esac
done


gtk_server_exit 
