/*
 * PSIP - A lightweight GTK GUI for pjsip
 * (C) James Budiono 2011, 2015
 * License: GNU GPL Version 3 or later, please see attached gpl-3.0.txt 
 * or http://www.gnu.org/copyleft/gpl.html
 * 
 * Shared definitions.
 */

/* ==== compile-time configuration settings  ==== */
//#define RELEASE			//define this to enable RELEASE features (currently only to embed psip.glade)
//#define DISABLE_RECORDER  //define this to permanently disable conversation recording

#ifdef FATDOG_COMPILE
	#pragma message "Building for Fatdog"
	#define DEFAULT_HELP_COMMAND "defaultbrowser file:///usr/share/doc/psip-doc.html"
	#define DEFAULT_RING_COMMAND ""	
	#define DEFAULT_RINGTONE_FILE "/usr/share/sounds/bell.wav"	
#else
	#define DEFAULT_HELP_COMMAND "defaultbrowser http://www.smokey01.com/help/psip/psip-help.html"
	#define DEFAULT_RING_COMMAND "aplay -Dplug:dmix /usr/share/sounds/2barks.au"	
#endif

#define DEFAULT_ONLINE_STATUS		"Online"
#define	DEFAULT_INCOMING_TIMEOUT	15		/* in seconds */
#define DEFAULT_TYPING_TIMEOUT		5		/* in seconds */
#define BACKEND_NUM_THREADS			1		/* minimum is one */
#define DEFAULT_MAX_CALLS			4		/* default max calls */
#define DEFAULT_SAMPLING_CHOICE		1		/* 0=8000, 1=16000, 2=22050, 3=32000, 4=44100, 5=48000 */
#define	DEFAULT_QUALITY				5		/* according to pjsip manual, default quality is 5 */
#define DEFAULT_BUDDIES "[{ \
			\"category\":	\"iptel.org utilities\", \
			\"buddies\":	[{ \
					\"nick\":	\"music\", \
					\"address\":	\"sip:music@iptel.org\" \
				}, { \
					\"nick\":	\"echo\", \
					\"address\":	\"sip:echo@iptel.org\" \
				}, { \
					\"nick\":	\"conference\", \
					\"address\":	\"sip:conference@iptel.org\" \
				}, { \
					\"nick\":	\"voice mail\", \
					\"address\":	\"sip:1000@iptel.org\" \
				}] \
		}, { \
			\"category\":	\"ekiga.net utilities\", \
			\"buddies\":	[{ \
					\"nick\":	\"echo\", \
					\"address\":	\"sip:500@ekiga.net\" \
				}, { \
					\"nick\":	\"callback\", \
					\"address\":	\"sip:520@ekiga.net\" \
				}, { \
					\"nick\":	\"conference\", \
					\"address\":	\"sip:501@ekiga.net\" \
				}] \
		}]"





/* === don't touch from here onwards unless you know what you're doing === */
#include <gtk/gtk.h>

#define CONFIG_FILE			"psip.conf"				/* base name of config file */
#define ACTIVITY_LOG_FILE	"psip-activity.log"		/* base name of the activity log file */

#define STATISTIC_BUFFER_SIZE 2048
#define MAX_AUDIO_DEVICES 	20	 /* make sure this is in sync with psip.glade */
#define INVALID_CALL_ID 	(-1)
#define UNREGISTERED_BUDDY	(-1)
#define GTK_END_OF_LIST		(-1) /* gtk code */

//buddylist columns - must sync with glade file
#define BUDDY_NICK			0
#define BUDDY_ADDRESS		1
#define BUDDY_STATUS		2
#define BUDDY_STATUS_TEXT	3
#define BUDDY_ICON			4
#define BUDDY_ID			5

//call_list columns - must sync with glade file
#define CALL_ADDRESS		0
#define CALL_STATUS			1
#define CALL_DATA			2
#define CALL_HOLD			3

//callhistorylist columns - must sync with glade file
#define CALL_HISTORY_WHEN		0
#define CALL_HISTORY_FROM		1
#define CALL_HISTORY_ACTION		2

//account_list columns - must sync with glade file
#define ACCOUNT_NAME 0
#define ACCOUNT_DETAILS 1

//notification types
enum {
	BACKEND_NOTIFICATION_TYPE_START,
	BACKEND_NOTIFICATION_TYPE_STOP,
	BACKEND_NOTIFICATION_END
};

typedef struct _account_details {
	gchararray name;
	gchararray sip_url;
	gchararray registrar;
	gchararray realm;
	gchararray user;
	gchararray password;
	gchararray proxy;
	int enable_srtp;
	int active;
	struct _account_details *next;
} account_details;

typedef struct _psip_state_struct psip_state_struct;
struct _psip_state_struct {
	//gui widgets
	GtkWindow *main_window, *progress_window, *call_window, *call_history_window;
	GtkDialog *confirm_dialog, *addbuddy_dialog, *error_dialog, *preferences_dialog, 
			  *call_statistic_dialog, *adhoc_address_dialog;
		
	GtkWidget *progressbar, *register_button, *main_statusbar, 
			  *loglevel_scaler, *local_mic_volume_scaler, *remote_speaker_volume_scaler, *quality_scaler;
	GtkLabel  *call_statistic_detail;
	GtkEntry  *online_status_field, *adhoc_address_field, *adhoc_call_field;
	
	GtkListStore *call_list, *callhistorylist, *freqlist;
	GtkTreeStore *buddytree;
	GtkTreeView *buddylistview, *call_listview;
	
	GtkEntry *addbuddy_nickname_field, *addbuddy_address_field, *addbuddy_category_field;
	GtkEntry *account_name_field, *account_sip_url_field, *account_registrar_field, *account_realm_field, 
			 *account_user_field, *account_password_field, *account_proxy_field;
	GtkToggleButton *account_srtp_field, *account_active_field;
	GtkTreeView *account_selector_view;
	GtkListStore *account_list;
	GtkTreePath *prev_path;
	account_details *account_selector_selected;
	
	GtkEntry *ring_command_field, *help_command_field, *call_timeout_field, *im_command_field;
	GtkToggleButton *minimise_tray_field, *auto_register_field, *beep_on_im_field, *activity_log_field;
	GtkFileChooserButton *ring_wav_file_button;
	GtkComboBox *sampling_rate_field;
			
	GtkEntry *max_calls_field, *sip_port_field, *public_ip_field, *stun_server_field, 
			 *turn_server_field, *turn_user_field, *turn_realm_field, *turn_password_field;
	GtkToggleButton *disable_vad_field,	*enable_ice_field,	*turn_use_tcp_field, *disable_tcp_field,
					*disable_optional_srtp_field;

	GtkWidget *audio_inputs[MAX_AUDIO_DEVICES], *audio_outputs[MAX_AUDIO_DEVICES];
	GHashTable *active_ims, *active_calls; /* hash tables for multiple IMs and calls */
	
	gboolean is_playing, is_recording;
	gchararray recording_filename, playing_filename, ring_filename;
	
	GThread *main_thread;
	FILE *activity_log_file;
};

typedef struct _im_data {
	gchararray address;
	GtkWindow *w;
	GtkWidget *msg, *history, *typing;
	GtkTextTag *local_prefix_tag, *remote_prefix_tag;
	gboolean is_typing;
} im_data;

typedef struct _call_data {
	gint call_id;
	gchararray address;
	GtkTreeIter *iter;
	gdouble level;
	gboolean hold;
} call_data;

typedef struct _audio_settings {
	gchararray input;
	gchararray output;
} audio_settings;


/* in psip.c */
extern psip_state_struct *psip_state;

extern void lock_gdk();
extern void unlock_gdk();
extern gchararray get_time_stamp();
extern void show_error(gchararray s);

extern void populate_account_selector();
extern void load_account_details_to_preferences_dialog(account_details *acct);
extern void update_selected_account_from_preferences_dialog();

extern void update_registration_status (gboolean registered);
extern void buddyview_set_online_status (GtkTreeIter *i, gboolean status, gchararray status_text);
extern im_data *create_new_im_window(gchararray address);
extern void im_window_insert_history_text(im_data *p, gchararray from, gchararray text, GtkTextTag *tag);

extern call_data *add_active_call (gchararray address, gchararray state, gint call_id);
extern void remove_active_call (call_data *p);
extern void update_call_state (call_data *p, gchararray state);
extern void add_call_history_entry (gchararray from, gchararray action);

extern void get_audio_preference_settings (audio_settings *as);

extern GPid start_notification_sound_command (gchararray cmd);
extern void stop_notification_sound_command (GPid pid);

extern void push_status (gchararray context, gchararray text);
extern void pop_status (gchararray context);

/* in config.c */
extern account_details *accounts;
extern account_details *active_account;
extern void load_config();
extern void save_config();
extern void log_activity (gchararray text); /* text must be g_strdup-ed */
extern void remove_account(account_details *acct);
extern account_details *add_account();
void update_account_details(account_details *acct, 
	     gchararray name, gchararray sip_url, gchararray registrar,
	     gchararray realm, gchararray user, gchararray password,
	     gchararray proxy, int enable_srtp, int active);

/* in backend.c */
extern gboolean backend_start();
extern void backend_stop();
extern void backend_prepare_preferences_dialog();
extern void backend_reconfigure();

void backend_register();
void backend_deregister();
gboolean backend_is_registered();

extern gboolean backend_make_call(call_data *p);
extern void backend_drop_call(call_data *p);
extern void backend_adjust_local_mic_level (double level);
extern void backend_adjust_remote_speaker_level (call_data *p, double level);
extern void backend_send_dtmf(call_data *p, gchararray digit);
extern void backend_hold_call (call_data *p);
extern void backend_unhold_call (call_data *p);
extern gboolean backend_get_call_statistic (call_data *p, gchararray buffer);

extern gint backend_register_buddy (gchararray address, GtkTreeIter *tree_iter);
extern GtkTreeIter *backend_deregister_buddy (gint buddy_id);
extern void backend_refresh_presence(gint buddy_id);
extern void backend_state_set_online_status();

extern void backend_send_message(gchararray address, gchararray text);
extern void backend_typing_indicator (gchararray address, gboolean is_typing);

extern gboolean backend_start_recording (gchararray filename);
extern void backend_stop_recording();
extern gboolean backend_start_playing (gchararray filename);
extern void backend_stop_playing();
extern void backend_audible_notification (unsigned type);


