#!/bin/sh
orig=netmon_wce.c
patch=netmon_stomp_puppyisms.diff

[ ! "$1" ] && echo "This script is used to remove puppy-isms.
Please pass 'yes' as a param to $0 or if you want
'gxmessage' as well pass 'yes please' (no quotes)" && exit

if [ "$1" = "yes" ];then
	echo "backing up original"
	cp -af $orig ${orig}.orig
	cat ${patch} | patch -p0 --verbose
	[ $? = 0 ] && echo "patch succeeded!" || echo "patch failed :-("
fi
if [ "$2" = "please" ];then
	sed -i 's%xmessage%gxmessage%g' ${orig}
	[ $? = 0 ] && echo "patching gxmessage succeeded!" || \
	echo "patching gxmessage failed :-("
fi
