/* 'netmon_wce' - Network monitor for system tray*/
/* fork of Barry's 'network_tray' */

#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <iwlib.h>
#include <ifaddrs.h>
#include <netinet/in.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <libintl.h>
#include <locale.h>
#define _(STRING)    gettext(STRING)

#define MONTH 	_("Month")

//wireless icons
#define icon_wi_q5		"/usr/share/pixmaps/puppy/quality_5.svg"
#define icon_wi_q4		"/usr/share/pixmaps/puppy/quality_4.svg"
#define icon_wi_q3		"/usr/share/pixmaps/puppy/quality_3.svg"
#define icon_wi_q2		"/usr/share/pixmaps/puppy/quality_2.svg"
#define icon_wi_q1		"/usr/share/pixmaps/puppy/quality_1.svg"
#define icon_wi_dis		"/usr/share/pixmaps/puppy/quality_0.svg"

//other icons
#define networkblank 	"/usr/share/pixmaps/puppy/internet_connect.svg"
#define networkboth		"/usr/share/pixmaps/puppy/internet_connect_both.svg"
#define networkdead		"/usr/share/pixmaps/puppy/internet_connect_no.svg"
#define networkin 		"/usr/share/pixmaps/puppy/internet_connect_yes.svg"
#define networkout 		"/usr/share/pixmaps/puppy/internet_connect_yes.svg"


GdkPixbuf *networkblank_pixbuf;
GdkPixbuf *networkboth_pixbuf;
GdkPixbuf *networkdead_pixbuf;
GdkPixbuf *networkin_pixbuf;
GdkPixbuf *networkout_pixbuf;
GdkPixbuf *wiconset[6];

GtkStatusIcon *tray_icon;
unsigned int interval = 600; //update interval in milliseconds
unsigned int new_interval = 600;

FILE *fp;
int flagactive = 0;
int flagactiveprev = 0;
char infomsg[256];
char rxstr[52];
long long int rxacc = 0;
char rxaccstr[64];
char txstr[52];
long long int txacc = 0;
char txaccstr[64];
long long int rxaccprev = 0;
long long int txaccprev = 0;
int flagtransfer = 0;
int flagtransferprev = 0;
int loopcnt = 0;
int breakcnt = 0;
int flagdisconnect = 0;

//100814
const char *rxmonthfile = "/var/local/sns/rx_bytes_month";
const char *txmonthfile = "/var/local/sns/tx_bytes_month";
char rxstrmonth[52];
long long int rxaccmonth = 0;
char txstrmonth[52];
long long int txaccmonth = 0;
long long int rxaccmonth_updated = 0;
long long int txaccmonth_updated = 0;
char ipa[20];
char command[256];
//wifi
int wireless = 0;
int enable_polling = 0;

GError *gerror;

//type to hold interface and ip address
struct iface_info {
	char *iname;
	char *ip_address;
};

//fill the type
struct iface_info get_info();
struct iface_info get_info() {
	struct iface_info info[16]; //if more than 16 we ain't runnin' puppy on this beast~
	struct ifaddrs *addrs;
	struct ifaddrs *tmp;
	getifaddrs(&addrs);
	tmp = addrs;
	int i = 0;

	while (tmp) {
		if (tmp->ifa_addr && tmp->ifa_addr->sa_family == AF_INET) {
			struct sockaddr_in *pAddr = (struct sockaddr_in *)tmp->ifa_addr;
			info[i].iname = tmp->ifa_name;
			info[i].ip_address = inet_ntoa(pAddr->sin_addr);
		}
		tmp = tmp->ifa_next;
		i++;
	}
	freeifaddrs(addrs);
	if (i == 0 ) exit (EXIT_FAILURE); //even lo failed
	return info[i - 1]; //grab the first live one
}

//type to hold link quality and maximum
struct link_qual {
	int my_qual;
	int my_max_qual;
};

//fill link_qual type
struct link_qual card_qual(char *interface);
struct link_qual card_qual(char *interface) {
	//http://www.linuxforums.org/forum/programming-scripting/195773-get-wireless-statistics-c.html
	struct link_qual l_qual;
	int sockfd;
	struct iw_statistics stats;
	struct iwreq req;
	struct	iw_range *i_range = malloc(sizeof(struct iw_range));
	if (!i_range) {
		perror("failed to allocate memory");
		exit (EXIT_FAILURE);
	}
	
	memset(&stats, 0, sizeof(stats));
	memset(&req, 0, sizeof(req));
	sprintf(req.ifr_name, "%s", interface);
	req.u.data.pointer = &stats;
	req.u.data.length = sizeof(stats);
#ifdef CLEAR_UPDATED
	req.u.data.flags = 1;
#endif

	if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
		perror("socket failed");
		free(i_range);
		exit (EXIT_FAILURE);
	}
	if (ioctl(sockfd, SIOCGIWSTATS, &req) == -1) {
		perror("ioctl SIOCGIWSTATS failed");
		close(sockfd);
		free(i_range);
		exit (EXIT_FAILURE);
	}
	if (iw_get_range_info(sockfd, interface, i_range) < 0) { //libiw
		l_qual.my_max_qual = 100;
	} else {
		l_qual.my_max_qual = i_range->max_qual.qual;
	}
	//cast to (int) from __u8 kernel type so we can work with
	l_qual.my_qual = (int)((char)stats.qual.qual);
	close(sockfd);
	free(i_range);
	return l_qual;
}

//finds active interface and builds tooltip
void find_active();
void find_active() {
	char *netdir = "/sys/class/net";
	char buf1[512];
	char buf2[512];
	char char1;
	//ip address
	struct iface_info now = get_info();
	sprintf(ipa, "%s", now.ip_address);
	
	if (strcmp(ipa, "127.0.0.1") != 0) {
		char1 = '0';
	}	
	//check if its wireless
	char wireless_dir[256];
	sprintf(wireless_dir, "%s/%s/wireless/", netdir, now.iname);
	if (access(wireless_dir, R_OK) == 0)
		wireless = 1;
	else
		wireless = 0;
    
    flagactive = 0;
    infomsg[0] = 0;
    strcat(infomsg, _("Active interface: "));
    
    if (strcmp(now.iname, "lo") != 0) {
	    if (char1 == '0') {
			flagactive = flagactive + 1;
			strcat(infomsg, now.iname);
			strcat(infomsg, " ");
			//accumulate bytes received...
			sprintf(buf1, "%s/%s/statistics/rx_bytes", netdir, now.iname);
			fp = fopen(buf1, "r");
			if (fp != NULL) {
				fgets(rxstr, 12, fp);
				rxacc = atoll(rxstr) / 1024;
				fclose(fp);
			}
			rxaccmonth_updated = (rxaccmonth + rxacc) / 1024; //100814 in MB
			//accumulate bytes transmitted...
			sprintf(buf2, "%s/%s/statistics/tx_bytes", netdir, now.iname);
			fp = fopen(buf2, "r");
			if (fp != NULL) {
				fgets(txstr, 12, fp);
				txacc = atoll(txstr)/1024;
				fclose(fp);
			}
			txaccmonth_updated = (txaccmonth+txacc) / 1024; //100814 in MB
		}
	}
	if (flagactive == 0) {
		strcat(infomsg, _("none "));
		strcat(infomsg, "\n");
        strcat(infomsg, _("Click this icon for network setup"));
    } else {
        if (rxacc < 1024) {
            sprintf(rxaccstr, "%.1f", ((float)rxacc));
            strcat(infomsg, "\nRx: ");
            strcat(infomsg, rxaccstr);
            strcat(infomsg, "KB");
        }
        else {
            sprintf(rxaccstr, "%.1f", ((float)rxacc / 1024.0));
            strcat(infomsg, "\nRx: ");
            strcat(infomsg, rxaccstr);
            strcat(infomsg, "MB");
        }
        //100814 monthly acc...
        sprintf(rxaccstr, " (%s:%lldMB) ",
						MONTH, rxaccmonth_updated);
        strcat(infomsg, rxaccstr);
        if (txacc < 1024) {
            sprintf(txaccstr, "%.1f", ((float)txacc));
            strcat(infomsg, "\nTx: ");
            strcat(infomsg, txaccstr);
            strcat(infomsg, "KB");
        }
        else {
            sprintf(txaccstr, "%.1f", ((float)txacc / 1024.0));
            strcat(infomsg, "\nTx: ");
            strcat(infomsg, txaccstr);
            strcat(infomsg, "MB");
        }
        //100814 monthly acc...
        sprintf(txaccstr, " (%s:%lldMB) ",
						MONTH, txaccmonth_updated);
        strcat(infomsg, txaccstr);
    
		strcat(infomsg, "\n");
		strcat(infomsg, _("IP address: "));
		strcat(infomsg, ipa);
	}
}

//updates info
gboolean Update(gpointer ptr);
gboolean Update(gpointer ptr) {
	static int wicon;
	static char tipbuf[256];
	char *strength = _("Wireless Strength");
	//printf("interval: %d\n", new_interval); //testing; comment for production
	find_active();
	if (flagactive == 0) {
		flagtransfer = 0;
    } else {
        flagtransfer = 1;
        if (rxacc != rxaccprev) flagtransfer = 2;
        if (txacc != txaccprev) flagtransfer = 3;
        if (txacc != txaccprev && rxacc != rxaccprev) flagtransfer = 4;
    }
	
	loopcnt = loopcnt + 1;
    //lot of trouble with this logic, so introduce breakcnt to force icon update if stuck...
    if (flagtransferprev == flagtransfer) {
		if (loopcnt != 1) { //want to update icon on first loop.
			if (flagactive == flagactiveprev && flagtransfer == flagtransferprev && flagtransfer == 1) breakcnt = breakcnt + 1; //no change.
			if (flagactive == flagactiveprev && flagtransfer == flagtransferprev && flagactive == 0) breakcnt = breakcnt + 1; //no change.
		} else {
			breakcnt = 0;
		}
		if (breakcnt != 0 && breakcnt < 8) return TRUE; //force update after 4 seconds.
    }
    breakcnt = 0;
    flagactiveprev = flagactive;
    txaccprev = txacc;
    rxaccprev = rxacc;
    flagtransferprev = flagtransfer;
    if (flagtransfer == 0) {
		gtk_status_icon_set_from_pixbuf(tray_icon, networkdead_pixbuf);
		//update tooltip...
		gtk_status_icon_set_tooltip(tray_icon, infomsg);
    } else {
		if (wireless == 0) { //no wireless
		    if (flagtransfer == 1) gtk_status_icon_set_from_pixbuf(tray_icon, networkblank_pixbuf);
		    else if (flagtransfer == 2) gtk_status_icon_set_from_pixbuf(tray_icon, networkin_pixbuf);
		    else if (flagtransfer == 3) gtk_status_icon_set_from_pixbuf(tray_icon, networkout_pixbuf);
		    else if (flagtransfer == 4) gtk_status_icon_set_from_pixbuf(tray_icon, networkboth_pixbuf);
		    //update tooltip...
		    gtk_status_icon_set_tooltip(tray_icon, infomsg);
		    
	    } else { //wireless
			if (enable_polling == 0) {
					gtk_status_icon_set_from_pixbuf(tray_icon, wiconset[4]); //arbitrary
					sprintf(tipbuf, "%s\n%s", infomsg, _("Wifi stats disabled"));
					gtk_status_icon_set_tooltip(tray_icon, tipbuf);
			} else { 
				//wireless test
				struct iface_info i_face = get_info();
				struct link_qual i_face_qual = card_qual(i_face.iname);
				int divisor;
				int wiQ, wiQpc;
				divisor = (int)i_face_qual.my_max_qual;
				if (divisor < 40) return FALSE; //40 is arbitrary
				wiQ = (int)i_face_qual.my_qual;
				
				//Code from Patriot's "LameWiFi"
				wiQpc = wiQ * 100 / divisor;
				if (wiQpc > 100) {
					perror("insane value for wifi stats");
					gtk_status_icon_set_from_pixbuf(tray_icon, wiconset[3]);
					sprintf(tipbuf, "%s\n%s", infomsg, _("Wifi Stats unreadable - disable polling in the menu."));
					gtk_status_icon_set_tooltip(tray_icon, tipbuf);
				} else {
					if (wiQpc > 89)
						wicon = 5;
					else if (wiQpc > 69)
						wicon = 4;
					else if (wiQpc > 49)
						wicon = 3;
					else if (wiQpc > 29)
						wicon = 2;
					else if (wiQpc > 9)
						wicon = 1;
					else
						wicon = 0;
			
					gtk_status_icon_set_from_pixbuf(tray_icon, wiconset[wicon]);
					sprintf(tipbuf, "%s\n%s %d%%", infomsg, strength, wiQpc);
					gtk_status_icon_set_tooltip(tray_icon, tipbuf);
				}
			}
		}
	}
	//via 'ptomato' - http://stackoverflow.com/questions/2948538/variable-timeouts-in-glib
	if(new_interval) {
        g_timeout_add(new_interval, (GSourceFunc)Update, NULL);
        return FALSE;
    }
    return TRUE;
}

//callbacks
void  view_popup_menu_onSetupNetworking (GtkWidget *menuitem, gpointer userdata);
void  view_popup_menu_onSetupNetworking (GtkWidget *menuitem, gpointer userdata) {
	/* we passed the view as userdata when we connected the signal */
	system("defaultconnect & ");
}

void  view_popup_menu_onNetworkStatus (GtkWidget *menuitem, gpointer userdata);
void  view_popup_menu_onNetworkStatus (GtkWidget *menuitem, gpointer userdata) {
	system("ipinfo & ");
}

void  view_popup_menu_onDisconnect (GtkWidget *menuitem, gpointer userdata);
void  view_popup_menu_onDisconnect (GtkWidget *menuitem, gpointer userdata) {
	flagdisconnect = 1;
	system("/usr/local/apps/Connect/AppRun --disconnect & ");
}

void  view_popup_menu_onReconnect (GtkWidget *menuitem, gpointer userdata);
void  view_popup_menu_onReconnect (GtkWidget *menuitem, gpointer userdata) {
    system("/usr/local/apps/Connect/AppRun --connect & ");
    flagactiveprev = 0; /*100703*/
}

void toggle_wireless_polling();
void toggle_wireless_polling() {
	if (enable_polling == 0) {
		enable_polling = 1;
		new_interval = 5000;
	} else if (enable_polling == 1) {
		enable_polling = 0;
		new_interval = 600;
	}
}

void quit();
void quit() {
	gtk_main_quit();
	exit(EXIT_SUCCESS);
}

//menu
void tray_icon_on_menu(GtkStatusIcon *status_icon, guint button, guint activate_time, gpointer user_data);
void tray_icon_on_menu(GtkStatusIcon *status_icon, guint button, guint activate_time, gpointer user_data) {
	GtkWidget *menu, *menuitem, *icon;
	menu = gtk_menu_new();
	menuitem = gtk_image_menu_item_new_with_label(_("Quit"));
	icon = gtk_image_new_from_stock(GTK_STOCK_QUIT, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), icon);
	g_signal_connect(menuitem, "activate", (GCallback) quit, status_icon);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	if (wireless != 0) {
		if (enable_polling == 0) {
			menuitem = gtk_image_menu_item_new_with_label(_("Enable wireless device polling"));
			icon = gtk_image_new_from_stock(GTK_STOCK_APPLY, GTK_ICON_SIZE_MENU);
		} else {
			menuitem = gtk_image_menu_item_new_with_label(_("Disable wireless device polling"));
			icon = gtk_image_new_from_stock(GTK_STOCK_CANCEL, GTK_ICON_SIZE_MENU);
		}
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), icon);
		g_signal_connect(menuitem, "activate", (GCallback) toggle_wireless_polling, status_icon);
		gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	}
	menuitem = gtk_image_menu_item_new_with_label(_("Setup networking"));
	icon = gtk_image_new_from_stock(GTK_STOCK_PREFERENCES, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), icon);
	g_signal_connect(menuitem, "activate", (GCallback) view_popup_menu_onSetupNetworking, status_icon);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	menuitem = gtk_image_menu_item_new_with_label(_("Network status information"));
	icon = gtk_image_new_from_stock(GTK_STOCK_DIALOG_INFO, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), icon);
	g_signal_connect(menuitem, "activate", (GCallback) view_popup_menu_onNetworkStatus, status_icon);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	if (flagactive != 0) {
		flagdisconnect = 0;
		menuitem = gtk_image_menu_item_new_with_label(_("Disconnect from network"));
		icon = gtk_image_new_from_stock(GTK_STOCK_DISCONNECT, GTK_ICON_SIZE_MENU);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), icon);
		g_signal_connect(menuitem, "activate", (GCallback) view_popup_menu_onDisconnect, status_icon);
		gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	}
	if (flagdisconnect == 1) {
		menuitem = gtk_image_menu_item_new_with_label(_("Reconnect to network"));
		icon = gtk_image_new_from_stock(GTK_STOCK_CONNECT, GTK_ICON_SIZE_MENU);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), icon);
		g_signal_connect(menuitem, "activate", (GCallback) view_popup_menu_onReconnect, status_icon);
		gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
	}
	gtk_widget_show_all(menu);
	gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, button, gdk_event_get_time(NULL));
}

//left click callback
void tray_icon_on_click(GtkStatusIcon *status_icon, gpointer user_data);
void tray_icon_on_click(GtkStatusIcon *status_icon, gpointer user_data) {
	char *msg_string = _("Note: right-click icon for network menu");
	sprintf(command, "gtkdialog-splash -placement bottom -bg purple -timeout 10 -text \"%s\" &", msg_string);
	if (flagactive == 0) {
		system("defaultconnect & ");
	} else {
		system(command);
		system("ipinfo & ");
	}
}

//build status icon
static GtkStatusIcon *create_tray_icon();
static GtkStatusIcon *create_tray_icon() {
	tray_icon = gtk_status_icon_new();
	g_signal_connect(G_OBJECT(tray_icon), "activate", G_CALLBACK(tray_icon_on_click), NULL);
	g_signal_connect(G_OBJECT(tray_icon), "popup-menu", G_CALLBACK(tray_icon_on_menu), NULL);
	
	//wired icons
	networkblank_pixbuf = gdk_pixbuf_new_from_file(networkblank, &gerror);
	networkboth_pixbuf = gdk_pixbuf_new_from_file(networkboth, &gerror);
	networkdead_pixbuf = gdk_pixbuf_new_from_file(networkdead, &gerror);
	networkin_pixbuf = gdk_pixbuf_new_from_file(networkin, &gerror);
	networkout_pixbuf = gdk_pixbuf_new_from_file(networkout, &gerror);
	//wireless icons
	wiconset[0] = gdk_pixbuf_new_from_file(icon_wi_dis, &gerror);
	wiconset[1] = gdk_pixbuf_new_from_file(icon_wi_q1, &gerror);
	wiconset[2] = gdk_pixbuf_new_from_file(icon_wi_q2, &gerror);
	wiconset[3] = gdk_pixbuf_new_from_file(icon_wi_q3, &gerror);
	wiconset[4] = gdk_pixbuf_new_from_file(icon_wi_q4, &gerror);
	wiconset[5] = gdk_pixbuf_new_from_file(icon_wi_q5, &gerror);
	
	if (wireless == 0 ) { //not wireless
		gtk_status_icon_set_from_pixbuf(tray_icon, networkblank_pixbuf);
	} else { //wireless	
		gtk_status_icon_set_from_pixbuf(tray_icon, wiconset[0]);
	}
	
	gtk_status_icon_set_tooltip(tray_icon,_("No active network interfaces"));
	gtk_status_icon_set_visible(tray_icon, TRUE);
	return tray_icon;
}

int main(int argc, char **argv) {
	
	if (strcmp(argv[0], "netmon_wpoll") == 0) { //start in polling mode w/symlink
		printf("%s: polling enabled\n", argv[0]);
		enable_polling = 1;
		new_interval = 5000;
	}
	
	gtk_init(&argc, &argv);
	
	setlocale( LC_ALL, "" );
	bindtextdomain( "netmon_wce", "/usr/share/locale" );
	textdomain( "netmon_wce" );
	
	//100814 monthly acc (see also /usr/local/simple_network_setup/rc.network and rc.shutdown)...
	fp = fopen(rxmonthfile,"r");
	if (fp != NULL) {
		fgets(rxstrmonth, 12, fp);
		rxaccmonth = atoll(rxstrmonth) / 1024; //in KB.
		fclose(fp);
	}
	fp = fopen(txmonthfile,"r");
	if (fp != NULL) {
		fgets(txstrmonth, 12, fp);
		txaccmonth = atoll(txstrmonth) / 1024;
		fclose(fp);
	}
	
	tray_icon = create_tray_icon();
		
	g_timeout_add(interval, Update, NULL);
	
	gtk_main();
	return 0;
}
