/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.bridge;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.settings.Mirror;
import org.codehaus.plexus.util.StringUtils;

public class MirrorSelector {
    private static final String WILDCARD = "*";
    private static final String EXTERNAL_WILDCARD = "external:*";

    public static Mirror getMirror(ArtifactRepository repository, List<Mirror> mirrors) {
        String repoId = repository.getId();
        if (repoId != null && mirrors != null) {
            for (Mirror mirror : mirrors) {
                if (!repoId.equals(mirror.getMirrorOf()) || !MirrorSelector.matchesLayout(repository, mirror)) continue;
                return mirror;
            }
            for (Mirror mirror : mirrors) {
                if (!MirrorSelector.matchPattern(repository, mirror.getMirrorOf()) || !MirrorSelector.matchesLayout(repository, mirror)) continue;
                return mirror;
            }
        }
        return null;
    }

    static boolean matchPattern(ArtifactRepository originalRepository, String pattern) {
        boolean result = false;
        String originalId = originalRepository.getId();
        if (WILDCARD.equals(pattern) || pattern.equals(originalId)) {
            result = true;
        } else {
            String[] repos;
            for (String repo : repos = pattern.split(",")) {
                if (repo.length() > 1 && repo.startsWith("!")) {
                    if (!repo.substring(1).equals(originalId)) continue;
                    result = false;
                    break;
                }
                if (repo.equals(originalId)) {
                    result = true;
                    break;
                }
                if (EXTERNAL_WILDCARD.equals(repo) && MirrorSelector.isExternalRepo(originalRepository)) {
                    result = true;
                    continue;
                }
                if (!WILDCARD.equals(repo)) continue;
                result = true;
            }
        }
        return result;
    }

    static boolean isExternalRepo(ArtifactRepository originalRepository) {
        try {
            URL url = new URL(originalRepository.getUrl());
            return !url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1") && !url.getProtocol().equals("file");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    static boolean matchesLayout(ArtifactRepository repository, Mirror mirror) {
        return MirrorSelector.matchesLayout(RepositoryUtils.getLayout(repository), mirror.getMirrorOfLayouts());
    }

    static boolean matchesLayout(String repoLayout, String mirrorLayout) {
        boolean result = false;
        if (StringUtils.isEmpty((String)mirrorLayout) || WILDCARD.equals(mirrorLayout)) {
            result = true;
        } else if (mirrorLayout.equals(repoLayout)) {
            result = true;
        } else {
            String[] layouts;
            for (String layout : layouts = mirrorLayout.split(",")) {
                if (layout.length() > 1 && layout.startsWith("!")) {
                    if (!layout.substring(1).equals(repoLayout)) continue;
                    result = false;
                    break;
                }
                if (layout.equals(repoLayout)) {
                    result = true;
                    break;
                }
                if (!WILDCARD.equals(layout)) continue;
                result = true;
            }
        }
        return result;
    }
}

