/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.Range;
import com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.MultiBitSetMatcherNodeGen;
import com.oracle.truffle.regex.util.CompilationFinalBitSet;
import java.util.Arrays;
import java.util.Iterator;

public abstract class MultiBitSetMatcher
extends InvertibleCharMatcher {
    private static final int BYTE_RANGE = 256;
    private static final int BYTE_MAX_VALUE = 255;
    private static final int BYTE_MIN_VALUE = 0;
    private static final CompilationFinalBitSet MATCH_NONE = new CompilationFinalBitSet(256);
    private static final CompilationFinalBitSet MATCH_ALL = new CompilationFinalBitSet(256);
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final CompilationFinalBitSet[] bitSets;

    public static MultiBitSetMatcher fromCodePointSet(boolean inverse, CodePointSet cps) {
        Object[] bitSets = new CompilationFinalBitSet[256];
        Arrays.fill(bitSets, MATCH_NONE);
        CompilationFinalBitSet cur = new CompilationFinalBitSet(256);
        Iterator<Range> it = cps.iterator16Bit();
        int curByte = -1;
        while (it.hasNext()) {
            Range r = it.next();
            if (curByte == -1) {
                curByte = MultiBitSetMatcher.highByte(r.lo);
            }
            if (MultiBitSetMatcher.highByte(r.lo) > curByte) {
                bitSets[curByte] = cur;
                cur = new CompilationFinalBitSet(256);
                curByte = MultiBitSetMatcher.highByte(r.lo);
            }
            if (MultiBitSetMatcher.highByte(r.lo) == MultiBitSetMatcher.highByte(r.hi)) {
                cur.setRange(MultiBitSetMatcher.lowByte(r.lo), MultiBitSetMatcher.lowByte(r.hi));
                continue;
            }
            cur.setRange(MultiBitSetMatcher.lowByte(r.lo), 255);
            bitSets[curByte] = cur;
            for (int j = MultiBitSetMatcher.highByte(r.lo) + 1; j < MultiBitSetMatcher.highByte(r.hi); ++j) {
                bitSets[j] = MATCH_ALL;
            }
            cur = new CompilationFinalBitSet(256);
            curByte = MultiBitSetMatcher.highByte(r.hi);
            cur.setRange(0, MultiBitSetMatcher.lowByte(r.hi));
        }
        bitSets[curByte] = cur;
        return MultiBitSetMatcherNodeGen.create(inverse, (CompilationFinalBitSet[])bitSets);
    }

    MultiBitSetMatcher(boolean invert, CompilationFinalBitSet[] bitSets) {
        super(invert);
        this.bitSets = bitSets;
    }

    @Specialization
    protected boolean match(char c, boolean compactString) {
        return this.result(this.bitSets[compactString ? 0 : MultiBitSetMatcher.highByte(c)].get(MultiBitSetMatcher.lowByte(c)));
    }

    @Override
    public int estimatedCost() {
        return 8;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder(this.modifiersToString()).append("[\n");
        for (int i = 0; i < this.bitSets.length; ++i) {
            sb.append(String.format("    %02x: ", i)).append(this.bitSets[i]).append("\n");
        }
        return sb.append("  ]").toString();
    }

    static {
        MATCH_ALL.invert();
    }
}

