/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array;

import com.oracle.truffle.js.runtime.array.ByteArrayAccess;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class ByteBufferNativeOrderByteArrayAccess
extends ByteArrayAccess {
    ByteBufferNativeOrderByteArrayAccess() {
    }

    @Override
    public int getInt8(byte[] buffer, int offset, int index, int bytesPerElement) {
        return ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).get(ByteBufferNativeOrderByteArrayAccess.byteIndex(offset, index, bytesPerElement));
    }

    @Override
    public int getInt16(byte[] buffer, int offset, int index, int bytesPerElement) {
        return ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).getShort(ByteBufferNativeOrderByteArrayAccess.byteIndex(offset, index, bytesPerElement));
    }

    @Override
    public int getInt32(byte[] buffer, int offset, int index, int bytesPerElement) {
        return ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).getInt(ByteBufferNativeOrderByteArrayAccess.byteIndex(offset, index, bytesPerElement));
    }

    @Override
    public float getFloat(byte[] buffer, int offset, int index, int bytesPerElement) {
        return ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).getFloat(ByteBufferNativeOrderByteArrayAccess.byteIndex(offset, index, bytesPerElement));
    }

    @Override
    public double getDouble(byte[] buffer, int offset, int index, int bytesPerElement) {
        return ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).getDouble(ByteBufferNativeOrderByteArrayAccess.byteIndex(offset, index, bytesPerElement));
    }

    @Override
    public long getInt64(byte[] buffer, int offset, int index, int bytesPerElement) {
        return ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).getLong(ByteBufferNativeOrderByteArrayAccess.byteIndex(offset, index, bytesPerElement));
    }

    @Override
    public void putInt8(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
        ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).put(ByteBufferNativeOrderByteArrayAccess.byteIndex(offset, index, bytesPerElement), (byte)value);
    }

    @Override
    public void putInt16(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
        ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).putShort(ByteBufferNativeOrderByteArrayAccess.byteIndex(offset, index, bytesPerElement), (short)value);
    }

    @Override
    public void putInt32(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
        ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).putInt(ByteBufferNativeOrderByteArrayAccess.byteIndex(offset, index, bytesPerElement), value);
    }

    @Override
    public void putFloat(byte[] buffer, int offset, int index, int bytesPerElement, float value) {
        ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).putFloat(ByteBufferNativeOrderByteArrayAccess.byteIndex(offset, index, bytesPerElement), value);
    }

    @Override
    public void putDouble(byte[] buffer, int offset, int index, int bytesPerElement, double value) {
        ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).putDouble(ByteBufferNativeOrderByteArrayAccess.byteIndex(offset, index, bytesPerElement), value);
    }

    @Override
    public void putInt64(byte[] buffer, int offset, int index, int bytesPerElement, long value) {
        ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).putLong(ByteBufferNativeOrderByteArrayAccess.byteIndex(offset, index, bytesPerElement), value);
    }

    private static int byteIndex(int offset, int index, int bytesPerElement) {
        return offset + index * bytesPerElement;
    }
}

