/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.tables.internal;

import com.vladsch.flexmark.ext.gfm.tables.TableBlock;
import com.vladsch.flexmark.ext.gfm.tables.TableBody;
import com.vladsch.flexmark.ext.gfm.tables.TableCell;
import com.vladsch.flexmark.ext.gfm.tables.TableHead;
import com.vladsch.flexmark.ext.gfm.tables.TableRow;
import com.vladsch.flexmark.ext.gfm.tables.TableSeparator;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TableNodeRenderer
implements NodeRenderer {
    public TableNodeRenderer(DataHolder options) {
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler(TableBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<TableBlock>(){

            public void render(TableBlock tableCell, NodeRendererContext context, HtmlWriter html) {
                TableNodeRenderer.this.render(tableCell, context, html);
            }
        }), new NodeRenderingHandler(TableHead.class, (CustomNodeRenderer)new CustomNodeRenderer<TableHead>(){

            public void render(TableHead tableCell, NodeRendererContext context, HtmlWriter html) {
                TableNodeRenderer.this.render(tableCell, context, html);
            }
        }), new NodeRenderingHandler(TableSeparator.class, (CustomNodeRenderer)new CustomNodeRenderer<TableSeparator>(){

            public void render(TableSeparator tableCell, NodeRendererContext context, HtmlWriter html) {
                TableNodeRenderer.this.render(tableCell, context, html);
            }
        }), new NodeRenderingHandler(TableBody.class, (CustomNodeRenderer)new CustomNodeRenderer<TableBody>(){

            public void render(TableBody tableCell, NodeRendererContext context, HtmlWriter html) {
                TableNodeRenderer.this.render(tableCell, context, html);
            }
        }), new NodeRenderingHandler(TableRow.class, (CustomNodeRenderer)new CustomNodeRenderer<TableRow>(){

            public void render(TableRow tableCell, NodeRendererContext context, HtmlWriter html) {
                TableNodeRenderer.this.render(tableCell, context, html);
            }
        }), new NodeRenderingHandler(TableCell.class, (CustomNodeRenderer)new CustomNodeRenderer<TableCell>(){

            public void render(TableCell tableCell, NodeRendererContext context, HtmlWriter html) {
                TableNodeRenderer.this.render(tableCell, context, html);
            }
        })));
    }

    private void render(final TableBlock tableBlock, final NodeRendererContext context, HtmlWriter html) {
        html.withAttr().tagIndent((CharSequence)"table", new Runnable(){

            @Override
            public void run() {
                context.renderChildren((Node)tableBlock);
            }
        });
    }

    private void render(final TableHead tableHead, final NodeRendererContext context, HtmlWriter html) {
        if (!tableHead.hasChildren()) {
            return;
        }
        ((HtmlWriter)html.withAttr().withCondLine()).tagIndent((CharSequence)"thead", new Runnable(){

            @Override
            public void run() {
                context.renderChildren((Node)tableHead);
            }
        });
    }

    private void render(TableSeparator tableSeparator, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(final TableBody tableBody, final NodeRendererContext context, HtmlWriter html) {
        if (!tableBody.hasChildren()) {
            return;
        }
        ((HtmlWriter)html.withAttr().withCondLine()).tagIndent((CharSequence)"tbody", new Runnable(){

            @Override
            public void run() {
                context.renderChildren((Node)tableBody);
            }
        });
    }

    private void render(final TableRow tableRow, final NodeRendererContext context, HtmlWriter html) {
        html.withAttr().tagLine((CharSequence)"tr", new Runnable(){

            @Override
            public void run() {
                context.renderChildren((Node)tableRow);
            }
        });
    }

    private void render(TableCell tableCell, NodeRendererContext context, HtmlWriter html) {
        String tag;
        String string = tag = tableCell.isHeader() ? "th" : "td";
        if (tableCell.getAlignment() != null) {
            html.attr((CharSequence)"align", (CharSequence)TableNodeRenderer.getAlignValue(tableCell.getAlignment()));
        }
        html.withAttr().tag((CharSequence)tag);
        context.renderChildren((Node)tableCell);
        html.tag((CharSequence)("/" + tag));
    }

    private static String getAlignValue(TableCell.Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new IllegalStateException("Unknown alignment: " + (Object)((Object)alignment));
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new TableNodeRenderer(options);
        }
    }
}

