/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.PromiseFunctionBuiltins;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.promise.PerformPromiseCombinatorNode;
import com.oracle.truffle.js.runtime.JSContext;

@GeneratedBy(value=PromiseFunctionBuiltins.class)
public final class PromiseFunctionBuiltinsFactory {

    @GeneratedBy(value=PromiseFunctionBuiltins.ResolveNode.class)
    public static final class ResolveNodeGen
    extends PromiseFunctionBuiltins.ResolveNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ResolveNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                DynamicObject arguments0Value__;
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                    return this.doObject(arguments0Value__, arguments1Value_);
                }
                if ((state & 2) != 0 && !JSGuards.isJSObject(arguments0Value_)) {
                    return this.doNotObject(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            DynamicObject arguments0Value_;
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                this.state_ = state |= 1;
                return this.doObject(arguments0Value_, arguments1Value);
            }
            if (!JSGuards.isJSObject(arguments0Value)) {
                this.state_ = state |= 2;
                return this.doNotObject(arguments0Value, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doObject";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "doNotObject";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static PromiseFunctionBuiltins.ResolveNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ResolveNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=PromiseFunctionBuiltins.RejectNode.class)
    public static final class RejectNodeGen
    extends PromiseFunctionBuiltins.RejectNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private RejectNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                DynamicObject arguments0Value__;
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                    return this.doObject(arguments0Value__, arguments1Value_);
                }
                if ((state & 2) != 0 && !JSGuards.isJSObject(arguments0Value_)) {
                    return this.doNotObject(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            DynamicObject arguments0Value_;
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                this.state_ = state |= 1;
                return this.doObject(arguments0Value_, arguments1Value);
            }
            if (!JSGuards.isJSObject(arguments0Value)) {
                this.state_ = state |= 2;
                return this.doNotObject(arguments0Value, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doObject";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "doNotObject";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static PromiseFunctionBuiltins.RejectNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new RejectNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=PromiseFunctionBuiltins.PromiseCombinatorNode.class)
    public static final class PromiseCombinatorNodeGen
    extends PromiseFunctionBuiltins.PromiseCombinatorNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private PromiseCombinatorNodeGen(JSContext context, JSBuiltin builtin, PerformPromiseCombinatorNode performPromiseOp, JavaScriptNode[] arguments) {
            super(context, builtin, performPromiseOp);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                DynamicObject arguments0Value__;
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                    return this.doObject(arguments0Value__, arguments1Value_);
                }
                if ((state & 2) != 0 && !JSGuards.isJSObject(arguments0Value_)) {
                    return this.doNotObject(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            DynamicObject arguments0Value_;
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                this.state_ = state |= 1;
                return this.doObject(arguments0Value_, arguments1Value);
            }
            if (!JSGuards.isJSObject(arguments0Value)) {
                this.state_ = state |= 2;
                return this.doNotObject(arguments0Value, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doObject";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "doNotObject";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static PromiseFunctionBuiltins.PromiseCombinatorNode create(JSContext context, JSBuiltin builtin, PerformPromiseCombinatorNode performPromiseOp, JavaScriptNode[] arguments) {
            return new PromiseCombinatorNodeGen(context, builtin, performPromiseOp, arguments);
        }
    }
}

