/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSDoubleToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToStringNode.class)
public final class JSToStringNodeGen
extends JSToStringNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile lazyString_flattenProfile_;
    @Node.Child
    private JSDoubleToStringNode double_doubleToStringNode_;
    @Node.Child
    private JSToPrimitiveNode jSObject_toPrimitiveHintStringNode_;
    @Node.Child
    private JSToPrimitiveNode truffleObject_toPrimitiveNode_;

    private JSToStringNodeGen(boolean undefinedToEmpty, boolean symbolToString) {
        super(undefinedToEmpty, symbolToString);
    }

    @Override
    public String executeString(Object arg0Value) {
        Object arg0Value_;
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof JSLazyString) {
            JSLazyString arg0Value_2 = (JSLazyString)arg0Value;
            return this.doLazyString(arg0Value_2, this.lazyString_flattenProfile_);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitString((state & 0xF000) >>> 12, arg0Value)) {
            String arg0Value_3 = JSTypesGen.asImplicitString((state & 0xF000) >>> 12, arg0Value);
            return this.doString(arg0Value_3);
        }
        if ((state & 0xC) != 0) {
            if ((state & 4) != 0 && JSGuards.isJSNull(arg0Value)) {
                return this.doNull(arg0Value);
            }
            if ((state & 8) != 0 && JSGuards.isUndefined(arg0Value)) {
                return this.doUndefined(arg0Value);
            }
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_4 = (Boolean)arg0Value;
            return this.doBoolean(arg0Value_4);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Integer) {
            int arg0Value_5 = (Integer)arg0Value;
            return this.doInteger(arg0Value_5);
        }
        if ((state & 0x40) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_6 = (BigInt)arg0Value;
            return this.doBigInt(arg0Value_6);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Long) {
            long arg0Value_7 = (Long)arg0Value;
            return this.doLong(arg0Value_7);
        }
        if ((state & 0x100) != 0 && JSTypesGen.isImplicitDouble((state & 0xF0000) >>> 16, arg0Value)) {
            double arg0Value_8 = JSTypesGen.asImplicitDouble((state & 0xF0000) >>> 16, arg0Value);
            return this.doDouble(arg0Value_8, this.double_doubleToStringNode_);
        }
        if ((state & 0x200) != 0 && JSTypes.isDynamicObject(arg0Value) && JSObject.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
            return this.doJSObject((DynamicObject)arg0Value_, this.jSObject_toPrimitiveHintStringNode_);
        }
        if ((state & 0x400) != 0 && arg0Value instanceof Symbol) {
            arg0Value_ = (Symbol)arg0Value;
            return this.doSymbol((Symbol)arg0Value_);
        }
        if ((state & 0x800) != 0 && JSGuards.isForeignObject(arg0Value)) {
            return this.doTruffleObject(arg0Value, this.truffleObject_toPrimitiveNode_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private String executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            DynamicObject arg0Value_;
            int arg0Value_2;
            if (arg0Value instanceof JSLazyString) {
                JSLazyString arg0Value_3 = (JSLazyString)arg0Value;
                this.lazyString_flattenProfile_ = ConditionProfile.createBinaryProfile();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                String string = this.doLazyString(arg0Value_3, this.lazyString_flattenProfile_);
                return string;
            }
            int stringCast02 = JSTypesGen.specializeImplicitString(arg0Value);
            if (stringCast02 != 0) {
                String arg0Value_4 = JSTypesGen.asImplicitString(stringCast02, arg0Value);
                state |= stringCast02 << 12;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                String string = this.doString(arg0Value_4);
                return string;
            }
            if (JSGuards.isJSNull(arg0Value)) {
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                String stringCast02 = this.doNull(arg0Value);
                return stringCast02;
            }
            if (exclude == 0 && JSGuards.isUndefined(arg0Value)) {
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                String stringCast02 = this.doUndefined(arg0Value);
                return stringCast02;
            }
            if (arg0Value instanceof Boolean) {
                arg0Value_2 = ((Boolean)arg0Value).booleanValue();
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                String arg0Value_4 = this.doBoolean(arg0Value_2 != 0);
                return arg0Value_4;
            }
            if (arg0Value instanceof Integer) {
                arg0Value_2 = (Integer)arg0Value;
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                String arg0Value_4 = this.doInteger(arg0Value_2);
                return arg0Value_4;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_5 = (BigInt)arg0Value;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                String arg0Value_4 = this.doBigInt(arg0Value_5);
                return arg0Value_4;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_6 = (Long)arg0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                String string = this.doLong(arg0Value_6);
                return string;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_7 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                this.double_doubleToStringNode_ = (JSDoubleToStringNode)super.insert((Node)JSDoubleToStringNode.create());
                state |= doubleCast0 << 16;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                String string = this.doDouble(arg0Value_7, this.double_doubleToStringNode_);
                return string;
            }
            if (JSTypes.isDynamicObject(arg0Value) && JSObject.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
                this.jSObject_toPrimitiveHintStringNode_ = (JSToPrimitiveNode)super.insert((Node)JSToPrimitiveNode.createHintString());
                this.exclude_ = exclude |= 1;
                state &= 0xFFFFFFF7;
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                String string = this.doJSObject(arg0Value_, this.jSObject_toPrimitiveHintStringNode_);
                return string;
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_8 = (Symbol)arg0Value;
                this.state_ = state |= 0x400;
                lock.unlock();
                hasLock = false;
                String string = this.doSymbol(arg0Value_8);
                return string;
            }
            if (JSGuards.isForeignObject(arg0Value)) {
                this.truffleObject_toPrimitiveNode_ = (JSToPrimitiveNode)super.insert((Node)JSToPrimitiveNode.createHintString());
                this.state_ = state |= 0x800;
                lock.unlock();
                hasLock = false;
                String string = this.doTruffleObject(arg0Value, this.truffleObject_toPrimitiveNode_);
                return string;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0xFFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0xFFF & (state & 0xFFF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[13];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doLazyString";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.lazyString_flattenProfile_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doNull";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : (exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[4] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doLong";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state & 0x100) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.double_doubleToStringNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state & 0x200) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.jSObject_toPrimitiveHintStringNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        s = new Object[3];
        s[0] = "doTruffleObject";
        if ((state & 0x800) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.truffleObject_toPrimitiveNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[12] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSToStringNode create(boolean undefinedToEmpty, boolean symbolToString) {
        return new JSToStringNodeGen(undefinedToEmpty, symbolToString);
    }

    @GeneratedBy(value=JSToStringNode.JSToStringWrapperNode.class)
    public static final class JSToStringWrapperNodeGen
    extends JSToStringNode.JSToStringWrapperNode
    implements Introspection.Provider {
        private JSToStringWrapperNodeGen(JavaScriptNode operand) {
            super(operand);
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
            return this.doDefault(operandNodeValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object operandNodeValue_ = this.operandNode.execute(frameValue);
            return this.doDefault(operandNodeValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "doDefault";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static JSToStringNode.JSToStringWrapperNode create(JavaScriptNode operand) {
            return new JSToStringWrapperNodeGen(operand);
        }
    }
}

