/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.ReadNode;
import com.oracle.truffle.js.nodes.access.GlobalConstantNode;
import com.oracle.truffle.js.nodes.access.GlobalObjectNode;
import com.oracle.truffle.js.nodes.access.GlobalScopeNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.instrumentation.NodeObjectDescriptor;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.Set;

public class GlobalPropertyNode
extends JSTargetableNode
implements ReadNode {
    private final String propertyName;
    private final JSContext context;
    @Node.Child
    private PropertyGetNode cache;
    @Node.Child
    private JavaScriptNode globalObjectNode;

    protected GlobalPropertyNode(JSContext context, String propertyName, JavaScriptNode globalObjectNode) {
        this.propertyName = propertyName;
        this.context = context;
        this.globalObjectNode = globalObjectNode;
    }

    public static JSTargetableNode createPropertyNode(JSContext ctx, String propertyName) {
        if (ctx != null && ctx.isOptionNashornCompatibilityMode()) {
            if (propertyName.equals("__LINE__")) {
                return new GlobalConstantNode(ctx, propertyName, new GlobalConstantNode.LineNumberNode());
            }
            if (propertyName.equals("__FILE__")) {
                return new GlobalConstantNode(ctx, propertyName, new GlobalConstantNode.FileNameNode());
            }
            if (propertyName.equals("__DIR__")) {
                return new GlobalConstantNode(ctx, propertyName, new GlobalConstantNode.DirNameNode(ctx));
            }
        }
        return new GlobalPropertyNode(ctx, propertyName, null);
    }

    public static JSTargetableNode createLexicalGlobal(JSContext ctx, String propertyName, boolean checkTDZ) {
        JavaScriptNode globalScope = checkTDZ ? GlobalScopeNode.createWithTDZCheck(ctx, propertyName) : GlobalScopeNode.create(ctx);
        return new GlobalPropertyNode(ctx, propertyName, globalScope);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if ((tag == JSTags.ReadVariableTag.class || tag == StandardTags.ReadVariableTag.class) && this.isScopeAccess()) {
            return true;
        }
        if (tag == JSTags.ReadPropertyTag.class && !this.isScopeAccess()) {
            return true;
        }
        return super.hasTag(tag);
    }

    private boolean isScopeAccess() {
        return this.globalObjectNode instanceof GlobalScopeNode;
    }

    public Object getNodeObject() {
        if (this.isScopeAccess()) {
            NodeObjectDescriptor descriptor = JSTags.createNodeObjectDescriptor("name", this.getPropertyKey());
            descriptor.addProperty("readVariableName", this.getPropertyKey());
            return descriptor;
        }
        return JSTags.createNodeObjectDescriptor("key", this.getPropertyKey());
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.ReadPropertyTag.class) && !this.isScopeAccess() && this.globalObjectNode == null) {
            GlobalObjectNode global = GlobalObjectNode.create(this.context);
            GlobalPropertyNode materialized = new GlobalPropertyNode(this.context, this.propertyName, global);
            if (this.cache != null && this.cache.isMethod()) {
                materialized.getCache().setMethod();
            }
            GlobalPropertyNode.transferSourceSectionAndTags(this, materialized);
            GlobalPropertyNode.transferSourceSection(this, global);
            return materialized;
        }
        return this;
    }

    @Override
    public Object executeWithTarget(VirtualFrame frame, Object target) {
        try {
            return this.getCache().getValue(JSTypesGen.expectDynamicObject(target));
        }
        catch (UnexpectedResultException e) {
            throw new AssertionError((Object)"target must always be a JSObject");
        }
    }

    @Override
    public final Object evaluateTarget(VirtualFrame frame) {
        if (this.globalObjectNode != null) {
            return this.globalObjectNode.execute(frame);
        }
        return GlobalObjectNode.getGlobalObject(this.context);
    }

    @Override
    public JavaScriptNode getTarget() {
        return this.getGlobalObjectNode();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.getCache().getValue(this.evaluateTarget(frame));
    }

    @Override
    public int executeInt(VirtualFrame frame) throws UnexpectedResultException {
        return this.getCache().getValueInt(this.evaluateTarget(frame));
    }

    @Override
    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        return this.getCache().getValueDouble(this.evaluateTarget(frame));
    }

    public String getPropertyKey() {
        return this.propertyName;
    }

    public void setMethod() {
        this.getCache().setMethod();
    }

    public void setPropertyAssumptionCheckEnabled(boolean enabled) {
        this.getCache().setPropertyAssumptionCheckEnabled(enabled);
    }

    private PropertyGetNode getCache() {
        if (this.cache == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.cache = (PropertyGetNode)this.insert(PropertyGetNode.create(this.propertyName, true, this.context));
        }
        return this.cache;
    }

    private JavaScriptNode getGlobalObjectNode() {
        if (this.globalObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.globalObjectNode = (JavaScriptNode)this.insert(GlobalObjectNode.create(this.context));
        }
        return this.globalObjectNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        GlobalPropertyNode copy = new GlobalPropertyNode(this.context, this.propertyName, GlobalPropertyNode.cloneUninitialized(this.globalObjectNode, materializedTags));
        if (this.cache != null && this.cache.isMethod()) {
            copy.getCache().setMethod();
        }
        return copy;
    }

    @Override
    public String expressionToString() {
        return this.getPropertyKey();
    }
}

