/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.tregex.nodes.input.InputCharAtNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputLengthNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputRegionMatchesNodeGen;

public abstract class InputRegionMatchesNode
extends Node {
    public static InputRegionMatchesNode create() {
        return InputRegionMatchesNodeGen.create();
    }

    public abstract boolean execute(Object var1, int var2, Object var3, int var4, int var5, String var6);

    @Specialization(guards={"mask == null"})
    public boolean regionMatches(String input, int fromIndex1, String match, int fromIndex2, int length, String mask) {
        return input.regionMatches(fromIndex1, match, fromIndex2, length);
    }

    @Specialization(guards={"mask != null"})
    public boolean regionMatchesWithMask(String input, int fromIndex1, String match, int fromIndex2, int length, String mask) {
        return ArrayUtils.regionEqualsWithOrMask((String)input, (int)fromIndex1, (String)match, (int)fromIndex2, (int)length, (String)mask);
    }

    @Specialization(guards={"mask == null"})
    public boolean regionMatchesTruffleObjNoMask(TruffleObject input, int fromIndex1, String match, int fromIndex2, int length, String mask, @Cached(value="create()") InputLengthNode lengthNode, @Cached(value="create()") InputCharAtNode charAtNode) {
        return InputRegionMatchesNode.regionMatchesTruffleObj(input, fromIndex1, match, fromIndex2, length, mask, lengthNode, charAtNode);
    }

    @Specialization(guards={"mask != null"})
    public boolean regionMatchesTruffleObjWithMask(TruffleObject input, int fromIndex1, String match, int fromIndex2, int length, String mask, @Cached(value="create()") InputLengthNode lengthNode, @Cached(value="create()") InputCharAtNode charAtNode) {
        assert (match.length() == mask.length());
        return InputRegionMatchesNode.regionMatchesTruffleObj(input, fromIndex1, match, fromIndex2, length, mask, lengthNode, charAtNode);
    }

    @Specialization(guards={"mask == null"})
    public boolean regionMatchesTruffleObjTruffleObjNoMask(TruffleObject input, int fromIndex1, TruffleObject match, int fromIndex2, int length, String mask, @Cached(value="create()") InputLengthNode lengthNode1, @Cached(value="create()") InputCharAtNode charAtNode1, @Cached(value="create()") InputLengthNode lengthNode2, @Cached(value="create()") InputCharAtNode charAtNode2) {
        if (fromIndex1 + length > lengthNode1.execute(input) || fromIndex2 + length > lengthNode2.execute(match)) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (charAtNode1.execute(input, fromIndex1 + i) == charAtNode2.execute(match, fromIndex2 + i)) continue;
            return false;
        }
        return true;
    }

    private static boolean regionMatchesTruffleObj(TruffleObject input, int fromIndex1, String match, int fromIndex2, int length, String mask, InputLengthNode lengthNode, InputCharAtNode charAtNode) {
        if (fromIndex1 + length > lengthNode.execute(input) || fromIndex2 + length > match.length()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (InputCharAtNode.charAtWithMask(input, fromIndex1 + i, mask, i, charAtNode) == match.charAt(fromIndex2 + i)) continue;
            return false;
        }
        return true;
    }
}

