/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldAddNodeGen;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.JSAttributes;

public abstract class PrivateFieldAddNode
extends JavaScriptBaseNode {
    protected final JSContext context;

    public static PrivateFieldAddNode create(JSContext context) {
        return PrivateFieldAddNodeGen.create(context);
    }

    protected PrivateFieldAddNode(JSContext context) {
        this.context = context;
    }

    public abstract void execute(Object var1, Object var2, Object var3);

    @Specialization(guards={"key == cachedKey", "isJSObject(target)"}, limit="1")
    void doCachedKey(DynamicObject target, HiddenKey key, Object value, @Cached(value="key") HiddenKey cachedKey, @Cached(value="create(key)") HasHiddenKeyCacheNode hasNode, @Cached(value="createSetHidden(key, context)") PropertySetNode setNode) {
        if (!hasNode.executeHasHiddenKey(target)) {
            setNode.setValue(target, value);
        } else {
            this.duplicate(key);
        }
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isJSObject(target)"}, replaces={"doCachedKey"})
    void doUncachedKey(DynamicObject target, HiddenKey key, Object value) {
        if (!target.containsKey((Object)key)) {
            target.define((Object)key, value, JSAttributes.getDefaultNotEnumerable());
        } else {
            this.duplicate(key);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private Object duplicate(HiddenKey key) {
        throw Errors.createTypeErrorCannotAddPrivateMember(key.getName(), this);
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    void doFallback(Object target, Object key, Object value) {
        throw Errors.createTypeErrorCannotSetProperty(key.toString(), target, this);
    }
}

