/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository;

import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.UnknownRepositoryLayoutException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ArtifactRepositoryFactory.class)
public class DefaultArtifactRepositoryFactory
implements ArtifactRepositoryFactory {
    @Requirement
    private org.apache.maven.repository.legacy.repository.ArtifactRepositoryFactory factory;
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private RepositorySystem repositorySystem;

    public ArtifactRepositoryLayout getLayout(String layoutId) throws UnknownRepositoryLayoutException {
        return this.factory.getLayout(layoutId);
    }

    public ArtifactRepository createDeploymentArtifactRepository(String id, String url, String layoutId, boolean uniqueVersion) throws UnknownRepositoryLayoutException {
        return this.injectSession(this.factory.createDeploymentArtifactRepository(id, url, layoutId, uniqueVersion), false);
    }

    public ArtifactRepository createDeploymentArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout, boolean uniqueVersion) {
        return this.injectSession(this.factory.createDeploymentArtifactRepository(id, url, repositoryLayout, uniqueVersion), false);
    }

    public ArtifactRepository createArtifactRepository(String id, String url, String layoutId, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) throws UnknownRepositoryLayoutException {
        return this.injectSession(this.factory.createArtifactRepository(layoutId, url, layoutId, snapshots, releases), true);
    }

    public ArtifactRepository createArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        return this.injectSession(this.factory.createArtifactRepository(id, url, repositoryLayout, snapshots, releases), true);
    }

    public void setGlobalUpdatePolicy(String updatePolicy) {
        this.factory.setGlobalUpdatePolicy(updatePolicy);
    }

    public void setGlobalChecksumPolicy(String checksumPolicy) {
        this.factory.setGlobalChecksumPolicy(checksumPolicy);
    }

    private ArtifactRepository injectSession(ArtifactRepository repository, boolean mirrors) {
        MavenExecutionRequest request;
        MavenSession session = this.legacySupport.getSession();
        if (session != null && repository != null && !this.isLocalRepository(repository) && (request = session.getRequest()) != null) {
            List<ArtifactRepository> repositories = Arrays.asList(repository);
            if (mirrors) {
                this.repositorySystem.injectMirror(repositories, request.getMirrors());
            }
            this.repositorySystem.injectProxy(repositories, request.getProxies());
            this.repositorySystem.injectAuthentication(repositories, request.getServers());
        }
        return repository;
    }

    private boolean isLocalRepository(ArtifactRepository repository) {
        return "local".equals(repository.getId());
    }
}

