/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.tregex.parser.flavors.PythonREMode;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;

public final class PythonFlags
extends AbstractConstantKeysObject {
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("ASCII", "DOTALL", "IGNORECASE", "LOCALE", "MULTILINE", "TEMPLATE", "UNICODE", "VERBOSE");
    private final int value;
    private static final String FLAGS = "iLmsxatu";
    private static final String TYPE_FLAGS = "Lau";
    private static final String GLOBAL_FLAGS = "t";
    private static final String INTERNAL_FLAGS = "y";
    public static final PythonFlags EMPTY_INSTANCE = new PythonFlags("");
    public static final PythonFlags TYPE_FLAGS_INSTANCE = new PythonFlags("Lau");

    public PythonFlags(String source) {
        int bits = 0;
        for (int i = 0; i < source.length(); ++i) {
            bits |= PythonFlags.maskForFlag(source.charAt(i));
        }
        this.value = bits;
    }

    private PythonFlags(int value) {
        this.value = value;
    }

    private static int maskForFlag(int flagChar) {
        int index = FLAGS.indexOf(flagChar);
        if (index >= 0) {
            return 1 << index;
        }
        assert (INTERNAL_FLAGS.indexOf(flagChar) >= 0);
        return 1 << FLAGS.length() + INTERNAL_FLAGS.indexOf(flagChar);
    }

    public boolean hasFlag(int flagChar) {
        return (this.value & PythonFlags.maskForFlag(flagChar)) != 0;
    }

    public boolean isIgnoreCase() {
        return this.hasFlag(105);
    }

    public boolean isLocale() {
        return this.hasFlag(76);
    }

    public boolean isMultiLine() {
        return this.hasFlag(109);
    }

    public boolean isDotAll() {
        return this.hasFlag(115);
    }

    public boolean isVerbose() {
        return this.hasFlag(120);
    }

    public boolean isAscii() {
        return this.hasFlag(97);
    }

    public boolean isTemplate() {
        return this.hasFlag(116);
    }

    public boolean isUnicode() {
        return this.hasFlag(117);
    }

    public boolean isSticky() {
        return this.hasFlag(121);
    }

    public PythonFlags addFlag(int flagChar) {
        return new PythonFlags(this.value | PythonFlags.maskForFlag(flagChar));
    }

    public PythonFlags addFlags(PythonFlags otherFlags) {
        return new PythonFlags(this.value | otherFlags.value);
    }

    public PythonFlags delFlags(PythonFlags otherFlags) {
        return new PythonFlags(this.value & ~otherFlags.value);
    }

    public PythonFlags fixFlags(PythonREMode mode) {
        switch (mode) {
            case Str: {
                if (this.hasFlag(76)) {
                    throw new RegexSyntaxException("cannot use LOCALE flag with a str pattern");
                }
                if (this.hasFlag(97) && this.hasFlag(117)) {
                    throw new RegexSyntaxException("ASCII and UNICODE flags are incompatible");
                }
                if (!this.hasFlag(97)) {
                    return this.addFlag(117);
                }
                return this;
            }
            case Bytes: {
                if (this.hasFlag(117)) {
                    throw new RegexSyntaxException("cannot use UNICODE flag with a bytes pattern");
                }
                if (this.hasFlag(97) && this.hasFlag(76)) {
                    throw new RegexSyntaxException("ASCII and LOCALE flags are incompatible");
                }
                return this;
            }
        }
        throw new IllegalStateException();
    }

    public static boolean isValidFlagChar(int candidateChar) {
        return FLAGS.indexOf(candidateChar) >= 0;
    }

    public int numberOfTypeFlags() {
        int typeFlags = 0;
        for (int i = 0; i < TYPE_FLAGS.length(); ++i) {
            if (!this.hasFlag(TYPE_FLAGS.charAt(i))) continue;
            ++typeFlags;
        }
        return typeFlags;
    }

    public boolean includesGlobalFlags() {
        for (int i = 0; i < GLOBAL_FLAGS.length(); ++i) {
            if (!this.hasFlag(GLOBAL_FLAGS.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean overlaps(PythonFlags otherFlags) {
        return (this.value & otherFlags.value) != 0;
    }

    public boolean equals(Object other) {
        return other instanceof PythonFlags && this.value == ((PythonFlags)other).value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(FLAGS.length());
        for (int i = 0; i < FLAGS.length(); ++i) {
            char flag = FLAGS.charAt(i);
            if (!this.hasFlag(flag)) continue;
            out.append(flag);
        }
        return out.toString();
    }

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "ASCII": {
                return this.isAscii();
            }
            case "DOTALL": {
                return this.isDotAll();
            }
            case "IGNORECASE": {
                return this.isIgnoreCase();
            }
            case "LOCALE": {
                return this.isLocale();
            }
            case "MULTILINE": {
                return this.isMultiLine();
            }
            case "TEMPLATE": {
                return this.isTemplate();
            }
            case "UNICODE": {
                return this.isUnicode();
            }
            case "VERBOSE": {
                return this.isVerbose();
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnknownIdentifierException.create((String)symbol);
    }
}

