/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;

final class SurefireDependencyResolver {
    static final String PROVIDER_GROUP_ID = "org.apache.maven.surefire";
    private static final String[] PROVIDER_CLASSPATH_ORDER = new String[]{"surefire-junit3", "surefire-junit4", "surefire-junit47", "surefire-testng", "surefire-junit-platform", "surefire-api", "surefire-logger-api", "common-java5", "common-junit3", "common-junit4", "common-junit48", "common-testng-utils"};
    private final RepositorySystem repositorySystem;
    private final ConsoleLogger log;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> pluginRemoteRepositories;
    private final List<ArtifactRepository> projectRemoteRepositories;
    private final String pluginName;
    private final DependencyResolver depencencyResolver;

    SurefireDependencyResolver(RepositorySystem repositorySystem, ConsoleLogger log, ArtifactRepository localRepository, List<ArtifactRepository> pluginRemoteRepositories, List<ArtifactRepository> projectRemoteRepositories, String pluginName, DependencyResolver depencencyResolver) {
        this.repositorySystem = repositorySystem;
        this.log = log;
        this.localRepository = localRepository;
        this.pluginRemoteRepositories = pluginRemoteRepositories;
        this.projectRemoteRepositories = projectRemoteRepositories;
        this.pluginName = pluginName;
        this.depencencyResolver = depencencyResolver;
    }

    static boolean isWithinVersionSpec(@Nullable Artifact artifact, @Nonnull String versionSpec) {
        if (artifact == null) {
            return false;
        }
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)versionSpec);
            try {
                return range.containsVersion(artifact.getSelectedVersion());
            }
            catch (NullPointerException e) {
                return range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifact.getBaseVersion()));
            }
        }
        catch (InvalidVersionSpecificationException | OverConstrainedVersionException e) {
            throw new RuntimeException("Bug in plugin. Please report with stacktrace");
        }
    }

    Set<Artifact> resolvePluginDependencies(ProjectBuildingRequest request, Collection<Dependency> pluginDependencies) throws MojoExecutionException {
        try {
            Iterable resolvedPluginDependencies = this.depencencyResolver.resolveDependencies(request, pluginDependencies, null, (TransformableFilter)ScopeFilter.including("compile", "runtime"));
            LinkedHashSet<Artifact> resolved = new LinkedHashSet<Artifact>();
            for (ArtifactResult resolvedPluginDependency : resolvedPluginDependencies) {
                resolved.add(resolvedPluginDependency.getArtifact());
            }
            return resolved;
        }
        catch (DependencyResolverException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    ArtifactResolutionResult resolvePluginArtifact(Artifact artifact) {
        return this.resolveArtifact(artifact, this.pluginRemoteRepositories);
    }

    ArtifactResolutionResult resolveProjectArtifact(Artifact artifact) {
        return this.resolveArtifact(artifact, this.projectRemoteRepositories);
    }

    private ArtifactResolutionResult resolveArtifact(Artifact artifact, List<ArtifactRepository> repositories) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setLocalRepository(this.localRepository).setResolveTransitively(true).setCollectionFilter((ArtifactFilter)new RuntimeArtifactFilter()).setRemoteRepositories(repositories);
        return this.repositorySystem.resolve(request);
    }

    @Nonnull
    Set<Artifact> getProviderClasspath(String providerArtifactId, String providerVersion) {
        Dependency provider = SurefireDependencyResolver.toProviderDependency(providerArtifactId, providerVersion);
        Artifact providerArtifact = this.repositorySystem.createDependencyArtifact(provider);
        ArtifactResolutionResult result = this.resolvePluginArtifact(providerArtifact);
        if (this.log.isDebugEnabled()) {
            for (Artifact artifact : result.getArtifacts()) {
                String artifactPath = artifact.getFile().getAbsolutePath();
                String scope = artifact.getScope();
                this.log.debug("Adding to " + this.pluginName + " test classpath: " + artifactPath + " Scope: " + scope);
            }
        }
        return SurefireDependencyResolver.orderProviderArtifacts(result.getArtifacts());
    }

    @Nonnull
    Map<String, Artifact> getProviderClasspathAsMap(String providerArtifactId, String providerVersion) {
        return ArtifactUtils.artifactMapByVersionlessId(this.getProviderClasspath(providerArtifactId, providerVersion));
    }

    Set<Artifact> addProviderToClasspath(Map<String, Artifact> pluginArtifactMap, Artifact mojoPluginArtifact, Artifact surefireApi, Artifact surefireLoggerApi) {
        LinkedHashSet<Artifact> providerArtifacts = new LinkedHashSet<Artifact>();
        ArtifactResolutionResult artifactResolutionResult = this.resolvePluginArtifact(mojoPluginArtifact);
        for (Artifact artifact : pluginArtifactMap.values()) {
            if (artifactResolutionResult.getArtifacts().contains(artifact)) continue;
            providerArtifacts.add(artifact);
            for (Artifact dependency : this.resolvePluginArtifact(artifact).getArtifacts()) {
                String groupId = dependency.getGroupId();
                String artifactId = dependency.getArtifactId();
                if (groupId.equals(surefireApi.getGroupId()) && artifactId.equals(surefireApi.getArtifactId())) {
                    providerArtifacts.add(surefireApi);
                    continue;
                }
                if (!groupId.equals(surefireLoggerApi.getGroupId()) || !artifactId.equals(surefireLoggerApi.getArtifactId())) continue;
                providerArtifacts.add(surefireLoggerApi);
            }
        }
        return SurefireDependencyResolver.orderProviderArtifacts(providerArtifacts);
    }

    private static Set<Artifact> orderProviderArtifacts(Set<Artifact> providerArtifacts) {
        LinkedHashSet<Artifact> orderedProviderArtifacts = new LinkedHashSet<Artifact>();
        for (String order : PROVIDER_CLASSPATH_ORDER) {
            Iterator<Artifact> providerArtifactsIt = providerArtifacts.iterator();
            while (providerArtifactsIt.hasNext()) {
                Artifact providerArtifact = providerArtifactsIt.next();
                if (!providerArtifact.getArtifactId().equals(order)) continue;
                orderedProviderArtifacts.add(providerArtifact);
                providerArtifactsIt.remove();
            }
        }
        orderedProviderArtifacts.addAll(providerArtifacts);
        return orderedProviderArtifacts;
    }

    private static Dependency toProviderDependency(String providerArtifactId, String providerVersion) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(PROVIDER_GROUP_ID);
        dependency.setArtifactId(providerArtifactId);
        dependency.setVersion(providerVersion);
        dependency.setType("jar");
        return dependency;
    }

    static class RuntimeArtifactFilter
    implements ArtifactFilter {
        private static final Collection<String> SCOPES = Arrays.asList("compile", "compile+runtime", "runtime");

        RuntimeArtifactFilter() {
        }

        public boolean include(Artifact artifact) {
            String scope = artifact.getScope();
            return !artifact.isOptional() && (scope == null || SCOPES.contains(scope));
        }
    }
}

